/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDataMigrationResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DeleteDataMigrationResponse.Builder, DeleteDataMigrationResponse> {
    private static final SdkField<DataMigration> DATA_MIGRATION_FIELD = SdkField
            .<DataMigration> builder(MarshallingType.SDK_POJO).memberName("DataMigration")
            .getter(getter(DeleteDataMigrationResponse::dataMigration)).setter(setter(Builder::dataMigration))
            .constructor(DataMigration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MIGRATION_FIELD));

    private final DataMigration dataMigration;

    private DeleteDataMigrationResponse(BuilderImpl builder) {
        super(builder);
        this.dataMigration = builder.dataMigration;
    }

    /**
     * <p>
     * The deleted data migration.
     * </p>
     * 
     * @return The deleted data migration.
     */
    public final DataMigration dataMigration() {
        return dataMigration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataMigration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataMigrationResponse)) {
            return false;
        }
        DeleteDataMigrationResponse other = (DeleteDataMigrationResponse) obj;
        return Objects.equals(dataMigration(), other.dataMigration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDataMigrationResponse").add("DataMigration", dataMigration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataMigration":
            return Optional.ofNullable(clazz.cast(dataMigration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataMigrationResponse, T> g) {
        return obj -> g.apply((DeleteDataMigrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDataMigrationResponse> {
        /**
         * <p>
         * The deleted data migration.
         * </p>
         * 
         * @param dataMigration
         *        The deleted data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataMigration(DataMigration dataMigration);

        /**
         * <p>
         * The deleted data migration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataMigration.Builder} avoiding the need
         * to create one manually via {@link DataMigration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataMigration.Builder#build()} is called immediately and its
         * result is passed to {@link #dataMigration(DataMigration)}.
         * 
         * @param dataMigration
         *        a consumer that will call methods on {@link DataMigration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataMigration(DataMigration)
         */
        default Builder dataMigration(Consumer<DataMigration.Builder> dataMigration) {
            return dataMigration(DataMigration.builder().applyMutation(dataMigration).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private DataMigration dataMigration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataMigrationResponse model) {
            super(model);
            dataMigration(model.dataMigration);
        }

        public final DataMigration.Builder getDataMigration() {
            return dataMigration != null ? dataMigration.toBuilder() : null;
        }

        public final void setDataMigration(DataMigration.BuilderImpl dataMigration) {
            this.dataMigration = dataMigration != null ? dataMigration.build() : null;
        }

        @Override
        public final Builder dataMigration(DataMigration dataMigration) {
            this.dataMigration = dataMigration;
            return this;
        }

        @Override
        public DeleteDataMigrationResponse build() {
            return new DeleteDataMigrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
