/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.databasemigration.model.AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.CollectorNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationException;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.FailedDependencyException;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.InsufficientResourceCapacityException;
import software.amazon.awssdk.services.databasemigration.model.InvalidCertificateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidOperationException;
import software.amazon.awssdk.services.databasemigration.model.InvalidResourceStateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidSubnetException;
import software.amazon.awssdk.services.databasemigration.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.KmsDisabledException;
import software.amazon.awssdk.services.databasemigration.model.KmsException;
import software.amazon.awssdk.services.databasemigration.model.KmsInvalidStateException;
import software.amazon.awssdk.services.databasemigration.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.databasemigration.model.KmsNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.KmsThrottlingException;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.ResourceQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisRequest;
import software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.S3AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.S3ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.databasemigration.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StopDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest;
import software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse;
import software.amazon.awssdk.services.databasemigration.model.UpgradeDependencyFailureException;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationWaiter;

/**
 * Service client for accessing AWS Database Migration Service. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Database Migration Service</fullname>
 * <p>
 * Database Migration Service (DMS) can migrate your data to and from the most widely used commercial and open-source
 * databases such as Oracle, PostgreSQL, Microsoft SQL Server, Amazon Redshift, MariaDB, Amazon Aurora, MySQL, and SAP
 * Adaptive Server Enterprise (ASE). The service supports homogeneous migrations such as Oracle to Oracle, as well as
 * heterogeneous migrations between different database platforms, such as Oracle to MySQL or SQL Server to PostgreSQL.
 * </p>
 * <p>
 * For more information about DMS, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/Welcome.html">What Is
 * Database Migration Service?</a> in the <i>Database Migration Service User Guide.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DatabaseMigrationClient extends AwsClient {
    String SERVICE_NAME = "dms";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "dms";

    /**
     * <p>
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or
     * used in a Condition statement in an IAM policy for DMS. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Associates a set of tags with an DMS resource.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or
     * used in a Condition statement in an IAM policy for DMS. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest.Builder} to create
     *        a request. Associates a set of tags with an DMS resource.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest.Builder}
     *        to create a request.
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Starts the analysis of up to 20 source databases to recommend target engines for each source database. This is a
     * batch version of <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html">StartRecommendations
     * </a>.
     * </p>
     * <p>
     * The result of analysis of each source database is reported individually in the response. Because the batch
     * request can result in a combination of successful and unsuccessful actions, you should check for batch errors
     * even when the call returns an HTTP status code of <code>200</code>.
     * </p>
     *
     * @param batchStartRecommendationsRequest
     * @return Result of the BatchStartRecommendations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.BatchStartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/BatchStartRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchStartRecommendationsResponse batchStartRecommendations(
            BatchStartRecommendationsRequest batchStartRecommendationsRequest) throws InvalidResourceStateException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the analysis of up to 20 source databases to recommend target engines for each source database. This is a
     * batch version of <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html">StartRecommendations
     * </a>.
     * </p>
     * <p>
     * The result of analysis of each source database is reported individually in the response. Because the batch
     * request can result in a combination of successful and unsuccessful actions, you should check for batch errors
     * even when the call returns an HTTP status code of <code>200</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStartRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link BatchStartRecommendationsRequest#builder()}
     * </p>
     *
     * @param batchStartRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest.Builder}
     *        to create a request.
     * @return Result of the BatchStartRecommendations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.BatchStartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/BatchStartRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchStartRecommendationsResponse batchStartRecommendations(
            Consumer<BatchStartRecommendationsRequest.Builder> batchStartRecommendationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return batchStartRecommendations(BatchStartRecommendationsRequest.builder()
                .applyMutation(batchStartRecommendationsRequest).build());
    }

    /**
     * <p>
     * Cancels a single premigration assessment run.
     * </p>
     * <p>
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts
     * to cancel any individual assessments that are currently running.
     * </p>
     *
     * @param cancelReplicationTaskAssessmentRunRequest
     * @return Result of the CancelReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CancelReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRun(
            CancelReplicationTaskAssessmentRunRequest cancelReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a single premigration assessment run.
     * </p>
     * <p>
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts
     * to cancel any individual assessments that are currently running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link CancelReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param cancelReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest.Builder}
     *        to create a request.
     * @return Result of the CancelReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CancelReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRun(
            Consumer<CancelReplicationTaskAssessmentRunRequest.Builder> cancelReplicationTaskAssessmentRunRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return cancelReplicationTaskAssessmentRun(CancelReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(cancelReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Creates a data migration using the provided settings.
     * </p>
     *
     * @param createDataMigrationRequest
     * @return Result of the CreateDataMigration operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InvalidOperationException
     *         The action or operation requested isn't valid.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataMigrationResponse createDataMigration(CreateDataMigrationRequest createDataMigrationRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            InvalidOperationException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data migration using the provided settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataMigrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataMigrationRequest#builder()}
     * </p>
     *
     * @param createDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDataMigration operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InvalidOperationException
     *         The action or operation requested isn't valid.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataMigrationResponse createDataMigration(
            Consumer<CreateDataMigrationRequest.Builder> createDataMigrationRequest) throws ResourceQuotaExceededException,
            ResourceNotFoundException, ResourceAlreadyExistsException, InvalidOperationException, FailedDependencyException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createDataMigration(CreateDataMigrationRequest.builder().applyMutation(createDataMigrationRequest).build());
    }

    /**
     * <p>
     * Creates a data provider using the provided settings. A data provider stores a data store type and location
     * information about your database.
     * </p>
     *
     * @param createDataProviderRequest
     * @return Result of the CreateDataProvider operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataProviderResponse createDataProvider(CreateDataProviderRequest createDataProviderRequest)
            throws ResourceQuotaExceededException, AccessDeniedException, ResourceAlreadyExistsException,
            FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data provider using the provided settings. A data provider stores a data store type and location
     * information about your database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataProviderRequest#builder()}
     * </p>
     *
     * @param createDataProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDataProvider operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataProviderResponse createDataProvider(Consumer<CreateDataProviderRequest.Builder> createDataProviderRequest)
            throws ResourceQuotaExceededException, AccessDeniedException, ResourceAlreadyExistsException,
            FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createDataProvider(CreateDataProviderRequest.builder().applyMutation(createDataProviderRequest).build());
    }

    /**
     * <p>
     * Creates an endpoint using the provided settings.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param createEndpointRequest
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest)
            throws KmsKeyNotAccessibleException, ResourceAlreadyExistsException, ResourceQuotaExceededException,
            InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint using the provided settings.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest)
            throws KmsKeyNotAccessibleException, ResourceAlreadyExistsException, ResourceQuotaExceededException,
            InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an DMS event notification subscription.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS
     * source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (
     * <code>EventCategories</code>) for events you want to be notified of. If you specify both the
     * <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and
     * <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for
     * the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>,
     * you receive notice of the events for that source type for all your DMS sources. If you don't specify either
     * <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException,
            KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an DMS event notification subscription.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS
     * source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (
     * <code>EventCategories</code>) for events you want to be notified of. If you specify both the
     * <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and
     * <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for
     * the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>,
     * you receive notice of the events for that source type for all your DMS sources. If you don't specify either
     * <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventSubscriptionResponse createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException,
            KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Fleet Advisor collector using the specified parameters.
     * </p>
     *
     * @param createFleetAdvisorCollectorRequest
     * @return Result of the CreateFleetAdvisorCollector operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFleetAdvisorCollectorResponse createFleetAdvisorCollector(
            CreateFleetAdvisorCollectorRequest createFleetAdvisorCollectorRequest) throws InvalidResourceStateException,
            AccessDeniedException, S3AccessDeniedException, S3ResourceNotFoundException, ResourceQuotaExceededException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Fleet Advisor collector using the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetAdvisorCollectorRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFleetAdvisorCollectorRequest#builder()}
     * </p>
     *
     * @param createFleetAdvisorCollectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest.Builder}
     *        to create a request.
     * @return Result of the CreateFleetAdvisorCollector operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFleetAdvisorCollectorResponse createFleetAdvisorCollector(
            Consumer<CreateFleetAdvisorCollectorRequest.Builder> createFleetAdvisorCollectorRequest)
            throws InvalidResourceStateException, AccessDeniedException, S3AccessDeniedException, S3ResourceNotFoundException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createFleetAdvisorCollector(CreateFleetAdvisorCollectorRequest.builder()
                .applyMutation(createFleetAdvisorCollectorRequest).build());
    }

    /**
     * <p>
     * Creates the instance profile using the specified parameters.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return Result of the CreateInstanceProfile operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstanceProfileResponse createInstanceProfile(CreateInstanceProfileRequest createInstanceProfileRequest)
            throws AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceQuotaExceededException, InvalidResourceStateException, KmsKeyNotAccessibleException,
            S3ResourceNotFoundException, S3AccessDeniedException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the instance profile using the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInstanceProfileRequest#builder()}
     * </p>
     *
     * @param createInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileRequest.Builder} to
     *        create a request.
     * @return Result of the CreateInstanceProfile operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstanceProfileResponse createInstanceProfile(
            Consumer<CreateInstanceProfileRequest.Builder> createInstanceProfileRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceQuotaExceededException,
            InvalidResourceStateException, KmsKeyNotAccessibleException, S3ResourceNotFoundException, S3AccessDeniedException,
            FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createInstanceProfile(CreateInstanceProfileRequest.builder().applyMutation(createInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Creates the migration project using the specified parameters.
     * </p>
     * <p>
     * You can run this action only after you create an instance profile and data providers using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateInstanceProfile.html"
     * >CreateInstanceProfile</a> and <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateDataProvider.html">CreateDataProvider</a>.
     * </p>
     *
     * @param createMigrationProjectRequest
     * @return Result of the CreateMigrationProject operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMigrationProjectResponse createMigrationProject(CreateMigrationProjectRequest createMigrationProjectRequest)
            throws AccessDeniedException, ResourceAlreadyExistsException, ResourceQuotaExceededException,
            ResourceNotFoundException, S3ResourceNotFoundException, S3AccessDeniedException, FailedDependencyException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the migration project using the specified parameters.
     * </p>
     * <p>
     * You can run this action only after you create an instance profile and data providers using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateInstanceProfile.html"
     * >CreateInstanceProfile</a> and <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateDataProvider.html">CreateDataProvider</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMigrationProjectRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMigrationProjectRequest#builder()}
     * </p>
     *
     * @param createMigrationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest.Builder} to
     *        create a request.
     * @return Result of the CreateMigrationProject operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMigrationProjectResponse createMigrationProject(
            Consumer<CreateMigrationProjectRequest.Builder> createMigrationProjectRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, ResourceQuotaExceededException, ResourceNotFoundException,
            S3ResourceNotFoundException, S3AccessDeniedException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return createMigrationProject(CreateMigrationProjectRequest.builder().applyMutation(createMigrationProjectRequest)
                .build());
    }

    /**
     * <p>
     * Creates a configuration that you can later provide to configure and start an DMS Serverless replication. You can
     * also provide options to validate the configuration inputs before you start the replication.
     * </p>
     *
     * @param createReplicationConfigRequest
     * @return Result of the CreateReplicationConfig operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateReplicationConfigResponse createReplicationConfig(CreateReplicationConfigRequest createReplicationConfigRequest)
            throws AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InvalidResourceStateException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration that you can later provide to configure and start an DMS Serverless replication. You can
     * also provide options to validate the configuration inputs before you start the replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateReplicationConfigRequest#builder()}
     * </p>
     *
     * @param createReplicationConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest.Builder} to
     *        create a request.
     * @return Result of the CreateReplicationConfig operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateReplicationConfigResponse createReplicationConfig(
            Consumer<CreateReplicationConfigRequest.Builder> createReplicationConfigRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, InvalidResourceStateException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createReplicationConfig(CreateReplicationConfigRequest.builder().applyMutation(createReplicationConfigRequest)
                .build());
    }

    /**
     * <p>
     * Creates the replication instance using the specified parameters.
     * </p>
     * <p>
     * DMS requires that your account have certain roles with appropriate permissions before you can create a
     * replication instance. For information on the required roles, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM
     * Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM
     * Permissions Needed to Use DMS</a>.
     * </p>
     * <note>
     * <p>
     * If you don't specify a version when creating a replication instance, DMS will create the instance using the
     * default engine version. For information about the default engine version, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReleaseNotes.html">Release Notes</a>.
     * </p>
     * </note>
     *
     * @param createReplicationInstanceRequest
     * @return Result of the CreateReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateReplicationInstanceResponse createReplicationInstance(
            CreateReplicationInstanceRequest createReplicationInstanceRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, InsufficientResourceCapacityException, ResourceQuotaExceededException,
            StorageQuotaExceededException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidResourceStateException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the replication instance using the specified parameters.
     * </p>
     * <p>
     * DMS requires that your account have certain roles with appropriate permissions before you can create a
     * replication instance. For information on the required roles, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM
     * Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM
     * Permissions Needed to Use DMS</a>.
     * </p>
     * <note>
     * <p>
     * If you don't specify a version when creating a replication instance, DMS will create the instance using the
     * default engine version. For information about the default engine version, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReleaseNotes.html">Release Notes</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param createReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest.Builder}
     *        to create a request.
     * @return Result of the CreateReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateReplicationInstanceResponse createReplicationInstance(
            Consumer<CreateReplicationInstanceRequest.Builder> createReplicationInstanceRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, InsufficientResourceCapacityException, ResourceQuotaExceededException,
            StorageQuotaExceededException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidResourceStateException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return createReplicationInstance(CreateReplicationInstanceRequest.builder()
                .applyMutation(createReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * </p>
     * <p>
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region,
     * otherwise the service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.
     * </p>
     * <p>
     * If a replication subnet group exists in your Amazon Web Services account, the CreateReplicationSubnetGroup action
     * returns the following error message: The Replication Subnet Group already exists. In this case, delete the
     * existing replication subnet group. To do so, use the <a
     * href="https://docs.aws.amazon.com/en_us/dms/latest/APIReference/API_DeleteReplicationSubnetGroup.html"
     * >DeleteReplicationSubnetGroup</a> action. Optionally, choose Subnet groups in the DMS console, then choose your
     * subnet group. Next, choose Delete from Actions.
     * </p>
     *
     * @param createReplicationSubnetGroupRequest
     * @return Result of the CreateReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationSubnetGroupResponse createReplicationSubnetGroup(
            CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceQuotaExceededException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * </p>
     * <p>
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region,
     * otherwise the service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.
     * </p>
     * <p>
     * If a replication subnet group exists in your Amazon Web Services account, the CreateReplicationSubnetGroup action
     * returns the following error message: The Replication Subnet Group already exists. In this case, delete the
     * existing replication subnet group. To do so, use the <a
     * href="https://docs.aws.amazon.com/en_us/dms/latest/APIReference/API_DeleteReplicationSubnetGroup.html"
     * >DeleteReplicationSubnetGroup</a> action. Optionally, choose Subnet groups in the DMS console, then choose your
     * subnet group. Next, choose Delete from Actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest.Builder}
     *        to create a request.
     * @return Result of the CreateReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationSubnetGroupResponse createReplicationSubnetGroup(
            Consumer<CreateReplicationSubnetGroupRequest.Builder> createReplicationSubnetGroupRequest)
            throws AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceQuotaExceededException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createReplicationSubnetGroup(CreateReplicationSubnetGroupRequest.builder()
                .applyMutation(createReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates a replication task using the specified parameters.
     * </p>
     *
     * @param createReplicationTaskRequest
     * @return Result of the CreateReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReplicationTaskResponse createReplicationTask(CreateReplicationTaskRequest createReplicationTaskRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException,
            ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a replication task using the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReplicationTaskRequest#builder()}
     * </p>
     *
     * @param createReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest.Builder} to
     *        create a request.
     * @return Result of the CreateReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReplicationTaskResponse createReplicationTask(
            Consumer<CreateReplicationTaskRequest.Builder> createReplicationTaskRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return createReplicationTask(CreateReplicationTaskRequest.builder().applyMutation(createReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCertificateResponse deleteCertificate(Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteCertificate(DeleteCertificateRequest.builder().applyMutation(deleteCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the connection between a replication instance and an endpoint.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the connection between a replication instance and an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified data migration.
     * </p>
     *
     * @param deleteDataMigrationRequest
     * @return Result of the DeleteDataMigration operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataMigrationResponse deleteDataMigration(DeleteDataMigrationRequest deleteDataMigrationRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified data migration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataMigrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataMigrationRequest#builder()}
     * </p>
     *
     * @param deleteDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDataMigration operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataMigrationResponse deleteDataMigration(
            Consumer<DeleteDataMigrationRequest.Builder> deleteDataMigrationRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteDataMigration(DeleteDataMigrationRequest.builder().applyMutation(deleteDataMigrationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified data provider.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the data provider must be deleted or modified before you can delete the
     * data provider.
     * </p>
     * </note>
     *
     * @param deleteDataProviderRequest
     * @return Result of the DeleteDataProvider operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataProviderResponse deleteDataProvider(DeleteDataProviderRequest deleteDataProviderRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified data provider.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the data provider must be deleted or modified before you can delete the
     * data provider.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataProviderRequest#builder()}
     * </p>
     *
     * @param deleteDataProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDataProvider operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataProviderResponse deleteDataProvider(Consumer<DeleteDataProviderRequest.Builder> deleteDataProviderRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return deleteDataProvider(DeleteDataProviderRequest.builder().applyMutation(deleteDataProviderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified endpoint.
     * </p>
     * <note>
     * <p>
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified endpoint.
     * </p>
     * <note>
     * <p>
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     * </p>
     * </note>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an DMS event subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an DMS event subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventSubscriptionResponse deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified Fleet Advisor collector.
     * </p>
     *
     * @param deleteFleetAdvisorCollectorRequest
     * @return Result of the DeleteFleetAdvisorCollector operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws CollectorNotFoundException
     *         The specified collector doesn't exist.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFleetAdvisorCollectorResponse deleteFleetAdvisorCollector(
            DeleteFleetAdvisorCollectorRequest deleteFleetAdvisorCollectorRequest) throws InvalidResourceStateException,
            CollectorNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Fleet Advisor collector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetAdvisorCollectorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFleetAdvisorCollectorRequest#builder()}
     * </p>
     *
     * @param deleteFleetAdvisorCollectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteFleetAdvisorCollector operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws CollectorNotFoundException
     *         The specified collector doesn't exist.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFleetAdvisorCollectorResponse deleteFleetAdvisorCollector(
            Consumer<DeleteFleetAdvisorCollectorRequest.Builder> deleteFleetAdvisorCollectorRequest)
            throws InvalidResourceStateException, CollectorNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteFleetAdvisorCollector(DeleteFleetAdvisorCollectorRequest.builder()
                .applyMutation(deleteFleetAdvisorCollectorRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Fleet Advisor collector databases.
     * </p>
     *
     * @param deleteFleetAdvisorDatabasesRequest
     * @return Result of the DeleteFleetAdvisorDatabases operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidOperationException
     *         The action or operation requested isn't valid.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFleetAdvisorDatabasesResponse deleteFleetAdvisorDatabases(
            DeleteFleetAdvisorDatabasesRequest deleteFleetAdvisorDatabasesRequest) throws ResourceNotFoundException,
            InvalidOperationException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Fleet Advisor collector databases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetAdvisorDatabasesRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFleetAdvisorDatabasesRequest#builder()}
     * </p>
     *
     * @param deleteFleetAdvisorDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteFleetAdvisorDatabases operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidOperationException
     *         The action or operation requested isn't valid.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFleetAdvisorDatabasesResponse deleteFleetAdvisorDatabases(
            Consumer<DeleteFleetAdvisorDatabasesRequest.Builder> deleteFleetAdvisorDatabasesRequest)
            throws ResourceNotFoundException, InvalidOperationException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteFleetAdvisorDatabases(DeleteFleetAdvisorDatabasesRequest.builder()
                .applyMutation(deleteFleetAdvisorDatabasesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified instance profile.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can delete the
     * instance profile.
     * </p>
     * </note>
     *
     * @param deleteInstanceProfileRequest
     * @return Result of the DeleteInstanceProfile operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceProfileResponse deleteInstanceProfile(DeleteInstanceProfileRequest deleteInstanceProfileRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified instance profile.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can delete the
     * instance profile.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInstanceProfileRequest#builder()}
     * </p>
     *
     * @param deleteInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteInstanceProfile operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceProfileResponse deleteInstanceProfile(
            Consumer<DeleteInstanceProfileRequest.Builder> deleteInstanceProfileRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteInstanceProfile(DeleteInstanceProfileRequest.builder().applyMutation(deleteInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the specified migration project.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can delete it.
     * </p>
     * </note>
     *
     * @param deleteMigrationProjectRequest
     * @return Result of the DeleteMigrationProject operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMigrationProjectResponse deleteMigrationProject(DeleteMigrationProjectRequest deleteMigrationProjectRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified migration project.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can delete it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMigrationProjectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMigrationProjectRequest#builder()}
     * </p>
     *
     * @param deleteMigrationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMigrationProject operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMigrationProjectResponse deleteMigrationProject(
            Consumer<DeleteMigrationProjectRequest.Builder> deleteMigrationProjectRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteMigrationProject(DeleteMigrationProjectRequest.builder().applyMutation(deleteMigrationProjectRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an DMS Serverless replication configuration. This effectively deprovisions any and all replications that
     * use this configuration. You can't delete the configuration for an DMS Serverless replication that is ongoing. You
     * can delete the configuration when the replication is in a non-RUNNING and non-STARTING state.
     * </p>
     *
     * @param deleteReplicationConfigRequest
     * @return Result of the DeleteReplicationConfig operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReplicationConfigResponse deleteReplicationConfig(DeleteReplicationConfigRequest deleteReplicationConfigRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an DMS Serverless replication configuration. This effectively deprovisions any and all replications that
     * use this configuration. You can't delete the configuration for an DMS Serverless replication that is ongoing. You
     * can delete the configuration when the replication is in a non-RUNNING and non-STARTING state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteReplicationConfigRequest#builder()}
     * </p>
     *
     * @param deleteReplicationConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteReplicationConfig operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReplicationConfigResponse deleteReplicationConfig(
            Consumer<DeleteReplicationConfigRequest.Builder> deleteReplicationConfigRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteReplicationConfig(DeleteReplicationConfigRequest.builder().applyMutation(deleteReplicationConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified replication instance.
     * </p>
     * <note>
     * <p>
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteReplicationInstanceRequest
     * @return Result of the DeleteReplicationInstance operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReplicationInstanceResponse deleteReplicationInstance(
            DeleteReplicationInstanceRequest deleteReplicationInstanceRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified replication instance.
     * </p>
     * <note>
     * <p>
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     * </p>
     * </note>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param deleteReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteReplicationInstance operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReplicationInstanceResponse deleteReplicationInstance(
            Consumer<DeleteReplicationInstanceRequest.Builder> deleteReplicationInstanceRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteReplicationInstance(DeleteReplicationInstanceRequest.builder()
                .applyMutation(deleteReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     *
     * @param deleteReplicationSubnetGroupRequest
     * @return Result of the DeleteReplicationSubnetGroup operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroup(
            DeleteReplicationSubnetGroupRequest deleteReplicationSubnetGroupRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteReplicationSubnetGroup operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroup(
            Consumer<DeleteReplicationSubnetGroupRequest.Builder> deleteReplicationSubnetGroupRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteReplicationSubnetGroup(DeleteReplicationSubnetGroupRequest.builder()
                .applyMutation(deleteReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified replication task.
     * </p>
     *
     * @param deleteReplicationTaskRequest
     * @return Result of the DeleteReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReplicationTaskResponse deleteReplicationTask(DeleteReplicationTaskRequest deleteReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified replication task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReplicationTaskRequest#builder()}
     * </p>
     *
     * @param deleteReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReplicationTaskResponse deleteReplicationTask(
            Consumer<DeleteReplicationTaskRequest.Builder> deleteReplicationTaskRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return deleteReplicationTask(DeleteReplicationTaskRequest.builder().applyMutation(deleteReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Deletes the record of a single premigration assessment run.
     * </p>
     * <p>
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves
     * untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     * </p>
     *
     * @param deleteReplicationTaskAssessmentRunRequest
     * @return Result of the DeleteReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRun(
            DeleteReplicationTaskAssessmentRunRequest deleteReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the record of a single premigration assessment run.
     * </p>
     * <p>
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves
     * untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param deleteReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRun(
            Consumer<DeleteReplicationTaskAssessmentRunRequest.Builder> deleteReplicationTaskAssessmentRunRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteReplicationTaskAssessmentRun(DeleteReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(deleteReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     *
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeAccountAttributes
     * @see #describeAccountAttributes(DescribeAccountAttributesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return Result of the DescribeApplicableIndividualAssessments operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessments(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeApplicableIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeApplicableIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeApplicableIndividualAssessments operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessments(
            Consumer<DescribeApplicableIndividualAssessmentsRequest.Builder> describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeApplicableIndividualAssessments(DescribeApplicableIndividualAssessmentsRequest.builder()
                .applyMutation(describeApplicableIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client
     *             .describeApplicableIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsIterable describeApplicableIndividualAssessmentsPaginator(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return new DescribeApplicableIndividualAssessmentsIterable(this, describeApplicableIndividualAssessmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client
     *             .describeApplicableIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeApplicableIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeApplicableIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsIterable describeApplicableIndividualAssessmentsPaginator(
            Consumer<DescribeApplicableIndividualAssessmentsRequest.Builder> describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeApplicableIndividualAssessmentsPaginator(DescribeApplicableIndividualAssessmentsRequest.builder()
                .applyMutation(describeApplicableIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeCertificates(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest).build());
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     *
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see #describeCertificates(DescribeCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeCertificates(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see #describeCertificatesPaginator(DescribeCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator(DescribeCertificatesRequest describeCertificatesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeCertificatesIterable(this, describeCertificatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     *
     * @param describeConnectionsRequest
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections(DescribeConnectionsRequest describeConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections(
            Consumer<DescribeConnectionsRequest.Builder> describeConnectionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeConnections(DescribeConnectionsRequest.builder().applyMutation(describeConnectionsRequest).build());
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     *
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see #describeConnections(DescribeConnectionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeConnections(DescribeConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client
     *             .describeConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see #describeConnectionsPaginator(DescribeConnectionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsIterable describeConnectionsPaginator() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeConnectionsPaginator(DescribeConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client
     *             .describeConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsIterable describeConnectionsPaginator(DescribeConnectionsRequest describeConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeConnectionsIterable(this, describeConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client
     *             .describeConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsIterable describeConnectionsPaginator(
            Consumer<DescribeConnectionsRequest.Builder> describeConnectionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeConnectionsPaginator(DescribeConnectionsRequest.builder().applyMutation(describeConnectionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns configuration parameters for a schema conversion project.
     * </p>
     *
     * @param describeConversionConfigurationRequest
     * @return Result of the DescribeConversionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConversionConfigurationResponse describeConversionConfiguration(
            DescribeConversionConfigurationRequest describeConversionConfigurationRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration parameters for a schema conversion project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConversionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConversionConfigurationRequest#builder()}
     * </p>
     *
     * @param describeConversionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeConversionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConversionConfigurationResponse describeConversionConfiguration(
            Consumer<DescribeConversionConfigurationRequest.Builder> describeConversionConfigurationRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeConversionConfiguration(DescribeConversionConfigurationRequest.builder()
                .applyMutation(describeConversionConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about data migrations.
     * </p>
     *
     * @param describeDataMigrationsRequest
     * @return Result of the DescribeDataMigrations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataMigrationsResponse describeDataMigrations(DescribeDataMigrationsRequest describeDataMigrationsRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about data migrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataMigrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataMigrationsRequest#builder()}
     * </p>
     *
     * @param describeDataMigrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeDataMigrations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataMigrationsResponse describeDataMigrations(
            Consumer<DescribeDataMigrationsRequest.Builder> describeDataMigrationsRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeDataMigrations(DescribeDataMigrationsRequest.builder().applyMutation(describeDataMigrationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDataMigrations(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsIterable responses = client.describeDataMigrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsIterable responses = client
     *             .describeDataMigrationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsIterable responses = client.describeDataMigrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataMigrations(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataMigrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataMigrationsIterable describeDataMigrationsPaginator(
            DescribeDataMigrationsRequest describeDataMigrationsRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeDataMigrationsIterable(this, describeDataMigrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDataMigrations(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsIterable responses = client.describeDataMigrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsIterable responses = client
     *             .describeDataMigrationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsIterable responses = client.describeDataMigrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataMigrations(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataMigrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataMigrationsRequest#builder()}
     * </p>
     *
     * @param describeDataMigrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataMigrationsIterable describeDataMigrationsPaginator(
            Consumer<DescribeDataMigrationsRequest.Builder> describeDataMigrationsRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeDataMigrationsPaginator(DescribeDataMigrationsRequest.builder()
                .applyMutation(describeDataMigrationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of data providers for your account in the current region.
     * </p>
     *
     * @param describeDataProvidersRequest
     * @return Result of the DescribeDataProviders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataProvidersResponse describeDataProviders(DescribeDataProvidersRequest describeDataProvidersRequest)
            throws ResourceNotFoundException, AccessDeniedException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of data providers for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataProvidersRequest#builder()}
     * </p>
     *
     * @param describeDataProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeDataProviders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataProvidersResponse describeDataProviders(
            Consumer<DescribeDataProvidersRequest.Builder> describeDataProvidersRequest) throws ResourceNotFoundException,
            AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeDataProviders(DescribeDataProvidersRequest.builder().applyMutation(describeDataProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDataProviders(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersIterable responses = client.describeDataProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersIterable responses = client
     *             .describeDataProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersIterable responses = client.describeDataProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataProviders(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataProvidersIterable describeDataProvidersPaginator(DescribeDataProvidersRequest describeDataProvidersRequest)
            throws ResourceNotFoundException, AccessDeniedException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return new DescribeDataProvidersIterable(this, describeDataProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDataProviders(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersIterable responses = client.describeDataProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersIterable responses = client
     *             .describeDataProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersIterable responses = client.describeDataProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataProviders(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataProvidersRequest#builder()}
     * </p>
     *
     * @param describeDataProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataProvidersIterable describeDataProvidersPaginator(
            Consumer<DescribeDataProvidersRequest.Builder> describeDataProvidersRequest) throws ResourceNotFoundException,
            AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeDataProvidersPaginator(DescribeDataProvidersRequest.builder().applyMutation(describeDataProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return Result of the DescribeEndpointSettings operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsResponse describeEndpointSettings(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEndpointSettingsRequest#builder()}
     * </p>
     *
     * @param describeEndpointSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEndpointSettings operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsResponse describeEndpointSettings(
            Consumer<DescribeEndpointSettingsRequest.Builder> describeEndpointSettingsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointSettings(DescribeEndpointSettingsRequest.builder().applyMutation(describeEndpointSettingsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client
     *             .describeEndpointSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsIterable describeEndpointSettingsPaginator(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeEndpointSettingsIterable(this, describeEndpointSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client
     *             .describeEndpointSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEndpointSettingsRequest#builder()}
     * </p>
     *
     * @param describeEndpointSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsIterable describeEndpointSettingsPaginator(
            Consumer<DescribeEndpointSettingsRequest.Builder> describeEndpointSettingsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointSettingsPaginator(DescribeEndpointSettingsRequest.builder()
                .applyMutation(describeEndpointSettingsRequest).build());
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return Result of the DescribeEndpointTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesResponse describeEndpointTypes(DescribeEndpointTypesRequest describeEndpointTypesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointTypesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointTypesRequest#builder()}
     * </p>
     *
     * @param describeEndpointTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEndpointTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesResponse describeEndpointTypes(
            Consumer<DescribeEndpointTypesRequest.Builder> describeEndpointTypesRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointTypes(DescribeEndpointTypesRequest.builder().applyMutation(describeEndpointTypesRequest).build());
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     *
     * @return Result of the DescribeEndpointTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see #describeEndpointTypes(DescribeEndpointTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesResponse describeEndpointTypes() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeEndpointTypes(DescribeEndpointTypesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client
     *             .describeEndpointTypesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see #describeEndpointTypesPaginator(DescribeEndpointTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesIterable describeEndpointTypesPaginator() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeEndpointTypesPaginator(DescribeEndpointTypesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client
     *             .describeEndpointTypesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesIterable describeEndpointTypesPaginator(DescribeEndpointTypesRequest describeEndpointTypesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEndpointTypesIterable(this, describeEndpointTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client
     *             .describeEndpointTypesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointTypesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointTypesRequest#builder()}
     * </p>
     *
     * @param describeEndpointTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesIterable describeEndpointTypesPaginator(
            Consumer<DescribeEndpointTypesRequest.Builder> describeEndpointTypesRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointTypesPaginator(DescribeEndpointTypesRequest.builder().applyMutation(describeEndpointTypesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     *
     * @param describeEndpointsRequest
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints(Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEndpoints(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     *
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see #describeEndpoints(DescribeEndpointsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpoints(DescribeEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see #describeEndpointsPaginator(DescribeEndpointsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsIterable describeEndpointsPaginator() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointsPaginator(DescribeEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsIterable describeEndpointsPaginator(DescribeEndpointsRequest describeEndpointsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEndpointsIterable(this, describeEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsIterable describeEndpointsPaginator(
            Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEndpointsPaginator(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication instance versions used in the project.
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return Result of the DescribeEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEngineVersionsResponse describeEngineVersions(DescribeEngineVersionsRequest describeEngineVersionsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication instance versions used in the project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEngineVersionsResponse describeEngineVersions(
            Consumer<DescribeEngineVersionsRequest.Builder> describeEngineVersionsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEngineVersions(DescribeEngineVersionsRequest.builder().applyMutation(describeEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEngineVersions(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsIterable responses = client.describeEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsIterable responses = client
     *             .describeEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsIterable responses = client.describeEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineVersions(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEngineVersionsIterable describeEngineVersionsPaginator(
            DescribeEngineVersionsRequest describeEngineVersionsRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeEngineVersionsIterable(this, describeEngineVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEngineVersions(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsIterable responses = client.describeEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsIterable responses = client
     *             .describeEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsIterable responses = client.describeEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineVersions(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEngineVersionsIterable describeEngineVersionsPaginator(
            Consumer<DescribeEngineVersionsRequest.Builder> describeEngineVersionsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEngineVersionsPaginator(DescribeEngineVersionsRequest.builder()
                .applyMutation(describeEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventCategories
     * @see #describeEventCategories(DescribeEventCategoriesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     *
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see #describeEventSubscriptions(DescribeEventSubscriptionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see #describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEventSubscriptionsIterable(this, describeEventSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see #describeEvents(DescribeEventsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents() throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see #describeEventsPaginator(DescribeEventsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEventsIterable(this, describeEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of extension pack associations for the specified migration project. An extension pack is
     * an add-on module that emulates functions present in a source database that are required when converting objects
     * to the target database.
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     * @return Result of the DescribeExtensionPackAssociations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExtensionPackAssociationsResponse describeExtensionPackAssociations(
            DescribeExtensionPackAssociationsRequest describeExtensionPackAssociationsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of extension pack associations for the specified migration project. An extension pack is
     * an add-on module that emulates functions present in a source database that are required when converting objects
     * to the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExtensionPackAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeExtensionPackAssociationsRequest#builder()}
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeExtensionPackAssociations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExtensionPackAssociationsResponse describeExtensionPackAssociations(
            Consumer<DescribeExtensionPackAssociationsRequest.Builder> describeExtensionPackAssociationsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeExtensionPackAssociations(DescribeExtensionPackAssociationsRequest.builder()
                .applyMutation(describeExtensionPackAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeExtensionPackAssociations(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsIterable responses = client.describeExtensionPackAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsIterable responses = client
     *             .describeExtensionPackAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsIterable responses = client.describeExtensionPackAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExtensionPackAssociations(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExtensionPackAssociationsIterable describeExtensionPackAssociationsPaginator(
            DescribeExtensionPackAssociationsRequest describeExtensionPackAssociationsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return new DescribeExtensionPackAssociationsIterable(this, describeExtensionPackAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeExtensionPackAssociations(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsIterable responses = client.describeExtensionPackAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsIterable responses = client
     *             .describeExtensionPackAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsIterable responses = client.describeExtensionPackAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExtensionPackAssociations(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExtensionPackAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeExtensionPackAssociationsRequest#builder()}
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExtensionPackAssociationsIterable describeExtensionPackAssociationsPaginator(
            Consumer<DescribeExtensionPackAssociationsRequest.Builder> describeExtensionPackAssociationsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeExtensionPackAssociationsPaginator(DescribeExtensionPackAssociationsRequest.builder()
                .applyMutation(describeExtensionPackAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the Fleet Advisor collectors in your account.
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     * @return Result of the DescribeFleetAdvisorCollectors operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorCollectorsResponse describeFleetAdvisorCollectors(
            DescribeFleetAdvisorCollectorsRequest describeFleetAdvisorCollectorsRequest) throws InvalidResourceStateException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the Fleet Advisor collectors in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorCollectorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorCollectorsRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeFleetAdvisorCollectors operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorCollectorsResponse describeFleetAdvisorCollectors(
            Consumer<DescribeFleetAdvisorCollectorsRequest.Builder> describeFleetAdvisorCollectorsRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorCollectors(DescribeFleetAdvisorCollectorsRequest.builder()
                .applyMutation(describeFleetAdvisorCollectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorCollectors(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsIterable responses = client.describeFleetAdvisorCollectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsIterable responses = client
     *             .describeFleetAdvisorCollectorsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsIterable responses = client.describeFleetAdvisorCollectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorCollectors(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorCollectorsIterable describeFleetAdvisorCollectorsPaginator(
            DescribeFleetAdvisorCollectorsRequest describeFleetAdvisorCollectorsRequest) throws InvalidResourceStateException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeFleetAdvisorCollectorsIterable(this, describeFleetAdvisorCollectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorCollectors(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsIterable responses = client.describeFleetAdvisorCollectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsIterable responses = client
     *             .describeFleetAdvisorCollectorsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsIterable responses = client.describeFleetAdvisorCollectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorCollectors(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorCollectorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorCollectorsRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorCollectorsIterable describeFleetAdvisorCollectorsPaginator(
            Consumer<DescribeFleetAdvisorCollectorsRequest.Builder> describeFleetAdvisorCollectorsRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorCollectorsPaginator(DescribeFleetAdvisorCollectorsRequest.builder()
                .applyMutation(describeFleetAdvisorCollectorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Fleet Advisor databases in your account.
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     * @return Result of the DescribeFleetAdvisorDatabases operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorDatabasesResponse describeFleetAdvisorDatabases(
            DescribeFleetAdvisorDatabasesRequest describeFleetAdvisorDatabasesRequest) throws InvalidResourceStateException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Fleet Advisor databases in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorDatabasesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorDatabasesRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeFleetAdvisorDatabases operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorDatabasesResponse describeFleetAdvisorDatabases(
            Consumer<DescribeFleetAdvisorDatabasesRequest.Builder> describeFleetAdvisorDatabasesRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorDatabases(DescribeFleetAdvisorDatabasesRequest.builder()
                .applyMutation(describeFleetAdvisorDatabasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorDatabases(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesIterable responses = client.describeFleetAdvisorDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesIterable responses = client
     *             .describeFleetAdvisorDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesIterable responses = client.describeFleetAdvisorDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorDatabases(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorDatabasesIterable describeFleetAdvisorDatabasesPaginator(
            DescribeFleetAdvisorDatabasesRequest describeFleetAdvisorDatabasesRequest) throws InvalidResourceStateException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeFleetAdvisorDatabasesIterable(this, describeFleetAdvisorDatabasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorDatabases(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesIterable responses = client.describeFleetAdvisorDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesIterable responses = client
     *             .describeFleetAdvisorDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesIterable responses = client.describeFleetAdvisorDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorDatabases(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorDatabasesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorDatabasesRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorDatabasesIterable describeFleetAdvisorDatabasesPaginator(
            Consumer<DescribeFleetAdvisorDatabasesRequest.Builder> describeFleetAdvisorDatabasesRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorDatabasesPaginator(DescribeFleetAdvisorDatabasesRequest.builder()
                .applyMutation(describeFleetAdvisorDatabasesRequest).build());
    }

    /**
     * <p>
     * Provides descriptions of large-scale assessment (LSA) analyses produced by your Fleet Advisor collectors.
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     * @return Result of the DescribeFleetAdvisorLsaAnalysis operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorLsaAnalysisResponse describeFleetAdvisorLsaAnalysis(
            DescribeFleetAdvisorLsaAnalysisRequest describeFleetAdvisorLsaAnalysisRequest) throws InvalidResourceStateException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides descriptions of large-scale assessment (LSA) analyses produced by your Fleet Advisor collectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorLsaAnalysisRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorLsaAnalysisRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeFleetAdvisorLsaAnalysis operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorLsaAnalysisResponse describeFleetAdvisorLsaAnalysis(
            Consumer<DescribeFleetAdvisorLsaAnalysisRequest.Builder> describeFleetAdvisorLsaAnalysisRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorLsaAnalysis(DescribeFleetAdvisorLsaAnalysisRequest.builder()
                .applyMutation(describeFleetAdvisorLsaAnalysisRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorLsaAnalysis(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisIterable responses = client.describeFleetAdvisorLsaAnalysisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisIterable responses = client
     *             .describeFleetAdvisorLsaAnalysisPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisIterable responses = client.describeFleetAdvisorLsaAnalysisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorLsaAnalysis(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorLsaAnalysisIterable describeFleetAdvisorLsaAnalysisPaginator(
            DescribeFleetAdvisorLsaAnalysisRequest describeFleetAdvisorLsaAnalysisRequest) throws InvalidResourceStateException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeFleetAdvisorLsaAnalysisIterable(this, describeFleetAdvisorLsaAnalysisRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorLsaAnalysis(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisIterable responses = client.describeFleetAdvisorLsaAnalysisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisIterable responses = client
     *             .describeFleetAdvisorLsaAnalysisPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisIterable responses = client.describeFleetAdvisorLsaAnalysisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorLsaAnalysis(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorLsaAnalysisRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorLsaAnalysisRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorLsaAnalysisIterable describeFleetAdvisorLsaAnalysisPaginator(
            Consumer<DescribeFleetAdvisorLsaAnalysisRequest.Builder> describeFleetAdvisorLsaAnalysisRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorLsaAnalysisPaginator(DescribeFleetAdvisorLsaAnalysisRequest.builder()
                .applyMutation(describeFleetAdvisorLsaAnalysisRequest).build());
    }

    /**
     * <p>
     * Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     * @return Result of the DescribeFleetAdvisorSchemaObjectSummary operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemaObjectSummaryResponse describeFleetAdvisorSchemaObjectSummary(
            DescribeFleetAdvisorSchemaObjectSummaryRequest describeFleetAdvisorSchemaObjectSummaryRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeFleetAdvisorSchemaObjectSummaryRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeFleetAdvisorSchemaObjectSummary operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemaObjectSummaryResponse describeFleetAdvisorSchemaObjectSummary(
            Consumer<DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder> describeFleetAdvisorSchemaObjectSummaryRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorSchemaObjectSummary(DescribeFleetAdvisorSchemaObjectSummaryRequest.builder()
                .applyMutation(describeFleetAdvisorSchemaObjectSummaryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorSchemaObjectSummary(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryIterable responses = client.describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryIterable responses = client
     *             .describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryIterable responses = client.describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorSchemaObjectSummary(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemaObjectSummaryIterable describeFleetAdvisorSchemaObjectSummaryPaginator(
            DescribeFleetAdvisorSchemaObjectSummaryRequest describeFleetAdvisorSchemaObjectSummaryRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeFleetAdvisorSchemaObjectSummaryIterable(this, describeFleetAdvisorSchemaObjectSummaryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorSchemaObjectSummary(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryIterable responses = client.describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryIterable responses = client
     *             .describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryIterable responses = client.describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorSchemaObjectSummary(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeFleetAdvisorSchemaObjectSummaryRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemaObjectSummaryIterable describeFleetAdvisorSchemaObjectSummaryPaginator(
            Consumer<DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder> describeFleetAdvisorSchemaObjectSummaryRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorSchemaObjectSummaryPaginator(DescribeFleetAdvisorSchemaObjectSummaryRequest.builder()
                .applyMutation(describeFleetAdvisorSchemaObjectSummaryRequest).build());
    }

    /**
     * <p>
     * Returns a list of schemas detected by Fleet Advisor Collectors in your account.
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     * @return Result of the DescribeFleetAdvisorSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemasResponse describeFleetAdvisorSchemas(
            DescribeFleetAdvisorSchemasRequest describeFleetAdvisorSchemasRequest) throws InvalidResourceStateException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of schemas detected by Fleet Advisor Collectors in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorSchemasRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorSchemasRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeFleetAdvisorSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemasResponse describeFleetAdvisorSchemas(
            Consumer<DescribeFleetAdvisorSchemasRequest.Builder> describeFleetAdvisorSchemasRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorSchemas(DescribeFleetAdvisorSchemasRequest.builder()
                .applyMutation(describeFleetAdvisorSchemasRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasIterable responses = client.describeFleetAdvisorSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasIterable responses = client
     *             .describeFleetAdvisorSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasIterable responses = client.describeFleetAdvisorSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemasIterable describeFleetAdvisorSchemasPaginator(
            DescribeFleetAdvisorSchemasRequest describeFleetAdvisorSchemasRequest) throws InvalidResourceStateException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeFleetAdvisorSchemasIterable(this, describeFleetAdvisorSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasIterable responses = client.describeFleetAdvisorSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasIterable responses = client
     *             .describeFleetAdvisorSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasIterable responses = client.describeFleetAdvisorSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorSchemasRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorSchemasRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemasIterable describeFleetAdvisorSchemasPaginator(
            Consumer<DescribeFleetAdvisorSchemasRequest.Builder> describeFleetAdvisorSchemasRequest)
            throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeFleetAdvisorSchemasPaginator(DescribeFleetAdvisorSchemasRequest.builder()
                .applyMutation(describeFleetAdvisorSchemasRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of instance profiles for your account in the current region.
     * </p>
     *
     * @param describeInstanceProfilesRequest
     * @return Result of the DescribeInstanceProfiles operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstanceProfilesResponse describeInstanceProfiles(
            DescribeInstanceProfilesRequest describeInstanceProfilesRequest) throws ResourceNotFoundException,
            AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of instance profiles for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param describeInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeInstanceProfiles operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstanceProfilesResponse describeInstanceProfiles(
            Consumer<DescribeInstanceProfilesRequest.Builder> describeInstanceProfilesRequest) throws ResourceNotFoundException,
            AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeInstanceProfiles(DescribeInstanceProfilesRequest.builder().applyMutation(describeInstanceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstanceProfiles(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesIterable responses = client.describeInstanceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesIterable responses = client
     *             .describeInstanceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesIterable responses = client.describeInstanceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceProfiles(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstanceProfilesIterable describeInstanceProfilesPaginator(
            DescribeInstanceProfilesRequest describeInstanceProfilesRequest) throws ResourceNotFoundException,
            AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeInstanceProfilesIterable(this, describeInstanceProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstanceProfiles(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesIterable responses = client.describeInstanceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesIterable responses = client
     *             .describeInstanceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesIterable responses = client.describeInstanceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceProfiles(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param describeInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstanceProfilesIterable describeInstanceProfilesPaginator(
            Consumer<DescribeInstanceProfilesRequest.Builder> describeInstanceProfilesRequest) throws ResourceNotFoundException,
            AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeInstanceProfilesPaginator(DescribeInstanceProfilesRequest.builder()
                .applyMutation(describeInstanceProfilesRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model assessments for your account in the current region.
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     * @return Result of the DescribeMetadataModelAssessments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelAssessmentsResponse describeMetadataModelAssessments(
            DescribeMetadataModelAssessmentsRequest describeMetadataModelAssessmentsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model assessments for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelAssessmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeMetadataModelAssessments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelAssessmentsResponse describeMetadataModelAssessments(
            Consumer<DescribeMetadataModelAssessmentsRequest.Builder> describeMetadataModelAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelAssessments(DescribeMetadataModelAssessmentsRequest.builder()
                .applyMutation(describeMetadataModelAssessmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsIterable responses = client.describeMetadataModelAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsIterable responses = client
     *             .describeMetadataModelAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsIterable responses = client.describeMetadataModelAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelAssessmentsIterable describeMetadataModelAssessmentsPaginator(
            DescribeMetadataModelAssessmentsRequest describeMetadataModelAssessmentsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeMetadataModelAssessmentsIterable(this, describeMetadataModelAssessmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsIterable responses = client.describeMetadataModelAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsIterable responses = client
     *             .describeMetadataModelAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsIterable responses = client.describeMetadataModelAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelAssessmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelAssessmentsIterable describeMetadataModelAssessmentsPaginator(
            Consumer<DescribeMetadataModelAssessmentsRequest.Builder> describeMetadataModelAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelAssessmentsPaginator(DescribeMetadataModelAssessmentsRequest.builder()
                .applyMutation(describeMetadataModelAssessmentsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model conversions for a migration project.
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     * @return Result of the DescribeMetadataModelConversions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelConversionsResponse describeMetadataModelConversions(
            DescribeMetadataModelConversionsRequest describeMetadataModelConversionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model conversions for a migration project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelConversionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelConversionsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeMetadataModelConversions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelConversionsResponse describeMetadataModelConversions(
            Consumer<DescribeMetadataModelConversionsRequest.Builder> describeMetadataModelConversionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelConversions(DescribeMetadataModelConversionsRequest.builder()
                .applyMutation(describeMetadataModelConversionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelConversions(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsIterable responses = client.describeMetadataModelConversionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsIterable responses = client
     *             .describeMetadataModelConversionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsIterable responses = client.describeMetadataModelConversionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelConversions(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelConversionsIterable describeMetadataModelConversionsPaginator(
            DescribeMetadataModelConversionsRequest describeMetadataModelConversionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeMetadataModelConversionsIterable(this, describeMetadataModelConversionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelConversions(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsIterable responses = client.describeMetadataModelConversionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsIterable responses = client
     *             .describeMetadataModelConversionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsIterable responses = client.describeMetadataModelConversionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelConversions(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelConversionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelConversionsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelConversionsIterable describeMetadataModelConversionsPaginator(
            Consumer<DescribeMetadataModelConversionsRequest.Builder> describeMetadataModelConversionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelConversionsPaginator(DescribeMetadataModelConversionsRequest.builder()
                .applyMutation(describeMetadataModelConversionsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     * @return Result of the DescribeMetadataModelExportsAsScript operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsAsScriptResponse describeMetadataModelExportsAsScript(
            DescribeMetadataModelExportsAsScriptRequest describeMetadataModelExportsAsScriptRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMetadataModelExportsAsScriptRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMetadataModelExportsAsScriptRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeMetadataModelExportsAsScript operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsAsScriptResponse describeMetadataModelExportsAsScript(
            Consumer<DescribeMetadataModelExportsAsScriptRequest.Builder> describeMetadataModelExportsAsScriptRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelExportsAsScript(DescribeMetadataModelExportsAsScriptRequest.builder()
                .applyMutation(describeMetadataModelExportsAsScriptRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelExportsAsScript(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptIterable responses = client.describeMetadataModelExportsAsScriptPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptIterable responses = client
     *             .describeMetadataModelExportsAsScriptPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptIterable responses = client.describeMetadataModelExportsAsScriptPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelExportsAsScript(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsAsScriptIterable describeMetadataModelExportsAsScriptPaginator(
            DescribeMetadataModelExportsAsScriptRequest describeMetadataModelExportsAsScriptRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeMetadataModelExportsAsScriptIterable(this, describeMetadataModelExportsAsScriptRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelExportsAsScript(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptIterable responses = client.describeMetadataModelExportsAsScriptPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptIterable responses = client
     *             .describeMetadataModelExportsAsScriptPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptIterable responses = client.describeMetadataModelExportsAsScriptPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelExportsAsScript(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMetadataModelExportsAsScriptRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMetadataModelExportsAsScriptRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsAsScriptIterable describeMetadataModelExportsAsScriptPaginator(
            Consumer<DescribeMetadataModelExportsAsScriptRequest.Builder> describeMetadataModelExportsAsScriptRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelExportsAsScriptPaginator(DescribeMetadataModelExportsAsScriptRequest.builder()
                .applyMutation(describeMetadataModelExportsAsScriptRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     * @return Result of the DescribeMetadataModelExportsToTarget operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsToTargetResponse describeMetadataModelExportsToTarget(
            DescribeMetadataModelExportsToTargetRequest describeMetadataModelExportsToTargetRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMetadataModelExportsToTargetRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMetadataModelExportsToTargetRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeMetadataModelExportsToTarget operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsToTargetResponse describeMetadataModelExportsToTarget(
            Consumer<DescribeMetadataModelExportsToTargetRequest.Builder> describeMetadataModelExportsToTargetRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelExportsToTarget(DescribeMetadataModelExportsToTargetRequest.builder()
                .applyMutation(describeMetadataModelExportsToTargetRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelExportsToTarget(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetIterable responses = client.describeMetadataModelExportsToTargetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetIterable responses = client
     *             .describeMetadataModelExportsToTargetPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetIterable responses = client.describeMetadataModelExportsToTargetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelExportsToTarget(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsToTargetIterable describeMetadataModelExportsToTargetPaginator(
            DescribeMetadataModelExportsToTargetRequest describeMetadataModelExportsToTargetRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeMetadataModelExportsToTargetIterable(this, describeMetadataModelExportsToTargetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelExportsToTarget(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetIterable responses = client.describeMetadataModelExportsToTargetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetIterable responses = client
     *             .describeMetadataModelExportsToTargetPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetIterable responses = client.describeMetadataModelExportsToTargetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelExportsToTarget(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMetadataModelExportsToTargetRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMetadataModelExportsToTargetRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsToTargetIterable describeMetadataModelExportsToTargetPaginator(
            Consumer<DescribeMetadataModelExportsToTargetRequest.Builder> describeMetadataModelExportsToTargetRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelExportsToTargetPaginator(DescribeMetadataModelExportsToTargetRequest.builder()
                .applyMutation(describeMetadataModelExportsToTargetRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model imports.
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     * @return Result of the DescribeMetadataModelImports operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelImportsResponse describeMetadataModelImports(
            DescribeMetadataModelImportsRequest describeMetadataModelImportsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model imports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelImportsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelImportsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeMetadataModelImports operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelImportsResponse describeMetadataModelImports(
            Consumer<DescribeMetadataModelImportsRequest.Builder> describeMetadataModelImportsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelImports(DescribeMetadataModelImportsRequest.builder()
                .applyMutation(describeMetadataModelImportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelImports(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsIterable responses = client.describeMetadataModelImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsIterable responses = client
     *             .describeMetadataModelImportsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsIterable responses = client.describeMetadataModelImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelImports(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelImportsIterable describeMetadataModelImportsPaginator(
            DescribeMetadataModelImportsRequest describeMetadataModelImportsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeMetadataModelImportsIterable(this, describeMetadataModelImportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelImports(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsIterable responses = client.describeMetadataModelImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsIterable responses = client
     *             .describeMetadataModelImportsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsIterable responses = client.describeMetadataModelImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelImports(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelImportsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelImportsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelImportsIterable describeMetadataModelImportsPaginator(
            Consumer<DescribeMetadataModelImportsRequest.Builder> describeMetadataModelImportsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeMetadataModelImportsPaginator(DescribeMetadataModelImportsRequest.builder()
                .applyMutation(describeMetadataModelImportsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of migration projects for your account in the current region.
     * </p>
     *
     * @param describeMigrationProjectsRequest
     * @return Result of the DescribeMigrationProjects operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMigrationProjectsResponse describeMigrationProjects(
            DescribeMigrationProjectsRequest describeMigrationProjectsRequest) throws ResourceNotFoundException,
            AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of migration projects for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMigrationProjectsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMigrationProjectsRequest#builder()}
     * </p>
     *
     * @param describeMigrationProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeMigrationProjects operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMigrationProjectsResponse describeMigrationProjects(
            Consumer<DescribeMigrationProjectsRequest.Builder> describeMigrationProjectsRequest)
            throws ResourceNotFoundException, AccessDeniedException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeMigrationProjects(DescribeMigrationProjectsRequest.builder()
                .applyMutation(describeMigrationProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMigrationProjects(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsIterable responses = client.describeMigrationProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsIterable responses = client
     *             .describeMigrationProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsIterable responses = client.describeMigrationProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMigrationProjects(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMigrationProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMigrationProjectsIterable describeMigrationProjectsPaginator(
            DescribeMigrationProjectsRequest describeMigrationProjectsRequest) throws ResourceNotFoundException,
            AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeMigrationProjectsIterable(this, describeMigrationProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMigrationProjects(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsIterable responses = client.describeMigrationProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsIterable responses = client
     *             .describeMigrationProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsIterable responses = client.describeMigrationProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMigrationProjects(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMigrationProjectsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMigrationProjectsRequest#builder()}
     * </p>
     *
     * @param describeMigrationProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMigrationProjectsIterable describeMigrationProjectsPaginator(
            Consumer<DescribeMigrationProjectsRequest.Builder> describeMigrationProjectsRequest)
            throws ResourceNotFoundException, AccessDeniedException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeMigrationProjectsPaginator(DescribeMigrationProjectsRequest.builder()
                .applyMutation(describeMigrationProjectsRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return Result of the DescribeOrderableReplicationInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrderableReplicationInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrderableReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeOrderableReplicationInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances(
            Consumer<DescribeOrderableReplicationInstancesRequest.Builder> describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest.builder()
                .applyMutation(describeOrderableReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     *
     * @return Result of the DescribeOrderableReplicationInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see #describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances() throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client
     *             .describeOrderableReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see #describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesIterable describeOrderableReplicationInstancesPaginator()
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client
     *             .describeOrderableReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesIterable describeOrderableReplicationInstancesPaginator(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeOrderableReplicationInstancesIterable(this, describeOrderableReplicationInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client
     *             .describeOrderableReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrderableReplicationInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrderableReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesIterable describeOrderableReplicationInstancesPaginator(
            Consumer<DescribeOrderableReplicationInstancesRequest.Builder> describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest.builder()
                .applyMutation(describeOrderableReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * For internal use only
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For internal use only
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client
     *             .describePendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribePendingMaintenanceActionsIterable(this, describePendingMaintenanceActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client
     *             .describePendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of limitations for recommendations of target Amazon Web Services engines.
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     * @return Result of the DescribeRecommendationLimitations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommendationLimitationsResponse describeRecommendationLimitations(
            DescribeRecommendationLimitationsRequest describeRecommendationLimitationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of limitations for recommendations of target Amazon Web Services engines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationLimitationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRecommendationLimitationsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRecommendationLimitations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommendationLimitationsResponse describeRecommendationLimitations(
            Consumer<DescribeRecommendationLimitationsRequest.Builder> describeRecommendationLimitationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeRecommendationLimitations(DescribeRecommendationLimitationsRequest.builder()
                .applyMutation(describeRecommendationLimitationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRecommendationLimitations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsIterable responses = client.describeRecommendationLimitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsIterable responses = client
     *             .describeRecommendationLimitationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsIterable responses = client.describeRecommendationLimitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendationLimitations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommendationLimitationsIterable describeRecommendationLimitationsPaginator(
            DescribeRecommendationLimitationsRequest describeRecommendationLimitationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeRecommendationLimitationsIterable(this, describeRecommendationLimitationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRecommendationLimitations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsIterable responses = client.describeRecommendationLimitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsIterable responses = client
     *             .describeRecommendationLimitationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsIterable responses = client.describeRecommendationLimitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendationLimitations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationLimitationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRecommendationLimitationsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommendationLimitationsIterable describeRecommendationLimitationsPaginator(
            Consumer<DescribeRecommendationLimitationsRequest.Builder> describeRecommendationLimitationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeRecommendationLimitationsPaginator(DescribeRecommendationLimitationsRequest.builder()
                .applyMutation(describeRecommendationLimitationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of target engine recommendations for your source databases.
     * </p>
     *
     * @param describeRecommendationsRequest
     * @return Result of the DescribeRecommendations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecommendationsResponse describeRecommendations(DescribeRecommendationsRequest describeRecommendationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of target engine recommendations for your source databases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRecommendationsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRecommendations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecommendationsResponse describeRecommendations(
            Consumer<DescribeRecommendationsRequest.Builder> describeRecommendationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeRecommendations(DescribeRecommendationsRequest.builder().applyMutation(describeRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRecommendations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsIterable responses = client.describeRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsIterable responses = client
     *             .describeRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsIterable responses = client.describeRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecommendationsIterable describeRecommendationsPaginator(
            DescribeRecommendationsRequest describeRecommendationsRequest) throws InvalidResourceStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeRecommendationsIterable(this, describeRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRecommendations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsIterable responses = client.describeRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsIterable responses = client
     *             .describeRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsIterable responses = client.describeRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRecommendationsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecommendationsIterable describeRecommendationsPaginator(
            Consumer<DescribeRecommendationsRequest.Builder> describeRecommendationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeRecommendationsPaginator(DescribeRecommendationsRequest.builder()
                .applyMutation(describeRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns the status of the RefreshSchemas operation.
     * </p>
     *
     * @param describeRefreshSchemasStatusRequest
     * @return Result of the DescribeRefreshSchemasStatus operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRefreshSchemasStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatus(
            DescribeRefreshSchemasStatusRequest describeRefreshSchemasStatusRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of the RefreshSchemas operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRefreshSchemasStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRefreshSchemasStatusRequest#builder()}
     * </p>
     *
     * @param describeRefreshSchemasStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeRefreshSchemasStatus operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRefreshSchemasStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatus(
            Consumer<DescribeRefreshSchemasStatusRequest.Builder> describeRefreshSchemasStatusRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeRefreshSchemasStatus(DescribeRefreshSchemasStatusRequest.builder()
                .applyMutation(describeRefreshSchemasStatusRequest).build());
    }

    /**
     * <p>
     * Returns one or more existing DMS Serverless replication configurations as a list of structures.
     * </p>
     *
     * @param describeReplicationConfigsRequest
     * @return Result of the DescribeReplicationConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigsResponse describeReplicationConfigs(
            DescribeReplicationConfigsRequest describeReplicationConfigsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more existing DMS Serverless replication configurations as a list of structures.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationConfigsRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigsResponse describeReplicationConfigs(
            Consumer<DescribeReplicationConfigsRequest.Builder> describeReplicationConfigsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationConfigs(DescribeReplicationConfigsRequest.builder()
                .applyMutation(describeReplicationConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsIterable responses = client.describeReplicationConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsIterable responses = client
     *             .describeReplicationConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsIterable responses = client.describeReplicationConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigsIterable describeReplicationConfigsPaginator(
            DescribeReplicationConfigsRequest describeReplicationConfigsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationConfigsIterable(this, describeReplicationConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsIterable responses = client.describeReplicationConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsIterable responses = client
     *             .describeReplicationConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsIterable responses = client.describeReplicationConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationConfigsRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigsIterable describeReplicationConfigsPaginator(
            Consumer<DescribeReplicationConfigsRequest.Builder> describeReplicationConfigsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationConfigsPaginator(DescribeReplicationConfigsRequest.builder()
                .applyMutation(describeReplicationConfigsRequest).build());
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return Result of the DescribeReplicationInstanceTaskLogs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogs(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstanceTaskLogsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstanceTaskLogsRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationInstanceTaskLogs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogs(
            Consumer<DescribeReplicationInstanceTaskLogsRequest.Builder> describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsRequest.builder()
                .applyMutation(describeReplicationInstanceTaskLogsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client
     *             .describeReplicationInstanceTaskLogsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsIterable describeReplicationInstanceTaskLogsPaginator(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeReplicationInstanceTaskLogsIterable(this, describeReplicationInstanceTaskLogsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client
     *             .describeReplicationInstanceTaskLogsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstanceTaskLogsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstanceTaskLogsRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsIterable describeReplicationInstanceTaskLogsPaginator(
            Consumer<DescribeReplicationInstanceTaskLogsRequest.Builder> describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeReplicationInstanceTaskLogsPaginator(DescribeReplicationInstanceTaskLogsRequest.builder()
                .applyMutation(describeReplicationInstanceTaskLogsRequest).build());
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return Result of the DescribeReplicationInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesResponse describeReplicationInstances(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesResponse describeReplicationInstances(
            Consumer<DescribeReplicationInstancesRequest.Builder> describeReplicationInstancesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationInstances(DescribeReplicationInstancesRequest.builder()
                .applyMutation(describeReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     *
     * @return Result of the DescribeReplicationInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see #describeReplicationInstances(DescribeReplicationInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesResponse describeReplicationInstances() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationInstances(DescribeReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client
     *             .describeReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see #describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesIterable describeReplicationInstancesPaginator() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client
     *             .describeReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesIterable describeReplicationInstancesPaginator(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationInstancesIterable(this, describeReplicationInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client
     *             .describeReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesIterable describeReplicationInstancesPaginator(
            Consumer<DescribeReplicationInstancesRequest.Builder> describeReplicationInstancesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest.builder()
                .applyMutation(describeReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return Result of the DescribeReplicationSubnetGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationSubnetGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups(
            Consumer<DescribeReplicationSubnetGroupsRequest.Builder> describeReplicationSubnetGroupsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest.builder()
                .applyMutation(describeReplicationSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     *
     * @return Result of the DescribeReplicationSubnetGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see #describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client
     *             .describeReplicationSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see #describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsIterable describeReplicationSubnetGroupsPaginator() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client
     *             .describeReplicationSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsIterable describeReplicationSubnetGroupsPaginator(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationSubnetGroupsIterable(this, describeReplicationSubnetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client
     *             .describeReplicationSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsIterable describeReplicationSubnetGroupsPaginator(
            Consumer<DescribeReplicationSubnetGroupsRequest.Builder> describeReplicationSubnetGroupsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest.builder()
                .applyMutation(describeReplicationSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns table and schema statistics for one or more provisioned replications that use a given DMS Serverless
     * replication configuration.
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     * @return Result of the DescribeReplicationTableStatistics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTableStatisticsResponse describeReplicationTableStatistics(
            DescribeReplicationTableStatisticsRequest describeReplicationTableStatisticsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns table and schema statistics for one or more provisioned replications that use a given DMS Serverless
     * replication configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTableStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationTableStatistics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTableStatisticsResponse describeReplicationTableStatistics(
            Consumer<DescribeReplicationTableStatisticsRequest.Builder> describeReplicationTableStatisticsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeReplicationTableStatistics(DescribeReplicationTableStatisticsRequest.builder()
                .applyMutation(describeReplicationTableStatisticsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsIterable responses = client.describeReplicationTableStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsIterable responses = client
     *             .describeReplicationTableStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsIterable responses = client.describeReplicationTableStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTableStatisticsIterable describeReplicationTableStatisticsPaginator(
            DescribeReplicationTableStatisticsRequest describeReplicationTableStatisticsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeReplicationTableStatisticsIterable(this, describeReplicationTableStatisticsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsIterable responses = client.describeReplicationTableStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsIterable responses = client
     *             .describeReplicationTableStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsIterable responses = client.describeReplicationTableStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTableStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTableStatisticsIterable describeReplicationTableStatisticsPaginator(
            Consumer<DescribeReplicationTableStatisticsRequest.Builder> describeReplicationTableStatisticsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeReplicationTableStatisticsPaginator(DescribeReplicationTableStatisticsRequest.builder()
                .applyMutation(describeReplicationTableStatisticsRequest).build());
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return Result of the DescribeReplicationTaskAssessmentResults operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResults(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentResultsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentResultsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationTaskAssessmentResults operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResults(
            Consumer<DescribeReplicationTaskAssessmentResultsRequest.Builder> describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskAssessmentResults(DescribeReplicationTaskAssessmentResultsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentResultsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client
     *             .describeReplicationTaskAssessmentResultsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsIterable describeReplicationTaskAssessmentResultsPaginator(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskAssessmentResultsIterable(this, describeReplicationTaskAssessmentResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client
     *             .describeReplicationTaskAssessmentResultsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentResultsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentResultsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsIterable describeReplicationTaskAssessmentResultsPaginator(
            Consumer<DescribeReplicationTaskAssessmentResultsRequest.Builder> describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskAssessmentResultsPaginator(DescribeReplicationTaskAssessmentResultsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentResultsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return Result of the DescribeReplicationTaskAssessmentRuns operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRuns(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentRunsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationTaskAssessmentRuns operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRuns(
            Consumer<DescribeReplicationTaskAssessmentRunsRequest.Builder> describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client
     *             .describeReplicationTaskAssessmentRunsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsIterable describeReplicationTaskAssessmentRunsPaginator(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskAssessmentRunsIterable(this, describeReplicationTaskAssessmentRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client
     *             .describeReplicationTaskAssessmentRunsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentRunsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsIterable describeReplicationTaskAssessmentRunsPaginator(
            Consumer<DescribeReplicationTaskAssessmentRunsRequest.Builder> describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskAssessmentRunsPaginator(DescribeReplicationTaskAssessmentRunsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return Result of the DescribeReplicationTaskIndividualAssessments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessments(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationTaskIndividualAssessments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessments(
            Consumer<DescribeReplicationTaskIndividualAssessmentsRequest.Builder> describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskIndividualAssessments(DescribeReplicationTaskIndividualAssessmentsRequest.builder()
                .applyMutation(describeReplicationTaskIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client
     *             .describeReplicationTaskIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsIterable describeReplicationTaskIndividualAssessmentsPaginator(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskIndividualAssessmentsIterable(this, describeReplicationTaskIndividualAssessmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client
     *             .describeReplicationTaskIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsIterable describeReplicationTaskIndividualAssessmentsPaginator(
            Consumer<DescribeReplicationTaskIndividualAssessmentsRequest.Builder> describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskIndividualAssessmentsPaginator(DescribeReplicationTaskIndividualAssessmentsRequest
                .builder().applyMutation(describeReplicationTaskIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return Result of the DescribeReplicationTasks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksResponse describeReplicationTasks(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTasksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationTasksRequest#builder()}
     * </p>
     *
     * @param describeReplicationTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeReplicationTasks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksResponse describeReplicationTasks(
            Consumer<DescribeReplicationTasksRequest.Builder> describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTasks(DescribeReplicationTasksRequest.builder().applyMutation(describeReplicationTasksRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     *
     * @return Result of the DescribeReplicationTasks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see #describeReplicationTasks(DescribeReplicationTasksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksResponse describeReplicationTasks() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeReplicationTasks(DescribeReplicationTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client
     *             .describeReplicationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see #describeReplicationTasksPaginator(DescribeReplicationTasksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksIterable describeReplicationTasksPaginator() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTasksPaginator(DescribeReplicationTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client
     *             .describeReplicationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksIterable describeReplicationTasksPaginator(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTasksIterable(this, describeReplicationTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client
     *             .describeReplicationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTasksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationTasksRequest#builder()}
     * </p>
     *
     * @param describeReplicationTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksIterable describeReplicationTasksPaginator(
            Consumer<DescribeReplicationTasksRequest.Builder> describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTasksPaginator(DescribeReplicationTasksRequest.builder()
                .applyMutation(describeReplicationTasksRequest).build());
    }

    /**
     * <p>
     * Provides details on replication progress by returning status information for one or more provisioned DMS
     * Serverless replications.
     * </p>
     *
     * @param describeReplicationsRequest
     * @return Result of the DescribeReplications operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReplicationsResponse describeReplications(DescribeReplicationsRequest describeReplicationsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details on replication progress by returning status information for one or more provisioned DMS
     * Serverless replications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReplicationsRequest#builder()}
     * </p>
     *
     * @param describeReplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeReplications operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReplicationsResponse describeReplications(
            Consumer<DescribeReplicationsRequest.Builder> describeReplicationsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplications(DescribeReplicationsRequest.builder().applyMutation(describeReplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplications(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsIterable responses = client.describeReplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsIterable responses = client
     *             .describeReplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsIterable responses = client.describeReplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplications(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReplicationsIterable describeReplicationsPaginator(DescribeReplicationsRequest describeReplicationsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationsIterable(this, describeReplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplications(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsIterable responses = client.describeReplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsIterable responses = client
     *             .describeReplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsIterable responses = client.describeReplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplications(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReplicationsRequest#builder()}
     * </p>
     *
     * @param describeReplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReplicationsIterable describeReplicationsPaginator(
            Consumer<DescribeReplicationsRequest.Builder> describeReplicationsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationsPaginator(DescribeReplicationsRequest.builder().applyMutation(describeReplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     *
     * @param describeSchemasRequest
     * @return Result of the DescribeSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasResponse describeSchemas(DescribeSchemasRequest describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSchemasRequest#builder()}
     * </p>
     *
     * @param describeSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasResponse describeSchemas(Consumer<DescribeSchemasRequest.Builder> describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeSchemas(DescribeSchemasRequest.builder().applyMutation(describeSchemasRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client
     *             .describeSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasIterable describeSchemasPaginator(DescribeSchemasRequest describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeSchemasIterable(this, describeSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client
     *             .describeSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSchemasRequest#builder()}
     * </p>
     *
     * @param describeSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasIterable describeSchemasPaginator(Consumer<DescribeSchemasRequest.Builder> describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeSchemasPaginator(DescribeSchemasRequest.builder().applyMutation(describeSchemasRequest).build());
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return Result of the DescribeTableStatistics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsResponse describeTableStatistics(DescribeTableStatisticsRequest describeTableStatisticsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeTableStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeTableStatistics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsResponse describeTableStatistics(
            Consumer<DescribeTableStatisticsRequest.Builder> describeTableStatisticsRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeTableStatistics(DescribeTableStatisticsRequest.builder().applyMutation(describeTableStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client
     *             .describeTableStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsIterable describeTableStatisticsPaginator(
            DescribeTableStatisticsRequest describeTableStatisticsRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeTableStatisticsIterable(this, describeTableStatisticsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client
     *             .describeTableStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeTableStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsIterable describeTableStatisticsPaginator(
            Consumer<DescribeTableStatisticsRequest.Builder> describeTableStatisticsRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeTableStatisticsPaginator(DescribeTableStatisticsRequest.builder()
                .applyMutation(describeTableStatisticsRequest).build());
    }

    /**
     * <p>
     * Saves a copy of a database migration assessment report to your Amazon S3 bucket. DMS can save your assessment
     * report as a comma-separated value (CSV) or a PDF file.
     * </p>
     *
     * @param exportMetadataModelAssessmentRequest
     * @return Result of the ExportMetadataModelAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ExportMetadataModelAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ExportMetadataModelAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportMetadataModelAssessmentResponse exportMetadataModelAssessment(
            ExportMetadataModelAssessmentRequest exportMetadataModelAssessmentRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Saves a copy of a database migration assessment report to your Amazon S3 bucket. DMS can save your assessment
     * report as a comma-separated value (CSV) or a PDF file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportMetadataModelAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link ExportMetadataModelAssessmentRequest#builder()}
     * </p>
     *
     * @param exportMetadataModelAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest.Builder}
     *        to create a request.
     * @return Result of the ExportMetadataModelAssessment operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ExportMetadataModelAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ExportMetadataModelAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportMetadataModelAssessmentResponse exportMetadataModelAssessment(
            Consumer<ExportMetadataModelAssessmentRequest.Builder> exportMetadataModelAssessmentRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return exportMetadataModelAssessment(ExportMetadataModelAssessmentRequest.builder()
                .applyMutation(exportMetadataModelAssessmentRequest).build());
    }

    /**
     * <p>
     * Uploads the specified certificate.
     * </p>
     *
     * @param importCertificateRequest
     * @return Result of the ImportCertificate operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InvalidCertificateException
     *         The certificate was not valid.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportCertificateResponse importCertificate(ImportCertificateRequest importCertificateRequest)
            throws ResourceAlreadyExistsException, InvalidCertificateException, ResourceQuotaExceededException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads the specified certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link ImportCertificateRequest#builder()}
     * </p>
     *
     * @param importCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest.Builder} to create
     *        a request.
     * @return Result of the ImportCertificate operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InvalidCertificateException
     *         The certificate was not valid.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportCertificateResponse importCertificate(Consumer<ImportCertificateRequest.Builder> importCertificateRequest)
            throws ResourceAlreadyExistsException, InvalidCertificateException, ResourceQuotaExceededException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return importCertificate(ImportCertificateRequest.builder().applyMutation(importCertificateRequest).build());
    }

    /**
     * <p>
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, subnet group, and
     * migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, subnet group, and
     * migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the specified schema conversion configuration using the provided parameters.
     * </p>
     *
     * @param modifyConversionConfigurationRequest
     * @return Result of the ModifyConversionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyConversionConfigurationResponse modifyConversionConfiguration(
            ModifyConversionConfigurationRequest modifyConversionConfigurationRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified schema conversion configuration using the provided parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyConversionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyConversionConfigurationRequest#builder()}
     * </p>
     *
     * @param modifyConversionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the ModifyConversionConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyConversionConfigurationResponse modifyConversionConfiguration(
            Consumer<ModifyConversionConfigurationRequest.Builder> modifyConversionConfigurationRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return modifyConversionConfiguration(ModifyConversionConfigurationRequest.builder()
                .applyMutation(modifyConversionConfigurationRequest).build());
    }

    /**
     * <p>
     * Modifies an existing DMS data migration.
     * </p>
     *
     * @param modifyDataMigrationRequest
     * @return Result of the ModifyDataMigration operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDataMigrationResponse modifyDataMigration(ModifyDataMigrationRequest modifyDataMigrationRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DMS data migration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDataMigrationRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDataMigrationRequest#builder()}
     * </p>
     *
     * @param modifyDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyDataMigration operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDataMigrationResponse modifyDataMigration(
            Consumer<ModifyDataMigrationRequest.Builder> modifyDataMigrationRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return modifyDataMigration(ModifyDataMigrationRequest.builder().applyMutation(modifyDataMigrationRequest).build());
    }

    /**
     * <p>
     * Modifies the specified data provider using the provided settings.
     * </p>
     * <note>
     * <p>
     * You must remove the data provider from all migration projects before you can modify it.
     * </p>
     * </note>
     *
     * @param modifyDataProviderRequest
     * @return Result of the ModifyDataProvider operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDataProviderResponse modifyDataProvider(ModifyDataProviderRequest modifyDataProviderRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified data provider using the provided settings.
     * </p>
     * <note>
     * <p>
     * You must remove the data provider from all migration projects before you can modify it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDataProviderRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDataProviderRequest#builder()}
     * </p>
     *
     * @param modifyDataProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyDataProvider operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDataProviderResponse modifyDataProvider(Consumer<ModifyDataProviderRequest.Builder> modifyDataProviderRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return modifyDataProvider(ModifyDataProviderRequest.builder().applyMutation(modifyDataProviderRequest).build());
    }

    /**
     * <p>
     * Modifies the specified endpoint.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param modifyEndpointRequest
     * @return Result of the ModifyEndpoint operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyEndpointResponse modifyEndpoint(ModifyEndpointRequest modifyEndpointRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException,
            KmsKeyNotAccessibleException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified endpoint.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyEndpointRequest#builder()}
     * </p>
     *
     * @param modifyEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyEndpoint operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyEndpointResponse modifyEndpoint(Consumer<ModifyEndpointRequest.Builder> modifyEndpointRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException,
            KmsKeyNotAccessibleException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return modifyEndpoint(ModifyEndpointRequest.builder().applyMutation(modifyEndpointRequest).build());
    }

    /**
     * <p>
     * Modifies an existing DMS event notification subscription.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, SnsInvalidTopicException,
            SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException,
            KmsNotFoundException, KmsThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DMS event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyEventSubscriptionResponse modifyEventSubscription(
            Consumer<ModifyEventSubscriptionRequest.Builder> modifyEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, SnsInvalidTopicException,
            SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException,
            KmsNotFoundException, KmsThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return modifyEventSubscription(ModifyEventSubscriptionRequest.builder().applyMutation(modifyEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the specified instance profile using the provided parameters.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can modify the
     * instance profile.
     * </p>
     * </note>
     *
     * @param modifyInstanceProfileRequest
     * @return Result of the ModifyInstanceProfile operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyInstanceProfileResponse modifyInstanceProfile(ModifyInstanceProfileRequest modifyInstanceProfileRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, KmsKeyNotAccessibleException,
            S3ResourceNotFoundException, S3AccessDeniedException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified instance profile using the provided parameters.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can modify the
     * instance profile.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyInstanceProfileRequest#builder()}
     * </p>
     *
     * @param modifyInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyInstanceProfile operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyInstanceProfileResponse modifyInstanceProfile(
            Consumer<ModifyInstanceProfileRequest.Builder> modifyInstanceProfileRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, KmsKeyNotAccessibleException, S3ResourceNotFoundException,
            S3AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return modifyInstanceProfile(ModifyInstanceProfileRequest.builder().applyMutation(modifyInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Modifies the specified migration project using the provided parameters.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can modify it.
     * </p>
     * </note>
     *
     * @param modifyMigrationProjectRequest
     * @return Result of the ModifyMigrationProject operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyMigrationProjectResponse modifyMigrationProject(ModifyMigrationProjectRequest modifyMigrationProjectRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, S3ResourceNotFoundException,
            S3AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified migration project using the provided parameters.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can modify it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyMigrationProjectRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyMigrationProjectRequest#builder()}
     * </p>
     *
     * @param modifyMigrationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyMigrationProject operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyMigrationProjectResponse modifyMigrationProject(
            Consumer<ModifyMigrationProjectRequest.Builder> modifyMigrationProjectRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, S3ResourceNotFoundException, S3AccessDeniedException,
            FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return modifyMigrationProject(ModifyMigrationProjectRequest.builder().applyMutation(modifyMigrationProjectRequest)
                .build());
    }

    /**
     * <p>
     * Modifies an existing DMS Serverless replication configuration that you can use to start a replication. This
     * command includes input validation and logic to check the state of any replication that uses this configuration.
     * You can only modify a replication configuration before any replication that uses it has started. As soon as you
     * have initially started a replication with a given configuiration, you can't modify that configuration, even if
     * you stop it.
     * </p>
     * <p>
     * Other run statuses that allow you to run this command include FAILED and CREATED. A provisioning state that
     * allows you to run this command is FAILED_PROVISION.
     * </p>
     *
     * @param modifyReplicationConfigRequest
     * @return Result of the ModifyReplicationConfig operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyReplicationConfigResponse modifyReplicationConfig(ModifyReplicationConfigRequest modifyReplicationConfigRequest)
            throws AccessDeniedException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidSubnetException, KmsKeyNotAccessibleException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DMS Serverless replication configuration that you can use to start a replication. This
     * command includes input validation and logic to check the state of any replication that uses this configuration.
     * You can only modify a replication configuration before any replication that uses it has started. As soon as you
     * have initially started a replication with a given configuiration, you can't modify that configuration, even if
     * you stop it.
     * </p>
     * <p>
     * Other run statuses that allow you to run this command include FAILED and CREATED. A provisioning state that
     * allows you to run this command is FAILED_PROVISION.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationConfigRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyReplicationConfigRequest#builder()}
     * </p>
     *
     * @param modifyReplicationConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyReplicationConfig operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyReplicationConfigResponse modifyReplicationConfig(
            Consumer<ModifyReplicationConfigRequest.Builder> modifyReplicationConfigRequest) throws AccessDeniedException,
            ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException,
            KmsKeyNotAccessibleException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return modifyReplicationConfig(ModifyReplicationConfigRequest.builder().applyMutation(modifyReplicationConfigRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <p>
     * Some settings are applied during the maintenance window.
     * </p>
     * <p/>
     *
     * @param modifyReplicationInstanceRequest
     * @return Result of the ModifyReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws UpgradeDependencyFailureException
     *         An upgrade dependency is preventing the database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyReplicationInstanceResponse modifyReplicationInstance(
            ModifyReplicationInstanceRequest modifyReplicationInstanceRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InsufficientResourceCapacityException, StorageQuotaExceededException, UpgradeDependencyFailureException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <p>
     * Some settings are applied during the maintenance window.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param modifyReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest.Builder}
     *        to create a request.
     * @return Result of the ModifyReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws UpgradeDependencyFailureException
     *         An upgrade dependency is preventing the database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyReplicationInstanceResponse modifyReplicationInstance(
            Consumer<ModifyReplicationInstanceRequest.Builder> modifyReplicationInstanceRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InsufficientResourceCapacityException, StorageQuotaExceededException, UpgradeDependencyFailureException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return modifyReplicationInstance(ModifyReplicationInstanceRequest.builder()
                .applyMutation(modifyReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for the specified replication subnet group.
     * </p>
     *
     * @param modifyReplicationSubnetGroupRequest
     * @return Result of the ModifyReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SubnetAlreadyInUseException
     *         The specified subnet is already in use.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroup(
            ModifyReplicationSubnetGroupRequest modifyReplicationSubnetGroupRequest) throws AccessDeniedException,
            ResourceNotFoundException, ResourceQuotaExceededException, SubnetAlreadyInUseException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for the specified replication subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest.Builder}
     *        to create a request.
     * @return Result of the ModifyReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SubnetAlreadyInUseException
     *         The specified subnet is already in use.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroup(
            Consumer<ModifyReplicationSubnetGroupRequest.Builder> modifyReplicationSubnetGroupRequest)
            throws AccessDeniedException, ResourceNotFoundException, ResourceQuotaExceededException, SubnetAlreadyInUseException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return modifyReplicationSubnetGroup(ModifyReplicationSubnetGroupRequest.builder()
                .applyMutation(modifyReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the specified replication task.
     * </p>
     * <p>
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the
     * <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param modifyReplicationTaskRequest
     * @return Result of the ModifyReplicationTask operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyReplicationTaskResponse modifyReplicationTask(ModifyReplicationTaskRequest modifyReplicationTaskRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException,
            KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified replication task.
     * </p>
     * <p>
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the
     * <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyReplicationTaskRequest#builder()}
     * </p>
     *
     * @param modifyReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyReplicationTask operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyReplicationTaskResponse modifyReplicationTask(
            Consumer<ModifyReplicationTaskRequest.Builder> modifyReplicationTaskRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, ResourceAlreadyExistsException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return modifyReplicationTask(ModifyReplicationTaskRequest.builder().applyMutation(modifyReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Moves a replication task from its current replication instance to a different target replication instance using
     * the specified parameters. The target replication instance must be created with the same or later DMS version as
     * the current replication instance.
     * </p>
     *
     * @param moveReplicationTaskRequest
     * @return Result of the MoveReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.MoveReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default MoveReplicationTaskResponse moveReplicationTask(MoveReplicationTaskRequest moveReplicationTaskRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a replication task from its current replication instance to a different target replication instance using
     * the specified parameters. The target replication instance must be created with the same or later DMS version as
     * the current replication instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MoveReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link MoveReplicationTaskRequest#builder()}
     * </p>
     *
     * @param moveReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest.Builder} to
     *        create a request.
     * @return Result of the MoveReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.MoveReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default MoveReplicationTaskResponse moveReplicationTask(
            Consumer<MoveReplicationTaskRequest.Builder> moveReplicationTaskRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return moveReplicationTask(MoveReplicationTaskRequest.builder().applyMutation(moveReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes
     * available again.
     * </p>
     *
     * @param rebootReplicationInstanceRequest
     * @return Result of the RebootReplicationInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RebootReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootReplicationInstanceResponse rebootReplicationInstance(
            RebootReplicationInstanceRequest rebootReplicationInstanceRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes
     * available again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link RebootReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param rebootReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest.Builder}
     *        to create a request.
     * @return Result of the RebootReplicationInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RebootReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootReplicationInstanceResponse rebootReplicationInstance(
            Consumer<RebootReplicationInstanceRequest.Builder> rebootReplicationInstanceRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return rebootReplicationInstance(RebootReplicationInstanceRequest.builder()
                .applyMutation(rebootReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes.
     * You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     * </p>
     *
     * @param refreshSchemasRequest
     * @return Result of the RefreshSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RefreshSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default RefreshSchemasResponse refreshSchemas(RefreshSchemasRequest refreshSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes.
     * You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RefreshSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link RefreshSchemasRequest#builder()}
     * </p>
     *
     * @param refreshSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest.Builder} to create a
     *        request.
     * @return Result of the RefreshSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RefreshSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default RefreshSchemasResponse refreshSchemas(Consumer<RefreshSchemasRequest.Builder> refreshSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return refreshSchemas(RefreshSchemasRequest.builder().applyMutation(refreshSchemasRequest).build());
    }

    /**
     * <p>
     * Reloads the target database table with the source data for a given DMS Serverless replication configuration.
     * </p>
     * <p>
     * You can only use this operation with a task in the RUNNING state, otherwise the service will throw an
     * <code>InvalidResourceStateFault</code> exception.
     * </p>
     *
     * @param reloadReplicationTablesRequest
     * @return Result of the ReloadReplicationTables operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ReloadReplicationTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadReplicationTables" target="_top">AWS
     *      API Documentation</a>
     */
    default ReloadReplicationTablesResponse reloadReplicationTables(ReloadReplicationTablesRequest reloadReplicationTablesRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reloads the target database table with the source data for a given DMS Serverless replication configuration.
     * </p>
     * <p>
     * You can only use this operation with a task in the RUNNING state, otherwise the service will throw an
     * <code>InvalidResourceStateFault</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReloadReplicationTablesRequest.Builder} avoiding
     * the need to create one manually via {@link ReloadReplicationTablesRequest#builder()}
     * </p>
     *
     * @param reloadReplicationTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest.Builder} to
     *        create a request.
     * @return Result of the ReloadReplicationTables operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ReloadReplicationTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadReplicationTables" target="_top">AWS
     *      API Documentation</a>
     */
    default ReloadReplicationTablesResponse reloadReplicationTables(
            Consumer<ReloadReplicationTablesRequest.Builder> reloadReplicationTablesRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return reloadReplicationTables(ReloadReplicationTablesRequest.builder().applyMutation(reloadReplicationTablesRequest)
                .build());
    }

    /**
     * <p>
     * Reloads the target database table with the source data.
     * </p>
     * <p>
     * You can only use this operation with a task in the <code>RUNNING</code> state, otherwise the service will throw
     * an <code>InvalidResourceStateFault</code> exception.
     * </p>
     *
     * @param reloadTablesRequest
     * @return Result of the ReloadTables operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ReloadTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ReloadTablesResponse reloadTables(ReloadTablesRequest reloadTablesRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reloads the target database table with the source data.
     * </p>
     * <p>
     * You can only use this operation with a task in the <code>RUNNING</code> state, otherwise the service will throw
     * an <code>InvalidResourceStateFault</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReloadTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ReloadTablesRequest#builder()}
     * </p>
     *
     * @param reloadTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest.Builder} to create a
     *        request.
     * @return Result of the ReloadTables operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ReloadTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ReloadTablesResponse reloadTables(Consumer<ReloadTablesRequest.Builder> reloadTablesRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return reloadTables(ReloadTablesRequest.builder().applyMutation(reloadTablesRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * <code>Tag</code> </a> data type description.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Removes one or more tags from an DMS resource.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * <code>Tag</code> </a> data type description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest.Builder} to
     *        create a request. Removes one or more tags from an DMS resource.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Runs large-scale assessment (LSA) analysis on every Fleet Advisor collector in your account.
     * </p>
     *
     * @param runFleetAdvisorLsaAnalysisRequest
     * @return Result of the RunFleetAdvisorLsaAnalysis operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RunFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RunFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default RunFleetAdvisorLsaAnalysisResponse runFleetAdvisorLsaAnalysis(
            RunFleetAdvisorLsaAnalysisRequest runFleetAdvisorLsaAnalysisRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs large-scale assessment (LSA) analysis on every Fleet Advisor collector in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RunFleetAdvisorLsaAnalysisRequest.Builder} avoiding
     * the need to create one manually via {@link RunFleetAdvisorLsaAnalysisRequest#builder()}
     * </p>
     *
     * @param runFleetAdvisorLsaAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisRequest.Builder}
     *        to create a request.
     * @return Result of the RunFleetAdvisorLsaAnalysis operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RunFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RunFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default RunFleetAdvisorLsaAnalysisResponse runFleetAdvisorLsaAnalysis(
            Consumer<RunFleetAdvisorLsaAnalysisRequest.Builder> runFleetAdvisorLsaAnalysisRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return runFleetAdvisorLsaAnalysis(RunFleetAdvisorLsaAnalysisRequest.builder()
                .applyMutation(runFleetAdvisorLsaAnalysisRequest).build());
    }

    /**
     * <p>
     * Starts the specified data migration.
     * </p>
     *
     * @param startDataMigrationRequest
     * @return Result of the StartDataMigration operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws InvalidOperationException
     *         The action or operation requested isn't valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDataMigrationResponse startDataMigration(StartDataMigrationRequest startDataMigrationRequest)
            throws InvalidResourceStateException, InvalidOperationException, ResourceNotFoundException,
            ResourceQuotaExceededException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified data migration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataMigrationRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataMigrationRequest#builder()}
     * </p>
     *
     * @param startDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest.Builder} to
     *        create a request.
     * @return Result of the StartDataMigration operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws InvalidOperationException
     *         The action or operation requested isn't valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDataMigrationResponse startDataMigration(Consumer<StartDataMigrationRequest.Builder> startDataMigrationRequest)
            throws InvalidResourceStateException, InvalidOperationException, ResourceNotFoundException,
            ResourceQuotaExceededException, FailedDependencyException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return startDataMigration(StartDataMigrationRequest.builder().applyMutation(startDataMigrationRequest).build());
    }

    /**
     * <p>
     * Applies the extension pack to your target database. An extension pack is an add-on module that emulates functions
     * present in a source database that are required when converting objects to the target database.
     * </p>
     *
     * @param startExtensionPackAssociationRequest
     * @return Result of the StartExtensionPackAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartExtensionPackAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartExtensionPackAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartExtensionPackAssociationResponse startExtensionPackAssociation(
            StartExtensionPackAssociationRequest startExtensionPackAssociationRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the extension pack to your target database. An extension pack is an add-on module that emulates functions
     * present in a source database that are required when converting objects to the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExtensionPackAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link StartExtensionPackAssociationRequest#builder()}
     * </p>
     *
     * @param startExtensionPackAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the StartExtensionPackAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartExtensionPackAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartExtensionPackAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartExtensionPackAssociationResponse startExtensionPackAssociation(
            Consumer<StartExtensionPackAssociationRequest.Builder> startExtensionPackAssociationRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException,
            ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException,
            S3AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return startExtensionPackAssociation(StartExtensionPackAssociationRequest.builder()
                .applyMutation(startExtensionPackAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a database migration assessment report by assessing the migration complexity for your source database. A
     * database migration assessment report summarizes all of the schema conversion tasks. It also details the action
     * items for database objects that can't be converted to the database engine of your target database instance.
     * </p>
     *
     * @param startMetadataModelAssessmentRequest
     * @return Result of the StartMetadataModelAssessment operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataModelAssessmentResponse startMetadataModelAssessment(
            StartMetadataModelAssessmentRequest startMetadataModelAssessmentRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a database migration assessment report by assessing the migration complexity for your source database. A
     * database migration assessment report summarizes all of the schema conversion tasks. It also details the action
     * items for database objects that can't be converted to the database engine of your target database instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link StartMetadataModelAssessmentRequest#builder()}
     * </p>
     *
     * @param startMetadataModelAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest.Builder}
     *        to create a request.
     * @return Result of the StartMetadataModelAssessment operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataModelAssessmentResponse startMetadataModelAssessment(
            Consumer<StartMetadataModelAssessmentRequest.Builder> startMetadataModelAssessmentRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException,
            ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException,
            S3AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return startMetadataModelAssessment(StartMetadataModelAssessmentRequest.builder()
                .applyMutation(startMetadataModelAssessmentRequest).build());
    }

    /**
     * <p>
     * Converts your source database objects to a format compatible with the target database.
     * </p>
     *
     * @param startMetadataModelConversionRequest
     * @return Result of the StartMetadataModelConversion operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelConversion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelConversion"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataModelConversionResponse startMetadataModelConversion(
            StartMetadataModelConversionRequest startMetadataModelConversionRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Converts your source database objects to a format compatible with the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelConversionRequest.Builder}
     * avoiding the need to create one manually via {@link StartMetadataModelConversionRequest#builder()}
     * </p>
     *
     * @param startMetadataModelConversionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest.Builder}
     *        to create a request.
     * @return Result of the StartMetadataModelConversion operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelConversion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelConversion"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataModelConversionResponse startMetadataModelConversion(
            Consumer<StartMetadataModelConversionRequest.Builder> startMetadataModelConversionRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException,
            ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException,
            S3AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return startMetadataModelConversion(StartMetadataModelConversionRequest.builder()
                .applyMutation(startMetadataModelConversionRequest).build());
    }

    /**
     * <p>
     * Saves your converted code to a file as a SQL script, and stores this file on your Amazon S3 bucket.
     * </p>
     *
     * @param startMetadataModelExportAsScriptRequest
     * @return Result of the StartMetadataModelExportAsScript operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelExportAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataModelExportAsScriptResponse startMetadataModelExportAsScript(
            StartMetadataModelExportAsScriptRequest startMetadataModelExportAsScriptRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Saves your converted code to a file as a SQL script, and stores this file on your Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelExportAsScriptRequest.Builder}
     * avoiding the need to create one manually via {@link StartMetadataModelExportAsScriptRequest#builder()}
     * </p>
     *
     * @param startMetadataModelExportAsScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest.Builder}
     *        to create a request.
     * @return Result of the StartMetadataModelExportAsScript operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelExportAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataModelExportAsScriptResponse startMetadataModelExportAsScript(
            Consumer<StartMetadataModelExportAsScriptRequest.Builder> startMetadataModelExportAsScriptRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException,
            ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException,
            S3AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return startMetadataModelExportAsScript(StartMetadataModelExportAsScriptRequest.builder()
                .applyMutation(startMetadataModelExportAsScriptRequest).build());
    }

    /**
     * <p>
     * Applies converted database objects to your target database.
     * </p>
     *
     * @param startMetadataModelExportToTargetRequest
     * @return Result of the StartMetadataModelExportToTarget operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelExportToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataModelExportToTargetResponse startMetadataModelExportToTarget(
            StartMetadataModelExportToTargetRequest startMetadataModelExportToTargetRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies converted database objects to your target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelExportToTargetRequest.Builder}
     * avoiding the need to create one manually via {@link StartMetadataModelExportToTargetRequest#builder()}
     * </p>
     *
     * @param startMetadataModelExportToTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest.Builder}
     *        to create a request.
     * @return Result of the StartMetadataModelExportToTarget operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelExportToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMetadataModelExportToTargetResponse startMetadataModelExportToTarget(
            Consumer<StartMetadataModelExportToTargetRequest.Builder> startMetadataModelExportToTargetRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException,
            ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException,
            S3AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return startMetadataModelExportToTarget(StartMetadataModelExportToTargetRequest.builder()
                .applyMutation(startMetadataModelExportToTargetRequest).build());
    }

    /**
     * <p>
     * Loads the metadata for all the dependent database objects of the parent object.
     * </p>
     * <p>
     * This operation uses your project's Amazon S3 bucket as a metadata cache to improve performance.
     * </p>
     *
     * @param startMetadataModelImportRequest
     * @return Result of the StartMetadataModelImport operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelImport" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMetadataModelImportResponse startMetadataModelImport(
            StartMetadataModelImportRequest startMetadataModelImportRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Loads the metadata for all the dependent database objects of the parent object.
     * </p>
     * <p>
     * This operation uses your project's Amazon S3 bucket as a metadata cache to improve performance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelImportRequest.Builder} avoiding
     * the need to create one manually via {@link StartMetadataModelImportRequest#builder()}
     * </p>
     *
     * @param startMetadataModelImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest.Builder} to
     *        create a request.
     * @return Result of the StartMetadataModelImport operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartMetadataModelImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelImport" target="_top">AWS
     *      API Documentation</a>
     */
    default StartMetadataModelImportResponse startMetadataModelImport(
            Consumer<StartMetadataModelImportRequest.Builder> startMetadataModelImportRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, S3ResourceNotFoundException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return startMetadataModelImport(StartMetadataModelImportRequest.builder().applyMutation(startMetadataModelImportRequest)
                .build());
    }

    /**
     * <p>
     * Starts the analysis of your source database to provide recommendations of target engines.
     * </p>
     * <p>
     * You can create recommendations for multiple source databases using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_BatchStartRecommendations.html"
     * >BatchStartRecommendations</a>.
     * </p>
     *
     * @param startRecommendationsRequest
     * @return Result of the StartRecommendations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default StartRecommendationsResponse startRecommendations(StartRecommendationsRequest startRecommendationsRequest)
            throws InvalidResourceStateException, AccessDeniedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the analysis of your source database to provide recommendations of target engines.
     * </p>
     * <p>
     * You can create recommendations for multiple source databases using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_BatchStartRecommendations.html"
     * >BatchStartRecommendations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link StartRecommendationsRequest#builder()}
     * </p>
     *
     * @param startRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequest.Builder} to
     *        create a request.
     * @return Result of the StartRecommendations operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default StartRecommendationsResponse startRecommendations(
            Consumer<StartRecommendationsRequest.Builder> startRecommendationsRequest) throws InvalidResourceStateException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return startRecommendations(StartRecommendationsRequest.builder().applyMutation(startRecommendationsRequest).build());
    }

    /**
     * <p>
     * For a given DMS Serverless replication configuration, DMS connects to the source endpoint and collects the
     * metadata to analyze the replication workload. Using this metadata, DMS then computes and provisions the required
     * capacity and starts replicating to the target endpoint using the server resources that DMS has provisioned for
     * the DMS Serverless replication.
     * </p>
     *
     * @param startReplicationRequest
     * @return Result of the StartReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationResponse startReplication(StartReplicationRequest startReplicationRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given DMS Serverless replication configuration, DMS connects to the source endpoint and collects the
     * metadata to analyze the replication workload. Using this metadata, DMS then computes and provisions the required
     * capacity and starts replicating to the target endpoint using the server resources that DMS has provisioned for
     * the DMS Serverless replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartReplicationRequest#builder()}
     * </p>
     *
     * @param startReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest.Builder} to create
     *        a request.
     * @return Result of the StartReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationResponse startReplication(Consumer<StartReplicationRequest.Builder> startReplicationRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return startReplication(StartReplicationRequest.builder().applyMutation(startReplicationRequest).build());
    }

    /**
     * <p>
     * Starts the replication task.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the
     * <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param startReplicationTaskRequest
     * @return Result of the StartReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationTaskResponse startReplicationTask(StartReplicationTaskRequest startReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the replication task.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the
     * <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StartReplicationTaskRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest.Builder} to
     *        create a request.
     * @return Result of the StartReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationTaskResponse startReplicationTask(
            Consumer<StartReplicationTaskRequest.Builder> startReplicationTaskRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return startReplicationTask(StartReplicationTaskRequest.builder().applyMutation(startReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Starts the replication task assessment for unsupported data types in the source database.
     * </p>
     * <p>
     * You can only use this operation for a task if the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The task must be in the <code>stopped</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The task must have successful connections to the source and target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If either of these conditions are not met, an <code>InvalidResourceStateFault</code> error will result.
     * </p>
     * <p>
     * For information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param startReplicationTaskAssessmentRequest
     * @return Result of the StartReplicationTaskAssessment operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartReplicationTaskAssessmentResponse startReplicationTaskAssessment(
            StartReplicationTaskAssessmentRequest startReplicationTaskAssessmentRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the replication task assessment for unsupported data types in the source database.
     * </p>
     * <p>
     * You can only use this operation for a task if the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The task must be in the <code>stopped</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The task must have successful connections to the source and target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If either of these conditions are not met, an <code>InvalidResourceStateFault</code> error will result.
     * </p>
     * <p>
     * For information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link StartReplicationTaskAssessmentRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest.Builder}
     *        to create a request.
     * @return Result of the StartReplicationTaskAssessment operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartReplicationTaskAssessmentResponse startReplicationTaskAssessment(
            Consumer<StartReplicationTaskAssessmentRequest.Builder> startReplicationTaskAssessmentRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return startReplicationTaskAssessment(StartReplicationTaskAssessmentRequest.builder()
                .applyMutation(startReplicationTaskAssessmentRequest).build());
    }

    /**
     * <p>
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     * </p>
     * <p>
     * The assessments that you can specify depend on the source and target database engine and the migration type
     * defined for the given task. To run this operation, your migration task must already be created. After you run
     * this operation, you can review the status of each individual assessment. You can also run the migration task
     * manually after the assessment run and its individual assessments complete.
     * </p>
     *
     * @param startReplicationTaskAssessmentRunRequest
     * @return Result of the StartReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsException
     *         An Key Management Service (KMS) error is preventing access to KMS.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartReplicationTaskAssessmentRunResponse startReplicationTaskAssessmentRun(
            StartReplicationTaskAssessmentRunRequest startReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, KmsAccessDeniedException, KmsDisabledException,
            KmsException, KmsInvalidStateException, KmsNotFoundException, KmsKeyNotAccessibleException, S3AccessDeniedException,
            S3ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     * </p>
     * <p>
     * The assessments that you can specify depend on the source and target database engine and the migration type
     * defined for the given task. To run this operation, your migration task must already be created. After you run
     * this operation, you can review the status of each individual assessment. You can also run the migration task
     * manually after the assessment run and its individual assessments complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link StartReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest.Builder}
     *        to create a request.
     * @return Result of the StartReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsException
     *         An Key Management Service (KMS) error is preventing access to KMS.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartReplicationTaskAssessmentRunResponse startReplicationTaskAssessmentRun(
            Consumer<StartReplicationTaskAssessmentRunRequest.Builder> startReplicationTaskAssessmentRunRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, KmsAccessDeniedException,
            KmsDisabledException, KmsException, KmsInvalidStateException, KmsNotFoundException, KmsKeyNotAccessibleException,
            S3AccessDeniedException, S3ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return startReplicationTaskAssessmentRun(StartReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(startReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Stops the specified data migration.
     * </p>
     *
     * @param stopDataMigrationRequest
     * @return Result of the StopDataMigration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDataMigrationResponse stopDataMigration(StopDataMigrationRequest stopDataMigrationRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified data migration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDataMigrationRequest.Builder} avoiding the need
     * to create one manually via {@link StopDataMigrationRequest#builder()}
     * </p>
     *
     * @param stopDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StopDataMigrationRequest.Builder} to create
     *        a request.
     * @return Result of the StopDataMigration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws FailedDependencyException
     *         A dependency threw an exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDataMigrationResponse stopDataMigration(Consumer<StopDataMigrationRequest.Builder> stopDataMigrationRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return stopDataMigration(StopDataMigrationRequest.builder().applyMutation(stopDataMigrationRequest).build());
    }

    /**
     * <p>
     * For a given DMS Serverless replication configuration, DMS stops any and all ongoing DMS Serverless replications.
     * This command doesn't deprovision the stopped replications.
     * </p>
     *
     * @param stopReplicationRequest
     * @return Result of the StopReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationResponse stopReplication(StopReplicationRequest stopReplicationRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given DMS Serverless replication configuration, DMS stops any and all ongoing DMS Serverless replications.
     * This command doesn't deprovision the stopped replications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopReplicationRequest#builder()}
     * </p>
     *
     * @param stopReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StopReplicationRequest.Builder} to create a
     *        request.
     * @return Result of the StopReplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationResponse stopReplication(Consumer<StopReplicationRequest.Builder> stopReplicationRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return stopReplication(StopReplicationRequest.builder().applyMutation(stopReplicationRequest).build());
    }

    /**
     * <p>
     * Stops the replication task.
     * </p>
     *
     * @param stopReplicationTaskRequest
     * @return Result of the StopReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationTaskResponse stopReplicationTask(StopReplicationTaskRequest stopReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the replication task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StopReplicationTaskRequest#builder()}
     * </p>
     *
     * @param stopReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest.Builder} to
     *        create a request.
     * @return Result of the StopReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationTaskResponse stopReplicationTask(
            Consumer<StopReplicationTaskRequest.Builder> stopReplicationTaskRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return stopReplicationTask(StopReplicationTaskRequest.builder().applyMutation(stopReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Tests the connection between the replication instance and the endpoint.
     * </p>
     *
     * @param testConnectionRequest
     * @return Result of the TestConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.TestConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default TestConnectionResponse testConnection(TestConnectionRequest testConnectionRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests the connection between the replication instance and the endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link TestConnectionRequest#builder()}
     * </p>
     *
     * @param testConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the TestConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.TestConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default TestConnectionResponse testConnection(Consumer<TestConnectionRequest.Builder> testConnectionRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return testConnection(TestConnectionRequest.builder().applyMutation(testConnectionRequest).build());
    }

    /**
     * <p>
     * Migrates 10 active and enabled Amazon SNS subscriptions at a time and converts them to corresponding Amazon
     * EventBridge rules. By default, this operation migrates subscriptions only when all your replication instance
     * versions are 3.4.5 or higher. If any replication instances are from versions earlier than 3.4.5, the operation
     * raises an error and tells you to upgrade these instances to version 3.4.5 or higher. To enable migration
     * regardless of version, set the <code>Force</code> option to true. However, if you don't upgrade instances earlier
     * than version 3.4.5, some types of events might not be available when you use Amazon EventBridge.
     * </p>
     * <p>
     * To call this operation, make sure that you have certain permissions added to your user account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html#CHAP_Events-migrate-to-eventbridge"
     * >Migrating event subscriptions to Amazon EventBridge</a> in the <i>Amazon Web Services Database Migration Service
     * User Guide</i>.
     * </p>
     *
     * @param updateSubscriptionsToEventBridgeRequest
     * @return Result of the UpdateSubscriptionsToEventBridge operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.UpdateSubscriptionsToEventBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/UpdateSubscriptionsToEventBridge"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubscriptionsToEventBridgeResponse updateSubscriptionsToEventBridge(
            UpdateSubscriptionsToEventBridgeRequest updateSubscriptionsToEventBridgeRequest) throws AccessDeniedException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Migrates 10 active and enabled Amazon SNS subscriptions at a time and converts them to corresponding Amazon
     * EventBridge rules. By default, this operation migrates subscriptions only when all your replication instance
     * versions are 3.4.5 or higher. If any replication instances are from versions earlier than 3.4.5, the operation
     * raises an error and tells you to upgrade these instances to version 3.4.5 or higher. To enable migration
     * regardless of version, set the <code>Force</code> option to true. However, if you don't upgrade instances earlier
     * than version 3.4.5, some types of events might not be available when you use Amazon EventBridge.
     * </p>
     * <p>
     * To call this operation, make sure that you have certain permissions added to your user account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html#CHAP_Events-migrate-to-eventbridge"
     * >Migrating event subscriptions to Amazon EventBridge</a> in the <i>Amazon Web Services Database Migration Service
     * User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionsToEventBridgeRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSubscriptionsToEventBridgeRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionsToEventBridgeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateSubscriptionsToEventBridge operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.UpdateSubscriptionsToEventBridge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/UpdateSubscriptionsToEventBridge"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSubscriptionsToEventBridgeResponse updateSubscriptionsToEventBridge(
            Consumer<UpdateSubscriptionsToEventBridgeRequest.Builder> updateSubscriptionsToEventBridgeRequest)
            throws AccessDeniedException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return updateSubscriptionsToEventBridge(UpdateSubscriptionsToEventBridgeRequest.builder()
                .applyMutation(updateSubscriptionsToEventBridgeRequest).build());
    }

    /**
     * Create an instance of {@link DatabaseMigrationWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link DatabaseMigrationWaiter}
     */
    default DatabaseMigrationWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link DatabaseMigrationClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DatabaseMigrationClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DatabaseMigrationClient}.
     */
    static DatabaseMigrationClientBuilder builder() {
        return new DefaultDatabaseMigrationClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default DatabaseMigrationServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
