/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetAdvisorDatabasesResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeFleetAdvisorDatabasesResponse.Builder, DescribeFleetAdvisorDatabasesResponse> {
    private static final SdkField<List<DatabaseResponse>> DATABASES_FIELD = SdkField
            .<List<DatabaseResponse>> builder(MarshallingType.LIST)
            .memberName("Databases")
            .getter(getter(DescribeFleetAdvisorDatabasesResponse::databases))
            .setter(setter(Builder::databases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Databases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatabaseResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatabaseResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeFleetAdvisorDatabasesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DatabaseResponse> databases;

    private final String nextToken;

    private DescribeFleetAdvisorDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.databases = builder.databases;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Databases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDatabases() {
        return databases != null && !(databases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides descriptions of the Fleet Advisor collector databases, including the database's collector, ID, and name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatabases} method.
     * </p>
     * 
     * @return Provides descriptions of the Fleet Advisor collector databases, including the database's collector, ID,
     *         and name.
     */
    public final List<DatabaseResponse> databases() {
        return databases;
    }

    /**
     * <p>
     * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged.
     * </p>
     * 
     * @return If <code>NextToken</code> is returned, there are more results available. The value of
     *         <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatabases() ? databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAdvisorDatabasesResponse)) {
            return false;
        }
        DescribeFleetAdvisorDatabasesResponse other = (DescribeFleetAdvisorDatabasesResponse) obj;
        return hasDatabases() == other.hasDatabases() && Objects.equals(databases(), other.databases())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetAdvisorDatabasesResponse").add("Databases", hasDatabases() ? databases() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Databases":
            return Optional.ofNullable(clazz.cast(databases()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Databases", DATABASES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAdvisorDatabasesResponse, T> g) {
        return obj -> g.apply((DescribeFleetAdvisorDatabasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetAdvisorDatabasesResponse> {
        /**
         * <p>
         * Provides descriptions of the Fleet Advisor collector databases, including the database's collector, ID, and
         * name.
         * </p>
         * 
         * @param databases
         *        Provides descriptions of the Fleet Advisor collector databases, including the database's collector,
         *        ID, and name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databases(Collection<DatabaseResponse> databases);

        /**
         * <p>
         * Provides descriptions of the Fleet Advisor collector databases, including the database's collector, ID, and
         * name.
         * </p>
         * 
         * @param databases
         *        Provides descriptions of the Fleet Advisor collector databases, including the database's collector,
         *        ID, and name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databases(DatabaseResponse... databases);

        /**
         * <p>
         * Provides descriptions of the Fleet Advisor collector databases, including the database's collector, ID, and
         * name.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.DatabaseResponse.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.DatabaseResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.DatabaseResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #databases(List<DatabaseResponse>)}.
         * 
         * @param databases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.DatabaseResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databases(java.util.Collection<DatabaseResponse>)
         */
        Builder databases(Consumer<DatabaseResponse.Builder>... databases);

        /**
         * <p>
         * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is returned, there are more results available. The value of
         *        <code>NextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private List<DatabaseResponse> databases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAdvisorDatabasesResponse model) {
            super(model);
            databases(model.databases);
            nextToken(model.nextToken);
        }

        public final List<DatabaseResponse.Builder> getDatabases() {
            List<DatabaseResponse.Builder> result = DatabaseListCopier.copyToBuilder(this.databases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabases(Collection<DatabaseResponse.BuilderImpl> databases) {
            this.databases = DatabaseListCopier.copyFromBuilder(databases);
        }

        @Override
        public final Builder databases(Collection<DatabaseResponse> databases) {
            this.databases = DatabaseListCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(DatabaseResponse... databases) {
            databases(Arrays.asList(databases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(Consumer<DatabaseResponse.Builder>... databases) {
            databases(Stream.of(databases).map(c -> DatabaseResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetAdvisorDatabasesResponse build() {
            return new DescribeFleetAdvisorDatabasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
