/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that describes the requirements to the target engine on Amazon RDS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsRequirements implements SdkPojo, Serializable, ToCopyableBuilder<RdsRequirements.Builder, RdsRequirements> {
    private static final SdkField<String> ENGINE_EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineEdition").getter(getter(RdsRequirements::engineEdition)).setter(setter(Builder::engineEdition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineEdition").build()).build();

    private static final SdkField<Double> INSTANCE_VCPU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("InstanceVcpu").getter(getter(RdsRequirements::instanceVcpu)).setter(setter(Builder::instanceVcpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceVcpu").build()).build();

    private static final SdkField<Double> INSTANCE_MEMORY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("InstanceMemory").getter(getter(RdsRequirements::instanceMemory)).setter(setter(Builder::instanceMemory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMemory").build()).build();

    private static final SdkField<Integer> STORAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageSize").getter(getter(RdsRequirements::storageSize)).setter(setter(Builder::storageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSize").build()).build();

    private static final SdkField<Integer> STORAGE_IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageIops").getter(getter(RdsRequirements::storageIops)).setter(setter(Builder::storageIops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageIops").build()).build();

    private static final SdkField<String> DEPLOYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentOption").getter(getter(RdsRequirements::deploymentOption))
            .setter(setter(Builder::deploymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentOption").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(RdsRequirements::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_EDITION_FIELD,
            INSTANCE_VCPU_FIELD, INSTANCE_MEMORY_FIELD, STORAGE_SIZE_FIELD, STORAGE_IOPS_FIELD, DEPLOYMENT_OPTION_FIELD,
            ENGINE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String engineEdition;

    private final Double instanceVcpu;

    private final Double instanceMemory;

    private final Integer storageSize;

    private final Integer storageIops;

    private final String deploymentOption;

    private final String engineVersion;

    private RdsRequirements(BuilderImpl builder) {
        this.engineEdition = builder.engineEdition;
        this.instanceVcpu = builder.instanceVcpu;
        this.instanceMemory = builder.instanceMemory;
        this.storageSize = builder.storageSize;
        this.storageIops = builder.storageIops;
        this.deploymentOption = builder.deploymentOption;
        this.engineVersion = builder.engineVersion;
    }

    /**
     * <p>
     * The required target Amazon RDS engine edition.
     * </p>
     * 
     * @return The required target Amazon RDS engine edition.
     */
    public final String engineEdition() {
        return engineEdition;
    }

    /**
     * <p>
     * The required number of virtual CPUs (vCPU) on the Amazon RDS DB instance.
     * </p>
     * 
     * @return The required number of virtual CPUs (vCPU) on the Amazon RDS DB instance.
     */
    public final Double instanceVcpu() {
        return instanceVcpu;
    }

    /**
     * <p>
     * The required memory on the Amazon RDS DB instance.
     * </p>
     * 
     * @return The required memory on the Amazon RDS DB instance.
     */
    public final Double instanceMemory() {
        return instanceMemory;
    }

    /**
     * <p>
     * The required Amazon RDS DB instance storage size.
     * </p>
     * 
     * @return The required Amazon RDS DB instance storage size.
     */
    public final Integer storageSize() {
        return storageSize;
    }

    /**
     * <p>
     * The required number of I/O operations completed each second (IOPS) on your Amazon RDS DB instance.
     * </p>
     * 
     * @return The required number of I/O operations completed each second (IOPS) on your Amazon RDS DB instance.
     */
    public final Integer storageIops() {
        return storageIops;
    }

    /**
     * <p>
     * The required deployment option for the Amazon RDS DB instance. Valid values include <code>"MULTI_AZ"</code> for
     * Multi-AZ deployments and <code>"SINGLE_AZ"</code> for Single-AZ deployments.
     * </p>
     * 
     * @return The required deployment option for the Amazon RDS DB instance. Valid values include
     *         <code>"MULTI_AZ"</code> for Multi-AZ deployments and <code>"SINGLE_AZ"</code> for Single-AZ deployments.
     */
    public final String deploymentOption() {
        return deploymentOption;
    }

    /**
     * <p>
     * The required target Amazon RDS engine version.
     * </p>
     * 
     * @return The required target Amazon RDS engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineEdition());
        hashCode = 31 * hashCode + Objects.hashCode(instanceVcpu());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMemory());
        hashCode = 31 * hashCode + Objects.hashCode(storageSize());
        hashCode = 31 * hashCode + Objects.hashCode(storageIops());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsRequirements)) {
            return false;
        }
        RdsRequirements other = (RdsRequirements) obj;
        return Objects.equals(engineEdition(), other.engineEdition()) && Objects.equals(instanceVcpu(), other.instanceVcpu())
                && Objects.equals(instanceMemory(), other.instanceMemory()) && Objects.equals(storageSize(), other.storageSize())
                && Objects.equals(storageIops(), other.storageIops())
                && Objects.equals(deploymentOption(), other.deploymentOption())
                && Objects.equals(engineVersion(), other.engineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsRequirements").add("EngineEdition", engineEdition()).add("InstanceVcpu", instanceVcpu())
                .add("InstanceMemory", instanceMemory()).add("StorageSize", storageSize()).add("StorageIops", storageIops())
                .add("DeploymentOption", deploymentOption()).add("EngineVersion", engineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineEdition":
            return Optional.ofNullable(clazz.cast(engineEdition()));
        case "InstanceVcpu":
            return Optional.ofNullable(clazz.cast(instanceVcpu()));
        case "InstanceMemory":
            return Optional.ofNullable(clazz.cast(instanceMemory()));
        case "StorageSize":
            return Optional.ofNullable(clazz.cast(storageSize()));
        case "StorageIops":
            return Optional.ofNullable(clazz.cast(storageIops()));
        case "DeploymentOption":
            return Optional.ofNullable(clazz.cast(deploymentOption()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngineEdition", ENGINE_EDITION_FIELD);
        map.put("InstanceVcpu", INSTANCE_VCPU_FIELD);
        map.put("InstanceMemory", INSTANCE_MEMORY_FIELD);
        map.put("StorageSize", STORAGE_SIZE_FIELD);
        map.put("StorageIops", STORAGE_IOPS_FIELD);
        map.put("DeploymentOption", DEPLOYMENT_OPTION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsRequirements, T> g) {
        return obj -> g.apply((RdsRequirements) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsRequirements> {
        /**
         * <p>
         * The required target Amazon RDS engine edition.
         * </p>
         * 
         * @param engineEdition
         *        The required target Amazon RDS engine edition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineEdition(String engineEdition);

        /**
         * <p>
         * The required number of virtual CPUs (vCPU) on the Amazon RDS DB instance.
         * </p>
         * 
         * @param instanceVcpu
         *        The required number of virtual CPUs (vCPU) on the Amazon RDS DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceVcpu(Double instanceVcpu);

        /**
         * <p>
         * The required memory on the Amazon RDS DB instance.
         * </p>
         * 
         * @param instanceMemory
         *        The required memory on the Amazon RDS DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMemory(Double instanceMemory);

        /**
         * <p>
         * The required Amazon RDS DB instance storage size.
         * </p>
         * 
         * @param storageSize
         *        The required Amazon RDS DB instance storage size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSize(Integer storageSize);

        /**
         * <p>
         * The required number of I/O operations completed each second (IOPS) on your Amazon RDS DB instance.
         * </p>
         * 
         * @param storageIops
         *        The required number of I/O operations completed each second (IOPS) on your Amazon RDS DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageIops(Integer storageIops);

        /**
         * <p>
         * The required deployment option for the Amazon RDS DB instance. Valid values include <code>"MULTI_AZ"</code>
         * for Multi-AZ deployments and <code>"SINGLE_AZ"</code> for Single-AZ deployments.
         * </p>
         * 
         * @param deploymentOption
         *        The required deployment option for the Amazon RDS DB instance. Valid values include
         *        <code>"MULTI_AZ"</code> for Multi-AZ deployments and <code>"SINGLE_AZ"</code> for Single-AZ
         *        deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentOption(String deploymentOption);

        /**
         * <p>
         * The required target Amazon RDS engine version.
         * </p>
         * 
         * @param engineVersion
         *        The required target Amazon RDS engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);
    }

    static final class BuilderImpl implements Builder {
        private String engineEdition;

        private Double instanceVcpu;

        private Double instanceMemory;

        private Integer storageSize;

        private Integer storageIops;

        private String deploymentOption;

        private String engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsRequirements model) {
            engineEdition(model.engineEdition);
            instanceVcpu(model.instanceVcpu);
            instanceMemory(model.instanceMemory);
            storageSize(model.storageSize);
            storageIops(model.storageIops);
            deploymentOption(model.deploymentOption);
            engineVersion(model.engineVersion);
        }

        public final String getEngineEdition() {
            return engineEdition;
        }

        public final void setEngineEdition(String engineEdition) {
            this.engineEdition = engineEdition;
        }

        @Override
        public final Builder engineEdition(String engineEdition) {
            this.engineEdition = engineEdition;
            return this;
        }

        public final Double getInstanceVcpu() {
            return instanceVcpu;
        }

        public final void setInstanceVcpu(Double instanceVcpu) {
            this.instanceVcpu = instanceVcpu;
        }

        @Override
        public final Builder instanceVcpu(Double instanceVcpu) {
            this.instanceVcpu = instanceVcpu;
            return this;
        }

        public final Double getInstanceMemory() {
            return instanceMemory;
        }

        public final void setInstanceMemory(Double instanceMemory) {
            this.instanceMemory = instanceMemory;
        }

        @Override
        public final Builder instanceMemory(Double instanceMemory) {
            this.instanceMemory = instanceMemory;
            return this;
        }

        public final Integer getStorageSize() {
            return storageSize;
        }

        public final void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @Override
        public final Builder storageSize(Integer storageSize) {
            this.storageSize = storageSize;
            return this;
        }

        public final Integer getStorageIops() {
            return storageIops;
        }

        public final void setStorageIops(Integer storageIops) {
            this.storageIops = storageIops;
        }

        @Override
        public final Builder storageIops(Integer storageIops) {
            this.storageIops = storageIops;
            return this;
        }

        public final String getDeploymentOption() {
            return deploymentOption;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        @Override
        public RdsRequirements build() {
            return new RdsRequirements(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
