/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the target engine for the specified source database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationData implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationData.Builder, RecommendationData> {
    private static final SdkField<RdsRecommendation> RDS_ENGINE_FIELD = SdkField
            .<RdsRecommendation> builder(MarshallingType.SDK_POJO).memberName("RdsEngine")
            .getter(getter(RecommendationData::rdsEngine)).setter(setter(Builder::rdsEngine))
            .constructor(RdsRecommendation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsEngine").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RDS_ENGINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RdsRecommendation rdsEngine;

    private RecommendationData(BuilderImpl builder) {
        this.rdsEngine = builder.rdsEngine;
    }

    /**
     * <p>
     * The recommendation of a target Amazon RDS database engine.
     * </p>
     * 
     * @return The recommendation of a target Amazon RDS database engine.
     */
    public final RdsRecommendation rdsEngine() {
        return rdsEngine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rdsEngine());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationData)) {
            return false;
        }
        RecommendationData other = (RecommendationData) obj;
        return Objects.equals(rdsEngine(), other.rdsEngine());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationData").add("RdsEngine", rdsEngine()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RdsEngine":
            return Optional.ofNullable(clazz.cast(rdsEngine()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RdsEngine", RDS_ENGINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationData, T> g) {
        return obj -> g.apply((RecommendationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationData> {
        /**
         * <p>
         * The recommendation of a target Amazon RDS database engine.
         * </p>
         * 
         * @param rdsEngine
         *        The recommendation of a target Amazon RDS database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsEngine(RdsRecommendation rdsEngine);

        /**
         * <p>
         * The recommendation of a target Amazon RDS database engine.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsRecommendation.Builder} avoiding the
         * need to create one manually via {@link RdsRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsRecommendation.Builder#build()} is called immediately and its
         * result is passed to {@link #rdsEngine(RdsRecommendation)}.
         * 
         * @param rdsEngine
         *        a consumer that will call methods on {@link RdsRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsEngine(RdsRecommendation)
         */
        default Builder rdsEngine(Consumer<RdsRecommendation.Builder> rdsEngine) {
            return rdsEngine(RdsRecommendation.builder().applyMutation(rdsEngine).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RdsRecommendation rdsEngine;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationData model) {
            rdsEngine(model.rdsEngine);
        }

        public final RdsRecommendation.Builder getRdsEngine() {
            return rdsEngine != null ? rdsEngine.toBuilder() : null;
        }

        public final void setRdsEngine(RdsRecommendation.BuilderImpl rdsEngine) {
            this.rdsEngine = rdsEngine != null ? rdsEngine.build() : null;
        }

        @Override
        public final Builder rdsEngine(RdsRecommendation rdsEngine) {
            this.rdsEngine = rdsEngine;
            return this;
        }

        @Override
        public RecommendationData build() {
            return new RecommendationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
