/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartReplicationRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<StartReplicationRequest.Builder, StartReplicationRequest> {
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigArn").getter(getter(StartReplicationRequest::replicationConfigArn))
            .setter(setter(Builder::replicationConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build())
            .build();

    private static final SdkField<String> START_REPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartReplicationType").getter(getter(StartReplicationRequest::startReplicationType))
            .setter(setter(Builder::startReplicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartReplicationType").build())
            .build();

    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CdcStartTime").getter(getter(StartReplicationRequest::cdcStartTime))
            .setter(setter(Builder::cdcStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()).build();

    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStartPosition").getter(getter(StartReplicationRequest::cdcStartPosition))
            .setter(setter(Builder::cdcStartPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()).build();

    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStopPosition").getter(getter(StartReplicationRequest::cdcStopPosition))
            .setter(setter(Builder::cdcStopPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_ARN_FIELD,
            START_REPLICATION_TYPE_FIELD, CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationConfigArn;

    private final String startReplicationType;

    private final Instant cdcStartTime;

    private final String cdcStartPosition;

    private final String cdcStopPosition;

    private StartReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.replicationConfigArn = builder.replicationConfigArn;
        this.startReplicationType = builder.startReplicationType;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
    }

    /**
     * <p>
     * The Amazon Resource Name of the replication for which to start replication.
     * </p>
     * 
     * @return The Amazon Resource Name of the replication for which to start replication.
     */
    public final String replicationConfigArn() {
        return replicationConfigArn;
    }

    /**
     * <p>
     * The replication type.
     * </p>
     * <p>
     * When the replication type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value for
     * the first run of the replication is <code>start-replication</code>. This option will start the replication.
     * </p>
     * <p>
     * You can also use <a>ReloadTables</a> to reload specific tables that failed during replication instead of
     * restarting the replication.
     * </p>
     * <p>
     * The <code>resume-processing</code> option isn't applicable for a full-load replication, because you can't resume
     * partially loaded tables during the full load phase.
     * </p>
     * <p>
     * For a <code>full-load-and-cdc</code> replication, DMS migrates table data, and then applies data changes that
     * occur on the source. To load all the tables again, and start capturing source changes, use
     * <code>reload-target</code>. Otherwise use <code>resume-processing</code>, to replicate the changes from the last
     * stop position.
     * </p>
     * 
     * @return The replication type.</p>
     *         <p>
     *         When the replication type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid
     *         value for the first run of the replication is <code>start-replication</code>. This option will start the
     *         replication.
     *         </p>
     *         <p>
     *         You can also use <a>ReloadTables</a> to reload specific tables that failed during replication instead of
     *         restarting the replication.
     *         </p>
     *         <p>
     *         The <code>resume-processing</code> option isn't applicable for a full-load replication, because you can't
     *         resume partially loaded tables during the full load phase.
     *         </p>
     *         <p>
     *         For a <code>full-load-and-cdc</code> replication, DMS migrates table data, and then applies data changes
     *         that occur on the source. To load all the tables again, and start capturing source changes, use
     *         <code>reload-target</code>. Otherwise use <code>resume-processing</code>, to replicate the changes from
     *         the last stop position.
     */
    public final String startReplicationType() {
        return startReplicationType;
    }

    /**
     * <p>
     * Indicates the start time for a change data capture (CDC) operation. Use either <code>CdcStartTime</code> or
     * <code>CdcStartPosition</code> to specify when you want a CDC operation to start. Specifying both values results
     * in an error.
     * </p>
     * 
     * @return Indicates the start time for a change data capture (CDC) operation. Use either <code>CdcStartTime</code>
     *         or <code>CdcStartPosition</code> to specify when you want a CDC operation to start. Specifying both
     *         values results in an error.
     */
    public final Instant cdcStartTime() {
        return cdcStartTime;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to start. Use either <code>CdcStartPosition</code>
     * or <code>CdcStartTime</code> to specify when you want a CDC operation to start. Specifying both values results in
     * an error.
     * </p>
     * <p>
     * The value can be in date, checkpoint, or LSN/SCN format.
     * </p>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to start. Use either
     *         <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want a CDC operation to
     *         start. Specifying both values results in an error.</p>
     *         <p>
     *         The value can be in date, checkpoint, or LSN/SCN format.
     */
    public final String cdcStartPosition() {
        return cdcStartPosition;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
     * commit time.
     * </p>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
     *         time or commit time.
     */
    public final String cdcStopPosition() {
        return cdcStopPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(startReplicationType());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStopPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplicationRequest)) {
            return false;
        }
        StartReplicationRequest other = (StartReplicationRequest) obj;
        return Objects.equals(replicationConfigArn(), other.replicationConfigArn())
                && Objects.equals(startReplicationType(), other.startReplicationType())
                && Objects.equals(cdcStartTime(), other.cdcStartTime())
                && Objects.equals(cdcStartPosition(), other.cdcStartPosition())
                && Objects.equals(cdcStopPosition(), other.cdcStopPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartReplicationRequest").add("ReplicationConfigArn", replicationConfigArn())
                .add("StartReplicationType", startReplicationType()).add("CdcStartTime", cdcStartTime())
                .add("CdcStartPosition", cdcStartPosition()).add("CdcStopPosition", cdcStopPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationConfigArn":
            return Optional.ofNullable(clazz.cast(replicationConfigArn()));
        case "StartReplicationType":
            return Optional.ofNullable(clazz.cast(startReplicationType()));
        case "CdcStartTime":
            return Optional.ofNullable(clazz.cast(cdcStartTime()));
        case "CdcStartPosition":
            return Optional.ofNullable(clazz.cast(cdcStartPosition()));
        case "CdcStopPosition":
            return Optional.ofNullable(clazz.cast(cdcStopPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationConfigArn", REPLICATION_CONFIG_ARN_FIELD);
        map.put("StartReplicationType", START_REPLICATION_TYPE_FIELD);
        map.put("CdcStartTime", CDC_START_TIME_FIELD);
        map.put("CdcStartPosition", CDC_START_POSITION_FIELD);
        map.put("CdcStopPosition", CDC_STOP_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartReplicationRequest, T> g) {
        return obj -> g.apply((StartReplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartReplicationRequest> {
        /**
         * <p>
         * The Amazon Resource Name of the replication for which to start replication.
         * </p>
         * 
         * @param replicationConfigArn
         *        The Amazon Resource Name of the replication for which to start replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigArn(String replicationConfigArn);

        /**
         * <p>
         * The replication type.
         * </p>
         * <p>
         * When the replication type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value
         * for the first run of the replication is <code>start-replication</code>. This option will start the
         * replication.
         * </p>
         * <p>
         * You can also use <a>ReloadTables</a> to reload specific tables that failed during replication instead of
         * restarting the replication.
         * </p>
         * <p>
         * The <code>resume-processing</code> option isn't applicable for a full-load replication, because you can't
         * resume partially loaded tables during the full load phase.
         * </p>
         * <p>
         * For a <code>full-load-and-cdc</code> replication, DMS migrates table data, and then applies data changes that
         * occur on the source. To load all the tables again, and start capturing source changes, use
         * <code>reload-target</code>. Otherwise use <code>resume-processing</code>, to replicate the changes from the
         * last stop position.
         * </p>
         * 
         * @param startReplicationType
         *        The replication type.</p>
         *        <p>
         *        When the replication type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid
         *        value for the first run of the replication is <code>start-replication</code>. This option will start
         *        the replication.
         *        </p>
         *        <p>
         *        You can also use <a>ReloadTables</a> to reload specific tables that failed during replication instead
         *        of restarting the replication.
         *        </p>
         *        <p>
         *        The <code>resume-processing</code> option isn't applicable for a full-load replication, because you
         *        can't resume partially loaded tables during the full load phase.
         *        </p>
         *        <p>
         *        For a <code>full-load-and-cdc</code> replication, DMS migrates table data, and then applies data
         *        changes that occur on the source. To load all the tables again, and start capturing source changes,
         *        use <code>reload-target</code>. Otherwise use <code>resume-processing</code>, to replicate the changes
         *        from the last stop position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startReplicationType(String startReplicationType);

        /**
         * <p>
         * Indicates the start time for a change data capture (CDC) operation. Use either <code>CdcStartTime</code> or
         * <code>CdcStartPosition</code> to specify when you want a CDC operation to start. Specifying both values
         * results in an error.
         * </p>
         * 
         * @param cdcStartTime
         *        Indicates the start time for a change data capture (CDC) operation. Use either
         *        <code>CdcStartTime</code> or <code>CdcStartPosition</code> to specify when you want a CDC operation to
         *        start. Specifying both values results in an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartTime(Instant cdcStartTime);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to start. Use either
         * <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want a CDC operation to start.
         * Specifying both values results in an error.
         * </p>
         * <p>
         * The value can be in date, checkpoint, or LSN/SCN format.
         * </p>
         * 
         * @param cdcStartPosition
         *        Indicates when you want a change data capture (CDC) operation to start. Use either
         *        <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want a CDC operation to
         *        start. Specifying both values results in an error.</p>
         *        <p>
         *        The value can be in date, checkpoint, or LSN/SCN format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartPosition(String cdcStartPosition);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
         * commit time.
         * </p>
         * 
         * @param cdcStopPosition
         *        Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
         *        time or commit time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStopPosition(String cdcStopPosition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationConfigArn;

        private String startReplicationType;

        private Instant cdcStartTime;

        private String cdcStartPosition;

        private String cdcStopPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplicationRequest model) {
            super(model);
            replicationConfigArn(model.replicationConfigArn);
            startReplicationType(model.startReplicationType);
            cdcStartTime(model.cdcStartTime);
            cdcStartPosition(model.cdcStartPosition);
            cdcStopPosition(model.cdcStopPosition);
        }

        public final String getReplicationConfigArn() {
            return replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final String getStartReplicationType() {
            return startReplicationType;
        }

        public final void setStartReplicationType(String startReplicationType) {
            this.startReplicationType = startReplicationType;
        }

        @Override
        public final Builder startReplicationType(String startReplicationType) {
            this.startReplicationType = startReplicationType;
            return this;
        }

        public final Instant getCdcStartTime() {
            return cdcStartTime;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final String getCdcStartPosition() {
            return cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final String getCdcStopPosition() {
            return cdcStopPosition;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReplicationRequest build() {
            return new StartReplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
