/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Fleet Advisor collector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollectorResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CollectorResponse.Builder, CollectorResponse> {
    private static final SdkField<String> COLLECTOR_REFERENCED_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectorReferencedId").getter(getter(CollectorResponse::collectorReferencedId))
            .setter(setter(Builder::collectorReferencedId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorReferencedId").build())
            .build();

    private static final SdkField<String> COLLECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectorName").getter(getter(CollectorResponse::collectorName)).setter(setter(Builder::collectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorName").build()).build();

    private static final SdkField<String> COLLECTOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectorVersion").getter(getter(CollectorResponse::collectorVersion))
            .setter(setter(Builder::collectorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorVersion").build()).build();

    private static final SdkField<String> VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionStatus").getter(getter(CollectorResponse::versionStatusAsString))
            .setter(setter(Builder::versionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionStatus").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CollectorResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(CollectorResponse::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(CollectorResponse::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<CollectorHealthCheck> COLLECTOR_HEALTH_CHECK_FIELD = SdkField
            .<CollectorHealthCheck> builder(MarshallingType.SDK_POJO).memberName("CollectorHealthCheck")
            .getter(getter(CollectorResponse::collectorHealthCheck)).setter(setter(Builder::collectorHealthCheck))
            .constructor(CollectorHealthCheck::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorHealthCheck").build())
            .build();

    private static final SdkField<String> LAST_DATA_RECEIVED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastDataReceived").getter(getter(CollectorResponse::lastDataReceived))
            .setter(setter(Builder::lastDataReceived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDataReceived").build()).build();

    private static final SdkField<String> REGISTERED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegisteredDate").getter(getter(CollectorResponse::registeredDate))
            .setter(setter(Builder::registeredDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredDate").build()).build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(CollectorResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModifiedDate").getter(getter(CollectorResponse::modifiedDate)).setter(setter(Builder::modifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedDate").build()).build();

    private static final SdkField<InventoryData> INVENTORY_DATA_FIELD = SdkField
            .<InventoryData> builder(MarshallingType.SDK_POJO).memberName("InventoryData")
            .getter(getter(CollectorResponse::inventoryData)).setter(setter(Builder::inventoryData))
            .constructor(InventoryData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTOR_REFERENCED_ID_FIELD,
            COLLECTOR_NAME_FIELD, COLLECTOR_VERSION_FIELD, VERSION_STATUS_FIELD, DESCRIPTION_FIELD, S3_BUCKET_NAME_FIELD,
            SERVICE_ACCESS_ROLE_ARN_FIELD, COLLECTOR_HEALTH_CHECK_FIELD, LAST_DATA_RECEIVED_FIELD, REGISTERED_DATE_FIELD,
            CREATED_DATE_FIELD, MODIFIED_DATE_FIELD, INVENTORY_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String collectorReferencedId;

    private final String collectorName;

    private final String collectorVersion;

    private final String versionStatus;

    private final String description;

    private final String s3BucketName;

    private final String serviceAccessRoleArn;

    private final CollectorHealthCheck collectorHealthCheck;

    private final String lastDataReceived;

    private final String registeredDate;

    private final String createdDate;

    private final String modifiedDate;

    private final InventoryData inventoryData;

    private CollectorResponse(BuilderImpl builder) {
        this.collectorReferencedId = builder.collectorReferencedId;
        this.collectorName = builder.collectorName;
        this.collectorVersion = builder.collectorVersion;
        this.versionStatus = builder.versionStatus;
        this.description = builder.description;
        this.s3BucketName = builder.s3BucketName;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.collectorHealthCheck = builder.collectorHealthCheck;
        this.lastDataReceived = builder.lastDataReceived;
        this.registeredDate = builder.registeredDate;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
        this.inventoryData = builder.inventoryData;
    }

    /**
     * <p>
     * The reference ID of the Fleet Advisor collector.
     * </p>
     * 
     * @return The reference ID of the Fleet Advisor collector.
     */
    public final String collectorReferencedId() {
        return collectorReferencedId;
    }

    /**
     * <p>
     * The name of the Fleet Advisor collector .
     * </p>
     * 
     * @return The name of the Fleet Advisor collector .
     */
    public final String collectorName() {
        return collectorName;
    }

    /**
     * <p>
     * The version of your Fleet Advisor collector, in semantic versioning format, for example <code>1.0.2</code>
     * </p>
     * 
     * @return The version of your Fleet Advisor collector, in semantic versioning format, for example
     *         <code>1.0.2</code>
     */
    public final String collectorVersion() {
        return collectorVersion;
    }

    /**
     * <p>
     * Whether the collector version is up to date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionStatus}
     * will return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionStatusAsString}.
     * </p>
     * 
     * @return Whether the collector version is up to date.
     * @see VersionStatus
     */
    public final VersionStatus versionStatus() {
        return VersionStatus.fromValue(versionStatus);
    }

    /**
     * <p>
     * Whether the collector version is up to date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionStatus}
     * will return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionStatusAsString}.
     * </p>
     * 
     * @return Whether the collector version is up to date.
     * @see VersionStatus
     */
    public final String versionStatusAsString() {
        return versionStatus;
    }

    /**
     * <p>
     * A summary description of the Fleet Advisor collector.
     * </p>
     * 
     * @return A summary description of the Fleet Advisor collector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon S3 bucket that the Fleet Advisor collector uses to store inventory metadata.
     * </p>
     * 
     * @return The Amazon S3 bucket that the Fleet Advisor collector uses to store inventory metadata.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The IAM role that grants permissions to access the specified Amazon S3 bucket.
     * </p>
     * 
     * @return The IAM role that grants permissions to access the specified Amazon S3 bucket.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * Returns the value of the CollectorHealthCheck property for this object.
     * 
     * @return The value of the CollectorHealthCheck property for this object.
     */
    public final CollectorHealthCheck collectorHealthCheck() {
        return collectorHealthCheck;
    }

    /**
     * <p>
     * The timestamp of the last time the collector received data, in the following format:
     * <code>2022-01-24T19:04:02.596113Z</code>
     * </p>
     * 
     * @return The timestamp of the last time the collector received data, in the following format:
     *         <code>2022-01-24T19:04:02.596113Z</code>
     */
    public final String lastDataReceived() {
        return lastDataReceived;
    }

    /**
     * <p>
     * The timestamp when DMS registered the collector, in the following format:
     * <code>2022-01-24T19:04:02.596113Z</code>
     * </p>
     * 
     * @return The timestamp when DMS registered the collector, in the following format:
     *         <code>2022-01-24T19:04:02.596113Z</code>
     */
    public final String registeredDate() {
        return registeredDate;
    }

    /**
     * <p>
     * The timestamp when you created the collector, in the following format: <code>2022-01-24T19:04:02.596113Z</code>
     * </p>
     * 
     * @return The timestamp when you created the collector, in the following format:
     *         <code>2022-01-24T19:04:02.596113Z</code>
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp when DMS last modified the collector, in the following format:
     * <code>2022-01-24T19:04:02.596113Z</code>
     * </p>
     * 
     * @return The timestamp when DMS last modified the collector, in the following format:
     *         <code>2022-01-24T19:04:02.596113Z</code>
     */
    public final String modifiedDate() {
        return modifiedDate;
    }

    /**
     * Returns the value of the InventoryData property for this object.
     * 
     * @return The value of the InventoryData property for this object.
     */
    public final InventoryData inventoryData() {
        return inventoryData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectorReferencedId());
        hashCode = 31 * hashCode + Objects.hashCode(collectorName());
        hashCode = 31 * hashCode + Objects.hashCode(collectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(versionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(collectorHealthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(lastDataReceived());
        hashCode = 31 * hashCode + Objects.hashCode(registeredDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(inventoryData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectorResponse)) {
            return false;
        }
        CollectorResponse other = (CollectorResponse) obj;
        return Objects.equals(collectorReferencedId(), other.collectorReferencedId())
                && Objects.equals(collectorName(), other.collectorName())
                && Objects.equals(collectorVersion(), other.collectorVersion())
                && Objects.equals(versionStatusAsString(), other.versionStatusAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(collectorHealthCheck(), other.collectorHealthCheck())
                && Objects.equals(lastDataReceived(), other.lastDataReceived())
                && Objects.equals(registeredDate(), other.registeredDate()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(modifiedDate(), other.modifiedDate()) && Objects.equals(inventoryData(), other.inventoryData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollectorResponse").add("CollectorReferencedId", collectorReferencedId())
                .add("CollectorName", collectorName()).add("CollectorVersion", collectorVersion())
                .add("VersionStatus", versionStatusAsString()).add("Description", description())
                .add("S3BucketName", s3BucketName()).add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("CollectorHealthCheck", collectorHealthCheck()).add("LastDataReceived", lastDataReceived())
                .add("RegisteredDate", registeredDate()).add("CreatedDate", createdDate()).add("ModifiedDate", modifiedDate())
                .add("InventoryData", inventoryData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectorReferencedId":
            return Optional.ofNullable(clazz.cast(collectorReferencedId()));
        case "CollectorName":
            return Optional.ofNullable(clazz.cast(collectorName()));
        case "CollectorVersion":
            return Optional.ofNullable(clazz.cast(collectorVersion()));
        case "VersionStatus":
            return Optional.ofNullable(clazz.cast(versionStatusAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "CollectorHealthCheck":
            return Optional.ofNullable(clazz.cast(collectorHealthCheck()));
        case "LastDataReceived":
            return Optional.ofNullable(clazz.cast(lastDataReceived()));
        case "RegisteredDate":
            return Optional.ofNullable(clazz.cast(registeredDate()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "ModifiedDate":
            return Optional.ofNullable(clazz.cast(modifiedDate()));
        case "InventoryData":
            return Optional.ofNullable(clazz.cast(inventoryData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CollectorReferencedId", COLLECTOR_REFERENCED_ID_FIELD);
        map.put("CollectorName", COLLECTOR_NAME_FIELD);
        map.put("CollectorVersion", COLLECTOR_VERSION_FIELD);
        map.put("VersionStatus", VERSION_STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("ServiceAccessRoleArn", SERVICE_ACCESS_ROLE_ARN_FIELD);
        map.put("CollectorHealthCheck", COLLECTOR_HEALTH_CHECK_FIELD);
        map.put("LastDataReceived", LAST_DATA_RECEIVED_FIELD);
        map.put("RegisteredDate", REGISTERED_DATE_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("ModifiedDate", MODIFIED_DATE_FIELD);
        map.put("InventoryData", INVENTORY_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectorResponse, T> g) {
        return obj -> g.apply((CollectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollectorResponse> {
        /**
         * <p>
         * The reference ID of the Fleet Advisor collector.
         * </p>
         * 
         * @param collectorReferencedId
         *        The reference ID of the Fleet Advisor collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorReferencedId(String collectorReferencedId);

        /**
         * <p>
         * The name of the Fleet Advisor collector .
         * </p>
         * 
         * @param collectorName
         *        The name of the Fleet Advisor collector .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorName(String collectorName);

        /**
         * <p>
         * The version of your Fleet Advisor collector, in semantic versioning format, for example <code>1.0.2</code>
         * </p>
         * 
         * @param collectorVersion
         *        The version of your Fleet Advisor collector, in semantic versioning format, for example
         *        <code>1.0.2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorVersion(String collectorVersion);

        /**
         * <p>
         * Whether the collector version is up to date.
         * </p>
         * 
         * @param versionStatus
         *        Whether the collector version is up to date.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder versionStatus(String versionStatus);

        /**
         * <p>
         * Whether the collector version is up to date.
         * </p>
         * 
         * @param versionStatus
         *        Whether the collector version is up to date.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder versionStatus(VersionStatus versionStatus);

        /**
         * <p>
         * A summary description of the Fleet Advisor collector.
         * </p>
         * 
         * @param description
         *        A summary description of the Fleet Advisor collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon S3 bucket that the Fleet Advisor collector uses to store inventory metadata.
         * </p>
         * 
         * @param s3BucketName
         *        The Amazon S3 bucket that the Fleet Advisor collector uses to store inventory metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The IAM role that grants permissions to access the specified Amazon S3 bucket.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The IAM role that grants permissions to access the specified Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * Sets the value of the CollectorHealthCheck property for this object.
         *
         * @param collectorHealthCheck
         *        The new value for the CollectorHealthCheck property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorHealthCheck(CollectorHealthCheck collectorHealthCheck);

        /**
         * Sets the value of the CollectorHealthCheck property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CollectorHealthCheck.Builder} avoiding
         * the need to create one manually via {@link CollectorHealthCheck#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollectorHealthCheck.Builder#build()} is called immediately and
         * its result is passed to {@link #collectorHealthCheck(CollectorHealthCheck)}.
         * 
         * @param collectorHealthCheck
         *        a consumer that will call methods on {@link CollectorHealthCheck.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectorHealthCheck(CollectorHealthCheck)
         */
        default Builder collectorHealthCheck(Consumer<CollectorHealthCheck.Builder> collectorHealthCheck) {
            return collectorHealthCheck(CollectorHealthCheck.builder().applyMutation(collectorHealthCheck).build());
        }

        /**
         * <p>
         * The timestamp of the last time the collector received data, in the following format:
         * <code>2022-01-24T19:04:02.596113Z</code>
         * </p>
         * 
         * @param lastDataReceived
         *        The timestamp of the last time the collector received data, in the following format:
         *        <code>2022-01-24T19:04:02.596113Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDataReceived(String lastDataReceived);

        /**
         * <p>
         * The timestamp when DMS registered the collector, in the following format:
         * <code>2022-01-24T19:04:02.596113Z</code>
         * </p>
         * 
         * @param registeredDate
         *        The timestamp when DMS registered the collector, in the following format:
         *        <code>2022-01-24T19:04:02.596113Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredDate(String registeredDate);

        /**
         * <p>
         * The timestamp when you created the collector, in the following format:
         * <code>2022-01-24T19:04:02.596113Z</code>
         * </p>
         * 
         * @param createdDate
         *        The timestamp when you created the collector, in the following format:
         *        <code>2022-01-24T19:04:02.596113Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * The timestamp when DMS last modified the collector, in the following format:
         * <code>2022-01-24T19:04:02.596113Z</code>
         * </p>
         * 
         * @param modifiedDate
         *        The timestamp when DMS last modified the collector, in the following format:
         *        <code>2022-01-24T19:04:02.596113Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedDate(String modifiedDate);

        /**
         * Sets the value of the InventoryData property for this object.
         *
         * @param inventoryData
         *        The new value for the InventoryData property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryData(InventoryData inventoryData);

        /**
         * Sets the value of the InventoryData property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InventoryData.Builder} avoiding the need
         * to create one manually via {@link InventoryData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InventoryData.Builder#build()} is called immediately and its
         * result is passed to {@link #inventoryData(InventoryData)}.
         * 
         * @param inventoryData
         *        a consumer that will call methods on {@link InventoryData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inventoryData(InventoryData)
         */
        default Builder inventoryData(Consumer<InventoryData.Builder> inventoryData) {
            return inventoryData(InventoryData.builder().applyMutation(inventoryData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String collectorReferencedId;

        private String collectorName;

        private String collectorVersion;

        private String versionStatus;

        private String description;

        private String s3BucketName;

        private String serviceAccessRoleArn;

        private CollectorHealthCheck collectorHealthCheck;

        private String lastDataReceived;

        private String registeredDate;

        private String createdDate;

        private String modifiedDate;

        private InventoryData inventoryData;

        private BuilderImpl() {
        }

        private BuilderImpl(CollectorResponse model) {
            collectorReferencedId(model.collectorReferencedId);
            collectorName(model.collectorName);
            collectorVersion(model.collectorVersion);
            versionStatus(model.versionStatus);
            description(model.description);
            s3BucketName(model.s3BucketName);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            collectorHealthCheck(model.collectorHealthCheck);
            lastDataReceived(model.lastDataReceived);
            registeredDate(model.registeredDate);
            createdDate(model.createdDate);
            modifiedDate(model.modifiedDate);
            inventoryData(model.inventoryData);
        }

        public final String getCollectorReferencedId() {
            return collectorReferencedId;
        }

        public final void setCollectorReferencedId(String collectorReferencedId) {
            this.collectorReferencedId = collectorReferencedId;
        }

        @Override
        public final Builder collectorReferencedId(String collectorReferencedId) {
            this.collectorReferencedId = collectorReferencedId;
            return this;
        }

        public final String getCollectorName() {
            return collectorName;
        }

        public final void setCollectorName(String collectorName) {
            this.collectorName = collectorName;
        }

        @Override
        public final Builder collectorName(String collectorName) {
            this.collectorName = collectorName;
            return this;
        }

        public final String getCollectorVersion() {
            return collectorVersion;
        }

        public final void setCollectorVersion(String collectorVersion) {
            this.collectorVersion = collectorVersion;
        }

        @Override
        public final Builder collectorVersion(String collectorVersion) {
            this.collectorVersion = collectorVersion;
            return this;
        }

        public final String getVersionStatus() {
            return versionStatus;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(VersionStatus versionStatus) {
            this.versionStatus(versionStatus == null ? null : versionStatus.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final CollectorHealthCheck.Builder getCollectorHealthCheck() {
            return collectorHealthCheck != null ? collectorHealthCheck.toBuilder() : null;
        }

        public final void setCollectorHealthCheck(CollectorHealthCheck.BuilderImpl collectorHealthCheck) {
            this.collectorHealthCheck = collectorHealthCheck != null ? collectorHealthCheck.build() : null;
        }

        @Override
        public final Builder collectorHealthCheck(CollectorHealthCheck collectorHealthCheck) {
            this.collectorHealthCheck = collectorHealthCheck;
            return this;
        }

        public final String getLastDataReceived() {
            return lastDataReceived;
        }

        public final void setLastDataReceived(String lastDataReceived) {
            this.lastDataReceived = lastDataReceived;
        }

        @Override
        public final Builder lastDataReceived(String lastDataReceived) {
            this.lastDataReceived = lastDataReceived;
            return this;
        }

        public final String getRegisteredDate() {
            return registeredDate;
        }

        public final void setRegisteredDate(String registeredDate) {
            this.registeredDate = registeredDate;
        }

        @Override
        public final Builder registeredDate(String registeredDate) {
            this.registeredDate = registeredDate;
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getModifiedDate() {
            return modifiedDate;
        }

        public final void setModifiedDate(String modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        @Override
        public final Builder modifiedDate(String modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final InventoryData.Builder getInventoryData() {
            return inventoryData != null ? inventoryData.toBuilder() : null;
        }

        public final void setInventoryData(InventoryData.BuilderImpl inventoryData) {
            this.inventoryData = inventoryData != null ? inventoryData.build() : null;
        }

        @Override
        public final Builder inventoryData(InventoryData inventoryData) {
            this.inventoryData = inventoryData;
            return this;
        }

        @Override
        public CollectorResponse build() {
            return new CollectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
