/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationInstanceTaskLogsResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeReplicationInstanceTaskLogsResponse.Builder, DescribeReplicationInstanceTaskLogsResponse> {
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceArn")
            .getter(getter(DescribeReplicationInstanceTaskLogsResponse::replicationInstanceArn))
            .setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<List<ReplicationInstanceTaskLog>> REPLICATION_INSTANCE_TASK_LOGS_FIELD = SdkField
            .<List<ReplicationInstanceTaskLog>> builder(MarshallingType.LIST)
            .memberName("ReplicationInstanceTaskLogs")
            .getter(getter(DescribeReplicationInstanceTaskLogsResponse::replicationInstanceTaskLogs))
            .setter(setter(Builder::replicationInstanceTaskLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceTaskLogs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationInstanceTaskLog> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationInstanceTaskLog::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReplicationInstanceTaskLogsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_INSTANCE_ARN_FIELD, REPLICATION_INSTANCE_TASK_LOGS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationInstanceArn;

    private final List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs;

    private final String marker;

    private DescribeReplicationInstanceTaskLogsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.replicationInstanceTaskLogs = builder.replicationInstanceTaskLogs;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication instance.
     */
    public final String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationInstanceTaskLogs property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicationInstanceTaskLogs() {
        return replicationInstanceTaskLogs != null && !(replicationInstanceTaskLogs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of replication task log metadata. Each member of the array contains the replication task name, ARN, and
     * task log size (in bytes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationInstanceTaskLogs} method.
     * </p>
     * 
     * @return An array of replication task log metadata. Each member of the array contains the replication task name,
     *         ARN, and task log size (in bytes).
     */
    public final List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs() {
        return replicationInstanceTaskLogs;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationInstanceTaskLogs() ? replicationInstanceTaskLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationInstanceTaskLogsResponse)) {
            return false;
        }
        DescribeReplicationInstanceTaskLogsResponse other = (DescribeReplicationInstanceTaskLogsResponse) obj;
        return Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && hasReplicationInstanceTaskLogs() == other.hasReplicationInstanceTaskLogs()
                && Objects.equals(replicationInstanceTaskLogs(), other.replicationInstanceTaskLogs())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicationInstanceTaskLogsResponse")
                .add("ReplicationInstanceArn", replicationInstanceArn())
                .add("ReplicationInstanceTaskLogs", hasReplicationInstanceTaskLogs() ? replicationInstanceTaskLogs() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "ReplicationInstanceTaskLogs":
            return Optional.ofNullable(clazz.cast(replicationInstanceTaskLogs()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationInstanceArn", REPLICATION_INSTANCE_ARN_FIELD);
        map.put("ReplicationInstanceTaskLogs", REPLICATION_INSTANCE_TASK_LOGS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationInstanceTaskLogsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationInstanceTaskLogsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationInstanceTaskLogsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * An array of replication task log metadata. Each member of the array contains the replication task name, ARN,
         * and task log size (in bytes).
         * </p>
         * 
         * @param replicationInstanceTaskLogs
         *        An array of replication task log metadata. Each member of the array contains the replication task
         *        name, ARN, and task log size (in bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceTaskLogs(Collection<ReplicationInstanceTaskLog> replicationInstanceTaskLogs);

        /**
         * <p>
         * An array of replication task log metadata. Each member of the array contains the replication task name, ARN,
         * and task log size (in bytes).
         * </p>
         * 
         * @param replicationInstanceTaskLogs
         *        An array of replication task log metadata. Each member of the array contains the replication task
         *        name, ARN, and task log size (in bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceTaskLogs(ReplicationInstanceTaskLog... replicationInstanceTaskLogs);

        /**
         * <p>
         * An array of replication task log metadata. Each member of the array contains the replication task name, ARN,
         * and task log size (in bytes).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #replicationInstanceTaskLogs(List<ReplicationInstanceTaskLog>)}.
         * 
         * @param replicationInstanceTaskLogs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationInstanceTaskLogs(java.util.Collection<ReplicationInstanceTaskLog>)
         */
        Builder replicationInstanceTaskLogs(Consumer<ReplicationInstanceTaskLog.Builder>... replicationInstanceTaskLogs);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String replicationInstanceArn;

        private List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationInstanceTaskLogsResponse model) {
            super(model);
            replicationInstanceArn(model.replicationInstanceArn);
            replicationInstanceTaskLogs(model.replicationInstanceTaskLogs);
            marker(model.marker);
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final List<ReplicationInstanceTaskLog.Builder> getReplicationInstanceTaskLogs() {
            List<ReplicationInstanceTaskLog.Builder> result = ReplicationInstanceTaskLogsListCopier
                    .copyToBuilder(this.replicationInstanceTaskLogs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationInstanceTaskLogs(
                Collection<ReplicationInstanceTaskLog.BuilderImpl> replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs = ReplicationInstanceTaskLogsListCopier.copyFromBuilder(replicationInstanceTaskLogs);
        }

        @Override
        public final Builder replicationInstanceTaskLogs(Collection<ReplicationInstanceTaskLog> replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs = ReplicationInstanceTaskLogsListCopier.copy(replicationInstanceTaskLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstanceTaskLogs(ReplicationInstanceTaskLog... replicationInstanceTaskLogs) {
            replicationInstanceTaskLogs(Arrays.asList(replicationInstanceTaskLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstanceTaskLogs(
                Consumer<ReplicationInstanceTaskLog.Builder>... replicationInstanceTaskLogs) {
            replicationInstanceTaskLogs(Stream.of(replicationInstanceTaskLogs)
                    .map(c -> ReplicationInstanceTaskLog.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeReplicationInstanceTaskLogsResponse build() {
            return new DescribeReplicationInstanceTaskLogsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
