/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies using Kerberos authentication settings for use with DMS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KerberosAuthenticationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<KerberosAuthenticationSettings.Builder, KerberosAuthenticationSettings> {
    private static final SdkField<String> KEY_CACHE_SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCacheSecretId").getter(getter(KerberosAuthenticationSettings::keyCacheSecretId))
            .setter(setter(Builder::keyCacheSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCacheSecretId").build()).build();

    private static final SdkField<String> KEY_CACHE_SECRET_IAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyCacheSecretIamArn").getter(getter(KerberosAuthenticationSettings::keyCacheSecretIamArn))
            .setter(setter(Builder::keyCacheSecretIamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCacheSecretIamArn").build())
            .build();

    private static final SdkField<String> KRB5_FILE_CONTENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Krb5FileContents").getter(getter(KerberosAuthenticationSettings::krb5FileContents))
            .setter(setter(Builder::krb5FileContents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Krb5FileContents").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_CACHE_SECRET_ID_FIELD,
            KEY_CACHE_SECRET_IAM_ARN_FIELD, KRB5_FILE_CONTENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyCacheSecretId;

    private final String keyCacheSecretIamArn;

    private final String krb5FileContents;

    private KerberosAuthenticationSettings(BuilderImpl builder) {
        this.keyCacheSecretId = builder.keyCacheSecretId;
        this.keyCacheSecretIamArn = builder.keyCacheSecretIamArn;
        this.krb5FileContents = builder.krb5FileContents;
    }

    /**
     * <p>
     * Specifies the secret ID of the key cache for the replication instance.
     * </p>
     * 
     * @return Specifies the secret ID of the key cache for the replication instance.
     */
    public final String keyCacheSecretId() {
        return keyCacheSecretId;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the IAM role that grants Amazon Web Services DMS access to the secret
     * containing key cache file for the replication instance.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the IAM role that grants Amazon Web Services DMS access to
     *         the secret containing key cache file for the replication instance.
     */
    public final String keyCacheSecretIamArn() {
        return keyCacheSecretIamArn;
    }

    /**
     * <p>
     * Specifies the ID of the secret that stores the key cache file required for kerberos authentication of the
     * replication instance.
     * </p>
     * 
     * @return Specifies the ID of the secret that stores the key cache file required for kerberos authentication of the
     *         replication instance.
     */
    public final String krb5FileContents() {
        return krb5FileContents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyCacheSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(keyCacheSecretIamArn());
        hashCode = 31 * hashCode + Objects.hashCode(krb5FileContents());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KerberosAuthenticationSettings)) {
            return false;
        }
        KerberosAuthenticationSettings other = (KerberosAuthenticationSettings) obj;
        return Objects.equals(keyCacheSecretId(), other.keyCacheSecretId())
                && Objects.equals(keyCacheSecretIamArn(), other.keyCacheSecretIamArn())
                && Objects.equals(krb5FileContents(), other.krb5FileContents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KerberosAuthenticationSettings").add("KeyCacheSecretId", keyCacheSecretId())
                .add("KeyCacheSecretIamArn", keyCacheSecretIamArn()).add("Krb5FileContents", krb5FileContents()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyCacheSecretId":
            return Optional.ofNullable(clazz.cast(keyCacheSecretId()));
        case "KeyCacheSecretIamArn":
            return Optional.ofNullable(clazz.cast(keyCacheSecretIamArn()));
        case "Krb5FileContents":
            return Optional.ofNullable(clazz.cast(krb5FileContents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyCacheSecretId", KEY_CACHE_SECRET_ID_FIELD);
        map.put("KeyCacheSecretIamArn", KEY_CACHE_SECRET_IAM_ARN_FIELD);
        map.put("Krb5FileContents", KRB5_FILE_CONTENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KerberosAuthenticationSettings, T> g) {
        return obj -> g.apply((KerberosAuthenticationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KerberosAuthenticationSettings> {
        /**
         * <p>
         * Specifies the secret ID of the key cache for the replication instance.
         * </p>
         * 
         * @param keyCacheSecretId
         *        Specifies the secret ID of the key cache for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCacheSecretId(String keyCacheSecretId);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the IAM role that grants Amazon Web Services DMS access to the
         * secret containing key cache file for the replication instance.
         * </p>
         * 
         * @param keyCacheSecretIamArn
         *        Specifies the Amazon Resource Name (ARN) of the IAM role that grants Amazon Web Services DMS access to
         *        the secret containing key cache file for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyCacheSecretIamArn(String keyCacheSecretIamArn);

        /**
         * <p>
         * Specifies the ID of the secret that stores the key cache file required for kerberos authentication of the
         * replication instance.
         * </p>
         * 
         * @param krb5FileContents
         *        Specifies the ID of the secret that stores the key cache file required for kerberos authentication of
         *        the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder krb5FileContents(String krb5FileContents);
    }

    static final class BuilderImpl implements Builder {
        private String keyCacheSecretId;

        private String keyCacheSecretIamArn;

        private String krb5FileContents;

        private BuilderImpl() {
        }

        private BuilderImpl(KerberosAuthenticationSettings model) {
            keyCacheSecretId(model.keyCacheSecretId);
            keyCacheSecretIamArn(model.keyCacheSecretIamArn);
            krb5FileContents(model.krb5FileContents);
        }

        public final String getKeyCacheSecretId() {
            return keyCacheSecretId;
        }

        public final void setKeyCacheSecretId(String keyCacheSecretId) {
            this.keyCacheSecretId = keyCacheSecretId;
        }

        @Override
        public final Builder keyCacheSecretId(String keyCacheSecretId) {
            this.keyCacheSecretId = keyCacheSecretId;
            return this;
        }

        public final String getKeyCacheSecretIamArn() {
            return keyCacheSecretIamArn;
        }

        public final void setKeyCacheSecretIamArn(String keyCacheSecretIamArn) {
            this.keyCacheSecretIamArn = keyCacheSecretIamArn;
        }

        @Override
        public final Builder keyCacheSecretIamArn(String keyCacheSecretIamArn) {
            this.keyCacheSecretIamArn = keyCacheSecretIamArn;
            return this;
        }

        public final String getKrb5FileContents() {
            return krb5FileContents;
        }

        public final void setKrb5FileContents(String krb5FileContents) {
            this.krb5FileContents = krb5FileContents;
        }

        @Override
        public final Builder krb5FileContents(String krb5FileContents) {
            this.krb5FileContents = krb5FileContents;
            return this;
        }

        @Override
        public KerberosAuthenticationSettings build() {
            return new KerberosAuthenticationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
