/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a Microsoft SQL Server endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MicrosoftSQLServerSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MicrosoftSQLServerSettings.Builder, MicrosoftSQLServerSettings> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(MicrosoftSQLServerSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Integer> BCP_PACKET_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BcpPacketSize").getter(getter(MicrosoftSQLServerSettings::bcpPacketSize))
            .setter(setter(Builder::bcpPacketSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BcpPacketSize").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(MicrosoftSQLServerSettings::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> CONTROL_TABLES_FILE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlTablesFileGroup").getter(getter(MicrosoftSQLServerSettings::controlTablesFileGroup))
            .setter(setter(Builder::controlTablesFileGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlTablesFileGroup").build())
            .build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(MicrosoftSQLServerSettings::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Boolean> QUERY_SINGLE_ALWAYS_ON_NODE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("QuerySingleAlwaysOnNode")
            .getter(getter(MicrosoftSQLServerSettings::querySingleAlwaysOnNode)).setter(setter(Builder::querySingleAlwaysOnNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySingleAlwaysOnNode").build())
            .build();

    private static final SdkField<Boolean> READ_BACKUP_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadBackupOnly").getter(getter(MicrosoftSQLServerSettings::readBackupOnly))
            .setter(setter(Builder::readBackupOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadBackupOnly").build()).build();

    private static final SdkField<String> SAFEGUARD_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SafeguardPolicy").getter(getter(MicrosoftSQLServerSettings::safeguardPolicyAsString))
            .setter(setter(Builder::safeguardPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafeguardPolicy").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(MicrosoftSQLServerSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(MicrosoftSQLServerSettings::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<Boolean> USE_BCP_FULL_LOAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseBcpFullLoad").getter(getter(MicrosoftSQLServerSettings::useBcpFullLoad))
            .setter(setter(Builder::useBcpFullLoad))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBcpFullLoad").build()).build();

    private static final SdkField<Boolean> USE_THIRD_PARTY_BACKUP_DEVICE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("UseThirdPartyBackupDevice")
            .getter(getter(MicrosoftSQLServerSettings::useThirdPartyBackupDevice))
            .setter(setter(Builder::useThirdPartyBackupDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseThirdPartyBackupDevice").build())
            .build();

    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerAccessRoleArn")
            .getter(getter(MicrosoftSQLServerSettings::secretsManagerAccessRoleArn))
            .setter(setter(Builder::secretsManagerAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn")
                    .build()).build();

    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerSecretId").getter(getter(MicrosoftSQLServerSettings::secretsManagerSecretId))
            .setter(setter(Builder::secretsManagerSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build())
            .build();

    private static final SdkField<Boolean> TRIM_SPACE_IN_CHAR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TrimSpaceInChar").getter(getter(MicrosoftSQLServerSettings::trimSpaceInChar))
            .setter(setter(Builder::trimSpaceInChar))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrimSpaceInChar").build()).build();

    private static final SdkField<String> TLOG_ACCESS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TlogAccessMode").getter(getter(MicrosoftSQLServerSettings::tlogAccessModeAsString))
            .setter(setter(Builder::tlogAccessMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlogAccessMode").build()).build();

    private static final SdkField<Boolean> FORCE_LOB_LOOKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceLobLookup").getter(getter(MicrosoftSQLServerSettings::forceLobLookup))
            .setter(setter(Builder::forceLobLookup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceLobLookup").build()).build();

    private static final SdkField<String> AUTHENTICATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMethod").getter(getter(MicrosoftSQLServerSettings::authenticationMethodAsString))
            .setter(setter(Builder::authenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD,
            BCP_PACKET_SIZE_FIELD, DATABASE_NAME_FIELD, CONTROL_TABLES_FILE_GROUP_FIELD, PASSWORD_FIELD,
            QUERY_SINGLE_ALWAYS_ON_NODE_FIELD, READ_BACKUP_ONLY_FIELD, SAFEGUARD_POLICY_FIELD, SERVER_NAME_FIELD, USERNAME_FIELD,
            USE_BCP_FULL_LOAD_FIELD, USE_THIRD_PARTY_BACKUP_DEVICE_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD,
            SECRETS_MANAGER_SECRET_ID_FIELD, TRIM_SPACE_IN_CHAR_FIELD, TLOG_ACCESS_MODE_FIELD, FORCE_LOB_LOOKUP_FIELD,
            AUTHENTICATION_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final Integer bcpPacketSize;

    private final String databaseName;

    private final String controlTablesFileGroup;

    private final String password;

    private final Boolean querySingleAlwaysOnNode;

    private final Boolean readBackupOnly;

    private final String safeguardPolicy;

    private final String serverName;

    private final String username;

    private final Boolean useBcpFullLoad;

    private final Boolean useThirdPartyBackupDevice;

    private final String secretsManagerAccessRoleArn;

    private final String secretsManagerSecretId;

    private final Boolean trimSpaceInChar;

    private final String tlogAccessMode;

    private final Boolean forceLobLookup;

    private final String authenticationMethod;

    private MicrosoftSQLServerSettings(BuilderImpl builder) {
        this.port = builder.port;
        this.bcpPacketSize = builder.bcpPacketSize;
        this.databaseName = builder.databaseName;
        this.controlTablesFileGroup = builder.controlTablesFileGroup;
        this.password = builder.password;
        this.querySingleAlwaysOnNode = builder.querySingleAlwaysOnNode;
        this.readBackupOnly = builder.readBackupOnly;
        this.safeguardPolicy = builder.safeguardPolicy;
        this.serverName = builder.serverName;
        this.username = builder.username;
        this.useBcpFullLoad = builder.useBcpFullLoad;
        this.useThirdPartyBackupDevice = builder.useThirdPartyBackupDevice;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.trimSpaceInChar = builder.trimSpaceInChar;
        this.tlogAccessMode = builder.tlogAccessMode;
        this.forceLobLookup = builder.forceLobLookup;
        this.authenticationMethod = builder.authenticationMethod;
    }

    /**
     * <p>
     * Endpoint TCP port.
     * </p>
     * 
     * @return Endpoint TCP port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The maximum size of the packets (in bytes) used to transfer data using BCP.
     * </p>
     * 
     * @return The maximum size of the packets (in bytes) used to transfer data using BCP.
     */
    public final Integer bcpPacketSize() {
        return bcpPacketSize;
    }

    /**
     * <p>
     * Database name for the endpoint.
     * </p>
     * 
     * @return Database name for the endpoint.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Specifies a file group for the DMS internal tables. When the replication task starts, all the internal DMS
     * control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the specified file group.
     * </p>
     * 
     * @return Specifies a file group for the DMS internal tables. When the replication task starts, all the internal
     *         DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the specified
     *         file group.
     */
    public final String controlTablesFileGroup() {
        return controlTablesFileGroup;
    }

    /**
     * <p>
     * Endpoint connection password.
     * </p>
     * 
     * @return Endpoint connection password.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * Cleans and recreates table metadata information on the replication instance when a mismatch occurs. An example is
     * a situation where running an alter DDL statement on a table might result in different information about the table
     * cached in the replication instance.
     * </p>
     * 
     * @return Cleans and recreates table metadata information on the replication instance when a mismatch occurs. An
     *         example is a situation where running an alter DDL statement on a table might result in different
     *         information about the table cached in the replication instance.
     */
    public final Boolean querySingleAlwaysOnNode() {
        return querySingleAlwaysOnNode;
    }

    /**
     * <p>
     * When this attribute is set to <code>Y</code>, DMS only reads changes from transaction log backups and doesn't
     * read from the active transaction log file during ongoing replication. Setting this parameter to <code>Y</code>
     * enables you to control active transaction log file growth during full load and ongoing replication tasks.
     * However, it can add some source latency to ongoing replication.
     * </p>
     * 
     * @return When this attribute is set to <code>Y</code>, DMS only reads changes from transaction log backups and
     *         doesn't read from the active transaction log file during ongoing replication. Setting this parameter to
     *         <code>Y</code> enables you to control active transaction log file growth during full load and ongoing
     *         replication tasks. However, it can add some source latency to ongoing replication.
     */
    public final Boolean readBackupOnly() {
        return readBackupOnly;
    }

    /**
     * <p>
     * Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation using one
     * of the following two methods.
     * </p>
     * <p>
     * <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS prevents
     * TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes that
     * appear after the transaction started aren't truncated. If you need Microsoft Replication to be enabled in your
     * database, then you must choose this method.
     * </p>
     * <p>
     * <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the changes and then
     * uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't involve any
     * transactional activities, it can only be used when Microsoft Replication isn't running. Also, when using this
     * method, only one DMS task can access the database at any given time. Therefore, if you need to run parallel DMS
     * tasks against the same database, use the default method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #safeguardPolicy}
     * will return {@link SafeguardPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #safeguardPolicyAsString}.
     * </p>
     * 
     * @return Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation
     *         using one of the following two methods.</p>
     *         <p>
     *         <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS
     *         prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is
     *         open, changes that appear after the transaction started aren't truncated. If you need Microsoft
     *         Replication to be enabled in your database, then you must choose this method.
     *         </p>
     *         <p>
     *         <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the changes
     *         and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method
     *         doesn't involve any transactional activities, it can only be used when Microsoft Replication isn't
     *         running. Also, when using this method, only one DMS task can access the database at any given time.
     *         Therefore, if you need to run parallel DMS tasks against the same database, use the default method.
     * @see SafeguardPolicy
     */
    public final SafeguardPolicy safeguardPolicy() {
        return SafeguardPolicy.fromValue(safeguardPolicy);
    }

    /**
     * <p>
     * Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation using one
     * of the following two methods.
     * </p>
     * <p>
     * <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS prevents
     * TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes that
     * appear after the transaction started aren't truncated. If you need Microsoft Replication to be enabled in your
     * database, then you must choose this method.
     * </p>
     * <p>
     * <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the changes and then
     * uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't involve any
     * transactional activities, it can only be used when Microsoft Replication isn't running. Also, when using this
     * method, only one DMS task can access the database at any given time. Therefore, if you need to run parallel DMS
     * tasks against the same database, use the default method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #safeguardPolicy}
     * will return {@link SafeguardPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #safeguardPolicyAsString}.
     * </p>
     * 
     * @return Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation
     *         using one of the following two methods.</p>
     *         <p>
     *         <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS
     *         prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is
     *         open, changes that appear after the transaction started aren't truncated. If you need Microsoft
     *         Replication to be enabled in your database, then you must choose this method.
     *         </p>
     *         <p>
     *         <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the changes
     *         and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method
     *         doesn't involve any transactional activities, it can only be used when Microsoft Replication isn't
     *         running. Also, when using this method, only one DMS task can access the database at any given time.
     *         Therefore, if you need to run parallel DMS tasks against the same database, use the default method.
     * @see SafeguardPolicy
     */
    public final String safeguardPolicyAsString() {
        return safeguardPolicy;
    }

    /**
     * <p>
     * Fully qualified domain name of the endpoint. For an Amazon RDS SQL Server instance, this is the output of <a
     * href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">DescribeDBInstances</a>,
     * in the
     * <code> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address</code>
     * field.
     * </p>
     * 
     * @return Fully qualified domain name of the endpoint. For an Amazon RDS SQL Server instance, this is the output of
     *         <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">
     *         DescribeDBInstances</a>, in the
     *         <code> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address</code>
     *         field.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * Endpoint connection user name.
     * </p>
     * 
     * @return Endpoint connection user name.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * Use this to attribute to transfer data for full-load operations using BCP. When the target table contains an
     * identity column that does not exist in the source table, you must disable the use BCP for loading table option.
     * </p>
     * 
     * @return Use this to attribute to transfer data for full-load operations using BCP. When the target table contains
     *         an identity column that does not exist in the source table, you must disable the use BCP for loading
     *         table option.
     */
    public final Boolean useBcpFullLoad() {
        return useBcpFullLoad;
    }

    /**
     * <p>
     * When this attribute is set to <code>Y</code>, DMS processes third-party transaction log backups if they are
     * created in native format.
     * </p>
     * 
     * @return When this attribute is set to <code>Y</code>, DMS processes third-party transaction log backups if they
     *         are created in native format.
     */
    public final Boolean useThirdPartyBackupDevice() {
        return useThirdPartyBackupDevice;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the
     * required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the
     * <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services
     * Secrets Manager secret that allows access to the SQL Server endpoint.
     * </p>
     * <note>
     * <p>
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and
     * <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
     * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
     * information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code>
     * and <code>SecretsManagerSecretId</code> required to access it, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using
     * secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants
     *         the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow
     *         the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web
     *         Services Secrets Manager secret that allows access to the SQL Server endpoint.</p> <note>
     *         <p>
     *         You can specify one of two sets of values for these permissions. You can specify the values for this
     *         setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
     *         <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't
     *         specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
     *         <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it,
     *         see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
     *         >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
     *         User Guide</i>.
     *         </p>
     */
    public final String secretsManagerAccessRoleArn() {
        return secretsManagerAccessRoleArn;
    }

    /**
     * <p>
     * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL Server
     * endpoint connection details.
     * </p>
     * 
     * @return The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
     *         SQL Server endpoint connection details.
     */
    public final String secretsManagerSecretId() {
        return secretsManagerSecretId;
    }

    /**
     * <p>
     * Use the <code>TrimSpaceInChar</code> source endpoint setting to right-trim data on CHAR and NCHAR data types
     * during migration. Setting <code>TrimSpaceInChar</code> does not left-trim data. The default value is
     * <code>true</code>.
     * </p>
     * 
     * @return Use the <code>TrimSpaceInChar</code> source endpoint setting to right-trim data on CHAR and NCHAR data
     *         types during migration. Setting <code>TrimSpaceInChar</code> does not left-trim data. The default value
     *         is <code>true</code>.
     */
    public final Boolean trimSpaceInChar() {
        return trimSpaceInChar;
    }

    /**
     * <p>
     * Indicates the mode used to fetch CDC data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlogAccessMode}
     * will return {@link TlogAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tlogAccessModeAsString}.
     * </p>
     * 
     * @return Indicates the mode used to fetch CDC data.
     * @see TlogAccessMode
     */
    public final TlogAccessMode tlogAccessMode() {
        return TlogAccessMode.fromValue(tlogAccessMode);
    }

    /**
     * <p>
     * Indicates the mode used to fetch CDC data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tlogAccessMode}
     * will return {@link TlogAccessMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tlogAccessModeAsString}.
     * </p>
     * 
     * @return Indicates the mode used to fetch CDC data.
     * @see TlogAccessMode
     */
    public final String tlogAccessModeAsString() {
        return tlogAccessMode;
    }

    /**
     * <p>
     * Forces LOB lookup on inline LOB.
     * </p>
     * 
     * @return Forces LOB lookup on inline LOB.
     */
    public final Boolean forceLobLookup() {
        return forceLobLookup;
    }

    /**
     * <p>
     * Specifies using Kerberos authentication with Microsoft SQL Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethod} will return {@link SqlServerAuthenticationMethod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodAsString}.
     * </p>
     * 
     * @return Specifies using Kerberos authentication with Microsoft SQL Server.
     * @see SqlServerAuthenticationMethod
     */
    public final SqlServerAuthenticationMethod authenticationMethod() {
        return SqlServerAuthenticationMethod.fromValue(authenticationMethod);
    }

    /**
     * <p>
     * Specifies using Kerberos authentication with Microsoft SQL Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethod} will return {@link SqlServerAuthenticationMethod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodAsString}.
     * </p>
     * 
     * @return Specifies using Kerberos authentication with Microsoft SQL Server.
     * @see SqlServerAuthenticationMethod
     */
    public final String authenticationMethodAsString() {
        return authenticationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(bcpPacketSize());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(controlTablesFileGroup());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(querySingleAlwaysOnNode());
        hashCode = 31 * hashCode + Objects.hashCode(readBackupOnly());
        hashCode = 31 * hashCode + Objects.hashCode(safeguardPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(useBcpFullLoad());
        hashCode = 31 * hashCode + Objects.hashCode(useThirdPartyBackupDevice());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(trimSpaceInChar());
        hashCode = 31 * hashCode + Objects.hashCode(tlogAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(forceLobLookup());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MicrosoftSQLServerSettings)) {
            return false;
        }
        MicrosoftSQLServerSettings other = (MicrosoftSQLServerSettings) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(bcpPacketSize(), other.bcpPacketSize())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(controlTablesFileGroup(), other.controlTablesFileGroup())
                && Objects.equals(password(), other.password())
                && Objects.equals(querySingleAlwaysOnNode(), other.querySingleAlwaysOnNode())
                && Objects.equals(readBackupOnly(), other.readBackupOnly())
                && Objects.equals(safeguardPolicyAsString(), other.safeguardPolicyAsString())
                && Objects.equals(serverName(), other.serverName()) && Objects.equals(username(), other.username())
                && Objects.equals(useBcpFullLoad(), other.useBcpFullLoad())
                && Objects.equals(useThirdPartyBackupDevice(), other.useThirdPartyBackupDevice())
                && Objects.equals(secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn())
                && Objects.equals(secretsManagerSecretId(), other.secretsManagerSecretId())
                && Objects.equals(trimSpaceInChar(), other.trimSpaceInChar())
                && Objects.equals(tlogAccessModeAsString(), other.tlogAccessModeAsString())
                && Objects.equals(forceLobLookup(), other.forceLobLookup())
                && Objects.equals(authenticationMethodAsString(), other.authenticationMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MicrosoftSQLServerSettings").add("Port", port()).add("BcpPacketSize", bcpPacketSize())
                .add("DatabaseName", databaseName()).add("ControlTablesFileGroup", controlTablesFileGroup())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QuerySingleAlwaysOnNode", querySingleAlwaysOnNode()).add("ReadBackupOnly", readBackupOnly())
                .add("SafeguardPolicy", safeguardPolicyAsString()).add("ServerName", serverName()).add("Username", username())
                .add("UseBcpFullLoad", useBcpFullLoad()).add("UseThirdPartyBackupDevice", useThirdPartyBackupDevice())
                .add("SecretsManagerAccessRoleArn", secretsManagerAccessRoleArn())
                .add("SecretsManagerSecretId", secretsManagerSecretId()).add("TrimSpaceInChar", trimSpaceInChar())
                .add("TlogAccessMode", tlogAccessModeAsString()).add("ForceLobLookup", forceLobLookup())
                .add("AuthenticationMethod", authenticationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "BcpPacketSize":
            return Optional.ofNullable(clazz.cast(bcpPacketSize()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "ControlTablesFileGroup":
            return Optional.ofNullable(clazz.cast(controlTablesFileGroup()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "QuerySingleAlwaysOnNode":
            return Optional.ofNullable(clazz.cast(querySingleAlwaysOnNode()));
        case "ReadBackupOnly":
            return Optional.ofNullable(clazz.cast(readBackupOnly()));
        case "SafeguardPolicy":
            return Optional.ofNullable(clazz.cast(safeguardPolicyAsString()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "UseBcpFullLoad":
            return Optional.ofNullable(clazz.cast(useBcpFullLoad()));
        case "UseThirdPartyBackupDevice":
            return Optional.ofNullable(clazz.cast(useThirdPartyBackupDevice()));
        case "SecretsManagerAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerAccessRoleArn()));
        case "SecretsManagerSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerSecretId()));
        case "TrimSpaceInChar":
            return Optional.ofNullable(clazz.cast(trimSpaceInChar()));
        case "TlogAccessMode":
            return Optional.ofNullable(clazz.cast(tlogAccessModeAsString()));
        case "ForceLobLookup":
            return Optional.ofNullable(clazz.cast(forceLobLookup()));
        case "AuthenticationMethod":
            return Optional.ofNullable(clazz.cast(authenticationMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Port", PORT_FIELD);
        map.put("BcpPacketSize", BCP_PACKET_SIZE_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("ControlTablesFileGroup", CONTROL_TABLES_FILE_GROUP_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("QuerySingleAlwaysOnNode", QUERY_SINGLE_ALWAYS_ON_NODE_FIELD);
        map.put("ReadBackupOnly", READ_BACKUP_ONLY_FIELD);
        map.put("SafeguardPolicy", SAFEGUARD_POLICY_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Username", USERNAME_FIELD);
        map.put("UseBcpFullLoad", USE_BCP_FULL_LOAD_FIELD);
        map.put("UseThirdPartyBackupDevice", USE_THIRD_PARTY_BACKUP_DEVICE_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("TrimSpaceInChar", TRIM_SPACE_IN_CHAR_FIELD);
        map.put("TlogAccessMode", TLOG_ACCESS_MODE_FIELD);
        map.put("ForceLobLookup", FORCE_LOB_LOOKUP_FIELD);
        map.put("AuthenticationMethod", AUTHENTICATION_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MicrosoftSQLServerSettings, T> g) {
        return obj -> g.apply((MicrosoftSQLServerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MicrosoftSQLServerSettings> {
        /**
         * <p>
         * Endpoint TCP port.
         * </p>
         * 
         * @param port
         *        Endpoint TCP port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The maximum size of the packets (in bytes) used to transfer data using BCP.
         * </p>
         * 
         * @param bcpPacketSize
         *        The maximum size of the packets (in bytes) used to transfer data using BCP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bcpPacketSize(Integer bcpPacketSize);

        /**
         * <p>
         * Database name for the endpoint.
         * </p>
         * 
         * @param databaseName
         *        Database name for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Specifies a file group for the DMS internal tables. When the replication task starts, all the internal DMS
         * control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the specified file
         * group.
         * </p>
         * 
         * @param controlTablesFileGroup
         *        Specifies a file group for the DMS internal tables. When the replication task starts, all the internal
         *        DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the
         *        specified file group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlTablesFileGroup(String controlTablesFileGroup);

        /**
         * <p>
         * Endpoint connection password.
         * </p>
         * 
         * @param password
         *        Endpoint connection password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * Cleans and recreates table metadata information on the replication instance when a mismatch occurs. An
         * example is a situation where running an alter DDL statement on a table might result in different information
         * about the table cached in the replication instance.
         * </p>
         * 
         * @param querySingleAlwaysOnNode
         *        Cleans and recreates table metadata information on the replication instance when a mismatch occurs. An
         *        example is a situation where running an alter DDL statement on a table might result in different
         *        information about the table cached in the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder querySingleAlwaysOnNode(Boolean querySingleAlwaysOnNode);

        /**
         * <p>
         * When this attribute is set to <code>Y</code>, DMS only reads changes from transaction log backups and doesn't
         * read from the active transaction log file during ongoing replication. Setting this parameter to
         * <code>Y</code> enables you to control active transaction log file growth during full load and ongoing
         * replication tasks. However, it can add some source latency to ongoing replication.
         * </p>
         * 
         * @param readBackupOnly
         *        When this attribute is set to <code>Y</code>, DMS only reads changes from transaction log backups and
         *        doesn't read from the active transaction log file during ongoing replication. Setting this parameter
         *        to <code>Y</code> enables you to control active transaction log file growth during full load and
         *        ongoing replication tasks. However, it can add some source latency to ongoing replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readBackupOnly(Boolean readBackupOnly);

        /**
         * <p>
         * Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation using
         * one of the following two methods.
         * </p>
         * <p>
         * <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS prevents
         * TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes
         * that appear after the transaction started aren't truncated. If you need Microsoft Replication to be enabled
         * in your database, then you must choose this method.
         * </p>
         * <p>
         * <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the changes and
         * then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't
         * involve any transactional activities, it can only be used when Microsoft Replication isn't running. Also,
         * when using this method, only one DMS task can access the database at any given time. Therefore, if you need
         * to run parallel DMS tasks against the same database, use the default method.
         * </p>
         * 
         * @param safeguardPolicy
         *        Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation
         *        using one of the following two methods.</p>
         *        <p>
         *        <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS
         *        prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is
         *        open, changes that appear after the transaction started aren't truncated. If you need Microsoft
         *        Replication to be enabled in your database, then you must choose this method.
         *        </p>
         *        <p>
         *        <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the
         *        changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this
         *        method doesn't involve any transactional activities, it can only be used when Microsoft Replication
         *        isn't running. Also, when using this method, only one DMS task can access the database at any given
         *        time. Therefore, if you need to run parallel DMS tasks against the same database, use the default
         *        method.
         * @see SafeguardPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SafeguardPolicy
         */
        Builder safeguardPolicy(String safeguardPolicy);

        /**
         * <p>
         * Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation using
         * one of the following two methods.
         * </p>
         * <p>
         * <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS prevents
         * TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes
         * that appear after the transaction started aren't truncated. If you need Microsoft Replication to be enabled
         * in your database, then you must choose this method.
         * </p>
         * <p>
         * <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the changes and
         * then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't
         * involve any transactional activities, it can only be used when Microsoft Replication isn't running. Also,
         * when using this method, only one DMS task can access the database at any given time. Therefore, if you need
         * to run parallel DMS tasks against the same database, use the default method.
         * </p>
         * 
         * @param safeguardPolicy
         *        Use this attribute to minimize the need to access the backup log and enable DMS to prevent truncation
         *        using one of the following two methods.</p>
         *        <p>
         *        <i>Start transactions in the database:</i> This is the default method. When this method is used, DMS
         *        prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is
         *        open, changes that appear after the transaction started aren't truncated. If you need Microsoft
         *        Replication to be enabled in your database, then you must choose this method.
         *        </p>
         *        <p>
         *        <i>Exclusively use sp_repldone within a single task</i>: When this method is used, DMS reads the
         *        changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this
         *        method doesn't involve any transactional activities, it can only be used when Microsoft Replication
         *        isn't running. Also, when using this method, only one DMS task can access the database at any given
         *        time. Therefore, if you need to run parallel DMS tasks against the same database, use the default
         *        method.
         * @see SafeguardPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SafeguardPolicy
         */
        Builder safeguardPolicy(SafeguardPolicy safeguardPolicy);

        /**
         * <p>
         * Fully qualified domain name of the endpoint. For an Amazon RDS SQL Server instance, this is the output of <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">
         * DescribeDBInstances</a>, in the
         * <code> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address</code>
         * field.
         * </p>
         * 
         * @param serverName
         *        Fully qualified domain name of the endpoint. For an Amazon RDS SQL Server instance, this is the output
         *        of <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html">
         *        DescribeDBInstances</a>, in the
         *        <code> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address</code>
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * Endpoint connection user name.
         * </p>
         * 
         * @param username
         *        Endpoint connection user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * Use this to attribute to transfer data for full-load operations using BCP. When the target table contains an
         * identity column that does not exist in the source table, you must disable the use BCP for loading table
         * option.
         * </p>
         * 
         * @param useBcpFullLoad
         *        Use this to attribute to transfer data for full-load operations using BCP. When the target table
         *        contains an identity column that does not exist in the source table, you must disable the use BCP for
         *        loading table option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBcpFullLoad(Boolean useBcpFullLoad);

        /**
         * <p>
         * When this attribute is set to <code>Y</code>, DMS processes third-party transaction log backups if they are
         * created in native format.
         * </p>
         * 
         * @param useThirdPartyBackupDevice
         *        When this attribute is set to <code>Y</code>, DMS processes third-party transaction log backups if
         *        they are created in native format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useThirdPartyBackupDevice(Boolean useThirdPartyBackupDevice);

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the
         * required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the
         * <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services
         * Secrets Manager secret that allows access to the SQL Server endpoint.
         * </p>
         * <note>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting
         * and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
         * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
         * information on creating this <code>SecretsManagerSecret</code> and the
         * <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see
         * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">
         * Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param secretsManagerAccessRoleArn
         *        The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and
         *        grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role
         *        must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of
         *        the Amazon Web Services Secrets Manager secret that allows access to the SQL Server endpoint.</p>
         *        <note>
         *        <p>
         *        You can specify one of two sets of values for these permissions. You can specify the values for this
         *        setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
         *        <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You
         *        can't specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
         *        <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access
         *        it, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
         *        >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
         *        User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn);

        /**
         * <p>
         * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL
         * Server endpoint connection details.
         * </p>
         * 
         * @param secretsManagerSecretId
         *        The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
         *        SQL Server endpoint connection details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecretId(String secretsManagerSecretId);

        /**
         * <p>
         * Use the <code>TrimSpaceInChar</code> source endpoint setting to right-trim data on CHAR and NCHAR data types
         * during migration. Setting <code>TrimSpaceInChar</code> does not left-trim data. The default value is
         * <code>true</code>.
         * </p>
         * 
         * @param trimSpaceInChar
         *        Use the <code>TrimSpaceInChar</code> source endpoint setting to right-trim data on CHAR and NCHAR data
         *        types during migration. Setting <code>TrimSpaceInChar</code> does not left-trim data. The default
         *        value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trimSpaceInChar(Boolean trimSpaceInChar);

        /**
         * <p>
         * Indicates the mode used to fetch CDC data.
         * </p>
         * 
         * @param tlogAccessMode
         *        Indicates the mode used to fetch CDC data.
         * @see TlogAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TlogAccessMode
         */
        Builder tlogAccessMode(String tlogAccessMode);

        /**
         * <p>
         * Indicates the mode used to fetch CDC data.
         * </p>
         * 
         * @param tlogAccessMode
         *        Indicates the mode used to fetch CDC data.
         * @see TlogAccessMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TlogAccessMode
         */
        Builder tlogAccessMode(TlogAccessMode tlogAccessMode);

        /**
         * <p>
         * Forces LOB lookup on inline LOB.
         * </p>
         * 
         * @param forceLobLookup
         *        Forces LOB lookup on inline LOB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceLobLookup(Boolean forceLobLookup);

        /**
         * <p>
         * Specifies using Kerberos authentication with Microsoft SQL Server.
         * </p>
         * 
         * @param authenticationMethod
         *        Specifies using Kerberos authentication with Microsoft SQL Server.
         * @see SqlServerAuthenticationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SqlServerAuthenticationMethod
         */
        Builder authenticationMethod(String authenticationMethod);

        /**
         * <p>
         * Specifies using Kerberos authentication with Microsoft SQL Server.
         * </p>
         * 
         * @param authenticationMethod
         *        Specifies using Kerberos authentication with Microsoft SQL Server.
         * @see SqlServerAuthenticationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SqlServerAuthenticationMethod
         */
        Builder authenticationMethod(SqlServerAuthenticationMethod authenticationMethod);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private Integer bcpPacketSize;

        private String databaseName;

        private String controlTablesFileGroup;

        private String password;

        private Boolean querySingleAlwaysOnNode;

        private Boolean readBackupOnly;

        private String safeguardPolicy;

        private String serverName;

        private String username;

        private Boolean useBcpFullLoad;

        private Boolean useThirdPartyBackupDevice;

        private String secretsManagerAccessRoleArn;

        private String secretsManagerSecretId;

        private Boolean trimSpaceInChar;

        private String tlogAccessMode;

        private Boolean forceLobLookup;

        private String authenticationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(MicrosoftSQLServerSettings model) {
            port(model.port);
            bcpPacketSize(model.bcpPacketSize);
            databaseName(model.databaseName);
            controlTablesFileGroup(model.controlTablesFileGroup);
            password(model.password);
            querySingleAlwaysOnNode(model.querySingleAlwaysOnNode);
            readBackupOnly(model.readBackupOnly);
            safeguardPolicy(model.safeguardPolicy);
            serverName(model.serverName);
            username(model.username);
            useBcpFullLoad(model.useBcpFullLoad);
            useThirdPartyBackupDevice(model.useThirdPartyBackupDevice);
            secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            secretsManagerSecretId(model.secretsManagerSecretId);
            trimSpaceInChar(model.trimSpaceInChar);
            tlogAccessMode(model.tlogAccessMode);
            forceLobLookup(model.forceLobLookup);
            authenticationMethod(model.authenticationMethod);
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Integer getBcpPacketSize() {
            return bcpPacketSize;
        }

        public final void setBcpPacketSize(Integer bcpPacketSize) {
            this.bcpPacketSize = bcpPacketSize;
        }

        @Override
        public final Builder bcpPacketSize(Integer bcpPacketSize) {
            this.bcpPacketSize = bcpPacketSize;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getControlTablesFileGroup() {
            return controlTablesFileGroup;
        }

        public final void setControlTablesFileGroup(String controlTablesFileGroup) {
            this.controlTablesFileGroup = controlTablesFileGroup;
        }

        @Override
        public final Builder controlTablesFileGroup(String controlTablesFileGroup) {
            this.controlTablesFileGroup = controlTablesFileGroup;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Boolean getQuerySingleAlwaysOnNode() {
            return querySingleAlwaysOnNode;
        }

        public final void setQuerySingleAlwaysOnNode(Boolean querySingleAlwaysOnNode) {
            this.querySingleAlwaysOnNode = querySingleAlwaysOnNode;
        }

        @Override
        public final Builder querySingleAlwaysOnNode(Boolean querySingleAlwaysOnNode) {
            this.querySingleAlwaysOnNode = querySingleAlwaysOnNode;
            return this;
        }

        public final Boolean getReadBackupOnly() {
            return readBackupOnly;
        }

        public final void setReadBackupOnly(Boolean readBackupOnly) {
            this.readBackupOnly = readBackupOnly;
        }

        @Override
        public final Builder readBackupOnly(Boolean readBackupOnly) {
            this.readBackupOnly = readBackupOnly;
            return this;
        }

        public final String getSafeguardPolicy() {
            return safeguardPolicy;
        }

        public final void setSafeguardPolicy(String safeguardPolicy) {
            this.safeguardPolicy = safeguardPolicy;
        }

        @Override
        public final Builder safeguardPolicy(String safeguardPolicy) {
            this.safeguardPolicy = safeguardPolicy;
            return this;
        }

        @Override
        public final Builder safeguardPolicy(SafeguardPolicy safeguardPolicy) {
            this.safeguardPolicy(safeguardPolicy == null ? null : safeguardPolicy.toString());
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Boolean getUseBcpFullLoad() {
            return useBcpFullLoad;
        }

        public final void setUseBcpFullLoad(Boolean useBcpFullLoad) {
            this.useBcpFullLoad = useBcpFullLoad;
        }

        @Override
        public final Builder useBcpFullLoad(Boolean useBcpFullLoad) {
            this.useBcpFullLoad = useBcpFullLoad;
            return this;
        }

        public final Boolean getUseThirdPartyBackupDevice() {
            return useThirdPartyBackupDevice;
        }

        public final void setUseThirdPartyBackupDevice(Boolean useThirdPartyBackupDevice) {
            this.useThirdPartyBackupDevice = useThirdPartyBackupDevice;
        }

        @Override
        public final Builder useThirdPartyBackupDevice(Boolean useThirdPartyBackupDevice) {
            this.useThirdPartyBackupDevice = useThirdPartyBackupDevice;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final Boolean getTrimSpaceInChar() {
            return trimSpaceInChar;
        }

        public final void setTrimSpaceInChar(Boolean trimSpaceInChar) {
            this.trimSpaceInChar = trimSpaceInChar;
        }

        @Override
        public final Builder trimSpaceInChar(Boolean trimSpaceInChar) {
            this.trimSpaceInChar = trimSpaceInChar;
            return this;
        }

        public final String getTlogAccessMode() {
            return tlogAccessMode;
        }

        public final void setTlogAccessMode(String tlogAccessMode) {
            this.tlogAccessMode = tlogAccessMode;
        }

        @Override
        public final Builder tlogAccessMode(String tlogAccessMode) {
            this.tlogAccessMode = tlogAccessMode;
            return this;
        }

        @Override
        public final Builder tlogAccessMode(TlogAccessMode tlogAccessMode) {
            this.tlogAccessMode(tlogAccessMode == null ? null : tlogAccessMode.toString());
            return this;
        }

        public final Boolean getForceLobLookup() {
            return forceLobLookup;
        }

        public final void setForceLobLookup(Boolean forceLobLookup) {
            this.forceLobLookup = forceLobLookup;
        }

        @Override
        public final Builder forceLobLookup(Boolean forceLobLookup) {
            this.forceLobLookup = forceLobLookup;
            return this;
        }

        public final String getAuthenticationMethod() {
            return authenticationMethod;
        }

        public final void setAuthenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
        }

        @Override
        public final Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Override
        public final Builder authenticationMethod(SqlServerAuthenticationMethod authenticationMethod) {
            this.authenticationMethod(authenticationMethod == null ? null : authenticationMethod.toString());
            return this;
        }

        @Override
        public MicrosoftSQLServerSettings build() {
            return new MicrosoftSQLServerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
