/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a MongoDB data provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MongoDbDataProviderSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MongoDbDataProviderSettings.Builder, MongoDbDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(MongoDbDataProviderSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(MongoDbDataProviderSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(MongoDbDataProviderSettings::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> SSL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslMode").getter(getter(MongoDbDataProviderSettings::sslModeAsString)).setter(setter(Builder::sslMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(MongoDbDataProviderSettings::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthType").getter(getter(MongoDbDataProviderSettings::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()).build();

    private static final SdkField<String> AUTH_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthSource").getter(getter(MongoDbDataProviderSettings::authSource)).setter(setter(Builder::authSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthSource").build()).build();

    private static final SdkField<String> AUTH_MECHANISM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthMechanism").getter(getter(MongoDbDataProviderSettings::authMechanismAsString))
            .setter(setter(Builder::authMechanism))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMechanism").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, SSL_MODE_FIELD,
                    CERTIFICATE_ARN_FIELD, AUTH_TYPE_FIELD, AUTH_SOURCE_FIELD, AUTH_MECHANISM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serverName;

    private final Integer port;

    private final String databaseName;

    private final String sslMode;

    private final String certificateArn;

    private final String authType;

    private final String authSource;

    private final String authMechanism;

    private MongoDbDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.sslMode = builder.sslMode;
        this.certificateArn = builder.certificateArn;
        this.authType = builder.authType;
        this.authSource = builder.authSource;
        this.authMechanism = builder.authMechanism;
    }

    /**
     * <p>
     * The name of the MongoDB server.
     * </p>
     * 
     * @return The name of the MongoDB server.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The port value for the MongoDB data provider.
     * </p>
     * 
     * @return The port value for the MongoDB data provider.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The database name on the MongoDB data provider.
     * </p>
     * 
     * @return The database name on the MongoDB data provider.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The SSL mode used to connect to the MongoDB data provider. The default value is <code>none</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the MongoDB data provider. The default value is <code>none</code>.
     * @see DmsSslModeValue
     */
    public final DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(sslMode);
    }

    /**
     * <p>
     * The SSL mode used to connect to the MongoDB data provider. The default value is <code>none</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the MongoDB data provider. The default value is <code>none</code>.
     * @see DmsSslModeValue
     */
    public final String sslModeAsString() {
        return sslMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The authentication type for the database connection. Valid values are PASSWORD or NO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the database connection. Valid values are PASSWORD or NO.
     * @see AuthTypeValue
     */
    public final AuthTypeValue authType() {
        return AuthTypeValue.fromValue(authType);
    }

    /**
     * <p>
     * The authentication type for the database connection. Valid values are PASSWORD or NO.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The authentication type for the database connection. Valid values are PASSWORD or NO.
     * @see AuthTypeValue
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The MongoDB database name. This setting isn't used when <code>AuthType</code> is set to <code>"no"</code>.
     * </p>
     * <p>
     * The default is <code>"admin"</code>.
     * </p>
     * 
     * @return The MongoDB database name. This setting isn't used when <code>AuthType</code> is set to <code>"no"</code>
     *         . </p>
     *         <p>
     *         The default is <code>"admin"</code>.
     */
    public final String authSource() {
        return authSource;
    }

    /**
     * <p>
     * The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR, or
     * SCRAM_SHA_1.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMechanism}
     * will return {@link AuthMechanismValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authMechanismAsString}.
     * </p>
     * 
     * @return The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR, or
     *         SCRAM_SHA_1.
     * @see AuthMechanismValue
     */
    public final AuthMechanismValue authMechanism() {
        return AuthMechanismValue.fromValue(authMechanism);
    }

    /**
     * <p>
     * The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR, or
     * SCRAM_SHA_1.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMechanism}
     * will return {@link AuthMechanismValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authMechanismAsString}.
     * </p>
     * 
     * @return The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR, or
     *         SCRAM_SHA_1.
     * @see AuthMechanismValue
     */
    public final String authMechanismAsString() {
        return authMechanism;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authSource());
        hashCode = 31 * hashCode + Objects.hashCode(authMechanismAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoDbDataProviderSettings)) {
            return false;
        }
        MongoDbDataProviderSettings other = (MongoDbDataProviderSettings) obj;
        return Objects.equals(serverName(), other.serverName()) && Objects.equals(port(), other.port())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(sslModeAsString(), other.sslModeAsString())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(authSource(), other.authSource())
                && Objects.equals(authMechanismAsString(), other.authMechanismAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MongoDbDataProviderSettings").add("ServerName", serverName()).add("Port", port())
                .add("DatabaseName", databaseName()).add("SslMode", sslModeAsString()).add("CertificateArn", certificateArn())
                .add("AuthType", authTypeAsString()).add("AuthSource", authSource())
                .add("AuthMechanism", authMechanismAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "SslMode":
            return Optional.ofNullable(clazz.cast(sslModeAsString()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "AuthType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "AuthSource":
            return Optional.ofNullable(clazz.cast(authSource()));
        case "AuthMechanism":
            return Optional.ofNullable(clazz.cast(authMechanismAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("SslMode", SSL_MODE_FIELD);
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("AuthSource", AUTH_SOURCE_FIELD);
        map.put("AuthMechanism", AUTH_MECHANISM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MongoDbDataProviderSettings, T> g) {
        return obj -> g.apply((MongoDbDataProviderSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MongoDbDataProviderSettings> {
        /**
         * <p>
         * The name of the MongoDB server.
         * </p>
         * 
         * @param serverName
         *        The name of the MongoDB server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The port value for the MongoDB data provider.
         * </p>
         * 
         * @param port
         *        The port value for the MongoDB data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The database name on the MongoDB data provider.
         * </p>
         * 
         * @param databaseName
         *        The database name on the MongoDB data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The SSL mode used to connect to the MongoDB data provider. The default value is <code>none</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the MongoDB data provider. The default value is <code>none</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(String sslMode);

        /**
         * <p>
         * The SSL mode used to connect to the MongoDB data provider. The default value is <code>none</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the MongoDB data provider. The default value is <code>none</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(DmsSslModeValue sslMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The authentication type for the database connection. Valid values are PASSWORD or NO.
         * </p>
         * 
         * @param authType
         *        The authentication type for the database connection. Valid values are PASSWORD or NO.
         * @see AuthTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTypeValue
         */
        Builder authType(String authType);

        /**
         * <p>
         * The authentication type for the database connection. Valid values are PASSWORD or NO.
         * </p>
         * 
         * @param authType
         *        The authentication type for the database connection. Valid values are PASSWORD or NO.
         * @see AuthTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthTypeValue
         */
        Builder authType(AuthTypeValue authType);

        /**
         * <p>
         * The MongoDB database name. This setting isn't used when <code>AuthType</code> is set to <code>"no"</code>.
         * </p>
         * <p>
         * The default is <code>"admin"</code>.
         * </p>
         * 
         * @param authSource
         *        The MongoDB database name. This setting isn't used when <code>AuthType</code> is set to
         *        <code>"no"</code>. </p>
         *        <p>
         *        The default is <code>"admin"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authSource(String authSource);

        /**
         * <p>
         * The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR, or
         * SCRAM_SHA_1.
         * </p>
         * 
         * @param authMechanism
         *        The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR,
         *        or SCRAM_SHA_1.
         * @see AuthMechanismValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMechanismValue
         */
        Builder authMechanism(String authMechanism);

        /**
         * <p>
         * The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR, or
         * SCRAM_SHA_1.
         * </p>
         * 
         * @param authMechanism
         *        The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR,
         *        or SCRAM_SHA_1.
         * @see AuthMechanismValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMechanismValue
         */
        Builder authMechanism(AuthMechanismValue authMechanism);
    }

    static final class BuilderImpl implements Builder {
        private String serverName;

        private Integer port;

        private String databaseName;

        private String sslMode;

        private String certificateArn;

        private String authType;

        private String authSource;

        private String authMechanism;

        private BuilderImpl() {
        }

        private BuilderImpl(MongoDbDataProviderSettings model) {
            serverName(model.serverName);
            port(model.port);
            databaseName(model.databaseName);
            sslMode(model.sslMode);
            certificateArn(model.certificateArn);
            authType(model.authType);
            authSource(model.authSource);
            authMechanism(model.authMechanism);
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getSslMode() {
            return sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthTypeValue authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getAuthSource() {
            return authSource;
        }

        public final void setAuthSource(String authSource) {
            this.authSource = authSource;
        }

        @Override
        public final Builder authSource(String authSource) {
            this.authSource = authSource;
            return this;
        }

        public final String getAuthMechanism() {
            return authMechanism;
        }

        public final void setAuthMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
        }

        @Override
        public final Builder authMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
            return this;
        }

        @Override
        public final Builder authMechanism(AuthMechanismValue authMechanism) {
            this.authMechanism(authMechanism == null ? null : authMechanism.toString());
            return this;
        }

        @Override
        public MongoDbDataProviderSettings build() {
            return new MongoDbDataProviderSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
