/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the last Fleet Advisor collector health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollectorHealthCheck implements SdkPojo, Serializable,
        ToCopyableBuilder<CollectorHealthCheck.Builder, CollectorHealthCheck> {
    private static final SdkField<String> COLLECTOR_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectorStatus").getter(getter(CollectorHealthCheck::collectorStatusAsString))
            .setter(setter(Builder::collectorStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorStatus").build()).build();

    private static final SdkField<Boolean> LOCAL_COLLECTOR_S3_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LocalCollectorS3Access").getter(getter(CollectorHealthCheck::localCollectorS3Access))
            .setter(setter(Builder::localCollectorS3Access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalCollectorS3Access").build())
            .build();

    private static final SdkField<Boolean> WEB_COLLECTOR_S3_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WebCollectorS3Access").getter(getter(CollectorHealthCheck::webCollectorS3Access))
            .setter(setter(Builder::webCollectorS3Access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCollectorS3Access").build())
            .build();

    private static final SdkField<Boolean> WEB_COLLECTOR_GRANTED_ROLE_BASED_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WebCollectorGrantedRoleBasedAccess")
            .getter(getter(CollectorHealthCheck::webCollectorGrantedRoleBasedAccess))
            .setter(setter(Builder::webCollectorGrantedRoleBasedAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCollectorGrantedRoleBasedAccess")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTOR_STATUS_FIELD,
            LOCAL_COLLECTOR_S3_ACCESS_FIELD, WEB_COLLECTOR_S3_ACCESS_FIELD, WEB_COLLECTOR_GRANTED_ROLE_BASED_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String collectorStatus;

    private final Boolean localCollectorS3Access;

    private final Boolean webCollectorS3Access;

    private final Boolean webCollectorGrantedRoleBasedAccess;

    private CollectorHealthCheck(BuilderImpl builder) {
        this.collectorStatus = builder.collectorStatus;
        this.localCollectorS3Access = builder.localCollectorS3Access;
        this.webCollectorS3Access = builder.webCollectorS3Access;
        this.webCollectorGrantedRoleBasedAccess = builder.webCollectorGrantedRoleBasedAccess;
    }

    /**
     * <p>
     * The status of the Fleet Advisor collector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #collectorStatus}
     * will return {@link CollectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #collectorStatusAsString}.
     * </p>
     * 
     * @return The status of the Fleet Advisor collector.
     * @see CollectorStatus
     */
    public final CollectorStatus collectorStatus() {
        return CollectorStatus.fromValue(collectorStatus);
    }

    /**
     * <p>
     * The status of the Fleet Advisor collector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #collectorStatus}
     * will return {@link CollectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #collectorStatusAsString}.
     * </p>
     * 
     * @return The status of the Fleet Advisor collector.
     * @see CollectorStatus
     */
    public final String collectorStatusAsString() {
        return collectorStatus;
    }

    /**
     * <p>
     * Whether the local collector can access its Amazon S3 bucket.
     * </p>
     * 
     * @return Whether the local collector can access its Amazon S3 bucket.
     */
    public final Boolean localCollectorS3Access() {
        return localCollectorS3Access;
    }

    /**
     * <p>
     * Whether the web collector can access its Amazon S3 bucket.
     * </p>
     * 
     * @return Whether the web collector can access its Amazon S3 bucket.
     */
    public final Boolean webCollectorS3Access() {
        return webCollectorS3Access;
    }

    /**
     * <p>
     * Whether the role that you provided when creating the Fleet Advisor collector has sufficient permissions to access
     * the Fleet Advisor web collector.
     * </p>
     * 
     * @return Whether the role that you provided when creating the Fleet Advisor collector has sufficient permissions
     *         to access the Fleet Advisor web collector.
     */
    public final Boolean webCollectorGrantedRoleBasedAccess() {
        return webCollectorGrantedRoleBasedAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectorStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(localCollectorS3Access());
        hashCode = 31 * hashCode + Objects.hashCode(webCollectorS3Access());
        hashCode = 31 * hashCode + Objects.hashCode(webCollectorGrantedRoleBasedAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectorHealthCheck)) {
            return false;
        }
        CollectorHealthCheck other = (CollectorHealthCheck) obj;
        return Objects.equals(collectorStatusAsString(), other.collectorStatusAsString())
                && Objects.equals(localCollectorS3Access(), other.localCollectorS3Access())
                && Objects.equals(webCollectorS3Access(), other.webCollectorS3Access())
                && Objects.equals(webCollectorGrantedRoleBasedAccess(), other.webCollectorGrantedRoleBasedAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollectorHealthCheck").add("CollectorStatus", collectorStatusAsString())
                .add("LocalCollectorS3Access", localCollectorS3Access()).add("WebCollectorS3Access", webCollectorS3Access())
                .add("WebCollectorGrantedRoleBasedAccess", webCollectorGrantedRoleBasedAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectorStatus":
            return Optional.ofNullable(clazz.cast(collectorStatusAsString()));
        case "LocalCollectorS3Access":
            return Optional.ofNullable(clazz.cast(localCollectorS3Access()));
        case "WebCollectorS3Access":
            return Optional.ofNullable(clazz.cast(webCollectorS3Access()));
        case "WebCollectorGrantedRoleBasedAccess":
            return Optional.ofNullable(clazz.cast(webCollectorGrantedRoleBasedAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CollectorStatus", COLLECTOR_STATUS_FIELD);
        map.put("LocalCollectorS3Access", LOCAL_COLLECTOR_S3_ACCESS_FIELD);
        map.put("WebCollectorS3Access", WEB_COLLECTOR_S3_ACCESS_FIELD);
        map.put("WebCollectorGrantedRoleBasedAccess", WEB_COLLECTOR_GRANTED_ROLE_BASED_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectorHealthCheck, T> g) {
        return obj -> g.apply((CollectorHealthCheck) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollectorHealthCheck> {
        /**
         * <p>
         * The status of the Fleet Advisor collector.
         * </p>
         * 
         * @param collectorStatus
         *        The status of the Fleet Advisor collector.
         * @see CollectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectorStatus
         */
        Builder collectorStatus(String collectorStatus);

        /**
         * <p>
         * The status of the Fleet Advisor collector.
         * </p>
         * 
         * @param collectorStatus
         *        The status of the Fleet Advisor collector.
         * @see CollectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectorStatus
         */
        Builder collectorStatus(CollectorStatus collectorStatus);

        /**
         * <p>
         * Whether the local collector can access its Amazon S3 bucket.
         * </p>
         * 
         * @param localCollectorS3Access
         *        Whether the local collector can access its Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localCollectorS3Access(Boolean localCollectorS3Access);

        /**
         * <p>
         * Whether the web collector can access its Amazon S3 bucket.
         * </p>
         * 
         * @param webCollectorS3Access
         *        Whether the web collector can access its Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webCollectorS3Access(Boolean webCollectorS3Access);

        /**
         * <p>
         * Whether the role that you provided when creating the Fleet Advisor collector has sufficient permissions to
         * access the Fleet Advisor web collector.
         * </p>
         * 
         * @param webCollectorGrantedRoleBasedAccess
         *        Whether the role that you provided when creating the Fleet Advisor collector has sufficient
         *        permissions to access the Fleet Advisor web collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webCollectorGrantedRoleBasedAccess(Boolean webCollectorGrantedRoleBasedAccess);
    }

    static final class BuilderImpl implements Builder {
        private String collectorStatus;

        private Boolean localCollectorS3Access;

        private Boolean webCollectorS3Access;

        private Boolean webCollectorGrantedRoleBasedAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(CollectorHealthCheck model) {
            collectorStatus(model.collectorStatus);
            localCollectorS3Access(model.localCollectorS3Access);
            webCollectorS3Access(model.webCollectorS3Access);
            webCollectorGrantedRoleBasedAccess(model.webCollectorGrantedRoleBasedAccess);
        }

        public final String getCollectorStatus() {
            return collectorStatus;
        }

        public final void setCollectorStatus(String collectorStatus) {
            this.collectorStatus = collectorStatus;
        }

        @Override
        public final Builder collectorStatus(String collectorStatus) {
            this.collectorStatus = collectorStatus;
            return this;
        }

        @Override
        public final Builder collectorStatus(CollectorStatus collectorStatus) {
            this.collectorStatus(collectorStatus == null ? null : collectorStatus.toString());
            return this;
        }

        public final Boolean getLocalCollectorS3Access() {
            return localCollectorS3Access;
        }

        public final void setLocalCollectorS3Access(Boolean localCollectorS3Access) {
            this.localCollectorS3Access = localCollectorS3Access;
        }

        @Override
        public final Builder localCollectorS3Access(Boolean localCollectorS3Access) {
            this.localCollectorS3Access = localCollectorS3Access;
            return this;
        }

        public final Boolean getWebCollectorS3Access() {
            return webCollectorS3Access;
        }

        public final void setWebCollectorS3Access(Boolean webCollectorS3Access) {
            this.webCollectorS3Access = webCollectorS3Access;
        }

        @Override
        public final Builder webCollectorS3Access(Boolean webCollectorS3Access) {
            this.webCollectorS3Access = webCollectorS3Access;
            return this;
        }

        public final Boolean getWebCollectorGrantedRoleBasedAccess() {
            return webCollectorGrantedRoleBasedAccess;
        }

        public final void setWebCollectorGrantedRoleBasedAccess(Boolean webCollectorGrantedRoleBasedAccess) {
            this.webCollectorGrantedRoleBasedAccess = webCollectorGrantedRoleBasedAccess;
        }

        @Override
        public final Builder webCollectorGrantedRoleBasedAccess(Boolean webCollectorGrantedRoleBasedAccess) {
            this.webCollectorGrantedRoleBasedAccess = webCollectorGrantedRoleBasedAccess;
            return this;
        }

        @Override
        public CollectorHealthCheck build() {
            return new CollectorHealthCheck(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
