/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataProviderResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<CreateDataProviderResponse.Builder, CreateDataProviderResponse> {
    private static final SdkField<DataProvider> DATA_PROVIDER_FIELD = SdkField.<DataProvider> builder(MarshallingType.SDK_POJO)
            .memberName("DataProvider").getter(getter(CreateDataProviderResponse::dataProvider))
            .setter(setter(Builder::dataProvider)).constructor(DataProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataProvider dataProvider;

    private CreateDataProviderResponse(BuilderImpl builder) {
        super(builder);
        this.dataProvider = builder.dataProvider;
    }

    /**
     * <p>
     * The data provider that was created.
     * </p>
     * 
     * @return The data provider that was created.
     */
    public final DataProvider dataProvider() {
        return dataProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataProviderResponse)) {
            return false;
        }
        CreateDataProviderResponse other = (CreateDataProviderResponse) obj;
        return Objects.equals(dataProvider(), other.dataProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataProviderResponse").add("DataProvider", dataProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProvider":
            return Optional.ofNullable(clazz.cast(dataProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataProvider", DATA_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataProviderResponse, T> g) {
        return obj -> g.apply((CreateDataProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataProviderResponse> {
        /**
         * <p>
         * The data provider that was created.
         * </p>
         * 
         * @param dataProvider
         *        The data provider that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProvider(DataProvider dataProvider);

        /**
         * <p>
         * The data provider that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProvider.Builder} avoiding the need
         * to create one manually via {@link DataProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #dataProvider(DataProvider)}.
         * 
         * @param dataProvider
         *        a consumer that will call methods on {@link DataProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProvider(DataProvider)
         */
        default Builder dataProvider(Consumer<DataProvider.Builder> dataProvider) {
            return dataProvider(DataProvider.builder().applyMutation(dataProvider).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private DataProvider dataProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataProviderResponse model) {
            super(model);
            dataProvider(model.dataProvider);
        }

        public final DataProvider.Builder getDataProvider() {
            return dataProvider != null ? dataProvider.toBuilder() : null;
        }

        public final void setDataProvider(DataProvider.BuilderImpl dataProvider) {
            this.dataProvider = dataProvider != null ? dataProvider.build() : null;
        }

        @Override
        public final Builder dataProvider(DataProvider dataProvider) {
            this.dataProvider = dataProvider;
            return this;
        }

        @Override
        public CreateDataProviderResponse build() {
            return new CreateDataProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
