/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a data provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProviderDescriptorDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProviderDescriptorDefinition.Builder, DataProviderDescriptorDefinition> {
    private static final SdkField<String> DATA_PROVIDER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataProviderIdentifier").getter(getter(DataProviderDescriptorDefinition::dataProviderIdentifier))
            .setter(setter(Builder::dataProviderIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderIdentifier").build())
            .build();

    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerSecretId").getter(getter(DataProviderDescriptorDefinition::secretsManagerSecretId))
            .setter(setter(Builder::secretsManagerSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build())
            .build();

    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerAccessRoleArn")
            .getter(getter(DataProviderDescriptorDefinition::secretsManagerAccessRoleArn))
            .setter(setter(Builder::secretsManagerAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_PROVIDER_IDENTIFIER_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataProviderIdentifier;

    private final String secretsManagerSecretId;

    private final String secretsManagerAccessRoleArn;

    private DataProviderDescriptorDefinition(BuilderImpl builder) {
        this.dataProviderIdentifier = builder.dataProviderIdentifier;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the data provider.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the data provider.
     */
    public final String dataProviderIdentifier() {
        return dataProviderIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services Secrets Manager Secret used to store access credentials for the data
     * provider.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services Secrets Manager Secret used to store access credentials for the
     *         data provider.
     */
    public final String secretsManagerSecretId() {
        return secretsManagerSecretId;
    }

    /**
     * <p>
     * The ARN of the role used to access Amazon Web Services Secrets Manager.
     * </p>
     * 
     * @return The ARN of the role used to access Amazon Web Services Secrets Manager.
     */
    public final String secretsManagerAccessRoleArn() {
        return secretsManagerAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataProviderIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProviderDescriptorDefinition)) {
            return false;
        }
        DataProviderDescriptorDefinition other = (DataProviderDescriptorDefinition) obj;
        return Objects.equals(dataProviderIdentifier(), other.dataProviderIdentifier())
                && Objects.equals(secretsManagerSecretId(), other.secretsManagerSecretId())
                && Objects.equals(secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProviderDescriptorDefinition").add("DataProviderIdentifier", dataProviderIdentifier())
                .add("SecretsManagerSecretId", secretsManagerSecretId())
                .add("SecretsManagerAccessRoleArn", secretsManagerAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProviderIdentifier":
            return Optional.ofNullable(clazz.cast(dataProviderIdentifier()));
        case "SecretsManagerSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerSecretId()));
        case "SecretsManagerAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataProviderIdentifier", DATA_PROVIDER_IDENTIFIER_FIELD);
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProviderDescriptorDefinition, T> g) {
        return obj -> g.apply((DataProviderDescriptorDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProviderDescriptorDefinition> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the data provider.
         * </p>
         * 
         * @param dataProviderIdentifier
         *        The name or Amazon Resource Name (ARN) of the data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProviderIdentifier(String dataProviderIdentifier);

        /**
         * <p>
         * The identifier of the Amazon Web Services Secrets Manager Secret used to store access credentials for the
         * data provider.
         * </p>
         * 
         * @param secretsManagerSecretId
         *        The identifier of the Amazon Web Services Secrets Manager Secret used to store access credentials for
         *        the data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecretId(String secretsManagerSecretId);

        /**
         * <p>
         * The ARN of the role used to access Amazon Web Services Secrets Manager.
         * </p>
         * 
         * @param secretsManagerAccessRoleArn
         *        The ARN of the role used to access Amazon Web Services Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataProviderIdentifier;

        private String secretsManagerSecretId;

        private String secretsManagerAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProviderDescriptorDefinition model) {
            dataProviderIdentifier(model.dataProviderIdentifier);
            secretsManagerSecretId(model.secretsManagerSecretId);
            secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
        }

        public final String getDataProviderIdentifier() {
            return dataProviderIdentifier;
        }

        public final void setDataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
        }

        @Override
        public final Builder dataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        @Override
        public DataProviderDescriptorDefinition build() {
            return new DataProviderDescriptorDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
