/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointTypesResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeEndpointTypesResponse.Builder, DescribeEndpointTypesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeEndpointTypesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<SupportedEndpointType>> SUPPORTED_ENDPOINT_TYPES_FIELD = SdkField
            .<List<SupportedEndpointType>> builder(MarshallingType.LIST)
            .memberName("SupportedEndpointTypes")
            .getter(getter(DescribeEndpointTypesResponse::supportedEndpointTypes))
            .setter(setter(Builder::supportedEndpointTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEndpointTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupportedEndpointType> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedEndpointType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            SUPPORTED_ENDPOINT_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<SupportedEndpointType> supportedEndpointTypes;

    private DescribeEndpointTypesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.supportedEndpointTypes = builder.supportedEndpointTypes;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedEndpointTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedEndpointTypes() {
        return supportedEndpointTypes != null && !(supportedEndpointTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of endpoints that are supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedEndpointTypes} method.
     * </p>
     * 
     * @return The types of endpoints that are supported.
     */
    public final List<SupportedEndpointType> supportedEndpointTypes() {
        return supportedEndpointTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedEndpointTypes() ? supportedEndpointTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointTypesResponse)) {
            return false;
        }
        DescribeEndpointTypesResponse other = (DescribeEndpointTypesResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasSupportedEndpointTypes() == other.hasSupportedEndpointTypes()
                && Objects.equals(supportedEndpointTypes(), other.supportedEndpointTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointTypesResponse").add("Marker", marker())
                .add("SupportedEndpointTypes", hasSupportedEndpointTypes() ? supportedEndpointTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "SupportedEndpointTypes":
            return Optional.ofNullable(clazz.cast(supportedEndpointTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("SupportedEndpointTypes", SUPPORTED_ENDPOINT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointTypesResponse, T> g) {
        return obj -> g.apply((DescribeEndpointTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEndpointTypesResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The types of endpoints that are supported.
         * </p>
         * 
         * @param supportedEndpointTypes
         *        The types of endpoints that are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEndpointTypes(Collection<SupportedEndpointType> supportedEndpointTypes);

        /**
         * <p>
         * The types of endpoints that are supported.
         * </p>
         * 
         * @param supportedEndpointTypes
         *        The types of endpoints that are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedEndpointTypes(SupportedEndpointType... supportedEndpointTypes);

        /**
         * <p>
         * The types of endpoints that are supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType.Builder#build()} is
         * called immediately and its result is passed to {@link #supportedEndpointTypes(List<SupportedEndpointType>)}.
         * 
         * @param supportedEndpointTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.SupportedEndpointType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedEndpointTypes(java.util.Collection<SupportedEndpointType>)
         */
        Builder supportedEndpointTypes(Consumer<SupportedEndpointType.Builder>... supportedEndpointTypes);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<SupportedEndpointType> supportedEndpointTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointTypesResponse model) {
            super(model);
            marker(model.marker);
            supportedEndpointTypes(model.supportedEndpointTypes);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<SupportedEndpointType.Builder> getSupportedEndpointTypes() {
            List<SupportedEndpointType.Builder> result = SupportedEndpointTypeListCopier
                    .copyToBuilder(this.supportedEndpointTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedEndpointTypes(Collection<SupportedEndpointType.BuilderImpl> supportedEndpointTypes) {
            this.supportedEndpointTypes = SupportedEndpointTypeListCopier.copyFromBuilder(supportedEndpointTypes);
        }

        @Override
        public final Builder supportedEndpointTypes(Collection<SupportedEndpointType> supportedEndpointTypes) {
            this.supportedEndpointTypes = SupportedEndpointTypeListCopier.copy(supportedEndpointTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEndpointTypes(SupportedEndpointType... supportedEndpointTypes) {
            supportedEndpointTypes(Arrays.asList(supportedEndpointTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEndpointTypes(Consumer<SupportedEndpointType.Builder>... supportedEndpointTypes) {
            supportedEndpointTypes(Stream.of(supportedEndpointTypes)
                    .map(c -> SupportedEndpointType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEndpointTypesResponse build() {
            return new DescribeEndpointTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
