/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceProfilesResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeInstanceProfilesResponse.Builder, DescribeInstanceProfilesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeInstanceProfilesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<InstanceProfile>> INSTANCE_PROFILES_FIELD = SdkField
            .<List<InstanceProfile>> builder(MarshallingType.LIST)
            .memberName("InstanceProfiles")
            .getter(getter(DescribeInstanceProfilesResponse::instanceProfiles))
            .setter(setter(Builder::instanceProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            INSTANCE_PROFILES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<InstanceProfile> instanceProfiles;

    private DescribeInstanceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.instanceProfiles = builder.instanceProfiles;
    }

    /**
     * <p>
     * Specifies the unique pagination token that makes it possible to display the next page of results. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * <p>
     * If <code>Marker</code> is returned by a previous response, there are more results available. The value of
     * <code>Marker</code> is a unique pagination token for each page. To retrieve the next page, make the call again
     * using the returned token and keeping all other arguments unchanged.
     * </p>
     * 
     * @return Specifies the unique pagination token that makes it possible to display the next page of results. If this
     *         parameter is specified, the response includes only records beyond the marker, up to the value specified
     *         by <code>MaxRecords</code>.</p>
     *         <p>
     *         If <code>Marker</code> is returned by a previous response, there are more results available. The value of
     *         <code>Marker</code> is a unique pagination token for each page. To retrieve the next page, make the call
     *         again using the returned token and keeping all other arguments unchanged.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceProfiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceProfiles() {
        return instanceProfiles != null && !(instanceProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A description of instance profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceProfiles} method.
     * </p>
     * 
     * @return A description of instance profiles.
     */
    public final List<InstanceProfile> instanceProfiles() {
        return instanceProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceProfiles() ? instanceProfiles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceProfilesResponse)) {
            return false;
        }
        DescribeInstanceProfilesResponse other = (DescribeInstanceProfilesResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasInstanceProfiles() == other.hasInstanceProfiles()
                && Objects.equals(instanceProfiles(), other.instanceProfiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceProfilesResponse").add("Marker", marker())
                .add("InstanceProfiles", hasInstanceProfiles() ? instanceProfiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "InstanceProfiles":
            return Optional.ofNullable(clazz.cast(instanceProfiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("InstanceProfiles", INSTANCE_PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceProfilesResponse, T> g) {
        return obj -> g.apply((DescribeInstanceProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceProfilesResponse> {
        /**
         * <p>
         * Specifies the unique pagination token that makes it possible to display the next page of results. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * <p>
         * If <code>Marker</code> is returned by a previous response, there are more results available. The value of
         * <code>Marker</code> is a unique pagination token for each page. To retrieve the next page, make the call
         * again using the returned token and keeping all other arguments unchanged.
         * </p>
         * 
         * @param marker
         *        Specifies the unique pagination token that makes it possible to display the next page of results. If
         *        this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.</p>
         *        <p>
         *        If <code>Marker</code> is returned by a previous response, there are more results available. The value
         *        of <code>Marker</code> is a unique pagination token for each page. To retrieve the next page, make the
         *        call again using the returned token and keeping all other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A description of instance profiles.
         * </p>
         * 
         * @param instanceProfiles
         *        A description of instance profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles);

        /**
         * <p>
         * A description of instance profiles.
         * </p>
         * 
         * @param instanceProfiles
         *        A description of instance profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfiles(InstanceProfile... instanceProfiles);

        /**
         * <p>
         * A description of instance profiles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.InstanceProfile.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.InstanceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.InstanceProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceProfiles(List<InstanceProfile>)}.
         * 
         * @param instanceProfiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.InstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceProfiles(java.util.Collection<InstanceProfile>)
         */
        Builder instanceProfiles(Consumer<InstanceProfile.Builder>... instanceProfiles);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<InstanceProfile> instanceProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceProfilesResponse model) {
            super(model);
            marker(model.marker);
            instanceProfiles(model.instanceProfiles);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<InstanceProfile.Builder> getInstanceProfiles() {
            List<InstanceProfile.Builder> result = InstanceProfileListCopier.copyToBuilder(this.instanceProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceProfiles(Collection<InstanceProfile.BuilderImpl> instanceProfiles) {
            this.instanceProfiles = InstanceProfileListCopier.copyFromBuilder(instanceProfiles);
        }

        @Override
        public final Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles) {
            this.instanceProfiles = InstanceProfileListCopier.copy(instanceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(InstanceProfile... instanceProfiles) {
            instanceProfiles(Arrays.asList(instanceProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(Consumer<InstanceProfile.Builder>... instanceProfiles) {
            instanceProfiles(Stream.of(instanceProfiles).map(c -> InstanceProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInstanceProfilesResponse build() {
            return new DescribeInstanceProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
