/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Endpoint settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointSetting implements SdkPojo, Serializable, ToCopyableBuilder<EndpointSetting.Builder, EndpointSetting> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EndpointSetting::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EndpointSetting::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> ENUM_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnumValues")
            .getter(getter(EndpointSetting::enumValues))
            .setter(setter(Builder::enumValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnumValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SENSITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Sensitive").getter(getter(EndpointSetting::sensitive)).setter(setter(Builder::sensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sensitive").build()).build();

    private static final SdkField<String> UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Units")
            .getter(getter(EndpointSetting::units)).setter(setter(Builder::units))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Units").build()).build();

    private static final SdkField<String> APPLICABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Applicability").getter(getter(EndpointSetting::applicability)).setter(setter(Builder::applicability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applicability").build()).build();

    private static final SdkField<Integer> INT_VALUE_MIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IntValueMin").getter(getter(EndpointSetting::intValueMin)).setter(setter(Builder::intValueMin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntValueMin").build()).build();

    private static final SdkField<Integer> INT_VALUE_MAX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IntValueMax").getter(getter(EndpointSetting::intValueMax)).setter(setter(Builder::intValueMax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntValueMax").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(EndpointSetting::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            ENUM_VALUES_FIELD, SENSITIVE_FIELD, UNITS_FIELD, APPLICABILITY_FIELD, INT_VALUE_MIN_FIELD, INT_VALUE_MAX_FIELD,
            DEFAULT_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final List<String> enumValues;

    private final Boolean sensitive;

    private final String units;

    private final String applicability;

    private final Integer intValueMin;

    private final Integer intValueMax;

    private final String defaultValue;

    private EndpointSetting(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.enumValues = builder.enumValues;
        this.sensitive = builder.sensitive;
        this.units = builder.units;
        this.applicability = builder.applicability;
        this.intValueMin = builder.intValueMin;
        this.intValueMax = builder.intValueMax;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The name that you want to give the endpoint settings.
     * </p>
     * 
     * @return The name that you want to give the endpoint settings.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EndpointSettingTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * @see EndpointSettingTypeValue
     */
    public final EndpointSettingTypeValue type() {
        return EndpointSettingTypeValue.fromValue(type);
    }

    /**
     * <p>
     * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EndpointSettingTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * @see EndpointSettingTypeValue
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnumValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEnumValues() {
        return enumValues != null && !(enumValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enumerated values to use for this endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnumValues} method.
     * </p>
     * 
     * @return Enumerated values to use for this endpoint.
     */
    public final List<String> enumValues() {
        return enumValues;
    }

    /**
     * <p>
     * A value that marks this endpoint setting as sensitive.
     * </p>
     * 
     * @return A value that marks this endpoint setting as sensitive.
     */
    public final Boolean sensitive() {
        return sensitive;
    }

    /**
     * <p>
     * The unit of measure for this endpoint setting.
     * </p>
     * 
     * @return The unit of measure for this endpoint setting.
     */
    public final String units() {
        return units;
    }

    /**
     * <p>
     * The relevance or validity of an endpoint setting for an engine name and its endpoint type.
     * </p>
     * 
     * @return The relevance or validity of an endpoint setting for an engine name and its endpoint type.
     */
    public final String applicability() {
        return applicability;
    }

    /**
     * <p>
     * The minimum value of an endpoint setting that is of type <code>int</code>.
     * </p>
     * 
     * @return The minimum value of an endpoint setting that is of type <code>int</code>.
     */
    public final Integer intValueMin() {
        return intValueMin;
    }

    /**
     * <p>
     * The maximum value of an endpoint setting that is of type <code>int</code>.
     * </p>
     * 
     * @return The maximum value of an endpoint setting that is of type <code>int</code>.
     */
    public final Integer intValueMax() {
        return intValueMax;
    }

    /**
     * <p>
     * The default value of the endpoint setting if no value is specified using <code>CreateEndpoint</code> or
     * <code>ModifyEndpoint</code>.
     * </p>
     * 
     * @return The default value of the endpoint setting if no value is specified using <code>CreateEndpoint</code> or
     *         <code>ModifyEndpoint</code>.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnumValues() ? enumValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sensitive());
        hashCode = 31 * hashCode + Objects.hashCode(units());
        hashCode = 31 * hashCode + Objects.hashCode(applicability());
        hashCode = 31 * hashCode + Objects.hashCode(intValueMin());
        hashCode = 31 * hashCode + Objects.hashCode(intValueMax());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointSetting)) {
            return false;
        }
        EndpointSetting other = (EndpointSetting) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasEnumValues() == other.hasEnumValues() && Objects.equals(enumValues(), other.enumValues())
                && Objects.equals(sensitive(), other.sensitive()) && Objects.equals(units(), other.units())
                && Objects.equals(applicability(), other.applicability()) && Objects.equals(intValueMin(), other.intValueMin())
                && Objects.equals(intValueMax(), other.intValueMax()) && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointSetting").add("Name", name()).add("Type", typeAsString())
                .add("EnumValues", hasEnumValues() ? enumValues() : null).add("Sensitive", sensitive()).add("Units", units())
                .add("Applicability", applicability()).add("IntValueMin", intValueMin()).add("IntValueMax", intValueMax())
                .add("DefaultValue", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "EnumValues":
            return Optional.ofNullable(clazz.cast(enumValues()));
        case "Sensitive":
            return Optional.ofNullable(clazz.cast(sensitive()));
        case "Units":
            return Optional.ofNullable(clazz.cast(units()));
        case "Applicability":
            return Optional.ofNullable(clazz.cast(applicability()));
        case "IntValueMin":
            return Optional.ofNullable(clazz.cast(intValueMin()));
        case "IntValueMax":
            return Optional.ofNullable(clazz.cast(intValueMax()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("EnumValues", ENUM_VALUES_FIELD);
        map.put("Sensitive", SENSITIVE_FIELD);
        map.put("Units", UNITS_FIELD);
        map.put("Applicability", APPLICABILITY_FIELD);
        map.put("IntValueMin", INT_VALUE_MIN_FIELD);
        map.put("IntValueMax", INT_VALUE_MAX_FIELD);
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointSetting, T> g) {
        return obj -> g.apply((EndpointSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointSetting> {
        /**
         * <p>
         * The name that you want to give the endpoint settings.
         * </p>
         * 
         * @param name
         *        The name that you want to give the endpoint settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * </p>
         * 
         * @param type
         *        The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * @see EndpointSettingTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointSettingTypeValue
         */
        Builder type(String type);

        /**
         * <p>
         * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * </p>
         * 
         * @param type
         *        The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * @see EndpointSettingTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointSettingTypeValue
         */
        Builder type(EndpointSettingTypeValue type);

        /**
         * <p>
         * Enumerated values to use for this endpoint.
         * </p>
         * 
         * @param enumValues
         *        Enumerated values to use for this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumValues(Collection<String> enumValues);

        /**
         * <p>
         * Enumerated values to use for this endpoint.
         * </p>
         * 
         * @param enumValues
         *        Enumerated values to use for this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumValues(String... enumValues);

        /**
         * <p>
         * A value that marks this endpoint setting as sensitive.
         * </p>
         * 
         * @param sensitive
         *        A value that marks this endpoint setting as sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitive(Boolean sensitive);

        /**
         * <p>
         * The unit of measure for this endpoint setting.
         * </p>
         * 
         * @param units
         *        The unit of measure for this endpoint setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder units(String units);

        /**
         * <p>
         * The relevance or validity of an endpoint setting for an engine name and its endpoint type.
         * </p>
         * 
         * @param applicability
         *        The relevance or validity of an endpoint setting for an engine name and its endpoint type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicability(String applicability);

        /**
         * <p>
         * The minimum value of an endpoint setting that is of type <code>int</code>.
         * </p>
         * 
         * @param intValueMin
         *        The minimum value of an endpoint setting that is of type <code>int</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intValueMin(Integer intValueMin);

        /**
         * <p>
         * The maximum value of an endpoint setting that is of type <code>int</code>.
         * </p>
         * 
         * @param intValueMax
         *        The maximum value of an endpoint setting that is of type <code>int</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intValueMax(Integer intValueMax);

        /**
         * <p>
         * The default value of the endpoint setting if no value is specified using <code>CreateEndpoint</code> or
         * <code>ModifyEndpoint</code>.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the endpoint setting if no value is specified using <code>CreateEndpoint</code>
         *        or <code>ModifyEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private List<String> enumValues = DefaultSdkAutoConstructList.getInstance();

        private Boolean sensitive;

        private String units;

        private String applicability;

        private Integer intValueMin;

        private Integer intValueMax;

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointSetting model) {
            name(model.name);
            type(model.type);
            enumValues(model.enumValues);
            sensitive(model.sensitive);
            units(model.units);
            applicability(model.applicability);
            intValueMin(model.intValueMin);
            intValueMax(model.intValueMax);
            defaultValue(model.defaultValue);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EndpointSettingTypeValue type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getEnumValues() {
            if (enumValues instanceof SdkAutoConstructList) {
                return null;
            }
            return enumValues;
        }

        public final void setEnumValues(Collection<String> enumValues) {
            this.enumValues = EndpointSettingEnumValuesCopier.copy(enumValues);
        }

        @Override
        public final Builder enumValues(Collection<String> enumValues) {
            this.enumValues = EndpointSettingEnumValuesCopier.copy(enumValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumValues(String... enumValues) {
            enumValues(Arrays.asList(enumValues));
            return this;
        }

        public final Boolean getSensitive() {
            return sensitive;
        }

        public final void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }

        @Override
        public final Builder sensitive(Boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public final String getUnits() {
            return units;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        @Override
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        public final String getApplicability() {
            return applicability;
        }

        public final void setApplicability(String applicability) {
            this.applicability = applicability;
        }

        @Override
        public final Builder applicability(String applicability) {
            this.applicability = applicability;
            return this;
        }

        public final Integer getIntValueMin() {
            return intValueMin;
        }

        public final void setIntValueMin(Integer intValueMin) {
            this.intValueMin = intValueMin;
        }

        @Override
        public final Builder intValueMin(Integer intValueMin) {
            this.intValueMin = intValueMin;
            return this;
        }

        public final Integer getIntValueMax() {
            return intValueMax;
        }

        public final void setIntValueMax(Integer intValueMax) {
            this.intValueMax = intValueMax;
        }

        @Override
        public final Builder intValueMax(Integer intValueMax) {
            this.intValueMax = intValueMax;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public EndpointSetting build() {
            return new EndpointSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
