/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that describes a recommendation of a target engine on Amazon RDS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsRecommendation.Builder, RdsRecommendation> {
    private static final SdkField<RdsRequirements> REQUIREMENTS_TO_TARGET_FIELD = SdkField
            .<RdsRequirements> builder(MarshallingType.SDK_POJO).memberName("RequirementsToTarget")
            .getter(getter(RdsRecommendation::requirementsToTarget)).setter(setter(Builder::requirementsToTarget))
            .constructor(RdsRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsToTarget").build())
            .build();

    private static final SdkField<RdsConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<RdsConfiguration> builder(MarshallingType.SDK_POJO).memberName("TargetConfiguration")
            .getter(getter(RdsRecommendation::targetConfiguration)).setter(setter(Builder::targetConfiguration))
            .constructor(RdsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIREMENTS_TO_TARGET_FIELD,
            TARGET_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RdsRequirements requirementsToTarget;

    private final RdsConfiguration targetConfiguration;

    private RdsRecommendation(BuilderImpl builder) {
        this.requirementsToTarget = builder.requirementsToTarget;
        this.targetConfiguration = builder.targetConfiguration;
    }

    /**
     * <p>
     * Supplemental information about the requirements to the recommended target database on Amazon RDS.
     * </p>
     * 
     * @return Supplemental information about the requirements to the recommended target database on Amazon RDS.
     */
    public final RdsRequirements requirementsToTarget() {
        return requirementsToTarget;
    }

    /**
     * <p>
     * Supplemental information about the configuration of the recommended target database on Amazon RDS.
     * </p>
     * 
     * @return Supplemental information about the configuration of the recommended target database on Amazon RDS.
     */
    public final RdsConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requirementsToTarget());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsRecommendation)) {
            return false;
        }
        RdsRecommendation other = (RdsRecommendation) obj;
        return Objects.equals(requirementsToTarget(), other.requirementsToTarget())
                && Objects.equals(targetConfiguration(), other.targetConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsRecommendation").add("RequirementsToTarget", requirementsToTarget())
                .add("TargetConfiguration", targetConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequirementsToTarget":
            return Optional.ofNullable(clazz.cast(requirementsToTarget()));
        case "TargetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequirementsToTarget", REQUIREMENTS_TO_TARGET_FIELD);
        map.put("TargetConfiguration", TARGET_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsRecommendation, T> g) {
        return obj -> g.apply((RdsRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsRecommendation> {
        /**
         * <p>
         * Supplemental information about the requirements to the recommended target database on Amazon RDS.
         * </p>
         * 
         * @param requirementsToTarget
         *        Supplemental information about the requirements to the recommended target database on Amazon RDS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requirementsToTarget(RdsRequirements requirementsToTarget);

        /**
         * <p>
         * Supplemental information about the requirements to the recommended target database on Amazon RDS.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsRequirements.Builder} avoiding the
         * need to create one manually via {@link RdsRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsRequirements.Builder#build()} is called immediately and its
         * result is passed to {@link #requirementsToTarget(RdsRequirements)}.
         * 
         * @param requirementsToTarget
         *        a consumer that will call methods on {@link RdsRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requirementsToTarget(RdsRequirements)
         */
        default Builder requirementsToTarget(Consumer<RdsRequirements.Builder> requirementsToTarget) {
            return requirementsToTarget(RdsRequirements.builder().applyMutation(requirementsToTarget).build());
        }

        /**
         * <p>
         * Supplemental information about the configuration of the recommended target database on Amazon RDS.
         * </p>
         * 
         * @param targetConfiguration
         *        Supplemental information about the configuration of the recommended target database on Amazon RDS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(RdsConfiguration targetConfiguration);

        /**
         * <p>
         * Supplemental information about the configuration of the recommended target database on Amazon RDS.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsConfiguration.Builder} avoiding the
         * need to create one manually via {@link RdsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #targetConfiguration(RdsConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link RdsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(RdsConfiguration)
         */
        default Builder targetConfiguration(Consumer<RdsConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(RdsConfiguration.builder().applyMutation(targetConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RdsRequirements requirementsToTarget;

        private RdsConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsRecommendation model) {
            requirementsToTarget(model.requirementsToTarget);
            targetConfiguration(model.targetConfiguration);
        }

        public final RdsRequirements.Builder getRequirementsToTarget() {
            return requirementsToTarget != null ? requirementsToTarget.toBuilder() : null;
        }

        public final void setRequirementsToTarget(RdsRequirements.BuilderImpl requirementsToTarget) {
            this.requirementsToTarget = requirementsToTarget != null ? requirementsToTarget.build() : null;
        }

        @Override
        public final Builder requirementsToTarget(RdsRequirements requirementsToTarget) {
            this.requirementsToTarget = requirementsToTarget;
            return this;
        }

        public final RdsConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(RdsConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(RdsConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        @Override
        public RdsRecommendation build() {
            return new RdsRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
