/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that describes a recommendation of a target engine.
 * </p>
 * <p>
 * A <i>recommendation</i> is a set of possible Amazon Web Services target engines that you can choose to migrate your
 * source on-premises database. In this set, Fleet Advisor suggests a single target engine as the right sized migration
 * destination. To determine this rightsized migration destination, Fleet Advisor uses the inventory metadata and
 * metrics from data collector. You can use recommendations before the start of migration to save costs and reduce
 * risks.
 * </p>
 * <p>
 * With recommendations, you can explore different target options and compare metrics, so you can make an informed
 * decision when you choose the migration target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recommendation implements SdkPojo, Serializable, ToCopyableBuilder<Recommendation.Builder, Recommendation> {
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseId").getter(getter(Recommendation::databaseId)).setter(setter(Builder::databaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()).build();

    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineName").getter(getter(Recommendation::engineName)).setter(setter(Builder::engineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()).build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(Recommendation::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Recommendation::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Boolean> PREFERRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Preferred").getter(getter(Recommendation::preferred)).setter(setter(Builder::preferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preferred").build()).build();

    private static final SdkField<RecommendationSettings> SETTINGS_FIELD = SdkField
            .<RecommendationSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(Recommendation::settings)).setter(setter(Builder::settings))
            .constructor(RecommendationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<RecommendationData> DATA_FIELD = SdkField
            .<RecommendationData> builder(MarshallingType.SDK_POJO).memberName("Data").getter(getter(Recommendation::data))
            .setter(setter(Builder::data)).constructor(RecommendationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ID_FIELD,
            ENGINE_NAME_FIELD, CREATED_DATE_FIELD, STATUS_FIELD, PREFERRED_FIELD, SETTINGS_FIELD, DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseId;

    private final String engineName;

    private final String createdDate;

    private final String status;

    private final Boolean preferred;

    private final RecommendationSettings settings;

    private final RecommendationData data;

    private Recommendation(BuilderImpl builder) {
        this.databaseId = builder.databaseId;
        this.engineName = builder.engineName;
        this.createdDate = builder.createdDate;
        this.status = builder.status;
        this.preferred = builder.preferred;
        this.settings = builder.settings;
        this.data = builder.data;
    }

    /**
     * <p>
     * The identifier of the source database for which Fleet Advisor provided this recommendation.
     * </p>
     * 
     * @return The identifier of the source database for which Fleet Advisor provided this recommendation.
     */
    public final String databaseId() {
        return databaseId;
    }

    /**
     * <p>
     * The name of the target engine. Valid values include <code>"rds-aurora-mysql"</code>,
     * <code>"rds-aurora-postgresql"</code>, <code>"rds-mysql"</code>, <code>"rds-oracle"</code>,
     * <code>"rds-sql-server"</code>, and <code>"rds-postgresql"</code>.
     * </p>
     * 
     * @return The name of the target engine. Valid values include <code>"rds-aurora-mysql"</code>,
     *         <code>"rds-aurora-postgresql"</code>, <code>"rds-mysql"</code>, <code>"rds-oracle"</code>,
     *         <code>"rds-sql-server"</code>, and <code>"rds-postgresql"</code>.
     */
    public final String engineName() {
        return engineName;
    }

    /**
     * <p>
     * The date when Fleet Advisor created the target engine recommendation.
     * </p>
     * 
     * @return The date when Fleet Advisor created the target engine recommendation.
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The status of the target engine recommendation. Valid values include <code>"alternate"</code>,
     * <code>"in-progress"</code>, <code>"not-viable"</code>, and <code>"recommended"</code>.
     * </p>
     * 
     * @return The status of the target engine recommendation. Valid values include <code>"alternate"</code>,
     *         <code>"in-progress"</code>, <code>"not-viable"</code>, and <code>"recommended"</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Indicates that this target is the rightsized migration destination.
     * </p>
     * 
     * @return Indicates that this target is the rightsized migration destination.
     */
    public final Boolean preferred() {
        return preferred;
    }

    /**
     * <p>
     * The settings in JSON format for the preferred target engine parameters. These parameters include capacity,
     * resource utilization, and the usage type (production, development, or testing).
     * </p>
     * 
     * @return The settings in JSON format for the preferred target engine parameters. These parameters include
     *         capacity, resource utilization, and the usage type (production, development, or testing).
     */
    public final RecommendationSettings settings() {
        return settings;
    }

    /**
     * <p>
     * The recommendation of a target engine for the specified source database.
     * </p>
     * 
     * @return The recommendation of a target engine for the specified source database.
     */
    public final RecommendationData data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(engineName());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(preferred());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation) obj;
        return Objects.equals(databaseId(), other.databaseId()) && Objects.equals(engineName(), other.engineName())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(status(), other.status())
                && Objects.equals(preferred(), other.preferred()) && Objects.equals(settings(), other.settings())
                && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recommendation").add("DatabaseId", databaseId()).add("EngineName", engineName())
                .add("CreatedDate", createdDate()).add("Status", status()).add("Preferred", preferred())
                .add("Settings", settings()).add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseId":
            return Optional.ofNullable(clazz.cast(databaseId()));
        case "EngineName":
            return Optional.ofNullable(clazz.cast(engineName()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Preferred":
            return Optional.ofNullable(clazz.cast(preferred()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseId", DATABASE_ID_FIELD);
        map.put("EngineName", ENGINE_NAME_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Preferred", PREFERRED_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("Data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recommendation> {
        /**
         * <p>
         * The identifier of the source database for which Fleet Advisor provided this recommendation.
         * </p>
         * 
         * @param databaseId
         *        The identifier of the source database for which Fleet Advisor provided this recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseId(String databaseId);

        /**
         * <p>
         * The name of the target engine. Valid values include <code>"rds-aurora-mysql"</code>,
         * <code>"rds-aurora-postgresql"</code>, <code>"rds-mysql"</code>, <code>"rds-oracle"</code>,
         * <code>"rds-sql-server"</code>, and <code>"rds-postgresql"</code>.
         * </p>
         * 
         * @param engineName
         *        The name of the target engine. Valid values include <code>"rds-aurora-mysql"</code>,
         *        <code>"rds-aurora-postgresql"</code>, <code>"rds-mysql"</code>, <code>"rds-oracle"</code>,
         *        <code>"rds-sql-server"</code>, and <code>"rds-postgresql"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineName(String engineName);

        /**
         * <p>
         * The date when Fleet Advisor created the target engine recommendation.
         * </p>
         * 
         * @param createdDate
         *        The date when Fleet Advisor created the target engine recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * The status of the target engine recommendation. Valid values include <code>"alternate"</code>,
         * <code>"in-progress"</code>, <code>"not-viable"</code>, and <code>"recommended"</code>.
         * </p>
         * 
         * @param status
         *        The status of the target engine recommendation. Valid values include <code>"alternate"</code>,
         *        <code>"in-progress"</code>, <code>"not-viable"</code>, and <code>"recommended"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates that this target is the rightsized migration destination.
         * </p>
         * 
         * @param preferred
         *        Indicates that this target is the rightsized migration destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferred(Boolean preferred);

        /**
         * <p>
         * The settings in JSON format for the preferred target engine parameters. These parameters include capacity,
         * resource utilization, and the usage type (production, development, or testing).
         * </p>
         * 
         * @param settings
         *        The settings in JSON format for the preferred target engine parameters. These parameters include
         *        capacity, resource utilization, and the usage type (production, development, or testing).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(RecommendationSettings settings);

        /**
         * <p>
         * The settings in JSON format for the preferred target engine parameters. These parameters include capacity,
         * resource utilization, and the usage type (production, development, or testing).
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationSettings.Builder} avoiding
         * the need to create one manually via {@link RecommendationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(RecommendationSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link RecommendationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(RecommendationSettings)
         */
        default Builder settings(Consumer<RecommendationSettings.Builder> settings) {
            return settings(RecommendationSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * The recommendation of a target engine for the specified source database.
         * </p>
         * 
         * @param data
         *        The recommendation of a target engine for the specified source database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(RecommendationData data);

        /**
         * <p>
         * The recommendation of a target engine for the specified source database.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationData.Builder} avoiding the
         * need to create one manually via {@link RecommendationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationData.Builder#build()} is called immediately and its
         * result is passed to {@link #data(RecommendationData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link RecommendationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(RecommendationData)
         */
        default Builder data(Consumer<RecommendationData.Builder> data) {
            return data(RecommendationData.builder().applyMutation(data).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String databaseId;

        private String engineName;

        private String createdDate;

        private String status;

        private Boolean preferred;

        private RecommendationSettings settings;

        private RecommendationData data;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            databaseId(model.databaseId);
            engineName(model.engineName);
            createdDate(model.createdDate);
            status(model.status);
            preferred(model.preferred);
            settings(model.settings);
            data(model.data);
        }

        public final String getDatabaseId() {
            return databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getEngineName() {
            return engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getPreferred() {
            return preferred;
        }

        public final void setPreferred(Boolean preferred) {
            this.preferred = preferred;
        }

        @Override
        public final Builder preferred(Boolean preferred) {
            this.preferred = preferred;
            return this;
        }

        public final RecommendationSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(RecommendationSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(RecommendationSettings settings) {
            this.settings = settings;
            return this;
        }

        public final RecommendationData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(RecommendationData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(RecommendationData data) {
            this.data = data;
            return this;
        }

        @Override
        public Recommendation build() {
            return new Recommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
