/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the required target engine settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationSettings.Builder, RecommendationSettings> {
    private static final SdkField<String> INSTANCE_SIZING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceSizingType").getter(getter(RecommendationSettings::instanceSizingType))
            .setter(setter(Builder::instanceSizingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceSizingType").build())
            .build();

    private static final SdkField<String> WORKLOAD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadType").getter(getter(RecommendationSettings::workloadType))
            .setter(setter(Builder::workloadType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SIZING_TYPE_FIELD,
            WORKLOAD_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceSizingType;

    private final String workloadType;

    private RecommendationSettings(BuilderImpl builder) {
        this.instanceSizingType = builder.instanceSizingType;
        this.workloadType = builder.workloadType;
    }

    /**
     * <p>
     * The size of your target instance. Fleet Advisor calculates this value based on your data collection type, such as
     * total capacity and resource utilization. Valid values include <code>"total-capacity"</code> and
     * <code>"utilization"</code>.
     * </p>
     * 
     * @return The size of your target instance. Fleet Advisor calculates this value based on your data collection type,
     *         such as total capacity and resource utilization. Valid values include <code>"total-capacity"</code> and
     *         <code>"utilization"</code>.
     */
    public final String instanceSizingType() {
        return instanceSizingType;
    }

    /**
     * <p>
     * The deployment option for your target engine. For production databases, Fleet Advisor chooses Multi-AZ
     * deployment. For development or test databases, Fleet Advisor chooses Single-AZ deployment. Valid values include
     * <code>"development"</code> and <code>"production"</code>.
     * </p>
     * 
     * @return The deployment option for your target engine. For production databases, Fleet Advisor chooses Multi-AZ
     *         deployment. For development or test databases, Fleet Advisor chooses Single-AZ deployment. Valid values
     *         include <code>"development"</code> and <code>"production"</code>.
     */
    public final String workloadType() {
        return workloadType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceSizingType());
        hashCode = 31 * hashCode + Objects.hashCode(workloadType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSettings)) {
            return false;
        }
        RecommendationSettings other = (RecommendationSettings) obj;
        return Objects.equals(instanceSizingType(), other.instanceSizingType())
                && Objects.equals(workloadType(), other.workloadType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationSettings").add("InstanceSizingType", instanceSizingType())
                .add("WorkloadType", workloadType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceSizingType":
            return Optional.ofNullable(clazz.cast(instanceSizingType()));
        case "WorkloadType":
            return Optional.ofNullable(clazz.cast(workloadType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceSizingType", INSTANCE_SIZING_TYPE_FIELD);
        map.put("WorkloadType", WORKLOAD_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSettings, T> g) {
        return obj -> g.apply((RecommendationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationSettings> {
        /**
         * <p>
         * The size of your target instance. Fleet Advisor calculates this value based on your data collection type,
         * such as total capacity and resource utilization. Valid values include <code>"total-capacity"</code> and
         * <code>"utilization"</code>.
         * </p>
         * 
         * @param instanceSizingType
         *        The size of your target instance. Fleet Advisor calculates this value based on your data collection
         *        type, such as total capacity and resource utilization. Valid values include
         *        <code>"total-capacity"</code> and <code>"utilization"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSizingType(String instanceSizingType);

        /**
         * <p>
         * The deployment option for your target engine. For production databases, Fleet Advisor chooses Multi-AZ
         * deployment. For development or test databases, Fleet Advisor chooses Single-AZ deployment. Valid values
         * include <code>"development"</code> and <code>"production"</code>.
         * </p>
         * 
         * @param workloadType
         *        The deployment option for your target engine. For production databases, Fleet Advisor chooses Multi-AZ
         *        deployment. For development or test databases, Fleet Advisor chooses Single-AZ deployment. Valid
         *        values include <code>"development"</code> and <code>"production"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadType(String workloadType);
    }

    static final class BuilderImpl implements Builder {
        private String instanceSizingType;

        private String workloadType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSettings model) {
            instanceSizingType(model.instanceSizingType);
            workloadType(model.workloadType);
        }

        public final String getInstanceSizingType() {
            return instanceSizingType;
        }

        public final void setInstanceSizingType(String instanceSizingType) {
            this.instanceSizingType = instanceSizingType;
        }

        @Override
        public final Builder instanceSizingType(String instanceSizingType) {
            this.instanceSizingType = instanceSizingType;
            return this;
        }

        public final String getWorkloadType() {
            return workloadType;
        }

        public final void setWorkloadType(String workloadType) {
            this.workloadType = workloadType;
        }

        @Override
        public final Builder workloadType(String workloadType) {
            this.workloadType = workloadType;
            return this;
        }

        @Override
        public RecommendationSettings build() {
            return new RecommendationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
