/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMetadataModelAssessmentResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<StartMetadataModelAssessmentResponse.Builder, StartMetadataModelAssessmentResponse> {
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestIdentifier").getter(getter(StartMetadataModelAssessmentResponse::requestIdentifier))
            .setter(setter(Builder::requestIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestIdentifier;

    private StartMetadataModelAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdentifier = builder.requestIdentifier;
    }

    /**
     * <p>
     * The identifier for the assessment operation.
     * </p>
     * 
     * @return The identifier for the assessment operation.
     */
    public final String requestIdentifier() {
        return requestIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetadataModelAssessmentResponse)) {
            return false;
        }
        StartMetadataModelAssessmentResponse other = (StartMetadataModelAssessmentResponse) obj;
        return Objects.equals(requestIdentifier(), other.requestIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMetadataModelAssessmentResponse").add("RequestIdentifier", requestIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestIdentifier":
            return Optional.ofNullable(clazz.cast(requestIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMetadataModelAssessmentResponse, T> g) {
        return obj -> g.apply((StartMetadataModelAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMetadataModelAssessmentResponse> {
        /**
         * <p>
         * The identifier for the assessment operation.
         * </p>
         * 
         * @param requestIdentifier
         *        The identifier for the assessment operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdentifier(String requestIdentifier);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String requestIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetadataModelAssessmentResponse model) {
            super(model);
            requestIdentifier(model.requestIdentifier);
        }

        public final String getRequestIdentifier() {
            return requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        @Override
        public StartMetadataModelAssessmentResponse build() {
            return new StartMetadataModelAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
