/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRecommendationsRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<StartRecommendationsRequest.Builder, StartRecommendationsRequest> {
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseId").getter(getter(StartRecommendationsRequest::databaseId)).setter(setter(Builder::databaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()).build();

    private static final SdkField<RecommendationSettings> SETTINGS_FIELD = SdkField
            .<RecommendationSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(StartRecommendationsRequest::settings)).setter(setter(Builder::settings))
            .constructor(RecommendationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ID_FIELD,
            SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String databaseId;

    private final RecommendationSettings settings;

    private StartRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.databaseId = builder.databaseId;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The identifier of the source database to analyze and provide recommendations for.
     * </p>
     * 
     * @return The identifier of the source database to analyze and provide recommendations for.
     */
    public final String databaseId() {
        return databaseId;
    }

    /**
     * <p>
     * The settings in JSON format that Fleet Advisor uses to determine target engine recommendations. These parameters
     * include target instance sizing and availability and durability settings. For target instance sizing, Fleet
     * Advisor supports the following two options: total capacity and resource utilization. For availability and
     * durability, Fleet Advisor supports the following two options: production (Multi-AZ deployments) and Dev/Test
     * (Single-AZ deployments).
     * </p>
     * 
     * @return The settings in JSON format that Fleet Advisor uses to determine target engine recommendations. These
     *         parameters include target instance sizing and availability and durability settings. For target instance
     *         sizing, Fleet Advisor supports the following two options: total capacity and resource utilization. For
     *         availability and durability, Fleet Advisor supports the following two options: production (Multi-AZ
     *         deployments) and Dev/Test (Single-AZ deployments).
     */
    public final RecommendationSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRecommendationsRequest)) {
            return false;
        }
        StartRecommendationsRequest other = (StartRecommendationsRequest) obj;
        return Objects.equals(databaseId(), other.databaseId()) && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRecommendationsRequest").add("DatabaseId", databaseId()).add("Settings", settings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseId":
            return Optional.ofNullable(clazz.cast(databaseId()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseId", DATABASE_ID_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRecommendationsRequest, T> g) {
        return obj -> g.apply((StartRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartRecommendationsRequest> {
        /**
         * <p>
         * The identifier of the source database to analyze and provide recommendations for.
         * </p>
         * 
         * @param databaseId
         *        The identifier of the source database to analyze and provide recommendations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseId(String databaseId);

        /**
         * <p>
         * The settings in JSON format that Fleet Advisor uses to determine target engine recommendations. These
         * parameters include target instance sizing and availability and durability settings. For target instance
         * sizing, Fleet Advisor supports the following two options: total capacity and resource utilization. For
         * availability and durability, Fleet Advisor supports the following two options: production (Multi-AZ
         * deployments) and Dev/Test (Single-AZ deployments).
         * </p>
         * 
         * @param settings
         *        The settings in JSON format that Fleet Advisor uses to determine target engine recommendations. These
         *        parameters include target instance sizing and availability and durability settings. For target
         *        instance sizing, Fleet Advisor supports the following two options: total capacity and resource
         *        utilization. For availability and durability, Fleet Advisor supports the following two options:
         *        production (Multi-AZ deployments) and Dev/Test (Single-AZ deployments).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(RecommendationSettings settings);

        /**
         * <p>
         * The settings in JSON format that Fleet Advisor uses to determine target engine recommendations. These
         * parameters include target instance sizing and availability and durability settings. For target instance
         * sizing, Fleet Advisor supports the following two options: total capacity and resource utilization. For
         * availability and durability, Fleet Advisor supports the following two options: production (Multi-AZ
         * deployments) and Dev/Test (Single-AZ deployments).
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationSettings.Builder} avoiding
         * the need to create one manually via {@link RecommendationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(RecommendationSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link RecommendationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(RecommendationSettings)
         */
        default Builder settings(Consumer<RecommendationSettings.Builder> settings) {
            return settings(RecommendationSettings.builder().applyMutation(settings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String databaseId;

        private RecommendationSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRecommendationsRequest model) {
            super(model);
            databaseId(model.databaseId);
            settings(model.settings);
        }

        public final String getDatabaseId() {
            return databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final RecommendationSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(RecommendationSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(RecommendationSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRecommendationsRequest build() {
            return new StartRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
