/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines an Amazon Timestream endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestreamSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TimestreamSettings.Builder, TimestreamSettings> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(TimestreamSettings::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<Integer> MEMORY_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemoryDuration").getter(getter(TimestreamSettings::memoryDuration))
            .setter(setter(Builder::memoryDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryDuration").build()).build();

    private static final SdkField<Integer> MAGNETIC_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MagneticDuration").getter(getter(TimestreamSettings::magneticDuration))
            .setter(setter(Builder::magneticDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticDuration").build()).build();

    private static final SdkField<Boolean> CDC_INSERTS_AND_UPDATES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CdcInsertsAndUpdates").getter(getter(TimestreamSettings::cdcInsertsAndUpdates))
            .setter(setter(Builder::cdcInsertsAndUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcInsertsAndUpdates").build())
            .build();

    private static final SdkField<Boolean> ENABLE_MAGNETIC_STORE_WRITES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableMagneticStoreWrites")
            .getter(getter(TimestreamSettings::enableMagneticStoreWrites)).setter(setter(Builder::enableMagneticStoreWrites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMagneticStoreWrites").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            MEMORY_DURATION_FIELD, MAGNETIC_DURATION_FIELD, CDC_INSERTS_AND_UPDATES_FIELD, ENABLE_MAGNETIC_STORE_WRITES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final Integer memoryDuration;

    private final Integer magneticDuration;

    private final Boolean cdcInsertsAndUpdates;

    private final Boolean enableMagneticStoreWrites;

    private TimestreamSettings(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.memoryDuration = builder.memoryDuration;
        this.magneticDuration = builder.magneticDuration;
        this.cdcInsertsAndUpdates = builder.cdcInsertsAndUpdates;
        this.enableMagneticStoreWrites = builder.enableMagneticStoreWrites;
    }

    /**
     * <p>
     * Database name for the endpoint.
     * </p>
     * 
     * @return Database name for the endpoint.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Set this attribute to specify the length of time to store all of the tables in memory that are migrated into
     * Amazon Timestream from the source database. Time is measured in units of hours. When Timestream data comes in, it
     * first resides in memory for the specified duration, which allows quick access to it.
     * </p>
     * 
     * @return Set this attribute to specify the length of time to store all of the tables in memory that are migrated
     *         into Amazon Timestream from the source database. Time is measured in units of hours. When Timestream data
     *         comes in, it first resides in memory for the specified duration, which allows quick access to it.
     */
    public final Integer memoryDuration() {
        return memoryDuration;
    }

    /**
     * <p>
     * Set this attribute to specify the default magnetic duration applied to the Amazon Timestream tables in days. This
     * is the number of days that records remain in magnetic store before being discarded. For more information, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">Storage</a> in the <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/">Amazon Timestream Developer Guide</a>.
     * </p>
     * 
     * @return Set this attribute to specify the default magnetic duration applied to the Amazon Timestream tables in
     *         days. This is the number of days that records remain in magnetic store before being discarded. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">Storage</a> in the <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/">Amazon Timestream Developer
     *         Guide</a>.
     */
    public final Integer magneticDuration() {
        return magneticDuration;
    }

    /**
     * <p>
     * Set this attribute to <code>true</code> to specify that DMS only applies inserts and updates, and not deletes.
     * Amazon Timestream does not allow deleting records, so if this value is <code>false</code>, DMS nulls out the
     * corresponding record in the Timestream database rather than deleting it.
     * </p>
     * 
     * @return Set this attribute to <code>true</code> to specify that DMS only applies inserts and updates, and not
     *         deletes. Amazon Timestream does not allow deleting records, so if this value is <code>false</code>, DMS
     *         nulls out the corresponding record in the Timestream database rather than deleting it.
     */
    public final Boolean cdcInsertsAndUpdates() {
        return cdcInsertsAndUpdates;
    }

    /**
     * <p>
     * Set this attribute to <code>true</code> to enable memory store writes. When this value is <code>false</code>, DMS
     * does not write records that are older in days than the value specified in <code>MagneticDuration</code>, because
     * Amazon Timestream does not allow memory writes by default. For more information, see <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">Storage</a> in the <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/">Amazon Timestream Developer Guide</a>.
     * </p>
     * 
     * @return Set this attribute to <code>true</code> to enable memory store writes. When this value is
     *         <code>false</code>, DMS does not write records that are older in days than the value specified in
     *         <code>MagneticDuration</code>, because Amazon Timestream does not allow memory writes by default. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">Storage</a> in the <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/">Amazon Timestream Developer
     *         Guide</a>.
     */
    public final Boolean enableMagneticStoreWrites() {
        return enableMagneticStoreWrites;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(memoryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(magneticDuration());
        hashCode = 31 * hashCode + Objects.hashCode(cdcInsertsAndUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(enableMagneticStoreWrites());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamSettings)) {
            return false;
        }
        TimestreamSettings other = (TimestreamSettings) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(memoryDuration(), other.memoryDuration())
                && Objects.equals(magneticDuration(), other.magneticDuration())
                && Objects.equals(cdcInsertsAndUpdates(), other.cdcInsertsAndUpdates())
                && Objects.equals(enableMagneticStoreWrites(), other.enableMagneticStoreWrites());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestreamSettings").add("DatabaseName", databaseName()).add("MemoryDuration", memoryDuration())
                .add("MagneticDuration", magneticDuration()).add("CdcInsertsAndUpdates", cdcInsertsAndUpdates())
                .add("EnableMagneticStoreWrites", enableMagneticStoreWrites()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "MemoryDuration":
            return Optional.ofNullable(clazz.cast(memoryDuration()));
        case "MagneticDuration":
            return Optional.ofNullable(clazz.cast(magneticDuration()));
        case "CdcInsertsAndUpdates":
            return Optional.ofNullable(clazz.cast(cdcInsertsAndUpdates()));
        case "EnableMagneticStoreWrites":
            return Optional.ofNullable(clazz.cast(enableMagneticStoreWrites()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("MemoryDuration", MEMORY_DURATION_FIELD);
        map.put("MagneticDuration", MAGNETIC_DURATION_FIELD);
        map.put("CdcInsertsAndUpdates", CDC_INSERTS_AND_UPDATES_FIELD);
        map.put("EnableMagneticStoreWrites", ENABLE_MAGNETIC_STORE_WRITES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestreamSettings, T> g) {
        return obj -> g.apply((TimestreamSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestreamSettings> {
        /**
         * <p>
         * Database name for the endpoint.
         * </p>
         * 
         * @param databaseName
         *        Database name for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Set this attribute to specify the length of time to store all of the tables in memory that are migrated into
         * Amazon Timestream from the source database. Time is measured in units of hours. When Timestream data comes
         * in, it first resides in memory for the specified duration, which allows quick access to it.
         * </p>
         * 
         * @param memoryDuration
         *        Set this attribute to specify the length of time to store all of the tables in memory that are
         *        migrated into Amazon Timestream from the source database. Time is measured in units of hours. When
         *        Timestream data comes in, it first resides in memory for the specified duration, which allows quick
         *        access to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryDuration(Integer memoryDuration);

        /**
         * <p>
         * Set this attribute to specify the default magnetic duration applied to the Amazon Timestream tables in days.
         * This is the number of days that records remain in magnetic store before being discarded. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">Storage</a> in the <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/">Amazon Timestream Developer Guide</a>.
         * </p>
         * 
         * @param magneticDuration
         *        Set this attribute to specify the default magnetic duration applied to the Amazon Timestream tables in
         *        days. This is the number of days that records remain in magnetic store before being discarded. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">Storage</a> in the <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/">Amazon Timestream Developer
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder magneticDuration(Integer magneticDuration);

        /**
         * <p>
         * Set this attribute to <code>true</code> to specify that DMS only applies inserts and updates, and not
         * deletes. Amazon Timestream does not allow deleting records, so if this value is <code>false</code>, DMS nulls
         * out the corresponding record in the Timestream database rather than deleting it.
         * </p>
         * 
         * @param cdcInsertsAndUpdates
         *        Set this attribute to <code>true</code> to specify that DMS only applies inserts and updates, and not
         *        deletes. Amazon Timestream does not allow deleting records, so if this value is <code>false</code>,
         *        DMS nulls out the corresponding record in the Timestream database rather than deleting it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates);

        /**
         * <p>
         * Set this attribute to <code>true</code> to enable memory store writes. When this value is <code>false</code>,
         * DMS does not write records that are older in days than the value specified in <code>MagneticDuration</code>,
         * because Amazon Timestream does not allow memory writes by default. For more information, see <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">Storage</a> in the <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/">Amazon Timestream Developer Guide</a>.
         * </p>
         * 
         * @param enableMagneticStoreWrites
         *        Set this attribute to <code>true</code> to enable memory store writes. When this value is
         *        <code>false</code>, DMS does not write records that are older in days than the value specified in
         *        <code>MagneticDuration</code>, because Amazon Timestream does not allow memory writes by default. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html">Storage</a> in the <a
         *        href="https://docs.aws.amazon.com/timestream/latest/developerguide/">Amazon Timestream Developer
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMagneticStoreWrites(Boolean enableMagneticStoreWrites);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private Integer memoryDuration;

        private Integer magneticDuration;

        private Boolean cdcInsertsAndUpdates;

        private Boolean enableMagneticStoreWrites;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestreamSettings model) {
            databaseName(model.databaseName);
            memoryDuration(model.memoryDuration);
            magneticDuration(model.magneticDuration);
            cdcInsertsAndUpdates(model.cdcInsertsAndUpdates);
            enableMagneticStoreWrites(model.enableMagneticStoreWrites);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Integer getMemoryDuration() {
            return memoryDuration;
        }

        public final void setMemoryDuration(Integer memoryDuration) {
            this.memoryDuration = memoryDuration;
        }

        @Override
        public final Builder memoryDuration(Integer memoryDuration) {
            this.memoryDuration = memoryDuration;
            return this;
        }

        public final Integer getMagneticDuration() {
            return magneticDuration;
        }

        public final void setMagneticDuration(Integer magneticDuration) {
            this.magneticDuration = magneticDuration;
        }

        @Override
        public final Builder magneticDuration(Integer magneticDuration) {
            this.magneticDuration = magneticDuration;
            return this;
        }

        public final Boolean getCdcInsertsAndUpdates() {
            return cdcInsertsAndUpdates;
        }

        public final void setCdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
        }

        @Override
        public final Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
            return this;
        }

        public final Boolean getEnableMagneticStoreWrites() {
            return enableMagneticStoreWrites;
        }

        public final void setEnableMagneticStoreWrites(Boolean enableMagneticStoreWrites) {
            this.enableMagneticStoreWrites = enableMagneticStoreWrites;
        }

        @Override
        public final Builder enableMagneticStoreWrites(Boolean enableMagneticStoreWrites) {
            this.enableMagneticStoreWrites = enableMagneticStoreWrites;
            return this;
        }

        @Override
        public TimestreamSettings build() {
            return new TimestreamSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
