/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataMigrationRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<CreateDataMigrationRequest.Builder, CreateDataMigrationRequest> {
    private static final SdkField<String> DATA_MIGRATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataMigrationName").getter(getter(CreateDataMigrationRequest::dataMigrationName))
            .setter(setter(Builder::dataMigrationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationName").build()).build();

    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MigrationProjectIdentifier")
            .getter(getter(CreateDataMigrationRequest::migrationProjectIdentifier))
            .setter(setter(Builder::migrationProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build())
            .build();

    private static final SdkField<String> DATA_MIGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataMigrationType").getter(getter(CreateDataMigrationRequest::dataMigrationTypeAsString))
            .setter(setter(Builder::dataMigrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationType").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(CreateDataMigrationRequest::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<Boolean> ENABLE_CLOUDWATCH_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCloudwatchLogs").getter(getter(CreateDataMigrationRequest::enableCloudwatchLogs))
            .setter(setter(Builder::enableCloudwatchLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogs").build())
            .build();

    private static final SdkField<List<SourceDataSetting>> SOURCE_DATA_SETTINGS_FIELD = SdkField
            .<List<SourceDataSetting>> builder(MarshallingType.LIST)
            .memberName("SourceDataSettings")
            .getter(getter(CreateDataMigrationRequest::sourceDataSettings))
            .setter(setter(Builder::sourceDataSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceDataSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceDataSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetDataSetting>> TARGET_DATA_SETTINGS_FIELD = SdkField
            .<List<TargetDataSetting>> builder(MarshallingType.LIST)
            .memberName("TargetDataSettings")
            .getter(getter(CreateDataMigrationRequest::targetDataSettings))
            .setter(setter(Builder::targetDataSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDataSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetDataSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetDataSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NUMBER_OF_JOBS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfJobs").getter(getter(CreateDataMigrationRequest::numberOfJobs))
            .setter(setter(Builder::numberOfJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfJobs").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDataMigrationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionRules").getter(getter(CreateDataMigrationRequest::selectionRules))
            .setter(setter(Builder::selectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MIGRATION_NAME_FIELD,
            MIGRATION_PROJECT_IDENTIFIER_FIELD, DATA_MIGRATION_TYPE_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD,
            ENABLE_CLOUDWATCH_LOGS_FIELD, SOURCE_DATA_SETTINGS_FIELD, TARGET_DATA_SETTINGS_FIELD, NUMBER_OF_JOBS_FIELD,
            TAGS_FIELD, SELECTION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataMigrationName;

    private final String migrationProjectIdentifier;

    private final String dataMigrationType;

    private final String serviceAccessRoleArn;

    private final Boolean enableCloudwatchLogs;

    private final List<SourceDataSetting> sourceDataSettings;

    private final List<TargetDataSetting> targetDataSettings;

    private final Integer numberOfJobs;

    private final List<Tag> tags;

    private final String selectionRules;

    private CreateDataMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.dataMigrationName = builder.dataMigrationName;
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.dataMigrationType = builder.dataMigrationType;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.enableCloudwatchLogs = builder.enableCloudwatchLogs;
        this.sourceDataSettings = builder.sourceDataSettings;
        this.targetDataSettings = builder.targetDataSettings;
        this.numberOfJobs = builder.numberOfJobs;
        this.tags = builder.tags;
        this.selectionRules = builder.selectionRules;
    }

    /**
     * <p>
     * A user-friendly name for the data migration. Data migration names have the following constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must begin with a letter, and can only contain ASCII letters, digits, and hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Length must be from 1 to 255 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A user-friendly name for the data migration. Data migration names have the following constraints:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must begin with a letter, and can only contain ASCII letters, digits, and hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Length must be from 1 to 255 characters.
     *         </p>
     *         </li>
     */
    public final String dataMigrationName() {
        return dataMigrationName;
    }

    /**
     * <p>
     * An identifier for the migration project.
     * </p>
     * 
     * @return An identifier for the migration project.
     */
    public final String migrationProjectIdentifier() {
        return migrationProjectIdentifier;
    }

    /**
     * <p>
     * Specifies if the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataMigrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataMigrationTypeAsString}.
     * </p>
     * 
     * @return Specifies if the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
     * @see MigrationTypeValue
     */
    public final MigrationTypeValue dataMigrationType() {
        return MigrationTypeValue.fromValue(dataMigrationType);
    }

    /**
     * <p>
     * Specifies if the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataMigrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataMigrationTypeAsString}.
     * </p>
     * 
     * @return Specifies if the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
     * @see MigrationTypeValue
     */
    public final String dataMigrationTypeAsString() {
        return dataMigrationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the service access role that you want to use to create the data migration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the service access role that you want to use to create the data
     *         migration.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * Specifies whether to enable CloudWatch logs for the data migration.
     * </p>
     * 
     * @return Specifies whether to enable CloudWatch logs for the data migration.
     */
    public final Boolean enableCloudwatchLogs() {
        return enableCloudwatchLogs;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceDataSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceDataSettings() {
        return sourceDataSettings != null && !(sourceDataSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies information about the source data provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceDataSettings} method.
     * </p>
     * 
     * @return Specifies information about the source data provider.
     */
    public final List<SourceDataSetting> sourceDataSettings() {
        return sourceDataSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetDataSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetDataSettings() {
        return targetDataSettings != null && !(targetDataSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies information about the target data provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetDataSettings} method.
     * </p>
     * 
     * @return Specifies information about the target data provider.
     */
    public final List<TargetDataSetting> targetDataSettings() {
        return targetDataSettings;
    }

    /**
     * <p>
     * The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load
     * them to the target.
     * </p>
     * 
     * @return The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then
     *         load them to the target.
     */
    public final Integer numberOfJobs() {
        return numberOfJobs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags to be assigned to the data migration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags to be assigned to the data migration.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * An optional JSON string specifying what tables, views, and schemas to include or exclude from the migration.
     * </p>
     * 
     * @return An optional JSON string specifying what tables, views, and schemas to include or exclude from the
     *         migration.
     */
    public final String selectionRules() {
        return selectionRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataMigrationName());
        hashCode = 31 * hashCode + Objects.hashCode(migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dataMigrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceDataSettings() ? sourceDataSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetDataSettings() ? targetDataSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(selectionRules());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataMigrationRequest)) {
            return false;
        }
        CreateDataMigrationRequest other = (CreateDataMigrationRequest) obj;
        return Objects.equals(dataMigrationName(), other.dataMigrationName())
                && Objects.equals(migrationProjectIdentifier(), other.migrationProjectIdentifier())
                && Objects.equals(dataMigrationTypeAsString(), other.dataMigrationTypeAsString())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(enableCloudwatchLogs(), other.enableCloudwatchLogs())
                && hasSourceDataSettings() == other.hasSourceDataSettings()
                && Objects.equals(sourceDataSettings(), other.sourceDataSettings())
                && hasTargetDataSettings() == other.hasTargetDataSettings()
                && Objects.equals(targetDataSettings(), other.targetDataSettings())
                && Objects.equals(numberOfJobs(), other.numberOfJobs()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(selectionRules(), other.selectionRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataMigrationRequest").add("DataMigrationName", dataMigrationName())
                .add("MigrationProjectIdentifier", migrationProjectIdentifier())
                .add("DataMigrationType", dataMigrationTypeAsString()).add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("EnableCloudwatchLogs", enableCloudwatchLogs())
                .add("SourceDataSettings", hasSourceDataSettings() ? sourceDataSettings() : null)
                .add("TargetDataSettings", hasTargetDataSettings() ? targetDataSettings() : null)
                .add("NumberOfJobs", numberOfJobs()).add("Tags", hasTags() ? tags() : null)
                .add("SelectionRules", selectionRules() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataMigrationName":
            return Optional.ofNullable(clazz.cast(dataMigrationName()));
        case "MigrationProjectIdentifier":
            return Optional.ofNullable(clazz.cast(migrationProjectIdentifier()));
        case "DataMigrationType":
            return Optional.ofNullable(clazz.cast(dataMigrationTypeAsString()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "EnableCloudwatchLogs":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogs()));
        case "SourceDataSettings":
            return Optional.ofNullable(clazz.cast(sourceDataSettings()));
        case "TargetDataSettings":
            return Optional.ofNullable(clazz.cast(targetDataSettings()));
        case "NumberOfJobs":
            return Optional.ofNullable(clazz.cast(numberOfJobs()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SelectionRules":
            return Optional.ofNullable(clazz.cast(selectionRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataMigrationName", DATA_MIGRATION_NAME_FIELD);
        map.put("MigrationProjectIdentifier", MIGRATION_PROJECT_IDENTIFIER_FIELD);
        map.put("DataMigrationType", DATA_MIGRATION_TYPE_FIELD);
        map.put("ServiceAccessRoleArn", SERVICE_ACCESS_ROLE_ARN_FIELD);
        map.put("EnableCloudwatchLogs", ENABLE_CLOUDWATCH_LOGS_FIELD);
        map.put("SourceDataSettings", SOURCE_DATA_SETTINGS_FIELD);
        map.put("TargetDataSettings", TARGET_DATA_SETTINGS_FIELD);
        map.put("NumberOfJobs", NUMBER_OF_JOBS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SelectionRules", SELECTION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataMigrationRequest, T> g) {
        return obj -> g.apply((CreateDataMigrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataMigrationRequest> {
        /**
         * <p>
         * A user-friendly name for the data migration. Data migration names have the following constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must begin with a letter, and can only contain ASCII letters, digits, and hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Length must be from 1 to 255 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataMigrationName
         *        A user-friendly name for the data migration. Data migration names have the following constraints:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must begin with a letter, and can only contain ASCII letters, digits, and hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Length must be from 1 to 255 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataMigrationName(String dataMigrationName);

        /**
         * <p>
         * An identifier for the migration project.
         * </p>
         * 
         * @param migrationProjectIdentifier
         *        An identifier for the migration project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationProjectIdentifier(String migrationProjectIdentifier);

        /**
         * <p>
         * Specifies if the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
         * </p>
         * 
         * @param dataMigrationType
         *        Specifies if the data migration is full-load only, change data capture (CDC) only, or full-load and
         *        CDC.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder dataMigrationType(String dataMigrationType);

        /**
         * <p>
         * Specifies if the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
         * </p>
         * 
         * @param dataMigrationType
         *        Specifies if the data migration is full-load only, change data capture (CDC) only, or full-load and
         *        CDC.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder dataMigrationType(MigrationTypeValue dataMigrationType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the service access role that you want to use to create the data migration.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) for the service access role that you want to use to create the data
         *        migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * Specifies whether to enable CloudWatch logs for the data migration.
         * </p>
         * 
         * @param enableCloudwatchLogs
         *        Specifies whether to enable CloudWatch logs for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogs(Boolean enableCloudwatchLogs);

        /**
         * <p>
         * Specifies information about the source data provider.
         * </p>
         * 
         * @param sourceDataSettings
         *        Specifies information about the source data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDataSettings(Collection<SourceDataSetting> sourceDataSettings);

        /**
         * <p>
         * Specifies information about the source data provider.
         * </p>
         * 
         * @param sourceDataSettings
         *        Specifies information about the source data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDataSettings(SourceDataSetting... sourceDataSettings);

        /**
         * <p>
         * Specifies information about the source data provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.SourceDataSetting.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.SourceDataSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.SourceDataSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceDataSettings(List<SourceDataSetting>)}.
         * 
         * @param sourceDataSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.SourceDataSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDataSettings(java.util.Collection<SourceDataSetting>)
         */
        Builder sourceDataSettings(Consumer<SourceDataSetting.Builder>... sourceDataSettings);

        /**
         * <p>
         * Specifies information about the target data provider.
         * </p>
         * 
         * @param targetDataSettings
         *        Specifies information about the target data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDataSettings(Collection<TargetDataSetting> targetDataSettings);

        /**
         * <p>
         * Specifies information about the target data provider.
         * </p>
         * 
         * @param targetDataSettings
         *        Specifies information about the target data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDataSettings(TargetDataSetting... targetDataSettings);

        /**
         * <p>
         * Specifies information about the target data provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.TargetDataSetting.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.TargetDataSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.TargetDataSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #targetDataSettings(List<TargetDataSetting>)}.
         * 
         * @param targetDataSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.TargetDataSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetDataSettings(java.util.Collection<TargetDataSetting>)
         */
        Builder targetDataSettings(Consumer<TargetDataSetting.Builder>... targetDataSettings);

        /**
         * <p>
         * The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load
         * them to the target.
         * </p>
         * 
         * @param numberOfJobs
         *        The number of parallel jobs that trigger parallel threads to unload the tables from the source, and
         *        then load them to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfJobs(Integer numberOfJobs);

        /**
         * <p>
         * One or more tags to be assigned to the data migration.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags to be assigned to the data migration.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags to be assigned to the data migration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.databasemigration.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An optional JSON string specifying what tables, views, and schemas to include or exclude from the migration.
         * </p>
         * 
         * @param selectionRules
         *        An optional JSON string specifying what tables, views, and schemas to include or exclude from the
         *        migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionRules(String selectionRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String dataMigrationName;

        private String migrationProjectIdentifier;

        private String dataMigrationType;

        private String serviceAccessRoleArn;

        private Boolean enableCloudwatchLogs;

        private List<SourceDataSetting> sourceDataSettings = DefaultSdkAutoConstructList.getInstance();

        private List<TargetDataSetting> targetDataSettings = DefaultSdkAutoConstructList.getInstance();

        private Integer numberOfJobs;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String selectionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataMigrationRequest model) {
            super(model);
            dataMigrationName(model.dataMigrationName);
            migrationProjectIdentifier(model.migrationProjectIdentifier);
            dataMigrationType(model.dataMigrationType);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            enableCloudwatchLogs(model.enableCloudwatchLogs);
            sourceDataSettings(model.sourceDataSettings);
            targetDataSettings(model.targetDataSettings);
            numberOfJobs(model.numberOfJobs);
            tags(model.tags);
            selectionRules(model.selectionRules);
        }

        public final String getDataMigrationName() {
            return dataMigrationName;
        }

        public final void setDataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
        }

        @Override
        public final Builder dataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
            return this;
        }

        public final String getMigrationProjectIdentifier() {
            return migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getDataMigrationType() {
            return dataMigrationType;
        }

        public final void setDataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
        }

        @Override
        public final Builder dataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
            return this;
        }

        @Override
        public final Builder dataMigrationType(MigrationTypeValue dataMigrationType) {
            this.dataMigrationType(dataMigrationType == null ? null : dataMigrationType.toString());
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final Boolean getEnableCloudwatchLogs() {
            return enableCloudwatchLogs;
        }

        public final void setEnableCloudwatchLogs(Boolean enableCloudwatchLogs) {
            this.enableCloudwatchLogs = enableCloudwatchLogs;
        }

        @Override
        public final Builder enableCloudwatchLogs(Boolean enableCloudwatchLogs) {
            this.enableCloudwatchLogs = enableCloudwatchLogs;
            return this;
        }

        public final List<SourceDataSetting.Builder> getSourceDataSettings() {
            List<SourceDataSetting.Builder> result = SourceDataSettingsCopier.copyToBuilder(this.sourceDataSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataSettings(Collection<SourceDataSetting.BuilderImpl> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copyFromBuilder(sourceDataSettings);
        }

        @Override
        public final Builder sourceDataSettings(Collection<SourceDataSetting> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copy(sourceDataSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(SourceDataSetting... sourceDataSettings) {
            sourceDataSettings(Arrays.asList(sourceDataSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(Consumer<SourceDataSetting.Builder>... sourceDataSettings) {
            sourceDataSettings(Stream.of(sourceDataSettings).map(c -> SourceDataSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TargetDataSetting.Builder> getTargetDataSettings() {
            List<TargetDataSetting.Builder> result = TargetDataSettingsCopier.copyToBuilder(this.targetDataSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetDataSettings(Collection<TargetDataSetting.BuilderImpl> targetDataSettings) {
            this.targetDataSettings = TargetDataSettingsCopier.copyFromBuilder(targetDataSettings);
        }

        @Override
        public final Builder targetDataSettings(Collection<TargetDataSetting> targetDataSettings) {
            this.targetDataSettings = TargetDataSettingsCopier.copy(targetDataSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataSettings(TargetDataSetting... targetDataSettings) {
            targetDataSettings(Arrays.asList(targetDataSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataSettings(Consumer<TargetDataSetting.Builder>... targetDataSettings) {
            targetDataSettings(Stream.of(targetDataSettings).map(c -> TargetDataSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getNumberOfJobs() {
            return numberOfJobs;
        }

        public final void setNumberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
        }

        @Override
        public final Builder numberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSelectionRules() {
            return selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataMigrationRequest build() {
            return new CreateDataMigrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
