/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReplicationConfigRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ModifyReplicationConfigRequest.Builder, ModifyReplicationConfigRequest> {
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigArn").getter(getter(ModifyReplicationConfigRequest::replicationConfigArn))
            .setter(setter(Builder::replicationConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build())
            .build();

    private static final SdkField<String> REPLICATION_CONFIG_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigIdentifier")
            .getter(getter(ModifyReplicationConfigRequest::replicationConfigIdentifier))
            .setter(setter(Builder::replicationConfigIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigIdentifier")
                    .build()).build();

    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationType").getter(getter(ModifyReplicationConfigRequest::replicationTypeAsString))
            .setter(setter(Builder::replicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationType").build()).build();

    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableMappings").getter(getter(ModifyReplicationConfigRequest::tableMappings))
            .setter(setter(Builder::tableMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()).build();

    private static final SdkField<String> REPLICATION_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSettings").getter(getter(ModifyReplicationConfigRequest::replicationSettings))
            .setter(setter(Builder::replicationSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSettings").build())
            .build();

    private static final SdkField<String> SUPPLEMENTAL_SETTINGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupplementalSettings").getter(getter(ModifyReplicationConfigRequest::supplementalSettings))
            .setter(setter(Builder::supplementalSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalSettings").build())
            .build();

    private static final SdkField<ComputeConfig> COMPUTE_CONFIG_FIELD = SdkField
            .<ComputeConfig> builder(MarshallingType.SDK_POJO).memberName("ComputeConfig")
            .getter(getter(ModifyReplicationConfigRequest::computeConfig)).setter(setter(Builder::computeConfig))
            .constructor(ComputeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeConfig").build()).build();

    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEndpointArn").getter(getter(ModifyReplicationConfigRequest::sourceEndpointArn))
            .setter(setter(Builder::sourceEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()).build();

    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetEndpointArn").getter(getter(ModifyReplicationConfigRequest::targetEndpointArn))
            .setter(setter(Builder::targetEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_ARN_FIELD,
            REPLICATION_CONFIG_IDENTIFIER_FIELD, REPLICATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_SETTINGS_FIELD,
            SUPPLEMENTAL_SETTINGS_FIELD, COMPUTE_CONFIG_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationConfigArn;

    private final String replicationConfigIdentifier;

    private final String replicationType;

    private final String tableMappings;

    private final String replicationSettings;

    private final String supplementalSettings;

    private final ComputeConfig computeConfig;

    private final String sourceEndpointArn;

    private final String targetEndpointArn;

    private ModifyReplicationConfigRequest(BuilderImpl builder) {
        super(builder);
        this.replicationConfigArn = builder.replicationConfigArn;
        this.replicationConfigIdentifier = builder.replicationConfigIdentifier;
        this.replicationType = builder.replicationType;
        this.tableMappings = builder.tableMappings;
        this.replicationSettings = builder.replicationSettings;
        this.supplementalSettings = builder.supplementalSettings;
        this.computeConfig = builder.computeConfig;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name of the replication to modify.
     * </p>
     * 
     * @return The Amazon Resource Name of the replication to modify.
     */
    public final String replicationConfigArn() {
        return replicationConfigArn;
    }

    /**
     * <p>
     * The new replication config to apply to the replication.
     * </p>
     * 
     * @return The new replication config to apply to the replication.
     */
    public final String replicationConfigIdentifier() {
        return replicationConfigIdentifier;
    }

    /**
     * <p>
     * The type of replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return The type of replication.
     * @see MigrationTypeValue
     */
    public final MigrationTypeValue replicationType() {
        return MigrationTypeValue.fromValue(replicationType);
    }

    /**
     * <p>
     * The type of replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return The type of replication.
     * @see MigrationTypeValue
     */
    public final String replicationTypeAsString() {
        return replicationType;
    }

    /**
     * <p>
     * Table mappings specified in the replication.
     * </p>
     * 
     * @return Table mappings specified in the replication.
     */
    public final String tableMappings() {
        return tableMappings;
    }

    /**
     * <p>
     * The settings for the replication.
     * </p>
     * 
     * @return The settings for the replication.
     */
    public final String replicationSettings() {
        return replicationSettings;
    }

    /**
     * <p>
     * Additional settings for the replication.
     * </p>
     * 
     * @return Additional settings for the replication.
     */
    public final String supplementalSettings() {
        return supplementalSettings;
    }

    /**
     * <p>
     * Configuration parameters for provisioning an DMS Serverless replication.
     * </p>
     * 
     * @return Configuration parameters for provisioning an DMS Serverless replication.
     */
    public final ComputeConfig computeConfig() {
        return computeConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source endpoint for this DMS serverless replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source endpoint for this DMS serverless replication configuration.
     */
    public final String sourceEndpointArn() {
        return sourceEndpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
     */
    public final String targetEndpointArn() {
        return targetEndpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(supplementalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetEndpointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationConfigRequest)) {
            return false;
        }
        ModifyReplicationConfigRequest other = (ModifyReplicationConfigRequest) obj;
        return Objects.equals(replicationConfigArn(), other.replicationConfigArn())
                && Objects.equals(replicationConfigIdentifier(), other.replicationConfigIdentifier())
                && Objects.equals(replicationTypeAsString(), other.replicationTypeAsString())
                && Objects.equals(tableMappings(), other.tableMappings())
                && Objects.equals(replicationSettings(), other.replicationSettings())
                && Objects.equals(supplementalSettings(), other.supplementalSettings())
                && Objects.equals(computeConfig(), other.computeConfig())
                && Objects.equals(sourceEndpointArn(), other.sourceEndpointArn())
                && Objects.equals(targetEndpointArn(), other.targetEndpointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyReplicationConfigRequest").add("ReplicationConfigArn", replicationConfigArn())
                .add("ReplicationConfigIdentifier", replicationConfigIdentifier())
                .add("ReplicationType", replicationTypeAsString()).add("TableMappings", tableMappings())
                .add("ReplicationSettings", replicationSettings()).add("SupplementalSettings", supplementalSettings())
                .add("ComputeConfig", computeConfig()).add("SourceEndpointArn", sourceEndpointArn())
                .add("TargetEndpointArn", targetEndpointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationConfigArn":
            return Optional.ofNullable(clazz.cast(replicationConfigArn()));
        case "ReplicationConfigIdentifier":
            return Optional.ofNullable(clazz.cast(replicationConfigIdentifier()));
        case "ReplicationType":
            return Optional.ofNullable(clazz.cast(replicationTypeAsString()));
        case "TableMappings":
            return Optional.ofNullable(clazz.cast(tableMappings()));
        case "ReplicationSettings":
            return Optional.ofNullable(clazz.cast(replicationSettings()));
        case "SupplementalSettings":
            return Optional.ofNullable(clazz.cast(supplementalSettings()));
        case "ComputeConfig":
            return Optional.ofNullable(clazz.cast(computeConfig()));
        case "SourceEndpointArn":
            return Optional.ofNullable(clazz.cast(sourceEndpointArn()));
        case "TargetEndpointArn":
            return Optional.ofNullable(clazz.cast(targetEndpointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationConfigArn", REPLICATION_CONFIG_ARN_FIELD);
        map.put("ReplicationConfigIdentifier", REPLICATION_CONFIG_IDENTIFIER_FIELD);
        map.put("ReplicationType", REPLICATION_TYPE_FIELD);
        map.put("TableMappings", TABLE_MAPPINGS_FIELD);
        map.put("ReplicationSettings", REPLICATION_SETTINGS_FIELD);
        map.put("SupplementalSettings", SUPPLEMENTAL_SETTINGS_FIELD);
        map.put("ComputeConfig", COMPUTE_CONFIG_FIELD);
        map.put("SourceEndpointArn", SOURCE_ENDPOINT_ARN_FIELD);
        map.put("TargetEndpointArn", TARGET_ENDPOINT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationConfigRequest, T> g) {
        return obj -> g.apply((ModifyReplicationConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyReplicationConfigRequest> {
        /**
         * <p>
         * The Amazon Resource Name of the replication to modify.
         * </p>
         * 
         * @param replicationConfigArn
         *        The Amazon Resource Name of the replication to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigArn(String replicationConfigArn);

        /**
         * <p>
         * The new replication config to apply to the replication.
         * </p>
         * 
         * @param replicationConfigIdentifier
         *        The new replication config to apply to the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigIdentifier(String replicationConfigIdentifier);

        /**
         * <p>
         * The type of replication.
         * </p>
         * 
         * @param replicationType
         *        The type of replication.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder replicationType(String replicationType);

        /**
         * <p>
         * The type of replication.
         * </p>
         * 
         * @param replicationType
         *        The type of replication.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder replicationType(MigrationTypeValue replicationType);

        /**
         * <p>
         * Table mappings specified in the replication.
         * </p>
         * 
         * @param tableMappings
         *        Table mappings specified in the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMappings(String tableMappings);

        /**
         * <p>
         * The settings for the replication.
         * </p>
         * 
         * @param replicationSettings
         *        The settings for the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSettings(String replicationSettings);

        /**
         * <p>
         * Additional settings for the replication.
         * </p>
         * 
         * @param supplementalSettings
         *        Additional settings for the replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supplementalSettings(String supplementalSettings);

        /**
         * <p>
         * Configuration parameters for provisioning an DMS Serverless replication.
         * </p>
         * 
         * @param computeConfig
         *        Configuration parameters for provisioning an DMS Serverless replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeConfig(ComputeConfig computeConfig);

        /**
         * <p>
         * Configuration parameters for provisioning an DMS Serverless replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeConfig.Builder} avoiding the need
         * to create one manually via {@link ComputeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #computeConfig(ComputeConfig)}.
         * 
         * @param computeConfig
         *        a consumer that will call methods on {@link ComputeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeConfig(ComputeConfig)
         */
        default Builder computeConfig(Consumer<ComputeConfig.Builder> computeConfig) {
            return computeConfig(ComputeConfig.builder().applyMutation(computeConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source endpoint for this DMS serverless replication configuration.
         * </p>
         * 
         * @param sourceEndpointArn
         *        The Amazon Resource Name (ARN) of the source endpoint for this DMS serverless replication
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEndpointArn(String sourceEndpointArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication configuration.
         * </p>
         * 
         * @param targetEndpointArn
         *        The Amazon Resource Name (ARN) of the target endpoint for this DMS serverless replication
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEndpointArn(String targetEndpointArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationConfigArn;

        private String replicationConfigIdentifier;

        private String replicationType;

        private String tableMappings;

        private String replicationSettings;

        private String supplementalSettings;

        private ComputeConfig computeConfig;

        private String sourceEndpointArn;

        private String targetEndpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationConfigRequest model) {
            super(model);
            replicationConfigArn(model.replicationConfigArn);
            replicationConfigIdentifier(model.replicationConfigIdentifier);
            replicationType(model.replicationType);
            tableMappings(model.tableMappings);
            replicationSettings(model.replicationSettings);
            supplementalSettings(model.supplementalSettings);
            computeConfig(model.computeConfig);
            sourceEndpointArn(model.sourceEndpointArn);
            targetEndpointArn(model.targetEndpointArn);
        }

        public final String getReplicationConfigArn() {
            return replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final String getReplicationConfigIdentifier() {
            return replicationConfigIdentifier;
        }

        public final void setReplicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
        }

        @Override
        public final Builder replicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
            return this;
        }

        public final String getReplicationType() {
            return replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(MigrationTypeValue replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final String getTableMappings() {
            return tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final String getReplicationSettings() {
            return replicationSettings;
        }

        public final void setReplicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
        }

        @Override
        public final Builder replicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
            return this;
        }

        public final String getSupplementalSettings() {
            return supplementalSettings;
        }

        public final void setSupplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
        }

        @Override
        public final Builder supplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
            return this;
        }

        public final ComputeConfig.Builder getComputeConfig() {
            return computeConfig != null ? computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfig.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfig computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final String getSourceEndpointArn() {
            return sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationConfigRequest build() {
            return new ModifyReplicationConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
