/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines an Oracle endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OracleSettings implements SdkPojo, Serializable, ToCopyableBuilder<OracleSettings.Builder, OracleSettings> {
    private static final SdkField<Boolean> ADD_SUPPLEMENTAL_LOGGING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AddSupplementalLogging").getter(getter(OracleSettings::addSupplementalLogging))
            .setter(setter(Builder::addSupplementalLogging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSupplementalLogging").build())
            .build();

    private static final SdkField<Integer> ARCHIVED_LOG_DEST_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ArchivedLogDestId").getter(getter(OracleSettings::archivedLogDestId))
            .setter(setter(Builder::archivedLogDestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivedLogDestId").build()).build();

    private static final SdkField<Integer> ADDITIONAL_ARCHIVED_LOG_DEST_ID_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AdditionalArchivedLogDestId")
            .getter(getter(OracleSettings::additionalArchivedLogDestId))
            .setter(setter(Builder::additionalArchivedLogDestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalArchivedLogDestId")
                    .build()).build();

    private static final SdkField<List<Integer>> EXTRA_ARCHIVED_LOG_DEST_IDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("ExtraArchivedLogDestIds")
            .getter(getter(OracleSettings::extraArchivedLogDestIds))
            .setter(setter(Builder::extraArchivedLogDestIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraArchivedLogDestIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOW_SELECT_NESTED_TABLES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowSelectNestedTables").getter(getter(OracleSettings::allowSelectNestedTables))
            .setter(setter(Builder::allowSelectNestedTables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSelectNestedTables").build())
            .build();

    private static final SdkField<Integer> PARALLEL_ASM_READ_THREADS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParallelAsmReadThreads").getter(getter(OracleSettings::parallelAsmReadThreads))
            .setter(setter(Builder::parallelAsmReadThreads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelAsmReadThreads").build())
            .build();

    private static final SdkField<Integer> READ_AHEAD_BLOCKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReadAheadBlocks").getter(getter(OracleSettings::readAheadBlocks))
            .setter(setter(Builder::readAheadBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAheadBlocks").build()).build();

    private static final SdkField<Boolean> ACCESS_ALTERNATE_DIRECTLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AccessAlternateDirectly").getter(getter(OracleSettings::accessAlternateDirectly))
            .setter(setter(Builder::accessAlternateDirectly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessAlternateDirectly").build())
            .build();

    private static final SdkField<Boolean> USE_ALTERNATE_FOLDER_FOR_ONLINE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseAlternateFolderForOnline")
            .getter(getter(OracleSettings::useAlternateFolderForOnline))
            .setter(setter(Builder::useAlternateFolderForOnline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseAlternateFolderForOnline")
                    .build()).build();

    private static final SdkField<String> ORACLE_PATH_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OraclePathPrefix").getter(getter(OracleSettings::oraclePathPrefix))
            .setter(setter(Builder::oraclePathPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OraclePathPrefix").build()).build();

    private static final SdkField<String> USE_PATH_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsePathPrefix").getter(getter(OracleSettings::usePathPrefix)).setter(setter(Builder::usePathPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePathPrefix").build()).build();

    private static final SdkField<Boolean> REPLACE_PATH_PREFIX_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReplacePathPrefix").getter(getter(OracleSettings::replacePathPrefix))
            .setter(setter(Builder::replacePathPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacePathPrefix").build()).build();

    private static final SdkField<Boolean> ENABLE_HOMOGENOUS_TABLESPACE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableHomogenousTablespace")
            .getter(getter(OracleSettings::enableHomogenousTablespace))
            .setter(setter(Builder::enableHomogenousTablespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHomogenousTablespace").build())
            .build();

    private static final SdkField<Boolean> DIRECT_PATH_NO_LOG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DirectPathNoLog").getter(getter(OracleSettings::directPathNoLog))
            .setter(setter(Builder::directPathNoLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectPathNoLog").build()).build();

    private static final SdkField<Boolean> ARCHIVED_LOGS_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ArchivedLogsOnly").getter(getter(OracleSettings::archivedLogsOnly))
            .setter(setter(Builder::archivedLogsOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivedLogsOnly").build()).build();

    private static final SdkField<String> ASM_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AsmPassword").getter(getter(OracleSettings::asmPassword)).setter(setter(Builder::asmPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmPassword").build()).build();

    private static final SdkField<String> ASM_SERVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AsmServer").getter(getter(OracleSettings::asmServer)).setter(setter(Builder::asmServer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmServer").build()).build();

    private static final SdkField<String> ASM_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AsmUser").getter(getter(OracleSettings::asmUser)).setter(setter(Builder::asmUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmUser").build()).build();

    private static final SdkField<String> CHAR_LENGTH_SEMANTICS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharLengthSemantics").getter(getter(OracleSettings::charLengthSemanticsAsString))
            .setter(setter(Builder::charLengthSemantics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharLengthSemantics").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(OracleSettings::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<Boolean> DIRECT_PATH_PARALLEL_LOAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DirectPathParallelLoad").getter(getter(OracleSettings::directPathParallelLoad))
            .setter(setter(Builder::directPathParallelLoad))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectPathParallelLoad").build())
            .build();

    private static final SdkField<Boolean> FAIL_TASKS_ON_LOB_TRUNCATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("FailTasksOnLobTruncation")
            .getter(getter(OracleSettings::failTasksOnLobTruncation)).setter(setter(Builder::failTasksOnLobTruncation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailTasksOnLobTruncation").build())
            .build();

    private static final SdkField<Integer> NUMBER_DATATYPE_SCALE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberDatatypeScale").getter(getter(OracleSettings::numberDatatypeScale))
            .setter(setter(Builder::numberDatatypeScale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberDatatypeScale").build())
            .build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(OracleSettings::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(OracleSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Boolean> READ_TABLE_SPACE_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadTableSpaceName").getter(getter(OracleSettings::readTableSpaceName))
            .setter(setter(Builder::readTableSpaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadTableSpaceName").build())
            .build();

    private static final SdkField<Integer> RETRY_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryInterval").getter(getter(OracleSettings::retryInterval)).setter(setter(Builder::retryInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryInterval").build()).build();

    private static final SdkField<String> SECURITY_DB_ENCRYPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityDbEncryption").getter(getter(OracleSettings::securityDbEncryption))
            .setter(setter(Builder::securityDbEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityDbEncryption").build())
            .build();

    private static final SdkField<String> SECURITY_DB_ENCRYPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityDbEncryptionName").getter(getter(OracleSettings::securityDbEncryptionName))
            .setter(setter(Builder::securityDbEncryptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityDbEncryptionName").build())
            .build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(OracleSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> SPATIAL_DATA_OPTION_TO_GEO_JSON_FUNCTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpatialDataOptionToGeoJsonFunctionName")
            .getter(getter(OracleSettings::spatialDataOptionToGeoJsonFunctionName))
            .setter(setter(Builder::spatialDataOptionToGeoJsonFunctionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SpatialDataOptionToGeoJsonFunctionName").build()).build();

    private static final SdkField<Integer> STANDBY_DELAY_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StandbyDelayTime").getter(getter(OracleSettings::standbyDelayTime))
            .setter(setter(Builder::standbyDelayTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandbyDelayTime").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(OracleSettings::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<Boolean> USE_B_FILE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseBFile").getter(getter(OracleSettings::useBFile)).setter(setter(Builder::useBFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBFile").build()).build();

    private static final SdkField<Boolean> USE_DIRECT_PATH_FULL_LOAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseDirectPathFullLoad").getter(getter(OracleSettings::useDirectPathFullLoad))
            .setter(setter(Builder::useDirectPathFullLoad))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDirectPathFullLoad").build())
            .build();

    private static final SdkField<Boolean> USE_LOGMINER_READER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLogminerReader").getter(getter(OracleSettings::useLogminerReader))
            .setter(setter(Builder::useLogminerReader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLogminerReader").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerAccessRoleArn")
            .getter(getter(OracleSettings::secretsManagerAccessRoleArn))
            .setter(setter(Builder::secretsManagerAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn")
                    .build()).build();

    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerSecretId").getter(getter(OracleSettings::secretsManagerSecretId))
            .setter(setter(Builder::secretsManagerSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build())
            .build();

    private static final SdkField<String> SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerOracleAsmAccessRoleArn")
            .getter(getter(OracleSettings::secretsManagerOracleAsmAccessRoleArn))
            .setter(setter(Builder::secretsManagerOracleAsmAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecretsManagerOracleAsmAccessRoleArn").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerOracleAsmSecretId")
            .getter(getter(OracleSettings::secretsManagerOracleAsmSecretId))
            .setter(setter(Builder::secretsManagerOracleAsmSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerOracleAsmSecretId")
                    .build()).build();

    private static final SdkField<Boolean> TRIM_SPACE_IN_CHAR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TrimSpaceInChar").getter(getter(OracleSettings::trimSpaceInChar))
            .setter(setter(Builder::trimSpaceInChar))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrimSpaceInChar").build()).build();

    private static final SdkField<Boolean> CONVERT_TIMESTAMP_WITH_ZONE_TO_UTC_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConvertTimestampWithZoneToUTC")
            .getter(getter(OracleSettings::convertTimestampWithZoneToUTC))
            .setter(setter(Builder::convertTimestampWithZoneToUTC))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConvertTimestampWithZoneToUTC")
                    .build()).build();

    private static final SdkField<Integer> OPEN_TRANSACTION_WINDOW_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OpenTransactionWindow").getter(getter(OracleSettings::openTransactionWindow))
            .setter(setter(Builder::openTransactionWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenTransactionWindow").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMethod").getter(getter(OracleSettings::authenticationMethodAsString))
            .setter(setter(Builder::authenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADD_SUPPLEMENTAL_LOGGING_FIELD, ARCHIVED_LOG_DEST_ID_FIELD, ADDITIONAL_ARCHIVED_LOG_DEST_ID_FIELD,
            EXTRA_ARCHIVED_LOG_DEST_IDS_FIELD, ALLOW_SELECT_NESTED_TABLES_FIELD, PARALLEL_ASM_READ_THREADS_FIELD,
            READ_AHEAD_BLOCKS_FIELD, ACCESS_ALTERNATE_DIRECTLY_FIELD, USE_ALTERNATE_FOLDER_FOR_ONLINE_FIELD,
            ORACLE_PATH_PREFIX_FIELD, USE_PATH_PREFIX_FIELD, REPLACE_PATH_PREFIX_FIELD, ENABLE_HOMOGENOUS_TABLESPACE_FIELD,
            DIRECT_PATH_NO_LOG_FIELD, ARCHIVED_LOGS_ONLY_FIELD, ASM_PASSWORD_FIELD, ASM_SERVER_FIELD, ASM_USER_FIELD,
            CHAR_LENGTH_SEMANTICS_FIELD, DATABASE_NAME_FIELD, DIRECT_PATH_PARALLEL_LOAD_FIELD,
            FAIL_TASKS_ON_LOB_TRUNCATION_FIELD, NUMBER_DATATYPE_SCALE_FIELD, PASSWORD_FIELD, PORT_FIELD,
            READ_TABLE_SPACE_NAME_FIELD, RETRY_INTERVAL_FIELD, SECURITY_DB_ENCRYPTION_FIELD, SECURITY_DB_ENCRYPTION_NAME_FIELD,
            SERVER_NAME_FIELD, SPATIAL_DATA_OPTION_TO_GEO_JSON_FUNCTION_NAME_FIELD, STANDBY_DELAY_TIME_FIELD, USERNAME_FIELD,
            USE_B_FILE_FIELD, USE_DIRECT_PATH_FULL_LOAD_FIELD, USE_LOGMINER_READER_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD,
            SECRETS_MANAGER_SECRET_ID_FIELD, SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD,
            SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD, TRIM_SPACE_IN_CHAR_FIELD, CONVERT_TIMESTAMP_WITH_ZONE_TO_UTC_FIELD,
            OPEN_TRANSACTION_WINDOW_FIELD, AUTHENTICATION_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean addSupplementalLogging;

    private final Integer archivedLogDestId;

    private final Integer additionalArchivedLogDestId;

    private final List<Integer> extraArchivedLogDestIds;

    private final Boolean allowSelectNestedTables;

    private final Integer parallelAsmReadThreads;

    private final Integer readAheadBlocks;

    private final Boolean accessAlternateDirectly;

    private final Boolean useAlternateFolderForOnline;

    private final String oraclePathPrefix;

    private final String usePathPrefix;

    private final Boolean replacePathPrefix;

    private final Boolean enableHomogenousTablespace;

    private final Boolean directPathNoLog;

    private final Boolean archivedLogsOnly;

    private final String asmPassword;

    private final String asmServer;

    private final String asmUser;

    private final String charLengthSemantics;

    private final String databaseName;

    private final Boolean directPathParallelLoad;

    private final Boolean failTasksOnLobTruncation;

    private final Integer numberDatatypeScale;

    private final String password;

    private final Integer port;

    private final Boolean readTableSpaceName;

    private final Integer retryInterval;

    private final String securityDbEncryption;

    private final String securityDbEncryptionName;

    private final String serverName;

    private final String spatialDataOptionToGeoJsonFunctionName;

    private final Integer standbyDelayTime;

    private final String username;

    private final Boolean useBFile;

    private final Boolean useDirectPathFullLoad;

    private final Boolean useLogminerReader;

    private final String secretsManagerAccessRoleArn;

    private final String secretsManagerSecretId;

    private final String secretsManagerOracleAsmAccessRoleArn;

    private final String secretsManagerOracleAsmSecretId;

    private final Boolean trimSpaceInChar;

    private final Boolean convertTimestampWithZoneToUTC;

    private final Integer openTransactionWindow;

    private final String authenticationMethod;

    private OracleSettings(BuilderImpl builder) {
        this.addSupplementalLogging = builder.addSupplementalLogging;
        this.archivedLogDestId = builder.archivedLogDestId;
        this.additionalArchivedLogDestId = builder.additionalArchivedLogDestId;
        this.extraArchivedLogDestIds = builder.extraArchivedLogDestIds;
        this.allowSelectNestedTables = builder.allowSelectNestedTables;
        this.parallelAsmReadThreads = builder.parallelAsmReadThreads;
        this.readAheadBlocks = builder.readAheadBlocks;
        this.accessAlternateDirectly = builder.accessAlternateDirectly;
        this.useAlternateFolderForOnline = builder.useAlternateFolderForOnline;
        this.oraclePathPrefix = builder.oraclePathPrefix;
        this.usePathPrefix = builder.usePathPrefix;
        this.replacePathPrefix = builder.replacePathPrefix;
        this.enableHomogenousTablespace = builder.enableHomogenousTablespace;
        this.directPathNoLog = builder.directPathNoLog;
        this.archivedLogsOnly = builder.archivedLogsOnly;
        this.asmPassword = builder.asmPassword;
        this.asmServer = builder.asmServer;
        this.asmUser = builder.asmUser;
        this.charLengthSemantics = builder.charLengthSemantics;
        this.databaseName = builder.databaseName;
        this.directPathParallelLoad = builder.directPathParallelLoad;
        this.failTasksOnLobTruncation = builder.failTasksOnLobTruncation;
        this.numberDatatypeScale = builder.numberDatatypeScale;
        this.password = builder.password;
        this.port = builder.port;
        this.readTableSpaceName = builder.readTableSpaceName;
        this.retryInterval = builder.retryInterval;
        this.securityDbEncryption = builder.securityDbEncryption;
        this.securityDbEncryptionName = builder.securityDbEncryptionName;
        this.serverName = builder.serverName;
        this.spatialDataOptionToGeoJsonFunctionName = builder.spatialDataOptionToGeoJsonFunctionName;
        this.standbyDelayTime = builder.standbyDelayTime;
        this.username = builder.username;
        this.useBFile = builder.useBFile;
        this.useDirectPathFullLoad = builder.useDirectPathFullLoad;
        this.useLogminerReader = builder.useLogminerReader;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.secretsManagerOracleAsmAccessRoleArn = builder.secretsManagerOracleAsmAccessRoleArn;
        this.secretsManagerOracleAsmSecretId = builder.secretsManagerOracleAsmSecretId;
        this.trimSpaceInChar = builder.trimSpaceInChar;
        this.convertTimestampWithZoneToUTC = builder.convertTimestampWithZoneToUTC;
        this.openTransactionWindow = builder.openTransactionWindow;
        this.authenticationMethod = builder.authenticationMethod;
    }

    /**
     * <p>
     * Set this attribute to set up table-level supplemental logging for the Oracle database. This attribute enables
     * PRIMARY KEY supplemental logging on all tables selected for a migration task.
     * </p>
     * <p>
     * If you use this option, you still need to enable database-level supplemental logging.
     * </p>
     * 
     * @return Set this attribute to set up table-level supplemental logging for the Oracle database. This attribute
     *         enables PRIMARY KEY supplemental logging on all tables selected for a migration task.</p>
     *         <p>
     *         If you use this option, you still need to enable database-level supplemental logging.
     */
    public final Boolean addSupplementalLogging() {
        return addSupplementalLogging;
    }

    /**
     * <p>
     * Specifies the ID of the destination for the archived redo logs. This value should be the same as a number in the
     * dest_id column of the v$archived_log view. If you work with an additional redo log destination, use the
     * <code>AdditionalArchivedLogDestId</code> option to specify the additional destination ID. Doing this improves
     * performance by ensuring that the correct logs are accessed from the outset.
     * </p>
     * 
     * @return Specifies the ID of the destination for the archived redo logs. This value should be the same as a number
     *         in the dest_id column of the v$archived_log view. If you work with an additional redo log destination,
     *         use the <code>AdditionalArchivedLogDestId</code> option to specify the additional destination ID. Doing
     *         this improves performance by ensuring that the correct logs are accessed from the outset.
     */
    public final Integer archivedLogDestId() {
        return archivedLogDestId;
    }

    /**
     * <p>
     * Set this attribute with <code>ArchivedLogDestId</code> in a primary/ standby setup. This attribute is useful in
     * the case of a switchover. In this case, DMS needs to know which destination to get archive redo logs from to read
     * changes. This need arises because the previous primary instance is now a standby instance after switchover.
     * </p>
     * <p>
     * Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use
     * <code>RESETLOGS</code> unless necessary. For additional information about <code>RESETLOGS</code>, see <a href=
     * "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
     * >RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
     * </p>
     * 
     * @return Set this attribute with <code>ArchivedLogDestId</code> in a primary/ standby setup. This attribute is
     *         useful in the case of a switchover. In this case, DMS needs to know which destination to get archive redo
     *         logs from to read changes. This need arises because the previous primary instance is now a standby
     *         instance after switchover.</p>
     *         <p>
     *         Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use
     *         <code>RESETLOGS</code> unless necessary. For additional information about <code>RESETLOGS</code>, see <a
     *         href=
     *         "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
     *         >RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
     */
    public final Integer additionalArchivedLogDestId() {
        return additionalArchivedLogDestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtraArchivedLogDestIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExtraArchivedLogDestIds() {
        return extraArchivedLogDestIds != null && !(extraArchivedLogDestIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the values of the
     * <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting with the
     * <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a
     * primary-to-multiple-standby setup.
     * </p>
     * <p>
     * This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case, DMS
     * needs information about what destination to get archive redo logs from to read changes. DMS needs this because
     * after the switchover the previous primary is a standby instance. For example, in a primary-to-single standby
     * setup you might apply the following settings.
     * </p>
     * <p>
     * <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
     * </p>
     * <p>
     * In a primary-to-multiple-standby setup, you might apply the following settings.
     * </p>
     * <p>
     * <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
     * </p>
     * <p>
     * Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use
     * <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code>, see <a href=
     * "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
     * > RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtraArchivedLogDestIds} method.
     * </p>
     * 
     * @return Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the values
     *         of the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting with the
     *         <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a
     *         primary-to-multiple-standby setup. </p>
     *         <p>
     *         This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this
     *         case, DMS needs information about what destination to get archive redo logs from to read changes. DMS
     *         needs this because after the switchover the previous primary is a standby instance. For example, in a
     *         primary-to-single standby setup you might apply the following settings.
     *         </p>
     *         <p>
     *         <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
     *         </p>
     *         <p>
     *         In a primary-to-multiple-standby setup, you might apply the following settings.
     *         </p>
     *         <p>
     *         <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
     *         </p>
     *         <p>
     *         Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use
     *         <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code>, see <a
     *         href=
     *         "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
     *         > RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
     */
    public final List<Integer> extraArchivedLogDestIds() {
        return extraArchivedLogDestIds;
    }

    /**
     * <p>
     * Set this attribute to <code>true</code> to enable replication of Oracle tables containing columns that are nested
     * tables or defined types.
     * </p>
     * 
     * @return Set this attribute to <code>true</code> to enable replication of Oracle tables containing columns that
     *         are nested tables or defined types.
     */
    public final Boolean allowSelectNestedTables() {
        return allowSelectNestedTables;
    }

    /**
     * <p>
     * Set this attribute to change the number of threads that DMS configures to perform a change data capture (CDC)
     * load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 2 (the default)
     * and 8 (the maximum). Use this attribute together with the <code>readAheadBlocks</code> attribute.
     * </p>
     * 
     * @return Set this attribute to change the number of threads that DMS configures to perform a change data capture
     *         (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 2
     *         (the default) and 8 (the maximum). Use this attribute together with the <code>readAheadBlocks</code>
     *         attribute.
     */
    public final Integer parallelAsmReadThreads() {
        return parallelAsmReadThreads;
    }

    /**
     * <p>
     * Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change data capture
     * (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 1000 (the
     * default) and 200,000 (the maximum).
     * </p>
     * 
     * @return Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change data
     *         capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value
     *         between 1000 (the default) and 200,000 (the maximum).
     */
    public final Integer readAheadBlocks() {
        return readAheadBlocks;
    }

    /**
     * <p>
     * Set this attribute to <code>false</code> in order to use the Binary Reader to capture change data for an Amazon
     * RDS for Oracle as the source. This tells the DMS instance to not access redo logs through any specified path
     * prefix replacement using direct file access.
     * </p>
     * 
     * @return Set this attribute to <code>false</code> in order to use the Binary Reader to capture change data for an
     *         Amazon RDS for Oracle as the source. This tells the DMS instance to not access redo logs through any
     *         specified path prefix replacement using direct file access.
     */
    public final Boolean accessAlternateDirectly() {
        return accessAlternateDirectly;
    }

    /**
     * <p>
     * Set this attribute to <code>true</code> in order to use the Binary Reader to capture change data for an Amazon
     * RDS for Oracle as the source. This tells the DMS instance to use any specified prefix replacement to access all
     * online redo logs.
     * </p>
     * 
     * @return Set this attribute to <code>true</code> in order to use the Binary Reader to capture change data for an
     *         Amazon RDS for Oracle as the source. This tells the DMS instance to use any specified prefix replacement
     *         to access all online redo logs.
     */
    public final Boolean useAlternateFolderForOnline() {
        return useAlternateFolderForOnline;
    }

    /**
     * <p>
     * Set this string attribute to the required value in order to use the Binary Reader to capture change data for an
     * Amazon RDS for Oracle as the source. This value specifies the default Oracle root used to access the redo logs.
     * </p>
     * 
     * @return Set this string attribute to the required value in order to use the Binary Reader to capture change data
     *         for an Amazon RDS for Oracle as the source. This value specifies the default Oracle root used to access
     *         the redo logs.
     */
    public final String oraclePathPrefix() {
        return oraclePathPrefix;
    }

    /**
     * <p>
     * Set this string attribute to the required value in order to use the Binary Reader to capture change data for an
     * Amazon RDS for Oracle as the source. This value specifies the path prefix used to replace the default Oracle root
     * to access the redo logs.
     * </p>
     * 
     * @return Set this string attribute to the required value in order to use the Binary Reader to capture change data
     *         for an Amazon RDS for Oracle as the source. This value specifies the path prefix used to replace the
     *         default Oracle root to access the redo logs.
     */
    public final String usePathPrefix() {
        return usePathPrefix;
    }

    /**
     * <p>
     * Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle
     * as the source. This setting tells DMS instance to replace the default Oracle root with the specified
     * <code>usePathPrefix</code> setting to access the redo logs.
     * </p>
     * 
     * @return Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for
     *         Oracle as the source. This setting tells DMS instance to replace the default Oracle root with the
     *         specified <code>usePathPrefix</code> setting to access the redo logs.
     */
    public final Boolean replacePathPrefix() {
        return replacePathPrefix;
    }

    /**
     * <p>
     * Set this attribute to enable homogenous tablespace replication and create existing tables or indexes under the
     * same tablespace on the target.
     * </p>
     * 
     * @return Set this attribute to enable homogenous tablespace replication and create existing tables or indexes
     *         under the same tablespace on the target.
     */
    public final Boolean enableHomogenousTablespace() {
        return enableHomogenousTablespace;
    }

    /**
     * <p>
     * When set to <code>true</code>, this attribute helps to increase the commit rate on the Oracle target database by
     * writing directly to tables and not writing a trail to database logs.
     * </p>
     * 
     * @return When set to <code>true</code>, this attribute helps to increase the commit rate on the Oracle target
     *         database by writing directly to tables and not writing a trail to database logs.
     */
    public final Boolean directPathNoLog() {
        return directPathNoLog;
    }

    /**
     * <p>
     * When this field is set to <code>True</code>, DMS only accesses the archived redo logs. If the archived redo logs
     * are stored on Automatic Storage Management (ASM) only, the DMS user account needs to be granted ASM privileges.
     * </p>
     * 
     * @return When this field is set to <code>True</code>, DMS only accesses the archived redo logs. If the archived
     *         redo logs are stored on Automatic Storage Management (ASM) only, the DMS user account needs to be granted
     *         ASM privileges.
     */
    public final Boolean archivedLogsOnly() {
        return archivedLogsOnly;
    }

    /**
     * <p>
     * For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password. You can set this value
     * from the <code> <i>asm_user_password</i> </code> value. You set this value as part of the comma-separated value
     * that you set to the <code>Password</code> request parameter when you create the endpoint to access transaction
     * logs using Binary Reader. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
     * >Configuration for change data capture (CDC) on an Oracle source database</a>.
     * </p>
     * 
     * @return For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password. You can set this
     *         value from the <code> <i>asm_user_password</i> </code> value. You set this value as part of the
     *         comma-separated value that you set to the <code>Password</code> request parameter when you create the
     *         endpoint to access transaction logs using Binary Reader. For more information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
     *         >Configuration for change data capture (CDC) on an Oracle source database</a>.
     */
    public final String asmPassword() {
        return asmPassword;
    }

    /**
     * <p>
     * For an Oracle source endpoint, your ASM server address. You can set this value from the <code>asm_server</code>
     * value. You set <code>asm_server</code> as part of the extra connection attribute string to access an Oracle
     * server with Binary Reader that uses ASM. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
     * >Configuration for change data capture (CDC) on an Oracle source database</a>.
     * </p>
     * 
     * @return For an Oracle source endpoint, your ASM server address. You can set this value from the
     *         <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute
     *         string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
     *         >Configuration for change data capture (CDC) on an Oracle source database</a>.
     */
    public final String asmServer() {
        return asmServer;
    }

    /**
     * <p>
     * For an Oracle source endpoint, your ASM user name. You can set this value from the <code>asm_user</code> value.
     * You set <code>asm_user</code> as part of the extra connection attribute string to access an Oracle server with
     * Binary Reader that uses ASM. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
     * >Configuration for change data capture (CDC) on an Oracle source database</a>.
     * </p>
     * 
     * @return For an Oracle source endpoint, your ASM user name. You can set this value from the <code>asm_user</code>
     *         value. You set <code>asm_user</code> as part of the extra connection attribute string to access an Oracle
     *         server with Binary Reader that uses ASM. For more information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
     *         >Configuration for change data capture (CDC) on an Oracle source database</a>.
     */
    public final String asmUser() {
        return asmUser;
    }

    /**
     * <p>
     * Specifies whether the length of a character column is in bytes or in characters. To indicate that the character
     * column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the character column length
     * is in bytes.
     * </p>
     * <p>
     * Example: <code>charLengthSemantics=CHAR;</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #charLengthSemantics} will return {@link CharLengthSemantics#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #charLengthSemanticsAsString}.
     * </p>
     * 
     * @return Specifies whether the length of a character column is in bytes or in characters. To indicate that the
     *         character column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the
     *         character column length is in bytes.</p>
     *         <p>
     *         Example: <code>charLengthSemantics=CHAR;</code>
     * @see CharLengthSemantics
     */
    public final CharLengthSemantics charLengthSemantics() {
        return CharLengthSemantics.fromValue(charLengthSemantics);
    }

    /**
     * <p>
     * Specifies whether the length of a character column is in bytes or in characters. To indicate that the character
     * column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the character column length
     * is in bytes.
     * </p>
     * <p>
     * Example: <code>charLengthSemantics=CHAR;</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #charLengthSemantics} will return {@link CharLengthSemantics#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #charLengthSemanticsAsString}.
     * </p>
     * 
     * @return Specifies whether the length of a character column is in bytes or in characters. To indicate that the
     *         character column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the
     *         character column length is in bytes.</p>
     *         <p>
     *         Example: <code>charLengthSemantics=CHAR;</code>
     * @see CharLengthSemantics
     */
    public final String charLengthSemanticsAsString() {
        return charLengthSemantics;
    }

    /**
     * <p>
     * Database name for the endpoint.
     * </p>
     * 
     * @return Database name for the endpoint.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * When set to <code>true</code>, this attribute specifies a parallel load when <code>useDirectPathFullLoad</code>
     * is set to <code>Y</code>. This attribute also only applies when you use the DMS parallel load feature. Note that
     * the target table cannot have any constraints or indexes.
     * </p>
     * 
     * @return When set to <code>true</code>, this attribute specifies a parallel load when
     *         <code>useDirectPathFullLoad</code> is set to <code>Y</code>. This attribute also only applies when you
     *         use the DMS parallel load feature. Note that the target table cannot have any constraints or indexes.
     */
    public final Boolean directPathParallelLoad() {
        return directPathParallelLoad;
    }

    /**
     * <p>
     * When set to <code>true</code>, this attribute causes a task to fail if the actual size of an LOB column is
     * greater than the specified <code>LobMaxSize</code>.
     * </p>
     * <p>
     * If a task is set to limited LOB mode and this option is set to <code>true</code>, the task fails instead of
     * truncating the LOB data.
     * </p>
     * 
     * @return When set to <code>true</code>, this attribute causes a task to fail if the actual size of an LOB column
     *         is greater than the specified <code>LobMaxSize</code>.</p>
     *         <p>
     *         If a task is set to limited LOB mode and this option is set to <code>true</code>, the task fails instead
     *         of truncating the LOB data.
     */
    public final Boolean failTasksOnLobTruncation() {
        return failTasksOnLobTruncation;
    }

    /**
     * <p>
     * Specifies the number scale. You can select a scale up to 38, or you can select FLOAT. By default, the NUMBER data
     * type is converted to precision 38, scale 10.
     * </p>
     * <p>
     * Example: <code>numberDataTypeScale=12</code>
     * </p>
     * 
     * @return Specifies the number scale. You can select a scale up to 38, or you can select FLOAT. By default, the
     *         NUMBER data type is converted to precision 38, scale 10.</p>
     *         <p>
     *         Example: <code>numberDataTypeScale=12</code>
     */
    public final Integer numberDatatypeScale() {
        return numberDatatypeScale;
    }

    /**
     * <p>
     * Endpoint connection password.
     * </p>
     * 
     * @return Endpoint connection password.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * Endpoint TCP port.
     * </p>
     * 
     * @return Endpoint TCP port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * When set to <code>true</code>, this attribute supports tablespace replication.
     * </p>
     * 
     * @return When set to <code>true</code>, this attribute supports tablespace replication.
     */
    public final Boolean readTableSpaceName() {
        return readTableSpaceName;
    }

    /**
     * <p>
     * Specifies the number of seconds that the system waits before resending a query.
     * </p>
     * <p>
     * Example: <code>retryInterval=6;</code>
     * </p>
     * 
     * @return Specifies the number of seconds that the system waits before resending a query.</p>
     *         <p>
     *         Example: <code>retryInterval=6;</code>
     */
    public final Integer retryInterval() {
        return retryInterval;
    }

    /**
     * <p>
     * For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to access
     * Oracle redo logs encrypted by TDE using Binary Reader. It is also the <code> <i>TDE_Password</i> </code> part of
     * the comma-separated value you set to the <code>Password</code> request parameter when you create the endpoint.
     * The <code>SecurityDbEncryptian</code> setting is related to this <code>SecurityDbEncryptionName</code> setting.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption">
     * Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration Service User
     * Guide</i>.
     * </p>
     * 
     * @return For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to
     *         access Oracle redo logs encrypted by TDE using Binary Reader. It is also the
     *         <code> <i>TDE_Password</i> </code> part of the comma-separated value you set to the <code>Password</code>
     *         request parameter when you create the endpoint. The <code>SecurityDbEncryptian</code> setting is related
     *         to this <code>SecurityDbEncryptionName</code> setting. For more information, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"
     *         > Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration
     *         Service User Guide</i>.
     */
    public final String securityDbEncryption() {
        return securityDbEncryption;
    }

    /**
     * <p>
     * For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the columns
     * and tablespaces in an Oracle source database that is encrypted using TDE. The key value is the value of the
     * <code>SecurityDbEncryption</code> setting. For more information on setting the key name value of
     * <code>SecurityDbEncryptionName</code>, see the information and example for setting the
     * <code>securityDbEncryptionName</code> extra connection attribute in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption">
     * Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration Service User
     * Guide</i>.
     * </p>
     * 
     * @return For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the
     *         columns and tablespaces in an Oracle source database that is encrypted using TDE. The key value is the
     *         value of the <code>SecurityDbEncryption</code> setting. For more information on setting the key name
     *         value of <code>SecurityDbEncryptionName</code>, see the information and example for setting the
     *         <code>securityDbEncryptionName</code> extra connection attribute in <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"
     *         > Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration
     *         Service User Guide</i>.
     */
    public final String securityDbEncryptionName() {
        return securityDbEncryptionName;
    }

    /**
     * <p>
     * Fully qualified domain name of the endpoint.
     * </p>
     * <p>
     * For an Amazon RDS Oracle instance, this is the output of <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html"
     * >DescribeDBInstances</a>, in the
     * <code> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address</code>
     * field.
     * </p>
     * 
     * @return Fully qualified domain name of the endpoint.</p>
     *         <p>
     *         For an Amazon RDS Oracle instance, this is the output of <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html"
     *         >DescribeDBInstances</a>, in the
     *         <code> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address</code>
     *         field.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * Use this attribute to convert <code>SDO_GEOMETRY</code> to <code>GEOJSON</code> format. By default, DMS calls the
     * <code>SDO2GEOJSON</code> custom function if present and accessible. Or you can create your own custom function
     * that mimics the operation of <code>SDOGEOJSON</code> and set <code>SpatialDataOptionToGeoJsonFunctionName</code>
     * to call it instead.
     * </p>
     * 
     * @return Use this attribute to convert <code>SDO_GEOMETRY</code> to <code>GEOJSON</code> format. By default, DMS
     *         calls the <code>SDO2GEOJSON</code> custom function if present and accessible. Or you can create your own
     *         custom function that mimics the operation of <code>SDOGEOJSON</code> and set
     *         <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead.
     */
    public final String spatialDataOptionToGeoJsonFunctionName() {
        return spatialDataOptionToGeoJsonFunctionName;
    }

    /**
     * <p>
     * Use this attribute to specify a time in minutes for the delay in standby sync. If the source is an Oracle Active
     * Data Guard standby database, use this attribute to specify the time lag between primary and standby databases.
     * </p>
     * <p>
     * In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source for
     * replicating ongoing changes. Doing this eliminates the need to connect to an active database that might be in
     * production.
     * </p>
     * 
     * @return Use this attribute to specify a time in minutes for the delay in standby sync. If the source is an Oracle
     *         Active Data Guard standby database, use this attribute to specify the time lag between primary and
     *         standby databases.</p>
     *         <p>
     *         In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source for
     *         replicating ongoing changes. Doing this eliminates the need to connect to an active database that might
     *         be in production.
     */
    public final Integer standbyDelayTime() {
        return standbyDelayTime;
    }

    /**
     * <p>
     * Endpoint connection user name.
     * </p>
     * 
     * @return Endpoint connection user name.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * Set this attribute to True to capture change data using the Binary Reader utility. Set
     * <code>UseLogminerReader</code> to False to set this attribute to True. To use Binary Reader with Amazon RDS for
     * Oracle as the source, you set additional attributes. For more information about using this setting with Oracle
     * Automatic Storage Management (ASM), see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using
     * Oracle LogMiner or DMS Binary Reader for CDC</a>.
     * </p>
     * 
     * @return Set this attribute to True to capture change data using the Binary Reader utility. Set
     *         <code>UseLogminerReader</code> to False to set this attribute to True. To use Binary Reader with Amazon
     *         RDS for Oracle as the source, you set additional attributes. For more information about using this
     *         setting with Oracle Automatic Storage Management (ASM), see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">
     *         Using Oracle LogMiner or DMS Binary Reader for CDC</a>.
     */
    public final Boolean useBFile() {
        return useBFile;
    }

    /**
     * <p>
     * Set this attribute to True to have DMS use a direct path full load. Specify this value to use the direct path
     * protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle target tables
     * during a full load.
     * </p>
     * 
     * @return Set this attribute to True to have DMS use a direct path full load. Specify this value to use the direct
     *         path protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle
     *         target tables during a full load.
     */
    public final Boolean useDirectPathFullLoad() {
        return useDirectPathFullLoad;
    }

    /**
     * <p>
     * Set this attribute to True to capture change data using the Oracle LogMiner utility (the default). Set this
     * attribute to False if you want to access the redo logs as a binary file. When you set
     * <code>UseLogminerReader</code> to False, also set <code>UseBfile</code> to True. For more information on this
     * setting and using Oracle ASM, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using
     * Oracle LogMiner or DMS Binary Reader for CDC</a> in the <i>DMS User Guide</i>.
     * </p>
     * 
     * @return Set this attribute to True to capture change data using the Oracle LogMiner utility (the default). Set
     *         this attribute to False if you want to access the redo logs as a binary file. When you set
     *         <code>UseLogminerReader</code> to False, also set <code>UseBfile</code> to True. For more information on
     *         this setting and using Oracle ASM, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">
     *         Using Oracle LogMiner or DMS Binary Reader for CDC</a> in the <i>DMS User Guide</i>.
     */
    public final Boolean useLogminerReader() {
        return useLogminerReader;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the
     * required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the
     * <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services
     * Secrets Manager secret that allows access to the Oracle endpoint.
     * </p>
     * <note>
     * <p>
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and
     * <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
     * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
     * information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code>
     * and <code>SecretsManagerSecretId</code> required to access it, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using
     * secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants
     *         the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow
     *         the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web
     *         Services Secrets Manager secret that allows access to the Oracle endpoint.</p> <note>
     *         <p>
     *         You can specify one of two sets of values for these permissions. You can specify the values for this
     *         setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
     *         <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't
     *         specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
     *         <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it,
     *         see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
     *         >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
     *         User Guide</i>.
     *         </p>
     */
    public final String secretsManagerAccessRoleArn() {
        return secretsManagerAccessRoleArn;
    }

    /**
     * <p>
     * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Oracle
     * endpoint connection details.
     * </p>
     * 
     * @return The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
     *         Oracle endpoint connection details.
     */
    public final String secretsManagerSecretId() {
        return secretsManagerSecretId;
    }

    /**
     * <p>
     * Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN of the IAM role that
     * specifies DMS as the trusted entity and grants the required permissions to access the
     * <code>SecretsManagerOracleAsmSecret</code>. This <code>SecretsManagerOracleAsmSecret</code> has the secret value
     * that allows access to the Oracle ASM of the endpoint.
     * </p>
     * <note>
     * <p>
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and
     * <code>SecretsManagerOracleAsmSecretId</code>. Or you can specify clear-text values for <code>AsmUser</code>,
     * <code>AsmPassword</code>, and <code>AsmServerName</code>. You can't specify both. For more information on
     * creating this <code>SecretsManagerOracleAsmSecret</code> and the
     * <code>SecretsManagerOracleAsmAccessRoleArn</code> and <code>SecretsManagerOracleAsmSecretId</code> required to
     * access it, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using
     * secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * </note>
     * 
     * @return Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN of the IAM
     *         role that specifies DMS as the trusted entity and grants the required permissions to access the
     *         <code>SecretsManagerOracleAsmSecret</code>. This <code>SecretsManagerOracleAsmSecret</code> has the
     *         secret value that allows access to the Oracle ASM of the endpoint.</p> <note>
     *         <p>
     *         You can specify one of two sets of values for these permissions. You can specify the values for this
     *         setting and <code>SecretsManagerOracleAsmSecretId</code>. Or you can specify clear-text values for
     *         <code>AsmUser</code>, <code>AsmPassword</code>, and <code>AsmServerName</code>. You can't specify both.
     *         For more information on creating this <code>SecretsManagerOracleAsmSecret</code> and the
     *         <code>SecretsManagerOracleAsmAccessRoleArn</code> and <code>SecretsManagerOracleAsmSecretId</code>
     *         required to access it, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
     *         >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
     *         User Guide</i>.
     *         </p>
     */
    public final String secretsManagerOracleAsmAccessRoleArn() {
        return secretsManagerOracleAsmAccessRoleArn;
    }

    /**
     * <p>
     * Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN, partial ARN, or
     * friendly name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM connection details
     * for the Oracle endpoint.
     * </p>
     * 
     * @return Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN, partial ARN,
     *         or friendly name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM
     *         connection details for the Oracle endpoint.
     */
    public final String secretsManagerOracleAsmSecretId() {
        return secretsManagerOracleAsmSecretId;
    }

    /**
     * <p>
     * Use the <code>TrimSpaceInChar</code> source endpoint setting to trim data on CHAR and NCHAR data types during
     * migration. The default value is <code>true</code>.
     * </p>
     * 
     * @return Use the <code>TrimSpaceInChar</code> source endpoint setting to trim data on CHAR and NCHAR data types
     *         during migration. The default value is <code>true</code>.
     */
    public final Boolean trimSpaceInChar() {
        return trimSpaceInChar;
    }

    /**
     * <p>
     * When true, converts timestamps with the <code>timezone</code> datatype to their UTC value.
     * </p>
     * 
     * @return When true, converts timestamps with the <code>timezone</code> datatype to their UTC value.
     */
    public final Boolean convertTimestampWithZoneToUTC() {
        return convertTimestampWithZoneToUTC;
    }

    /**
     * <p>
     * The timeframe in minutes to check for open transactions for a CDC-only task.
     * </p>
     * <p>
     * You can specify an integer value between 0 (the default) and 240 (the maximum).
     * </p>
     * <note>
     * <p>
     * This parameter is only valid in DMS version 3.5.0 and later.
     * </p>
     * </note>
     * 
     * @return The timeframe in minutes to check for open transactions for a CDC-only task.</p>
     *         <p>
     *         You can specify an integer value between 0 (the default) and 240 (the maximum).
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is only valid in DMS version 3.5.0 and later.
     *         </p>
     */
    public final Integer openTransactionWindow() {
        return openTransactionWindow;
    }

    /**
     * <p>
     * Specifies the authentication method to be used with Oracle.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethod} will return {@link OracleAuthenticationMethod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodAsString}.
     * </p>
     * 
     * @return Specifies the authentication method to be used with Oracle.
     * @see OracleAuthenticationMethod
     */
    public final OracleAuthenticationMethod authenticationMethod() {
        return OracleAuthenticationMethod.fromValue(authenticationMethod);
    }

    /**
     * <p>
     * Specifies the authentication method to be used with Oracle.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethod} will return {@link OracleAuthenticationMethod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodAsString}.
     * </p>
     * 
     * @return Specifies the authentication method to be used with Oracle.
     * @see OracleAuthenticationMethod
     */
    public final String authenticationMethodAsString() {
        return authenticationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addSupplementalLogging());
        hashCode = 31 * hashCode + Objects.hashCode(archivedLogDestId());
        hashCode = 31 * hashCode + Objects.hashCode(additionalArchivedLogDestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasExtraArchivedLogDestIds() ? extraArchivedLogDestIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowSelectNestedTables());
        hashCode = 31 * hashCode + Objects.hashCode(parallelAsmReadThreads());
        hashCode = 31 * hashCode + Objects.hashCode(readAheadBlocks());
        hashCode = 31 * hashCode + Objects.hashCode(accessAlternateDirectly());
        hashCode = 31 * hashCode + Objects.hashCode(useAlternateFolderForOnline());
        hashCode = 31 * hashCode + Objects.hashCode(oraclePathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(usePathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(replacePathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(enableHomogenousTablespace());
        hashCode = 31 * hashCode + Objects.hashCode(directPathNoLog());
        hashCode = 31 * hashCode + Objects.hashCode(archivedLogsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(asmPassword());
        hashCode = 31 * hashCode + Objects.hashCode(asmServer());
        hashCode = 31 * hashCode + Objects.hashCode(asmUser());
        hashCode = 31 * hashCode + Objects.hashCode(charLengthSemanticsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(directPathParallelLoad());
        hashCode = 31 * hashCode + Objects.hashCode(failTasksOnLobTruncation());
        hashCode = 31 * hashCode + Objects.hashCode(numberDatatypeScale());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(readTableSpaceName());
        hashCode = 31 * hashCode + Objects.hashCode(retryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(securityDbEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(securityDbEncryptionName());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(spatialDataOptionToGeoJsonFunctionName());
        hashCode = 31 * hashCode + Objects.hashCode(standbyDelayTime());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(useBFile());
        hashCode = 31 * hashCode + Objects.hashCode(useDirectPathFullLoad());
        hashCode = 31 * hashCode + Objects.hashCode(useLogminerReader());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerOracleAsmAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerOracleAsmSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(trimSpaceInChar());
        hashCode = 31 * hashCode + Objects.hashCode(convertTimestampWithZoneToUTC());
        hashCode = 31 * hashCode + Objects.hashCode(openTransactionWindow());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OracleSettings)) {
            return false;
        }
        OracleSettings other = (OracleSettings) obj;
        return Objects.equals(addSupplementalLogging(), other.addSupplementalLogging())
                && Objects.equals(archivedLogDestId(), other.archivedLogDestId())
                && Objects.equals(additionalArchivedLogDestId(), other.additionalArchivedLogDestId())
                && hasExtraArchivedLogDestIds() == other.hasExtraArchivedLogDestIds()
                && Objects.equals(extraArchivedLogDestIds(), other.extraArchivedLogDestIds())
                && Objects.equals(allowSelectNestedTables(), other.allowSelectNestedTables())
                && Objects.equals(parallelAsmReadThreads(), other.parallelAsmReadThreads())
                && Objects.equals(readAheadBlocks(), other.readAheadBlocks())
                && Objects.equals(accessAlternateDirectly(), other.accessAlternateDirectly())
                && Objects.equals(useAlternateFolderForOnline(), other.useAlternateFolderForOnline())
                && Objects.equals(oraclePathPrefix(), other.oraclePathPrefix())
                && Objects.equals(usePathPrefix(), other.usePathPrefix())
                && Objects.equals(replacePathPrefix(), other.replacePathPrefix())
                && Objects.equals(enableHomogenousTablespace(), other.enableHomogenousTablespace())
                && Objects.equals(directPathNoLog(), other.directPathNoLog())
                && Objects.equals(archivedLogsOnly(), other.archivedLogsOnly())
                && Objects.equals(asmPassword(), other.asmPassword()) && Objects.equals(asmServer(), other.asmServer())
                && Objects.equals(asmUser(), other.asmUser())
                && Objects.equals(charLengthSemanticsAsString(), other.charLengthSemanticsAsString())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(directPathParallelLoad(), other.directPathParallelLoad())
                && Objects.equals(failTasksOnLobTruncation(), other.failTasksOnLobTruncation())
                && Objects.equals(numberDatatypeScale(), other.numberDatatypeScale())
                && Objects.equals(password(), other.password()) && Objects.equals(port(), other.port())
                && Objects.equals(readTableSpaceName(), other.readTableSpaceName())
                && Objects.equals(retryInterval(), other.retryInterval())
                && Objects.equals(securityDbEncryption(), other.securityDbEncryption())
                && Objects.equals(securityDbEncryptionName(), other.securityDbEncryptionName())
                && Objects.equals(serverName(), other.serverName())
                && Objects.equals(spatialDataOptionToGeoJsonFunctionName(), other.spatialDataOptionToGeoJsonFunctionName())
                && Objects.equals(standbyDelayTime(), other.standbyDelayTime()) && Objects.equals(username(), other.username())
                && Objects.equals(useBFile(), other.useBFile())
                && Objects.equals(useDirectPathFullLoad(), other.useDirectPathFullLoad())
                && Objects.equals(useLogminerReader(), other.useLogminerReader())
                && Objects.equals(secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn())
                && Objects.equals(secretsManagerSecretId(), other.secretsManagerSecretId())
                && Objects.equals(secretsManagerOracleAsmAccessRoleArn(), other.secretsManagerOracleAsmAccessRoleArn())
                && Objects.equals(secretsManagerOracleAsmSecretId(), other.secretsManagerOracleAsmSecretId())
                && Objects.equals(trimSpaceInChar(), other.trimSpaceInChar())
                && Objects.equals(convertTimestampWithZoneToUTC(), other.convertTimestampWithZoneToUTC())
                && Objects.equals(openTransactionWindow(), other.openTransactionWindow())
                && Objects.equals(authenticationMethodAsString(), other.authenticationMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OracleSettings").add("AddSupplementalLogging", addSupplementalLogging())
                .add("ArchivedLogDestId", archivedLogDestId()).add("AdditionalArchivedLogDestId", additionalArchivedLogDestId())
                .add("ExtraArchivedLogDestIds", hasExtraArchivedLogDestIds() ? extraArchivedLogDestIds() : null)
                .add("AllowSelectNestedTables", allowSelectNestedTables())
                .add("ParallelAsmReadThreads", parallelAsmReadThreads()).add("ReadAheadBlocks", readAheadBlocks())
                .add("AccessAlternateDirectly", accessAlternateDirectly())
                .add("UseAlternateFolderForOnline", useAlternateFolderForOnline()).add("OraclePathPrefix", oraclePathPrefix())
                .add("UsePathPrefix", usePathPrefix()).add("ReplacePathPrefix", replacePathPrefix())
                .add("EnableHomogenousTablespace", enableHomogenousTablespace()).add("DirectPathNoLog", directPathNoLog())
                .add("ArchivedLogsOnly", archivedLogsOnly())
                .add("AsmPassword", asmPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AsmServer", asmServer()).add("AsmUser", asmUser())
                .add("CharLengthSemantics", charLengthSemanticsAsString()).add("DatabaseName", databaseName())
                .add("DirectPathParallelLoad", directPathParallelLoad())
                .add("FailTasksOnLobTruncation", failTasksOnLobTruncation()).add("NumberDatatypeScale", numberDatatypeScale())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("Port", port())
                .add("ReadTableSpaceName", readTableSpaceName()).add("RetryInterval", retryInterval())
                .add("SecurityDbEncryption", securityDbEncryption() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecurityDbEncryptionName", securityDbEncryptionName()).add("ServerName", serverName())
                .add("SpatialDataOptionToGeoJsonFunctionName", spatialDataOptionToGeoJsonFunctionName())
                .add("StandbyDelayTime", standbyDelayTime()).add("Username", username()).add("UseBFile", useBFile())
                .add("UseDirectPathFullLoad", useDirectPathFullLoad()).add("UseLogminerReader", useLogminerReader())
                .add("SecretsManagerAccessRoleArn", secretsManagerAccessRoleArn())
                .add("SecretsManagerSecretId", secretsManagerSecretId())
                .add("SecretsManagerOracleAsmAccessRoleArn", secretsManagerOracleAsmAccessRoleArn())
                .add("SecretsManagerOracleAsmSecretId", secretsManagerOracleAsmSecretId())
                .add("TrimSpaceInChar", trimSpaceInChar()).add("ConvertTimestampWithZoneToUTC", convertTimestampWithZoneToUTC())
                .add("OpenTransactionWindow", openTransactionWindow())
                .add("AuthenticationMethod", authenticationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddSupplementalLogging":
            return Optional.ofNullable(clazz.cast(addSupplementalLogging()));
        case "ArchivedLogDestId":
            return Optional.ofNullable(clazz.cast(archivedLogDestId()));
        case "AdditionalArchivedLogDestId":
            return Optional.ofNullable(clazz.cast(additionalArchivedLogDestId()));
        case "ExtraArchivedLogDestIds":
            return Optional.ofNullable(clazz.cast(extraArchivedLogDestIds()));
        case "AllowSelectNestedTables":
            return Optional.ofNullable(clazz.cast(allowSelectNestedTables()));
        case "ParallelAsmReadThreads":
            return Optional.ofNullable(clazz.cast(parallelAsmReadThreads()));
        case "ReadAheadBlocks":
            return Optional.ofNullable(clazz.cast(readAheadBlocks()));
        case "AccessAlternateDirectly":
            return Optional.ofNullable(clazz.cast(accessAlternateDirectly()));
        case "UseAlternateFolderForOnline":
            return Optional.ofNullable(clazz.cast(useAlternateFolderForOnline()));
        case "OraclePathPrefix":
            return Optional.ofNullable(clazz.cast(oraclePathPrefix()));
        case "UsePathPrefix":
            return Optional.ofNullable(clazz.cast(usePathPrefix()));
        case "ReplacePathPrefix":
            return Optional.ofNullable(clazz.cast(replacePathPrefix()));
        case "EnableHomogenousTablespace":
            return Optional.ofNullable(clazz.cast(enableHomogenousTablespace()));
        case "DirectPathNoLog":
            return Optional.ofNullable(clazz.cast(directPathNoLog()));
        case "ArchivedLogsOnly":
            return Optional.ofNullable(clazz.cast(archivedLogsOnly()));
        case "AsmPassword":
            return Optional.ofNullable(clazz.cast(asmPassword()));
        case "AsmServer":
            return Optional.ofNullable(clazz.cast(asmServer()));
        case "AsmUser":
            return Optional.ofNullable(clazz.cast(asmUser()));
        case "CharLengthSemantics":
            return Optional.ofNullable(clazz.cast(charLengthSemanticsAsString()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DirectPathParallelLoad":
            return Optional.ofNullable(clazz.cast(directPathParallelLoad()));
        case "FailTasksOnLobTruncation":
            return Optional.ofNullable(clazz.cast(failTasksOnLobTruncation()));
        case "NumberDatatypeScale":
            return Optional.ofNullable(clazz.cast(numberDatatypeScale()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "ReadTableSpaceName":
            return Optional.ofNullable(clazz.cast(readTableSpaceName()));
        case "RetryInterval":
            return Optional.ofNullable(clazz.cast(retryInterval()));
        case "SecurityDbEncryption":
            return Optional.ofNullable(clazz.cast(securityDbEncryption()));
        case "SecurityDbEncryptionName":
            return Optional.ofNullable(clazz.cast(securityDbEncryptionName()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "SpatialDataOptionToGeoJsonFunctionName":
            return Optional.ofNullable(clazz.cast(spatialDataOptionToGeoJsonFunctionName()));
        case "StandbyDelayTime":
            return Optional.ofNullable(clazz.cast(standbyDelayTime()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "UseBFile":
            return Optional.ofNullable(clazz.cast(useBFile()));
        case "UseDirectPathFullLoad":
            return Optional.ofNullable(clazz.cast(useDirectPathFullLoad()));
        case "UseLogminerReader":
            return Optional.ofNullable(clazz.cast(useLogminerReader()));
        case "SecretsManagerAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerAccessRoleArn()));
        case "SecretsManagerSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerSecretId()));
        case "SecretsManagerOracleAsmAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerOracleAsmAccessRoleArn()));
        case "SecretsManagerOracleAsmSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerOracleAsmSecretId()));
        case "TrimSpaceInChar":
            return Optional.ofNullable(clazz.cast(trimSpaceInChar()));
        case "ConvertTimestampWithZoneToUTC":
            return Optional.ofNullable(clazz.cast(convertTimestampWithZoneToUTC()));
        case "OpenTransactionWindow":
            return Optional.ofNullable(clazz.cast(openTransactionWindow()));
        case "AuthenticationMethod":
            return Optional.ofNullable(clazz.cast(authenticationMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AddSupplementalLogging", ADD_SUPPLEMENTAL_LOGGING_FIELD);
        map.put("ArchivedLogDestId", ARCHIVED_LOG_DEST_ID_FIELD);
        map.put("AdditionalArchivedLogDestId", ADDITIONAL_ARCHIVED_LOG_DEST_ID_FIELD);
        map.put("ExtraArchivedLogDestIds", EXTRA_ARCHIVED_LOG_DEST_IDS_FIELD);
        map.put("AllowSelectNestedTables", ALLOW_SELECT_NESTED_TABLES_FIELD);
        map.put("ParallelAsmReadThreads", PARALLEL_ASM_READ_THREADS_FIELD);
        map.put("ReadAheadBlocks", READ_AHEAD_BLOCKS_FIELD);
        map.put("AccessAlternateDirectly", ACCESS_ALTERNATE_DIRECTLY_FIELD);
        map.put("UseAlternateFolderForOnline", USE_ALTERNATE_FOLDER_FOR_ONLINE_FIELD);
        map.put("OraclePathPrefix", ORACLE_PATH_PREFIX_FIELD);
        map.put("UsePathPrefix", USE_PATH_PREFIX_FIELD);
        map.put("ReplacePathPrefix", REPLACE_PATH_PREFIX_FIELD);
        map.put("EnableHomogenousTablespace", ENABLE_HOMOGENOUS_TABLESPACE_FIELD);
        map.put("DirectPathNoLog", DIRECT_PATH_NO_LOG_FIELD);
        map.put("ArchivedLogsOnly", ARCHIVED_LOGS_ONLY_FIELD);
        map.put("AsmPassword", ASM_PASSWORD_FIELD);
        map.put("AsmServer", ASM_SERVER_FIELD);
        map.put("AsmUser", ASM_USER_FIELD);
        map.put("CharLengthSemantics", CHAR_LENGTH_SEMANTICS_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("DirectPathParallelLoad", DIRECT_PATH_PARALLEL_LOAD_FIELD);
        map.put("FailTasksOnLobTruncation", FAIL_TASKS_ON_LOB_TRUNCATION_FIELD);
        map.put("NumberDatatypeScale", NUMBER_DATATYPE_SCALE_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("ReadTableSpaceName", READ_TABLE_SPACE_NAME_FIELD);
        map.put("RetryInterval", RETRY_INTERVAL_FIELD);
        map.put("SecurityDbEncryption", SECURITY_DB_ENCRYPTION_FIELD);
        map.put("SecurityDbEncryptionName", SECURITY_DB_ENCRYPTION_NAME_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("SpatialDataOptionToGeoJsonFunctionName", SPATIAL_DATA_OPTION_TO_GEO_JSON_FUNCTION_NAME_FIELD);
        map.put("StandbyDelayTime", STANDBY_DELAY_TIME_FIELD);
        map.put("Username", USERNAME_FIELD);
        map.put("UseBFile", USE_B_FILE_FIELD);
        map.put("UseDirectPathFullLoad", USE_DIRECT_PATH_FULL_LOAD_FIELD);
        map.put("UseLogminerReader", USE_LOGMINER_READER_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("SecretsManagerOracleAsmAccessRoleArn", SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerOracleAsmSecretId", SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD);
        map.put("TrimSpaceInChar", TRIM_SPACE_IN_CHAR_FIELD);
        map.put("ConvertTimestampWithZoneToUTC", CONVERT_TIMESTAMP_WITH_ZONE_TO_UTC_FIELD);
        map.put("OpenTransactionWindow", OPEN_TRANSACTION_WINDOW_FIELD);
        map.put("AuthenticationMethod", AUTHENTICATION_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OracleSettings, T> g) {
        return obj -> g.apply((OracleSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OracleSettings> {
        /**
         * <p>
         * Set this attribute to set up table-level supplemental logging for the Oracle database. This attribute enables
         * PRIMARY KEY supplemental logging on all tables selected for a migration task.
         * </p>
         * <p>
         * If you use this option, you still need to enable database-level supplemental logging.
         * </p>
         * 
         * @param addSupplementalLogging
         *        Set this attribute to set up table-level supplemental logging for the Oracle database. This attribute
         *        enables PRIMARY KEY supplemental logging on all tables selected for a migration task.</p>
         *        <p>
         *        If you use this option, you still need to enable database-level supplemental logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSupplementalLogging(Boolean addSupplementalLogging);

        /**
         * <p>
         * Specifies the ID of the destination for the archived redo logs. This value should be the same as a number in
         * the dest_id column of the v$archived_log view. If you work with an additional redo log destination, use the
         * <code>AdditionalArchivedLogDestId</code> option to specify the additional destination ID. Doing this improves
         * performance by ensuring that the correct logs are accessed from the outset.
         * </p>
         * 
         * @param archivedLogDestId
         *        Specifies the ID of the destination for the archived redo logs. This value should be the same as a
         *        number in the dest_id column of the v$archived_log view. If you work with an additional redo log
         *        destination, use the <code>AdditionalArchivedLogDestId</code> option to specify the additional
         *        destination ID. Doing this improves performance by ensuring that the correct logs are accessed from
         *        the outset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivedLogDestId(Integer archivedLogDestId);

        /**
         * <p>
         * Set this attribute with <code>ArchivedLogDestId</code> in a primary/ standby setup. This attribute is useful
         * in the case of a switchover. In this case, DMS needs to know which destination to get archive redo logs from
         * to read changes. This need arises because the previous primary instance is now a standby instance after
         * switchover.
         * </p>
         * <p>
         * Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use
         * <code>RESETLOGS</code> unless necessary. For additional information about <code>RESETLOGS</code>, see <a
         * href=
         * "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
         * >RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
         * </p>
         * 
         * @param additionalArchivedLogDestId
         *        Set this attribute with <code>ArchivedLogDestId</code> in a primary/ standby setup. This attribute is
         *        useful in the case of a switchover. In this case, DMS needs to know which destination to get archive
         *        redo logs from to read changes. This need arises because the previous primary instance is now a
         *        standby instance after switchover.</p>
         *        <p>
         *        Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never
         *        use <code>RESETLOGS</code> unless necessary. For additional information about <code>RESETLOGS</code>,
         *        see <a href=
         *        "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
         *        >RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArchivedLogDestId(Integer additionalArchivedLogDestId);

        /**
         * <p>
         * Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the values of
         * the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting with the
         * <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a
         * primary-to-multiple-standby setup.
         * </p>
         * <p>
         * This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case,
         * DMS needs information about what destination to get archive redo logs from to read changes. DMS needs this
         * because after the switchover the previous primary is a standby instance. For example, in a primary-to-single
         * standby setup you might apply the following settings.
         * </p>
         * <p>
         * <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
         * </p>
         * <p>
         * In a primary-to-multiple-standby setup, you might apply the following settings.
         * </p>
         * <p>
         * <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
         * </p>
         * <p>
         * Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use
         * <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code>, see <a href=
         * "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
         * > RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
         * </p>
         * 
         * @param extraArchivedLogDestIds
         *        Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the
         *        values of the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting
         *        with the <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a
         *        primary-to-multiple-standby setup. </p>
         *        <p>
         *        This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this
         *        case, DMS needs information about what destination to get archive redo logs from to read changes. DMS
         *        needs this because after the switchover the previous primary is a standby instance. For example, in a
         *        primary-to-single standby setup you might apply the following settings.
         *        </p>
         *        <p>
         *        <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
         *        </p>
         *        <p>
         *        In a primary-to-multiple-standby setup, you might apply the following settings.
         *        </p>
         *        <p>
         *        <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
         *        </p>
         *        <p>
         *        Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never
         *        use <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code>,
         *        see <a href=
         *        "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
         *        > RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraArchivedLogDestIds(Collection<Integer> extraArchivedLogDestIds);

        /**
         * <p>
         * Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the values of
         * the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting with the
         * <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a
         * primary-to-multiple-standby setup.
         * </p>
         * <p>
         * This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case,
         * DMS needs information about what destination to get archive redo logs from to read changes. DMS needs this
         * because after the switchover the previous primary is a standby instance. For example, in a primary-to-single
         * standby setup you might apply the following settings.
         * </p>
         * <p>
         * <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
         * </p>
         * <p>
         * In a primary-to-multiple-standby setup, you might apply the following settings.
         * </p>
         * <p>
         * <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
         * </p>
         * <p>
         * Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never use
         * <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code>, see <a href=
         * "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
         * > RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
         * </p>
         * 
         * @param extraArchivedLogDestIds
         *        Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the
         *        values of the <code>dest_id</code> column in the <code>v$archived_log</code> view. Use this setting
         *        with the <code>archivedLogDestId</code> extra connection attribute in a primary-to-single setup or a
         *        primary-to-multiple-standby setup. </p>
         *        <p>
         *        This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this
         *        case, DMS needs information about what destination to get archive redo logs from to read changes. DMS
         *        needs this because after the switchover the previous primary is a standby instance. For example, in a
         *        primary-to-single standby setup you might apply the following settings.
         *        </p>
         *        <p>
         *        <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
         *        </p>
         *        <p>
         *        In a primary-to-multiple-standby setup, you might apply the following settings.
         *        </p>
         *        <p>
         *        <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
         *        </p>
         *        <p>
         *        Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the database, never
         *        use <code>RESETLOGS</code> unless it's necessary. For more information about <code>RESETLOGS</code>,
         *        see <a href=
         *        "https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"
         *        > RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery User's Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraArchivedLogDestIds(Integer... extraArchivedLogDestIds);

        /**
         * <p>
         * Set this attribute to <code>true</code> to enable replication of Oracle tables containing columns that are
         * nested tables or defined types.
         * </p>
         * 
         * @param allowSelectNestedTables
         *        Set this attribute to <code>true</code> to enable replication of Oracle tables containing columns that
         *        are nested tables or defined types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSelectNestedTables(Boolean allowSelectNestedTables);

        /**
         * <p>
         * Set this attribute to change the number of threads that DMS configures to perform a change data capture (CDC)
         * load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 2 (the
         * default) and 8 (the maximum). Use this attribute together with the <code>readAheadBlocks</code> attribute.
         * </p>
         * 
         * @param parallelAsmReadThreads
         *        Set this attribute to change the number of threads that DMS configures to perform a change data
         *        capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value
         *        between 2 (the default) and 8 (the maximum). Use this attribute together with the
         *        <code>readAheadBlocks</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelAsmReadThreads(Integer parallelAsmReadThreads);

        /**
         * <p>
         * Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change data
         * capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between
         * 1000 (the default) and 200,000 (the maximum).
         * </p>
         * 
         * @param readAheadBlocks
         *        Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change
         *        data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer
         *        value between 1000 (the default) and 200,000 (the maximum).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAheadBlocks(Integer readAheadBlocks);

        /**
         * <p>
         * Set this attribute to <code>false</code> in order to use the Binary Reader to capture change data for an
         * Amazon RDS for Oracle as the source. This tells the DMS instance to not access redo logs through any
         * specified path prefix replacement using direct file access.
         * </p>
         * 
         * @param accessAlternateDirectly
         *        Set this attribute to <code>false</code> in order to use the Binary Reader to capture change data for
         *        an Amazon RDS for Oracle as the source. This tells the DMS instance to not access redo logs through
         *        any specified path prefix replacement using direct file access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessAlternateDirectly(Boolean accessAlternateDirectly);

        /**
         * <p>
         * Set this attribute to <code>true</code> in order to use the Binary Reader to capture change data for an
         * Amazon RDS for Oracle as the source. This tells the DMS instance to use any specified prefix replacement to
         * access all online redo logs.
         * </p>
         * 
         * @param useAlternateFolderForOnline
         *        Set this attribute to <code>true</code> in order to use the Binary Reader to capture change data for
         *        an Amazon RDS for Oracle as the source. This tells the DMS instance to use any specified prefix
         *        replacement to access all online redo logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useAlternateFolderForOnline(Boolean useAlternateFolderForOnline);

        /**
         * <p>
         * Set this string attribute to the required value in order to use the Binary Reader to capture change data for
         * an Amazon RDS for Oracle as the source. This value specifies the default Oracle root used to access the redo
         * logs.
         * </p>
         * 
         * @param oraclePathPrefix
         *        Set this string attribute to the required value in order to use the Binary Reader to capture change
         *        data for an Amazon RDS for Oracle as the source. This value specifies the default Oracle root used to
         *        access the redo logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oraclePathPrefix(String oraclePathPrefix);

        /**
         * <p>
         * Set this string attribute to the required value in order to use the Binary Reader to capture change data for
         * an Amazon RDS for Oracle as the source. This value specifies the path prefix used to replace the default
         * Oracle root to access the redo logs.
         * </p>
         * 
         * @param usePathPrefix
         *        Set this string attribute to the required value in order to use the Binary Reader to capture change
         *        data for an Amazon RDS for Oracle as the source. This value specifies the path prefix used to replace
         *        the default Oracle root to access the redo logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usePathPrefix(String usePathPrefix);

        /**
         * <p>
         * Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for
         * Oracle as the source. This setting tells DMS instance to replace the default Oracle root with the specified
         * <code>usePathPrefix</code> setting to access the redo logs.
         * </p>
         * 
         * @param replacePathPrefix
         *        Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS
         *        for Oracle as the source. This setting tells DMS instance to replace the default Oracle root with the
         *        specified <code>usePathPrefix</code> setting to access the redo logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacePathPrefix(Boolean replacePathPrefix);

        /**
         * <p>
         * Set this attribute to enable homogenous tablespace replication and create existing tables or indexes under
         * the same tablespace on the target.
         * </p>
         * 
         * @param enableHomogenousTablespace
         *        Set this attribute to enable homogenous tablespace replication and create existing tables or indexes
         *        under the same tablespace on the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableHomogenousTablespace(Boolean enableHomogenousTablespace);

        /**
         * <p>
         * When set to <code>true</code>, this attribute helps to increase the commit rate on the Oracle target database
         * by writing directly to tables and not writing a trail to database logs.
         * </p>
         * 
         * @param directPathNoLog
         *        When set to <code>true</code>, this attribute helps to increase the commit rate on the Oracle target
         *        database by writing directly to tables and not writing a trail to database logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directPathNoLog(Boolean directPathNoLog);

        /**
         * <p>
         * When this field is set to <code>True</code>, DMS only accesses the archived redo logs. If the archived redo
         * logs are stored on Automatic Storage Management (ASM) only, the DMS user account needs to be granted ASM
         * privileges.
         * </p>
         * 
         * @param archivedLogsOnly
         *        When this field is set to <code>True</code>, DMS only accesses the archived redo logs. If the archived
         *        redo logs are stored on Automatic Storage Management (ASM) only, the DMS user account needs to be
         *        granted ASM privileges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivedLogsOnly(Boolean archivedLogsOnly);

        /**
         * <p>
         * For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password. You can set this
         * value from the <code> <i>asm_user_password</i> </code> value. You set this value as part of the
         * comma-separated value that you set to the <code>Password</code> request parameter when you create the
         * endpoint to access transaction logs using Binary Reader. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
         * >Configuration for change data capture (CDC) on an Oracle source database</a>.
         * </p>
         * 
         * @param asmPassword
         *        For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password. You can set
         *        this value from the <code> <i>asm_user_password</i> </code> value. You set this value as part of the
         *        comma-separated value that you set to the <code>Password</code> request parameter when you create the
         *        endpoint to access transaction logs using Binary Reader. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
         *        >Configuration for change data capture (CDC) on an Oracle source database</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asmPassword(String asmPassword);

        /**
         * <p>
         * For an Oracle source endpoint, your ASM server address. You can set this value from the
         * <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute
         * string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
         * >Configuration for change data capture (CDC) on an Oracle source database</a>.
         * </p>
         * 
         * @param asmServer
         *        For an Oracle source endpoint, your ASM server address. You can set this value from the
         *        <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection
         *        attribute string to access an Oracle server with Binary Reader that uses ASM. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
         *        >Configuration for change data capture (CDC) on an Oracle source database</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asmServer(String asmServer);

        /**
         * <p>
         * For an Oracle source endpoint, your ASM user name. You can set this value from the <code>asm_user</code>
         * value. You set <code>asm_user</code> as part of the extra connection attribute string to access an Oracle
         * server with Binary Reader that uses ASM. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
         * >Configuration for change data capture (CDC) on an Oracle source database</a>.
         * </p>
         * 
         * @param asmUser
         *        For an Oracle source endpoint, your ASM user name. You can set this value from the
         *        <code>asm_user</code> value. You set <code>asm_user</code> as part of the extra connection attribute
         *        string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
         *        >Configuration for change data capture (CDC) on an Oracle source database</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asmUser(String asmUser);

        /**
         * <p>
         * Specifies whether the length of a character column is in bytes or in characters. To indicate that the
         * character column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the character
         * column length is in bytes.
         * </p>
         * <p>
         * Example: <code>charLengthSemantics=CHAR;</code>
         * </p>
         * 
         * @param charLengthSemantics
         *        Specifies whether the length of a character column is in bytes or in characters. To indicate that the
         *        character column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the
         *        character column length is in bytes.</p>
         *        <p>
         *        Example: <code>charLengthSemantics=CHAR;</code>
         * @see CharLengthSemantics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CharLengthSemantics
         */
        Builder charLengthSemantics(String charLengthSemantics);

        /**
         * <p>
         * Specifies whether the length of a character column is in bytes or in characters. To indicate that the
         * character column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the character
         * column length is in bytes.
         * </p>
         * <p>
         * Example: <code>charLengthSemantics=CHAR;</code>
         * </p>
         * 
         * @param charLengthSemantics
         *        Specifies whether the length of a character column is in bytes or in characters. To indicate that the
         *        character column length is in characters, set this attribute to <code>CHAR</code>. Otherwise, the
         *        character column length is in bytes.</p>
         *        <p>
         *        Example: <code>charLengthSemantics=CHAR;</code>
         * @see CharLengthSemantics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CharLengthSemantics
         */
        Builder charLengthSemantics(CharLengthSemantics charLengthSemantics);

        /**
         * <p>
         * Database name for the endpoint.
         * </p>
         * 
         * @param databaseName
         *        Database name for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * When set to <code>true</code>, this attribute specifies a parallel load when
         * <code>useDirectPathFullLoad</code> is set to <code>Y</code>. This attribute also only applies when you use
         * the DMS parallel load feature. Note that the target table cannot have any constraints or indexes.
         * </p>
         * 
         * @param directPathParallelLoad
         *        When set to <code>true</code>, this attribute specifies a parallel load when
         *        <code>useDirectPathFullLoad</code> is set to <code>Y</code>. This attribute also only applies when you
         *        use the DMS parallel load feature. Note that the target table cannot have any constraints or indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directPathParallelLoad(Boolean directPathParallelLoad);

        /**
         * <p>
         * When set to <code>true</code>, this attribute causes a task to fail if the actual size of an LOB column is
         * greater than the specified <code>LobMaxSize</code>.
         * </p>
         * <p>
         * If a task is set to limited LOB mode and this option is set to <code>true</code>, the task fails instead of
         * truncating the LOB data.
         * </p>
         * 
         * @param failTasksOnLobTruncation
         *        When set to <code>true</code>, this attribute causes a task to fail if the actual size of an LOB
         *        column is greater than the specified <code>LobMaxSize</code>.</p>
         *        <p>
         *        If a task is set to limited LOB mode and this option is set to <code>true</code>, the task fails
         *        instead of truncating the LOB data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failTasksOnLobTruncation(Boolean failTasksOnLobTruncation);

        /**
         * <p>
         * Specifies the number scale. You can select a scale up to 38, or you can select FLOAT. By default, the NUMBER
         * data type is converted to precision 38, scale 10.
         * </p>
         * <p>
         * Example: <code>numberDataTypeScale=12</code>
         * </p>
         * 
         * @param numberDatatypeScale
         *        Specifies the number scale. You can select a scale up to 38, or you can select FLOAT. By default, the
         *        NUMBER data type is converted to precision 38, scale 10.</p>
         *        <p>
         *        Example: <code>numberDataTypeScale=12</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberDatatypeScale(Integer numberDatatypeScale);

        /**
         * <p>
         * Endpoint connection password.
         * </p>
         * 
         * @param password
         *        Endpoint connection password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * Endpoint TCP port.
         * </p>
         * 
         * @param port
         *        Endpoint TCP port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * When set to <code>true</code>, this attribute supports tablespace replication.
         * </p>
         * 
         * @param readTableSpaceName
         *        When set to <code>true</code>, this attribute supports tablespace replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readTableSpaceName(Boolean readTableSpaceName);

        /**
         * <p>
         * Specifies the number of seconds that the system waits before resending a query.
         * </p>
         * <p>
         * Example: <code>retryInterval=6;</code>
         * </p>
         * 
         * @param retryInterval
         *        Specifies the number of seconds that the system waits before resending a query.</p>
         *        <p>
         *        Example: <code>retryInterval=6;</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryInterval(Integer retryInterval);

        /**
         * <p>
         * For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to access
         * Oracle redo logs encrypted by TDE using Binary Reader. It is also the <code> <i>TDE_Password</i> </code> part
         * of the comma-separated value you set to the <code>Password</code> request parameter when you create the
         * endpoint. The <code>SecurityDbEncryptian</code> setting is related to this
         * <code>SecurityDbEncryptionName</code> setting. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption">
         * Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration Service
         * User Guide</i>.
         * </p>
         * 
         * @param securityDbEncryption
         *        For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to
         *        access Oracle redo logs encrypted by TDE using Binary Reader. It is also the
         *        <code> <i>TDE_Password</i> </code> part of the comma-separated value you set to the
         *        <code>Password</code> request parameter when you create the endpoint. The
         *        <code>SecurityDbEncryptian</code> setting is related to this <code>SecurityDbEncryptionName</code>
         *        setting. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"
         *        > Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration
         *        Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityDbEncryption(String securityDbEncryption);

        /**
         * <p>
         * For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the
         * columns and tablespaces in an Oracle source database that is encrypted using TDE. The key value is the value
         * of the <code>SecurityDbEncryption</code> setting. For more information on setting the key name value of
         * <code>SecurityDbEncryptionName</code>, see the information and example for setting the
         * <code>securityDbEncryptionName</code> extra connection attribute in <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption">
         * Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration Service
         * User Guide</i>.
         * </p>
         * 
         * @param securityDbEncryptionName
         *        For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the
         *        columns and tablespaces in an Oracle source database that is encrypted using TDE. The key value is the
         *        value of the <code>SecurityDbEncryption</code> setting. For more information on setting the key name
         *        value of <code>SecurityDbEncryptionName</code>, see the information and example for setting the
         *        <code>securityDbEncryptionName</code> extra connection attribute in <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"
         *        > Supported encryption methods for using Oracle as a source for DMS </a> in the <i>Database Migration
         *        Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityDbEncryptionName(String securityDbEncryptionName);

        /**
         * <p>
         * Fully qualified domain name of the endpoint.
         * </p>
         * <p>
         * For an Amazon RDS Oracle instance, this is the output of <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html"
         * >DescribeDBInstances</a>, in the
         * <code> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address</code>
         * field.
         * </p>
         * 
         * @param serverName
         *        Fully qualified domain name of the endpoint.</p>
         *        <p>
         *        For an Amazon RDS Oracle instance, this is the output of <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html"
         *        >DescribeDBInstances</a>, in the
         *        <code> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address</code>
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * Use this attribute to convert <code>SDO_GEOMETRY</code> to <code>GEOJSON</code> format. By default, DMS calls
         * the <code>SDO2GEOJSON</code> custom function if present and accessible. Or you can create your own custom
         * function that mimics the operation of <code>SDOGEOJSON</code> and set
         * <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead.
         * </p>
         * 
         * @param spatialDataOptionToGeoJsonFunctionName
         *        Use this attribute to convert <code>SDO_GEOMETRY</code> to <code>GEOJSON</code> format. By default,
         *        DMS calls the <code>SDO2GEOJSON</code> custom function if present and accessible. Or you can create
         *        your own custom function that mimics the operation of <code>SDOGEOJSON</code> and set
         *        <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spatialDataOptionToGeoJsonFunctionName(String spatialDataOptionToGeoJsonFunctionName);

        /**
         * <p>
         * Use this attribute to specify a time in minutes for the delay in standby sync. If the source is an Oracle
         * Active Data Guard standby database, use this attribute to specify the time lag between primary and standby
         * databases.
         * </p>
         * <p>
         * In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source for
         * replicating ongoing changes. Doing this eliminates the need to connect to an active database that might be in
         * production.
         * </p>
         * 
         * @param standbyDelayTime
         *        Use this attribute to specify a time in minutes for the delay in standby sync. If the source is an
         *        Oracle Active Data Guard standby database, use this attribute to specify the time lag between primary
         *        and standby databases.</p>
         *        <p>
         *        In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source
         *        for replicating ongoing changes. Doing this eliminates the need to connect to an active database that
         *        might be in production.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standbyDelayTime(Integer standbyDelayTime);

        /**
         * <p>
         * Endpoint connection user name.
         * </p>
         * 
         * @param username
         *        Endpoint connection user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * Set this attribute to True to capture change data using the Binary Reader utility. Set
         * <code>UseLogminerReader</code> to False to set this attribute to True. To use Binary Reader with Amazon RDS
         * for Oracle as the source, you set additional attributes. For more information about using this setting with
         * Oracle Automatic Storage Management (ASM), see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using
         * Oracle LogMiner or DMS Binary Reader for CDC</a>.
         * </p>
         * 
         * @param useBFile
         *        Set this attribute to True to capture change data using the Binary Reader utility. Set
         *        <code>UseLogminerReader</code> to False to set this attribute to True. To use Binary Reader with
         *        Amazon RDS for Oracle as the source, you set additional attributes. For more information about using
         *        this setting with Oracle Automatic Storage Management (ASM), see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">
         *        Using Oracle LogMiner or DMS Binary Reader for CDC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBFile(Boolean useBFile);

        /**
         * <p>
         * Set this attribute to True to have DMS use a direct path full load. Specify this value to use the direct path
         * protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle target
         * tables during a full load.
         * </p>
         * 
         * @param useDirectPathFullLoad
         *        Set this attribute to True to have DMS use a direct path full load. Specify this value to use the
         *        direct path protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load
         *        Oracle target tables during a full load.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useDirectPathFullLoad(Boolean useDirectPathFullLoad);

        /**
         * <p>
         * Set this attribute to True to capture change data using the Oracle LogMiner utility (the default). Set this
         * attribute to False if you want to access the redo logs as a binary file. When you set
         * <code>UseLogminerReader</code> to False, also set <code>UseBfile</code> to True. For more information on this
         * setting and using Oracle ASM, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using
         * Oracle LogMiner or DMS Binary Reader for CDC</a> in the <i>DMS User Guide</i>.
         * </p>
         * 
         * @param useLogminerReader
         *        Set this attribute to True to capture change data using the Oracle LogMiner utility (the default). Set
         *        this attribute to False if you want to access the redo logs as a binary file. When you set
         *        <code>UseLogminerReader</code> to False, also set <code>UseBfile</code> to True. For more information
         *        on this setting and using Oracle ASM, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC">
         *        Using Oracle LogMiner or DMS Binary Reader for CDC</a> in the <i>DMS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLogminerReader(Boolean useLogminerReader);

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the
         * required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the
         * <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services
         * Secrets Manager secret that allows access to the Oracle endpoint.
         * </p>
         * <note>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting
         * and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
         * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
         * information on creating this <code>SecretsManagerSecret</code> and the
         * <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see
         * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">
         * Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param secretsManagerAccessRoleArn
         *        The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and
         *        grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role
         *        must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of
         *        the Amazon Web Services Secrets Manager secret that allows access to the Oracle endpoint.</p> <note>
         *        <p>
         *        You can specify one of two sets of values for these permissions. You can specify the values for this
         *        setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
         *        <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You
         *        can't specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
         *        <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access
         *        it, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
         *        >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
         *        User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn);

        /**
         * <p>
         * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Oracle
         * endpoint connection details.
         * </p>
         * 
         * @param secretsManagerSecretId
         *        The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
         *        Oracle endpoint connection details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecretId(String secretsManagerSecretId);

        /**
         * <p>
         * Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN of the IAM role
         * that specifies DMS as the trusted entity and grants the required permissions to access the
         * <code>SecretsManagerOracleAsmSecret</code>. This <code>SecretsManagerOracleAsmSecret</code> has the secret
         * value that allows access to the Oracle ASM of the endpoint.
         * </p>
         * <note>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting
         * and <code>SecretsManagerOracleAsmSecretId</code>. Or you can specify clear-text values for
         * <code>AsmUser</code>, <code>AsmPassword</code>, and <code>AsmServerName</code>. You can't specify both. For
         * more information on creating this <code>SecretsManagerOracleAsmSecret</code> and the
         * <code>SecretsManagerOracleAsmAccessRoleArn</code> and <code>SecretsManagerOracleAsmSecretId</code> required
         * to access it, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using
         * secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param secretsManagerOracleAsmAccessRoleArn
         *        Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN of the IAM
         *        role that specifies DMS as the trusted entity and grants the required permissions to access the
         *        <code>SecretsManagerOracleAsmSecret</code>. This <code>SecretsManagerOracleAsmSecret</code> has the
         *        secret value that allows access to the Oracle ASM of the endpoint.</p> <note>
         *        <p>
         *        You can specify one of two sets of values for these permissions. You can specify the values for this
         *        setting and <code>SecretsManagerOracleAsmSecretId</code>. Or you can specify clear-text values for
         *        <code>AsmUser</code>, <code>AsmPassword</code>, and <code>AsmServerName</code>. You can't specify
         *        both. For more information on creating this <code>SecretsManagerOracleAsmSecret</code> and the
         *        <code>SecretsManagerOracleAsmAccessRoleArn</code> and <code>SecretsManagerOracleAsmSecretId</code>
         *        required to access it, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
         *        >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
         *        User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn);

        /**
         * <p>
         * Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN, partial ARN, or
         * friendly name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM connection
         * details for the Oracle endpoint.
         * </p>
         * 
         * @param secretsManagerOracleAsmSecretId
         *        Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN, partial
         *        ARN, or friendly name of the <code>SecretsManagerOracleAsmSecret</code> that contains the Oracle ASM
         *        connection details for the Oracle endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId);

        /**
         * <p>
         * Use the <code>TrimSpaceInChar</code> source endpoint setting to trim data on CHAR and NCHAR data types during
         * migration. The default value is <code>true</code>.
         * </p>
         * 
         * @param trimSpaceInChar
         *        Use the <code>TrimSpaceInChar</code> source endpoint setting to trim data on CHAR and NCHAR data types
         *        during migration. The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trimSpaceInChar(Boolean trimSpaceInChar);

        /**
         * <p>
         * When true, converts timestamps with the <code>timezone</code> datatype to their UTC value.
         * </p>
         * 
         * @param convertTimestampWithZoneToUTC
         *        When true, converts timestamps with the <code>timezone</code> datatype to their UTC value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder convertTimestampWithZoneToUTC(Boolean convertTimestampWithZoneToUTC);

        /**
         * <p>
         * The timeframe in minutes to check for open transactions for a CDC-only task.
         * </p>
         * <p>
         * You can specify an integer value between 0 (the default) and 240 (the maximum).
         * </p>
         * <note>
         * <p>
         * This parameter is only valid in DMS version 3.5.0 and later.
         * </p>
         * </note>
         * 
         * @param openTransactionWindow
         *        The timeframe in minutes to check for open transactions for a CDC-only task.</p>
         *        <p>
         *        You can specify an integer value between 0 (the default) and 240 (the maximum).
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is only valid in DMS version 3.5.0 and later.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openTransactionWindow(Integer openTransactionWindow);

        /**
         * <p>
         * Specifies the authentication method to be used with Oracle.
         * </p>
         * 
         * @param authenticationMethod
         *        Specifies the authentication method to be used with Oracle.
         * @see OracleAuthenticationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OracleAuthenticationMethod
         */
        Builder authenticationMethod(String authenticationMethod);

        /**
         * <p>
         * Specifies the authentication method to be used with Oracle.
         * </p>
         * 
         * @param authenticationMethod
         *        Specifies the authentication method to be used with Oracle.
         * @see OracleAuthenticationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OracleAuthenticationMethod
         */
        Builder authenticationMethod(OracleAuthenticationMethod authenticationMethod);
    }

    static final class BuilderImpl implements Builder {
        private Boolean addSupplementalLogging;

        private Integer archivedLogDestId;

        private Integer additionalArchivedLogDestId;

        private List<Integer> extraArchivedLogDestIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowSelectNestedTables;

        private Integer parallelAsmReadThreads;

        private Integer readAheadBlocks;

        private Boolean accessAlternateDirectly;

        private Boolean useAlternateFolderForOnline;

        private String oraclePathPrefix;

        private String usePathPrefix;

        private Boolean replacePathPrefix;

        private Boolean enableHomogenousTablespace;

        private Boolean directPathNoLog;

        private Boolean archivedLogsOnly;

        private String asmPassword;

        private String asmServer;

        private String asmUser;

        private String charLengthSemantics;

        private String databaseName;

        private Boolean directPathParallelLoad;

        private Boolean failTasksOnLobTruncation;

        private Integer numberDatatypeScale;

        private String password;

        private Integer port;

        private Boolean readTableSpaceName;

        private Integer retryInterval;

        private String securityDbEncryption;

        private String securityDbEncryptionName;

        private String serverName;

        private String spatialDataOptionToGeoJsonFunctionName;

        private Integer standbyDelayTime;

        private String username;

        private Boolean useBFile;

        private Boolean useDirectPathFullLoad;

        private Boolean useLogminerReader;

        private String secretsManagerAccessRoleArn;

        private String secretsManagerSecretId;

        private String secretsManagerOracleAsmAccessRoleArn;

        private String secretsManagerOracleAsmSecretId;

        private Boolean trimSpaceInChar;

        private Boolean convertTimestampWithZoneToUTC;

        private Integer openTransactionWindow;

        private String authenticationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(OracleSettings model) {
            addSupplementalLogging(model.addSupplementalLogging);
            archivedLogDestId(model.archivedLogDestId);
            additionalArchivedLogDestId(model.additionalArchivedLogDestId);
            extraArchivedLogDestIds(model.extraArchivedLogDestIds);
            allowSelectNestedTables(model.allowSelectNestedTables);
            parallelAsmReadThreads(model.parallelAsmReadThreads);
            readAheadBlocks(model.readAheadBlocks);
            accessAlternateDirectly(model.accessAlternateDirectly);
            useAlternateFolderForOnline(model.useAlternateFolderForOnline);
            oraclePathPrefix(model.oraclePathPrefix);
            usePathPrefix(model.usePathPrefix);
            replacePathPrefix(model.replacePathPrefix);
            enableHomogenousTablespace(model.enableHomogenousTablespace);
            directPathNoLog(model.directPathNoLog);
            archivedLogsOnly(model.archivedLogsOnly);
            asmPassword(model.asmPassword);
            asmServer(model.asmServer);
            asmUser(model.asmUser);
            charLengthSemantics(model.charLengthSemantics);
            databaseName(model.databaseName);
            directPathParallelLoad(model.directPathParallelLoad);
            failTasksOnLobTruncation(model.failTasksOnLobTruncation);
            numberDatatypeScale(model.numberDatatypeScale);
            password(model.password);
            port(model.port);
            readTableSpaceName(model.readTableSpaceName);
            retryInterval(model.retryInterval);
            securityDbEncryption(model.securityDbEncryption);
            securityDbEncryptionName(model.securityDbEncryptionName);
            serverName(model.serverName);
            spatialDataOptionToGeoJsonFunctionName(model.spatialDataOptionToGeoJsonFunctionName);
            standbyDelayTime(model.standbyDelayTime);
            username(model.username);
            useBFile(model.useBFile);
            useDirectPathFullLoad(model.useDirectPathFullLoad);
            useLogminerReader(model.useLogminerReader);
            secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            secretsManagerSecretId(model.secretsManagerSecretId);
            secretsManagerOracleAsmAccessRoleArn(model.secretsManagerOracleAsmAccessRoleArn);
            secretsManagerOracleAsmSecretId(model.secretsManagerOracleAsmSecretId);
            trimSpaceInChar(model.trimSpaceInChar);
            convertTimestampWithZoneToUTC(model.convertTimestampWithZoneToUTC);
            openTransactionWindow(model.openTransactionWindow);
            authenticationMethod(model.authenticationMethod);
        }

        public final Boolean getAddSupplementalLogging() {
            return addSupplementalLogging;
        }

        public final void setAddSupplementalLogging(Boolean addSupplementalLogging) {
            this.addSupplementalLogging = addSupplementalLogging;
        }

        @Override
        public final Builder addSupplementalLogging(Boolean addSupplementalLogging) {
            this.addSupplementalLogging = addSupplementalLogging;
            return this;
        }

        public final Integer getArchivedLogDestId() {
            return archivedLogDestId;
        }

        public final void setArchivedLogDestId(Integer archivedLogDestId) {
            this.archivedLogDestId = archivedLogDestId;
        }

        @Override
        public final Builder archivedLogDestId(Integer archivedLogDestId) {
            this.archivedLogDestId = archivedLogDestId;
            return this;
        }

        public final Integer getAdditionalArchivedLogDestId() {
            return additionalArchivedLogDestId;
        }

        public final void setAdditionalArchivedLogDestId(Integer additionalArchivedLogDestId) {
            this.additionalArchivedLogDestId = additionalArchivedLogDestId;
        }

        @Override
        public final Builder additionalArchivedLogDestId(Integer additionalArchivedLogDestId) {
            this.additionalArchivedLogDestId = additionalArchivedLogDestId;
            return this;
        }

        public final Collection<Integer> getExtraArchivedLogDestIds() {
            if (extraArchivedLogDestIds instanceof SdkAutoConstructList) {
                return null;
            }
            return extraArchivedLogDestIds;
        }

        public final void setExtraArchivedLogDestIds(Collection<Integer> extraArchivedLogDestIds) {
            this.extraArchivedLogDestIds = IntegerListCopier.copy(extraArchivedLogDestIds);
        }

        @Override
        public final Builder extraArchivedLogDestIds(Collection<Integer> extraArchivedLogDestIds) {
            this.extraArchivedLogDestIds = IntegerListCopier.copy(extraArchivedLogDestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraArchivedLogDestIds(Integer... extraArchivedLogDestIds) {
            extraArchivedLogDestIds(Arrays.asList(extraArchivedLogDestIds));
            return this;
        }

        public final Boolean getAllowSelectNestedTables() {
            return allowSelectNestedTables;
        }

        public final void setAllowSelectNestedTables(Boolean allowSelectNestedTables) {
            this.allowSelectNestedTables = allowSelectNestedTables;
        }

        @Override
        public final Builder allowSelectNestedTables(Boolean allowSelectNestedTables) {
            this.allowSelectNestedTables = allowSelectNestedTables;
            return this;
        }

        public final Integer getParallelAsmReadThreads() {
            return parallelAsmReadThreads;
        }

        public final void setParallelAsmReadThreads(Integer parallelAsmReadThreads) {
            this.parallelAsmReadThreads = parallelAsmReadThreads;
        }

        @Override
        public final Builder parallelAsmReadThreads(Integer parallelAsmReadThreads) {
            this.parallelAsmReadThreads = parallelAsmReadThreads;
            return this;
        }

        public final Integer getReadAheadBlocks() {
            return readAheadBlocks;
        }

        public final void setReadAheadBlocks(Integer readAheadBlocks) {
            this.readAheadBlocks = readAheadBlocks;
        }

        @Override
        public final Builder readAheadBlocks(Integer readAheadBlocks) {
            this.readAheadBlocks = readAheadBlocks;
            return this;
        }

        public final Boolean getAccessAlternateDirectly() {
            return accessAlternateDirectly;
        }

        public final void setAccessAlternateDirectly(Boolean accessAlternateDirectly) {
            this.accessAlternateDirectly = accessAlternateDirectly;
        }

        @Override
        public final Builder accessAlternateDirectly(Boolean accessAlternateDirectly) {
            this.accessAlternateDirectly = accessAlternateDirectly;
            return this;
        }

        public final Boolean getUseAlternateFolderForOnline() {
            return useAlternateFolderForOnline;
        }

        public final void setUseAlternateFolderForOnline(Boolean useAlternateFolderForOnline) {
            this.useAlternateFolderForOnline = useAlternateFolderForOnline;
        }

        @Override
        public final Builder useAlternateFolderForOnline(Boolean useAlternateFolderForOnline) {
            this.useAlternateFolderForOnline = useAlternateFolderForOnline;
            return this;
        }

        public final String getOraclePathPrefix() {
            return oraclePathPrefix;
        }

        public final void setOraclePathPrefix(String oraclePathPrefix) {
            this.oraclePathPrefix = oraclePathPrefix;
        }

        @Override
        public final Builder oraclePathPrefix(String oraclePathPrefix) {
            this.oraclePathPrefix = oraclePathPrefix;
            return this;
        }

        public final String getUsePathPrefix() {
            return usePathPrefix;
        }

        public final void setUsePathPrefix(String usePathPrefix) {
            this.usePathPrefix = usePathPrefix;
        }

        @Override
        public final Builder usePathPrefix(String usePathPrefix) {
            this.usePathPrefix = usePathPrefix;
            return this;
        }

        public final Boolean getReplacePathPrefix() {
            return replacePathPrefix;
        }

        public final void setReplacePathPrefix(Boolean replacePathPrefix) {
            this.replacePathPrefix = replacePathPrefix;
        }

        @Override
        public final Builder replacePathPrefix(Boolean replacePathPrefix) {
            this.replacePathPrefix = replacePathPrefix;
            return this;
        }

        public final Boolean getEnableHomogenousTablespace() {
            return enableHomogenousTablespace;
        }

        public final void setEnableHomogenousTablespace(Boolean enableHomogenousTablespace) {
            this.enableHomogenousTablespace = enableHomogenousTablespace;
        }

        @Override
        public final Builder enableHomogenousTablespace(Boolean enableHomogenousTablespace) {
            this.enableHomogenousTablespace = enableHomogenousTablespace;
            return this;
        }

        public final Boolean getDirectPathNoLog() {
            return directPathNoLog;
        }

        public final void setDirectPathNoLog(Boolean directPathNoLog) {
            this.directPathNoLog = directPathNoLog;
        }

        @Override
        public final Builder directPathNoLog(Boolean directPathNoLog) {
            this.directPathNoLog = directPathNoLog;
            return this;
        }

        public final Boolean getArchivedLogsOnly() {
            return archivedLogsOnly;
        }

        public final void setArchivedLogsOnly(Boolean archivedLogsOnly) {
            this.archivedLogsOnly = archivedLogsOnly;
        }

        @Override
        public final Builder archivedLogsOnly(Boolean archivedLogsOnly) {
            this.archivedLogsOnly = archivedLogsOnly;
            return this;
        }

        public final String getAsmPassword() {
            return asmPassword;
        }

        public final void setAsmPassword(String asmPassword) {
            this.asmPassword = asmPassword;
        }

        @Override
        public final Builder asmPassword(String asmPassword) {
            this.asmPassword = asmPassword;
            return this;
        }

        public final String getAsmServer() {
            return asmServer;
        }

        public final void setAsmServer(String asmServer) {
            this.asmServer = asmServer;
        }

        @Override
        public final Builder asmServer(String asmServer) {
            this.asmServer = asmServer;
            return this;
        }

        public final String getAsmUser() {
            return asmUser;
        }

        public final void setAsmUser(String asmUser) {
            this.asmUser = asmUser;
        }

        @Override
        public final Builder asmUser(String asmUser) {
            this.asmUser = asmUser;
            return this;
        }

        public final String getCharLengthSemantics() {
            return charLengthSemantics;
        }

        public final void setCharLengthSemantics(String charLengthSemantics) {
            this.charLengthSemantics = charLengthSemantics;
        }

        @Override
        public final Builder charLengthSemantics(String charLengthSemantics) {
            this.charLengthSemantics = charLengthSemantics;
            return this;
        }

        @Override
        public final Builder charLengthSemantics(CharLengthSemantics charLengthSemantics) {
            this.charLengthSemantics(charLengthSemantics == null ? null : charLengthSemantics.toString());
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Boolean getDirectPathParallelLoad() {
            return directPathParallelLoad;
        }

        public final void setDirectPathParallelLoad(Boolean directPathParallelLoad) {
            this.directPathParallelLoad = directPathParallelLoad;
        }

        @Override
        public final Builder directPathParallelLoad(Boolean directPathParallelLoad) {
            this.directPathParallelLoad = directPathParallelLoad;
            return this;
        }

        public final Boolean getFailTasksOnLobTruncation() {
            return failTasksOnLobTruncation;
        }

        public final void setFailTasksOnLobTruncation(Boolean failTasksOnLobTruncation) {
            this.failTasksOnLobTruncation = failTasksOnLobTruncation;
        }

        @Override
        public final Builder failTasksOnLobTruncation(Boolean failTasksOnLobTruncation) {
            this.failTasksOnLobTruncation = failTasksOnLobTruncation;
            return this;
        }

        public final Integer getNumberDatatypeScale() {
            return numberDatatypeScale;
        }

        public final void setNumberDatatypeScale(Integer numberDatatypeScale) {
            this.numberDatatypeScale = numberDatatypeScale;
        }

        @Override
        public final Builder numberDatatypeScale(Integer numberDatatypeScale) {
            this.numberDatatypeScale = numberDatatypeScale;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getReadTableSpaceName() {
            return readTableSpaceName;
        }

        public final void setReadTableSpaceName(Boolean readTableSpaceName) {
            this.readTableSpaceName = readTableSpaceName;
        }

        @Override
        public final Builder readTableSpaceName(Boolean readTableSpaceName) {
            this.readTableSpaceName = readTableSpaceName;
            return this;
        }

        public final Integer getRetryInterval() {
            return retryInterval;
        }

        public final void setRetryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
        }

        @Override
        public final Builder retryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public final String getSecurityDbEncryption() {
            return securityDbEncryption;
        }

        public final void setSecurityDbEncryption(String securityDbEncryption) {
            this.securityDbEncryption = securityDbEncryption;
        }

        @Override
        public final Builder securityDbEncryption(String securityDbEncryption) {
            this.securityDbEncryption = securityDbEncryption;
            return this;
        }

        public final String getSecurityDbEncryptionName() {
            return securityDbEncryptionName;
        }

        public final void setSecurityDbEncryptionName(String securityDbEncryptionName) {
            this.securityDbEncryptionName = securityDbEncryptionName;
        }

        @Override
        public final Builder securityDbEncryptionName(String securityDbEncryptionName) {
            this.securityDbEncryptionName = securityDbEncryptionName;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getSpatialDataOptionToGeoJsonFunctionName() {
            return spatialDataOptionToGeoJsonFunctionName;
        }

        public final void setSpatialDataOptionToGeoJsonFunctionName(String spatialDataOptionToGeoJsonFunctionName) {
            this.spatialDataOptionToGeoJsonFunctionName = spatialDataOptionToGeoJsonFunctionName;
        }

        @Override
        public final Builder spatialDataOptionToGeoJsonFunctionName(String spatialDataOptionToGeoJsonFunctionName) {
            this.spatialDataOptionToGeoJsonFunctionName = spatialDataOptionToGeoJsonFunctionName;
            return this;
        }

        public final Integer getStandbyDelayTime() {
            return standbyDelayTime;
        }

        public final void setStandbyDelayTime(Integer standbyDelayTime) {
            this.standbyDelayTime = standbyDelayTime;
        }

        @Override
        public final Builder standbyDelayTime(Integer standbyDelayTime) {
            this.standbyDelayTime = standbyDelayTime;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Boolean getUseBFile() {
            return useBFile;
        }

        public final void setUseBFile(Boolean useBFile) {
            this.useBFile = useBFile;
        }

        @Override
        public final Builder useBFile(Boolean useBFile) {
            this.useBFile = useBFile;
            return this;
        }

        public final Boolean getUseDirectPathFullLoad() {
            return useDirectPathFullLoad;
        }

        public final void setUseDirectPathFullLoad(Boolean useDirectPathFullLoad) {
            this.useDirectPathFullLoad = useDirectPathFullLoad;
        }

        @Override
        public final Builder useDirectPathFullLoad(Boolean useDirectPathFullLoad) {
            this.useDirectPathFullLoad = useDirectPathFullLoad;
            return this;
        }

        public final Boolean getUseLogminerReader() {
            return useLogminerReader;
        }

        public final void setUseLogminerReader(Boolean useLogminerReader) {
            this.useLogminerReader = useLogminerReader;
        }

        @Override
        public final Builder useLogminerReader(Boolean useLogminerReader) {
            this.useLogminerReader = useLogminerReader;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final String getSecretsManagerOracleAsmAccessRoleArn() {
            return secretsManagerOracleAsmAccessRoleArn;
        }

        public final void setSecretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
            this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
            this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerOracleAsmSecretId() {
            return secretsManagerOracleAsmSecretId;
        }

        public final void setSecretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
            this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
        }

        @Override
        public final Builder secretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
            this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
            return this;
        }

        public final Boolean getTrimSpaceInChar() {
            return trimSpaceInChar;
        }

        public final void setTrimSpaceInChar(Boolean trimSpaceInChar) {
            this.trimSpaceInChar = trimSpaceInChar;
        }

        @Override
        public final Builder trimSpaceInChar(Boolean trimSpaceInChar) {
            this.trimSpaceInChar = trimSpaceInChar;
            return this;
        }

        public final Boolean getConvertTimestampWithZoneToUTC() {
            return convertTimestampWithZoneToUTC;
        }

        public final void setConvertTimestampWithZoneToUTC(Boolean convertTimestampWithZoneToUTC) {
            this.convertTimestampWithZoneToUTC = convertTimestampWithZoneToUTC;
        }

        @Override
        public final Builder convertTimestampWithZoneToUTC(Boolean convertTimestampWithZoneToUTC) {
            this.convertTimestampWithZoneToUTC = convertTimestampWithZoneToUTC;
            return this;
        }

        public final Integer getOpenTransactionWindow() {
            return openTransactionWindow;
        }

        public final void setOpenTransactionWindow(Integer openTransactionWindow) {
            this.openTransactionWindow = openTransactionWindow;
        }

        @Override
        public final Builder openTransactionWindow(Integer openTransactionWindow) {
            this.openTransactionWindow = openTransactionWindow;
            return this;
        }

        public final String getAuthenticationMethod() {
            return authenticationMethod;
        }

        public final void setAuthenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
        }

        @Override
        public final Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Override
        public final Builder authenticationMethod(OracleAuthenticationMethod authenticationMethod) {
            this.authenticationMethod(authenticationMethod == null ? null : authenticationMethod.toString());
            return this;
        }

        @Override
        public OracleSettings build() {
            return new OracleSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
