/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDataMigrationRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, StartDataMigrationRequest> {
    private static final SdkField<String> DATA_MIGRATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationIdentifier").getter(StartDataMigrationRequest.getter(StartDataMigrationRequest::dataMigrationIdentifier)).setter(StartDataMigrationRequest.setter(Builder::dataMigrationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationIdentifier").build()}).build();
    private static final SdkField<String> START_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartType").getter(StartDataMigrationRequest.getter(StartDataMigrationRequest::startTypeAsString)).setter(StartDataMigrationRequest.setter(Builder::startType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MIGRATION_IDENTIFIER_FIELD, START_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDataMigrationRequest.memberNameToFieldInitializer();
    private final String dataMigrationIdentifier;
    private final String startType;

    private StartDataMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.dataMigrationIdentifier = builder.dataMigrationIdentifier;
        this.startType = builder.startType;
    }

    public final String dataMigrationIdentifier() {
        return this.dataMigrationIdentifier;
    }

    public final StartReplicationMigrationTypeValue startType() {
        return StartReplicationMigrationTypeValue.fromValue(this.startType);
    }

    public final String startTypeAsString() {
        return this.startType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataMigrationRequest)) {
            return false;
        }
        StartDataMigrationRequest other = (StartDataMigrationRequest)((Object)obj);
        return Objects.equals(this.dataMigrationIdentifier(), other.dataMigrationIdentifier()) && Objects.equals(this.startTypeAsString(), other.startTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartDataMigrationRequest").add("DataMigrationIdentifier", (Object)this.dataMigrationIdentifier()).add("StartType", (Object)this.startTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataMigrationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationIdentifier()));
            }
            case "StartType": {
                return Optional.ofNullable(clazz.cast(this.startTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataMigrationIdentifier", DATA_MIGRATION_IDENTIFIER_FIELD);
        map.put("StartType", START_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDataMigrationRequest, T> g) {
        return obj -> g.apply((StartDataMigrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String dataMigrationIdentifier;
        private String startType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataMigrationRequest model) {
            super(model);
            this.dataMigrationIdentifier(model.dataMigrationIdentifier);
            this.startType(model.startType);
        }

        public final String getDataMigrationIdentifier() {
            return this.dataMigrationIdentifier;
        }

        public final void setDataMigrationIdentifier(String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
        }

        @Override
        public final Builder dataMigrationIdentifier(String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
            return this;
        }

        public final String getStartType() {
            return this.startType;
        }

        public final void setStartType(String startType) {
            this.startType = startType;
        }

        @Override
        public final Builder startType(String startType) {
            this.startType = startType;
            return this;
        }

        @Override
        public final Builder startType(StartReplicationMigrationTypeValue startType) {
            this.startType(startType == null ? null : startType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataMigrationRequest build() {
            return new StartDataMigrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDataMigrationRequest> {
        public Builder dataMigrationIdentifier(String var1);

        public Builder startType(String var1);

        public Builder startType(StartReplicationMigrationTypeValue var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

