/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse;

public class DescribeMetadataModelImportsIterable
implements SdkIterable<DescribeMetadataModelImportsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeMetadataModelImportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMetadataModelImportsIterable(DatabaseMigrationClient client, DescribeMetadataModelImportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMetadataModelImportsResponseFetcher();
    }

    public Iterator<DescribeMetadataModelImportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeMetadataModelImportsResponseFetcher
    implements SyncPageFetcher<DescribeMetadataModelImportsResponse> {
        private DescribeMetadataModelImportsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelImportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeMetadataModelImportsResponse nextPage(DescribeMetadataModelImportsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelImportsIterable.this.client.describeMetadataModelImports(DescribeMetadataModelImportsIterable.this.firstRequest);
            }
            return DescribeMetadataModelImportsIterable.this.client.describeMetadataModelImports((DescribeMetadataModelImportsRequest)((Object)DescribeMetadataModelImportsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

