/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationServiceClientConfiguration;
import software.amazon.awssdk.services.databasemigration.internal.DatabaseMigrationServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.databasemigration.model.AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.CollectorNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationException;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.FailedDependencyException;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.InsufficientResourceCapacityException;
import software.amazon.awssdk.services.databasemigration.model.InvalidCertificateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidOperationException;
import software.amazon.awssdk.services.databasemigration.model.InvalidResourceStateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidSubnetException;
import software.amazon.awssdk.services.databasemigration.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.KmsDisabledException;
import software.amazon.awssdk.services.databasemigration.model.KmsException;
import software.amazon.awssdk.services.databasemigration.model.KmsInvalidStateException;
import software.amazon.awssdk.services.databasemigration.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.databasemigration.model.KmsNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.KmsThrottlingException;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.ResourceQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisRequest;
import software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.S3AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.S3ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.databasemigration.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StopDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest;
import software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse;
import software.amazon.awssdk.services.databasemigration.model.UpgradeDependencyFailureException;
import software.amazon.awssdk.services.databasemigration.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.BatchStartRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CancelReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateDataProviderRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateFleetAdvisorCollectorRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateMigrationProjectRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationConfigRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteDataProviderRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteFleetAdvisorCollectorRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteFleetAdvisorDatabasesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteMigrationProjectRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationConfigRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeApplicableIndividualAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeConnectionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeConversionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeDataMigrationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeDataProvidersRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointSettingsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointTypesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeExtensionPackAssociationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorCollectorsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorDatabasesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorLsaAnalysisRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorSchemaObjectSummaryRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeInstanceProfilesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelConversionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelExportsAsScriptRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelExportsToTargetRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelImportsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMigrationProjectsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeOrderableReplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeRecommendationLimitationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeRefreshSchemasStatusRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationConfigsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationInstanceTaskLogsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTableStatisticsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskAssessmentResultsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskAssessmentRunsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskIndividualAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTasksRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeTableStatisticsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ExportMetadataModelAssessmentRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ImportCertificateRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyConversionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyDataProviderRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyMigrationProjectRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationConfigRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.MoveReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RebootReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RefreshSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ReloadReplicationTablesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ReloadTablesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RunFleetAdvisorLsaAnalysisRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartExtensionPackAssociationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelAssessmentRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelConversionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelExportAsScriptRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelExportToTargetRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelImportRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskAssessmentRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StopDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StopReplicationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StopReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.TestConnectionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.UpdateSubscriptionsToEventBridgeRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDatabaseMigrationClient
implements DatabaseMigrationClient {
    private static final Logger log = Logger.loggerFor(DefaultDatabaseMigrationClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDatabaseMigrationClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Database_Migration_Service#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsToResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            AddTagsToResourceResponse addTagsToResourceResponse = (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addTagsToResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsToResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$addTagsToResource$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ApplyPendingMaintenanceActionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)applyPendingMaintenanceActionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplyPendingMaintenanceAction");
            ApplyPendingMaintenanceActionResponse applyPendingMaintenanceActionResponse = (ApplyPendingMaintenanceActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyPendingMaintenanceAction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)applyPendingMaintenanceActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ApplyPendingMaintenanceActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return applyPendingMaintenanceActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$applyPendingMaintenanceAction$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchStartRecommendationsResponse batchStartRecommendations(BatchStartRecommendationsRequest batchStartRecommendationsRequest) throws InvalidResourceStateException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchStartRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchStartRecommendationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, batchStartRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchStartRecommendations");
            BatchStartRecommendationsResponse batchStartRecommendationsResponse = (BatchStartRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchStartRecommendations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchStartRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchStartRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchStartRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$batchStartRecommendations$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRun(CancelReplicationTaskAssessmentRunRequest cancelReplicationTaskAssessmentRunRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelReplicationTaskAssessmentRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelReplicationTaskAssessmentRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, cancelReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelReplicationTaskAssessmentRun");
            CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRunResponse = (CancelReplicationTaskAssessmentRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelReplicationTaskAssessmentRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelReplicationTaskAssessmentRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelReplicationTaskAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelReplicationTaskAssessmentRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$cancelReplicationTaskAssessmentRun$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataMigrationResponse createDataMigration(CreateDataMigrationRequest createDataMigrationRequest) throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException, InvalidOperationException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataMigrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataMigrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createDataMigrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataMigration");
            CreateDataMigrationResponse createDataMigrationResponse = (CreateDataMigrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataMigration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDataMigrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataMigrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataMigrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createDataMigration$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataProviderResponse createDataProvider(CreateDataProviderRequest createDataProviderRequest) throws ResourceQuotaExceededException, AccessDeniedException, ResourceAlreadyExistsException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createDataProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataProvider");
            CreateDataProviderResponse createDataProviderResponse = (CreateDataProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDataProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createDataProvider$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest) throws KmsKeyNotAccessibleException, ResourceAlreadyExistsException, ResourceQuotaExceededException, InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, S3AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpoint");
            CreateEndpointResponse createEndpointResponse = (CreateEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createEndpoint$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException, SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventSubscription");
            CreateEventSubscriptionResponse createEventSubscriptionResponse = (CreateEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createEventSubscription$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFleetAdvisorCollectorResponse createFleetAdvisorCollector(CreateFleetAdvisorCollectorRequest createFleetAdvisorCollectorRequest) throws InvalidResourceStateException, AccessDeniedException, S3AccessDeniedException, S3ResourceNotFoundException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFleetAdvisorCollectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFleetAdvisorCollectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createFleetAdvisorCollectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFleetAdvisorCollector");
            CreateFleetAdvisorCollectorResponse createFleetAdvisorCollectorResponse = (CreateFleetAdvisorCollectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFleetAdvisorCollector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFleetAdvisorCollectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFleetAdvisorCollectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFleetAdvisorCollectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createFleetAdvisorCollector$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInstanceProfileResponse createInstanceProfile(CreateInstanceProfileRequest createInstanceProfileRequest) throws AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceQuotaExceededException, InvalidResourceStateException, KmsKeyNotAccessibleException, S3ResourceNotFoundException, S3AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstanceProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInstanceProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createInstanceProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstanceProfile");
            CreateInstanceProfileResponse createInstanceProfileResponse = (CreateInstanceProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstanceProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createInstanceProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateInstanceProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInstanceProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createInstanceProfile$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMigrationProjectResponse createMigrationProject(CreateMigrationProjectRequest createMigrationProjectRequest) throws AccessDeniedException, ResourceAlreadyExistsException, ResourceQuotaExceededException, ResourceNotFoundException, S3ResourceNotFoundException, S3AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMigrationProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMigrationProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createMigrationProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMigrationProject");
            CreateMigrationProjectResponse createMigrationProjectResponse = (CreateMigrationProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMigrationProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMigrationProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMigrationProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMigrationProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createMigrationProject$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationConfigResponse createReplicationConfig(CreateReplicationConfigRequest createReplicationConfigRequest) throws AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException, InvalidResourceStateException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReplicationConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createReplicationConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationConfig");
            CreateReplicationConfigResponse createReplicationConfigResponse = (CreateReplicationConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createReplicationConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createReplicationConfig$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationInstanceResponse createReplicationInstance(CreateReplicationInstanceRequest createReplicationInstanceRequest) throws AccessDeniedException, ResourceAlreadyExistsException, InsufficientResourceCapacityException, ResourceQuotaExceededException, StorageQuotaExceededException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidResourceStateException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReplicationInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createReplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationInstance");
            CreateReplicationInstanceResponse createReplicationInstanceResponse = (CreateReplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createReplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createReplicationInstance$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationSubnetGroupResponse createReplicationSubnetGroup(CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest) throws AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException, ResourceQuotaExceededException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReplicationSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createReplicationSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationSubnetGroup");
            CreateReplicationSubnetGroupResponse createReplicationSubnetGroupResponse = (CreateReplicationSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createReplicationSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createReplicationSubnetGroup$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationTaskResponse createReplicationTask(CreateReplicationTaskRequest createReplicationTaskRequest) throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReplicationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, createReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationTask");
            CreateReplicationTaskResponse createReplicationTaskResponse = (CreateReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$createReplicationTask$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificate");
            DeleteCertificateResponse deleteCertificateResponse = (DeleteCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteCertificate$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnection");
            DeleteConnectionResponse deleteConnectionResponse = (DeleteConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteConnection$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataMigrationResponse deleteDataMigration(DeleteDataMigrationRequest deleteDataMigrationRequest) throws InvalidResourceStateException, ResourceNotFoundException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataMigrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataMigrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteDataMigrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataMigration");
            DeleteDataMigrationResponse deleteDataMigrationResponse = (DeleteDataMigrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataMigration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDataMigrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataMigrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataMigrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteDataMigration$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataProviderResponse deleteDataProvider(DeleteDataProviderRequest deleteDataProviderRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteDataProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataProvider");
            DeleteDataProviderResponse deleteDataProviderResponse = (DeleteDataProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDataProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteDataProvider$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpoint");
            DeleteEndpointResponse deleteEndpointResponse = (DeleteEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteEndpoint$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventSubscription");
            DeleteEventSubscriptionResponse deleteEventSubscriptionResponse = (DeleteEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteEventSubscription$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFleetAdvisorCollectorResponse deleteFleetAdvisorCollector(DeleteFleetAdvisorCollectorRequest deleteFleetAdvisorCollectorRequest) throws InvalidResourceStateException, CollectorNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFleetAdvisorCollectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFleetAdvisorCollectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteFleetAdvisorCollectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFleetAdvisorCollector");
            DeleteFleetAdvisorCollectorResponse deleteFleetAdvisorCollectorResponse = (DeleteFleetAdvisorCollectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFleetAdvisorCollector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFleetAdvisorCollectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFleetAdvisorCollectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFleetAdvisorCollectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteFleetAdvisorCollector$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFleetAdvisorDatabasesResponse deleteFleetAdvisorDatabases(DeleteFleetAdvisorDatabasesRequest deleteFleetAdvisorDatabasesRequest) throws ResourceNotFoundException, InvalidOperationException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFleetAdvisorDatabasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFleetAdvisorDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteFleetAdvisorDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFleetAdvisorDatabases");
            DeleteFleetAdvisorDatabasesResponse deleteFleetAdvisorDatabasesResponse = (DeleteFleetAdvisorDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFleetAdvisorDatabases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFleetAdvisorDatabasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFleetAdvisorDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFleetAdvisorDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteFleetAdvisorDatabases$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInstanceProfileResponse deleteInstanceProfile(DeleteInstanceProfileRequest deleteInstanceProfileRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInstanceProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteInstanceProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInstanceProfile");
            DeleteInstanceProfileResponse deleteInstanceProfileResponse = (DeleteInstanceProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstanceProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInstanceProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInstanceProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInstanceProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteInstanceProfile$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMigrationProjectResponse deleteMigrationProject(DeleteMigrationProjectRequest deleteMigrationProjectRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMigrationProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMigrationProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteMigrationProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMigrationProject");
            DeleteMigrationProjectResponse deleteMigrationProjectResponse = (DeleteMigrationProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMigrationProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMigrationProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMigrationProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMigrationProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteMigrationProject$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationConfigResponse deleteReplicationConfig(DeleteReplicationConfigRequest deleteReplicationConfigRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReplicationConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteReplicationConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationConfig");
            DeleteReplicationConfigResponse deleteReplicationConfigResponse = (DeleteReplicationConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReplicationConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationConfig$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationInstanceResponse deleteReplicationInstance(DeleteReplicationInstanceRequest deleteReplicationInstanceRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReplicationInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteReplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationInstance");
            DeleteReplicationInstanceResponse deleteReplicationInstanceResponse = (DeleteReplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationInstance$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroup(DeleteReplicationSubnetGroupRequest deleteReplicationSubnetGroupRequest) throws InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReplicationSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteReplicationSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationSubnetGroup");
            DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroupResponse = (DeleteReplicationSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReplicationSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationSubnetGroup$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationTaskResponse deleteReplicationTask(DeleteReplicationTaskRequest deleteReplicationTaskRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReplicationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationTask");
            DeleteReplicationTaskResponse deleteReplicationTaskResponse = (DeleteReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationTask$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRun(DeleteReplicationTaskAssessmentRunRequest deleteReplicationTaskAssessmentRunRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationTaskAssessmentRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReplicationTaskAssessmentRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, deleteReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationTaskAssessmentRun");
            DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRunResponse = (DeleteReplicationTaskAssessmentRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationTaskAssessmentRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReplicationTaskAssessmentRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationTaskAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationTaskAssessmentRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$deleteReplicationTaskAssessmentRun$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountAttributes");
            DescribeAccountAttributesResponse describeAccountAttributesResponse = (DescribeAccountAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAccountAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeAccountAttributes$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessments(DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicableIndividualAssessmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicableIndividualAssessmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeApplicableIndividualAssessmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplicableIndividualAssessments");
            DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessmentsResponse = (DescribeApplicableIndividualAssessmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicableIndividualAssessments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeApplicableIndividualAssessmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeApplicableIndividualAssessmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeApplicableIndividualAssessmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeApplicableIndividualAssessments$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificates");
            DescribeCertificatesResponse describeCertificatesResponse = (DescribeCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeCertificates$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsResponse describeConnections(DescribeConnectionsRequest describeConnectionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnections");
            DescribeConnectionsResponse describeConnectionsResponse = (DescribeConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeConnections$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConversionConfigurationResponse describeConversionConfiguration(DescribeConversionConfigurationRequest describeConversionConfigurationRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConversionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConversionConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeConversionConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConversionConfiguration");
            DescribeConversionConfigurationResponse describeConversionConfigurationResponse = (DescribeConversionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConversionConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConversionConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConversionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConversionConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeConversionConfiguration$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDataMigrationsResponse describeDataMigrations(DescribeDataMigrationsRequest describeDataMigrationsRequest) throws InvalidResourceStateException, ResourceNotFoundException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataMigrationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataMigrationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeDataMigrationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataMigrations");
            DescribeDataMigrationsResponse describeDataMigrationsResponse = (DescribeDataMigrationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataMigrations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDataMigrationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDataMigrationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDataMigrationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeDataMigrations$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDataProvidersResponse describeDataProviders(DescribeDataProvidersRequest describeDataProvidersRequest) throws ResourceNotFoundException, AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataProvidersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataProvidersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeDataProvidersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataProviders");
            DescribeDataProvidersResponse describeDataProvidersResponse = (DescribeDataProvidersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataProviders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDataProvidersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDataProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDataProvidersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeDataProviders$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointSettingsResponse describeEndpointSettings(DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeEndpointSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointSettings");
            DescribeEndpointSettingsResponse describeEndpointSettingsResponse = (DescribeEndpointSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEndpointSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEndpointSettings$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointTypesResponse describeEndpointTypes(DescribeEndpointTypesRequest describeEndpointTypesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeEndpointTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointTypes");
            DescribeEndpointTypesResponse describeEndpointTypesResponse = (DescribeEndpointTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEndpointTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEndpointTypes$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            DescribeEndpointsResponse describeEndpointsResponse = (DescribeEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEndpoints$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEngineVersionsResponse describeEngineVersions(DescribeEngineVersionsRequest describeEngineVersionsRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEngineVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEngineVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeEngineVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineVersions");
            DescribeEngineVersionsResponse describeEngineVersionsResponse = (DescribeEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEngineVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEngineVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEngineVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEngineVersions$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventCategoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventCategoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeEventCategoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventCategories");
            DescribeEventCategoriesResponse describeEventCategoriesResponse = (DescribeEventCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventCategoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventCategoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEventCategories$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventSubscriptionsResponse describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventSubscriptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventSubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeEventSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventSubscriptions");
            DescribeEventSubscriptionsResponse describeEventSubscriptionsResponse = (DescribeEventSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventSubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventSubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEventSubscriptions$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            DescribeEventsResponse describeEventsResponse = (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeEvents$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExtensionPackAssociationsResponse describeExtensionPackAssociations(DescribeExtensionPackAssociationsRequest describeExtensionPackAssociationsRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExtensionPackAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExtensionPackAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeExtensionPackAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExtensionPackAssociations");
            DescribeExtensionPackAssociationsResponse describeExtensionPackAssociationsResponse = (DescribeExtensionPackAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExtensionPackAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeExtensionPackAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExtensionPackAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExtensionPackAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeExtensionPackAssociations$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetAdvisorCollectorsResponse describeFleetAdvisorCollectors(DescribeFleetAdvisorCollectorsRequest describeFleetAdvisorCollectorsRequest) throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetAdvisorCollectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFleetAdvisorCollectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeFleetAdvisorCollectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetAdvisorCollectors");
            DescribeFleetAdvisorCollectorsResponse describeFleetAdvisorCollectorsResponse = (DescribeFleetAdvisorCollectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetAdvisorCollectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFleetAdvisorCollectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetAdvisorCollectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetAdvisorCollectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeFleetAdvisorCollectors$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetAdvisorDatabasesResponse describeFleetAdvisorDatabases(DescribeFleetAdvisorDatabasesRequest describeFleetAdvisorDatabasesRequest) throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetAdvisorDatabasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFleetAdvisorDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeFleetAdvisorDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetAdvisorDatabases");
            DescribeFleetAdvisorDatabasesResponse describeFleetAdvisorDatabasesResponse = (DescribeFleetAdvisorDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetAdvisorDatabases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFleetAdvisorDatabasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetAdvisorDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetAdvisorDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeFleetAdvisorDatabases$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetAdvisorLsaAnalysisResponse describeFleetAdvisorLsaAnalysis(DescribeFleetAdvisorLsaAnalysisRequest describeFleetAdvisorLsaAnalysisRequest) throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetAdvisorLsaAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFleetAdvisorLsaAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeFleetAdvisorLsaAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetAdvisorLsaAnalysis");
            DescribeFleetAdvisorLsaAnalysisResponse describeFleetAdvisorLsaAnalysisResponse = (DescribeFleetAdvisorLsaAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetAdvisorLsaAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFleetAdvisorLsaAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetAdvisorLsaAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetAdvisorLsaAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeFleetAdvisorLsaAnalysis$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetAdvisorSchemaObjectSummaryResponse describeFleetAdvisorSchemaObjectSummary(DescribeFleetAdvisorSchemaObjectSummaryRequest describeFleetAdvisorSchemaObjectSummaryRequest) throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetAdvisorSchemaObjectSummaryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFleetAdvisorSchemaObjectSummaryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeFleetAdvisorSchemaObjectSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetAdvisorSchemaObjectSummary");
            DescribeFleetAdvisorSchemaObjectSummaryResponse describeFleetAdvisorSchemaObjectSummaryResponse = (DescribeFleetAdvisorSchemaObjectSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetAdvisorSchemaObjectSummary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFleetAdvisorSchemaObjectSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetAdvisorSchemaObjectSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetAdvisorSchemaObjectSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeFleetAdvisorSchemaObjectSummary$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFleetAdvisorSchemasResponse describeFleetAdvisorSchemas(DescribeFleetAdvisorSchemasRequest describeFleetAdvisorSchemasRequest) throws InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetAdvisorSchemasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFleetAdvisorSchemasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeFleetAdvisorSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFleetAdvisorSchemas");
            DescribeFleetAdvisorSchemasResponse describeFleetAdvisorSchemasResponse = (DescribeFleetAdvisorSchemasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetAdvisorSchemas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFleetAdvisorSchemasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFleetAdvisorSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFleetAdvisorSchemasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeFleetAdvisorSchemas$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceProfilesResponse describeInstanceProfiles(DescribeInstanceProfilesRequest describeInstanceProfilesRequest) throws ResourceNotFoundException, AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInstanceProfilesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInstanceProfilesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeInstanceProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInstanceProfiles");
            DescribeInstanceProfilesResponse describeInstanceProfilesResponse = (DescribeInstanceProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceProfiles").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInstanceProfilesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInstanceProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInstanceProfilesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeInstanceProfiles$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetadataModelAssessmentsResponse describeMetadataModelAssessments(DescribeMetadataModelAssessmentsRequest describeMetadataModelAssessmentsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetadataModelAssessmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMetadataModelAssessmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeMetadataModelAssessmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetadataModelAssessments");
            DescribeMetadataModelAssessmentsResponse describeMetadataModelAssessmentsResponse = (DescribeMetadataModelAssessmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetadataModelAssessments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMetadataModelAssessmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetadataModelAssessmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMetadataModelAssessmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeMetadataModelAssessments$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetadataModelConversionsResponse describeMetadataModelConversions(DescribeMetadataModelConversionsRequest describeMetadataModelConversionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetadataModelConversionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMetadataModelConversionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeMetadataModelConversionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetadataModelConversions");
            DescribeMetadataModelConversionsResponse describeMetadataModelConversionsResponse = (DescribeMetadataModelConversionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetadataModelConversions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMetadataModelConversionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetadataModelConversionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMetadataModelConversionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeMetadataModelConversions$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetadataModelExportsAsScriptResponse describeMetadataModelExportsAsScript(DescribeMetadataModelExportsAsScriptRequest describeMetadataModelExportsAsScriptRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetadataModelExportsAsScriptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMetadataModelExportsAsScriptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeMetadataModelExportsAsScriptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetadataModelExportsAsScript");
            DescribeMetadataModelExportsAsScriptResponse describeMetadataModelExportsAsScriptResponse = (DescribeMetadataModelExportsAsScriptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetadataModelExportsAsScript").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMetadataModelExportsAsScriptRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetadataModelExportsAsScriptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMetadataModelExportsAsScriptResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeMetadataModelExportsAsScript$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetadataModelExportsToTargetResponse describeMetadataModelExportsToTarget(DescribeMetadataModelExportsToTargetRequest describeMetadataModelExportsToTargetRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetadataModelExportsToTargetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMetadataModelExportsToTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeMetadataModelExportsToTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetadataModelExportsToTarget");
            DescribeMetadataModelExportsToTargetResponse describeMetadataModelExportsToTargetResponse = (DescribeMetadataModelExportsToTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetadataModelExportsToTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMetadataModelExportsToTargetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetadataModelExportsToTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMetadataModelExportsToTargetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeMetadataModelExportsToTarget$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetadataModelImportsResponse describeMetadataModelImports(DescribeMetadataModelImportsRequest describeMetadataModelImportsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetadataModelImportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMetadataModelImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeMetadataModelImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetadataModelImports");
            DescribeMetadataModelImportsResponse describeMetadataModelImportsResponse = (DescribeMetadataModelImportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetadataModelImports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMetadataModelImportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetadataModelImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMetadataModelImportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeMetadataModelImports$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMigrationProjectsResponse describeMigrationProjects(DescribeMigrationProjectsRequest describeMigrationProjectsRequest) throws ResourceNotFoundException, AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMigrationProjectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMigrationProjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeMigrationProjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMigrationProjects");
            DescribeMigrationProjectsResponse describeMigrationProjectsResponse = (DescribeMigrationProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMigrationProjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMigrationProjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMigrationProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMigrationProjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeMigrationProjects$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest) throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrderableReplicationInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrderableReplicationInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeOrderableReplicationInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrderableReplicationInstances");
            DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstancesResponse = (DescribeOrderableReplicationInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableReplicationInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOrderableReplicationInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrderableReplicationInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrderableReplicationInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeOrderableReplicationInstances$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePendingMaintenanceActionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePendingMaintenanceActionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePendingMaintenanceActions");
            DescribePendingMaintenanceActionsResponse describePendingMaintenanceActionsResponse = (DescribePendingMaintenanceActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingMaintenanceActions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePendingMaintenanceActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePendingMaintenanceActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePendingMaintenanceActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describePendingMaintenanceActions$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRecommendationLimitationsResponse describeRecommendationLimitations(DescribeRecommendationLimitationsRequest describeRecommendationLimitationsRequest) throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecommendationLimitationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRecommendationLimitationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeRecommendationLimitationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRecommendationLimitations");
            DescribeRecommendationLimitationsResponse describeRecommendationLimitationsResponse = (DescribeRecommendationLimitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecommendationLimitations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRecommendationLimitationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRecommendationLimitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRecommendationLimitationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeRecommendationLimitations$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRecommendationsResponse describeRecommendations(DescribeRecommendationsRequest describeRecommendationsRequest) throws InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRecommendationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRecommendations");
            DescribeRecommendationsResponse describeRecommendationsResponse = (DescribeRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecommendations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeRecommendations$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatus(DescribeRefreshSchemasStatusRequest describeRefreshSchemasStatusRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRefreshSchemasStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRefreshSchemasStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeRefreshSchemasStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRefreshSchemasStatus");
            DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatusResponse = (DescribeRefreshSchemasStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRefreshSchemasStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRefreshSchemasStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRefreshSchemasStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRefreshSchemasStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeRefreshSchemasStatus$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationConfigsResponse describeReplicationConfigs(DescribeReplicationConfigsRequest describeReplicationConfigsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationConfigsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationConfigsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationConfigsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationConfigs");
            DescribeReplicationConfigsResponse describeReplicationConfigsResponse = (DescribeReplicationConfigsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationConfigs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationConfigsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationConfigsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationConfigsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationConfigs$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationInstanceTaskLogsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationInstanceTaskLogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationInstanceTaskLogsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationInstanceTaskLogs");
            DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogsResponse = (DescribeReplicationInstanceTaskLogsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationInstanceTaskLogs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationInstanceTaskLogsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationInstanceTaskLogsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationInstanceTaskLogsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationInstanceTaskLogs$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationInstancesResponse describeReplicationInstances(DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationInstances");
            DescribeReplicationInstancesResponse describeReplicationInstancesResponse = (DescribeReplicationInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationInstances$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationSubnetGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationSubnetGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationSubnetGroups");
            DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroupsResponse = (DescribeReplicationSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationSubnetGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationSubnetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationSubnetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationSubnetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationSubnetGroups$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTableStatisticsResponse describeReplicationTableStatistics(DescribeReplicationTableStatisticsRequest describeReplicationTableStatisticsRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTableStatisticsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationTableStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationTableStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTableStatistics");
            DescribeReplicationTableStatisticsResponse describeReplicationTableStatisticsResponse = (DescribeReplicationTableStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTableStatistics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationTableStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTableStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTableStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTableStatistics$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResults(DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTaskAssessmentResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationTaskAssessmentResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationTaskAssessmentResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTaskAssessmentResults");
            DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResultsResponse = (DescribeReplicationTaskAssessmentResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTaskAssessmentResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationTaskAssessmentResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTaskAssessmentResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTaskAssessmentResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTaskAssessmentResults$135((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTaskAssessmentRunsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationTaskAssessmentRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationTaskAssessmentRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTaskAssessmentRuns");
            DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRunsResponse = (DescribeReplicationTaskAssessmentRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTaskAssessmentRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationTaskAssessmentRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTaskAssessmentRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTaskAssessmentRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTaskAssessmentRuns$137((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessments(DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTaskIndividualAssessmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationTaskIndividualAssessmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationTaskIndividualAssessmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTaskIndividualAssessments");
            DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessmentsResponse = (DescribeReplicationTaskIndividualAssessmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTaskIndividualAssessments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationTaskIndividualAssessmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTaskIndividualAssessmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTaskIndividualAssessmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTaskIndividualAssessments$139((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationTasksResponse describeReplicationTasks(DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationTasks");
            DescribeReplicationTasksResponse describeReplicationTasksResponse = (DescribeReplicationTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplicationTasks$141((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationsResponse describeReplications(DescribeReplicationsRequest describeReplicationsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReplicationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeReplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplications");
            DescribeReplicationsResponse describeReplicationsResponse = (DescribeReplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplications").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeReplications$143((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSchemasResponse describeSchemas(DescribeSchemasRequest describeSchemasRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSchemasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSchemasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSchemas");
            DescribeSchemasResponse describeSchemasResponse = (DescribeSchemasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSchemas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSchemasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSchemasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeSchemas$145((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableStatisticsResponse describeTableStatistics(DescribeTableStatisticsRequest describeTableStatisticsRequest) throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableStatisticsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTableStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, describeTableStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableStatistics");
            DescribeTableStatisticsResponse describeTableStatisticsResponse = (DescribeTableStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableStatistics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTableStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$describeTableStatistics$147((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportMetadataModelAssessmentResponse exportMetadataModelAssessment(ExportMetadataModelAssessmentRequest exportMetadataModelAssessmentRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportMetadataModelAssessmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exportMetadataModelAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, exportMetadataModelAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportMetadataModelAssessment");
            ExportMetadataModelAssessmentResponse exportMetadataModelAssessmentResponse = (ExportMetadataModelAssessmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportMetadataModelAssessment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)exportMetadataModelAssessmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportMetadataModelAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportMetadataModelAssessmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$exportMetadataModelAssessment$149((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportCertificateResponse importCertificate(ImportCertificateRequest importCertificateRequest) throws ResourceAlreadyExistsException, InvalidCertificateException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, importCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportCertificate");
            ImportCertificateResponse importCertificateResponse = (ImportCertificateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importCertificateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importCertificateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$importCertificate$151((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$listTagsForResource$153((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyConversionConfigurationResponse modifyConversionConfiguration(ModifyConversionConfigurationRequest modifyConversionConfigurationRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyConversionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyConversionConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyConversionConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyConversionConfiguration");
            ModifyConversionConfigurationResponse modifyConversionConfigurationResponse = (ModifyConversionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyConversionConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyConversionConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyConversionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyConversionConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyConversionConfiguration$155((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDataMigrationResponse modifyDataMigration(ModifyDataMigrationRequest modifyDataMigrationRequest) throws InvalidResourceStateException, ResourceNotFoundException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyDataMigrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyDataMigrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyDataMigrationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDataMigration");
            ModifyDataMigrationResponse modifyDataMigrationResponse = (ModifyDataMigrationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDataMigration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyDataMigrationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDataMigrationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyDataMigrationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyDataMigration$157((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDataProviderResponse modifyDataProvider(ModifyDataProviderRequest modifyDataProviderRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyDataProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyDataProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyDataProviderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDataProvider");
            ModifyDataProviderResponse modifyDataProviderResponse = (ModifyDataProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDataProvider").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyDataProviderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDataProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyDataProviderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyDataProvider$159((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyEndpointResponse modifyEndpoint(ModifyEndpointRequest modifyEndpointRequest) throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException, KmsKeyNotAccessibleException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEndpoint");
            ModifyEndpointResponse modifyEndpointResponse = (ModifyEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyEndpoint$161((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) throws ResourceQuotaExceededException, ResourceNotFoundException, SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyEventSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyEventSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyEventSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyEventSubscription");
            ModifyEventSubscriptionResponse modifyEventSubscriptionResponse = (ModifyEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEventSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyEventSubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyEventSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyEventSubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyEventSubscription$163((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyInstanceProfileResponse modifyInstanceProfile(ModifyInstanceProfileRequest modifyInstanceProfileRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, KmsKeyNotAccessibleException, S3ResourceNotFoundException, S3AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyInstanceProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyInstanceProfileRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyInstanceProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyInstanceProfile");
            ModifyInstanceProfileResponse modifyInstanceProfileResponse = (ModifyInstanceProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyInstanceProfile").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyInstanceProfileRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyInstanceProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyInstanceProfileResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyInstanceProfile$165((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyMigrationProjectResponse modifyMigrationProject(ModifyMigrationProjectRequest modifyMigrationProjectRequest) throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, S3ResourceNotFoundException, S3AccessDeniedException, FailedDependencyException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyMigrationProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyMigrationProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyMigrationProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyMigrationProject");
            ModifyMigrationProjectResponse modifyMigrationProjectResponse = (ModifyMigrationProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyMigrationProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyMigrationProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyMigrationProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyMigrationProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyMigrationProject$167((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyReplicationConfigResponse modifyReplicationConfig(ModifyReplicationConfigRequest modifyReplicationConfigRequest) throws AccessDeniedException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, KmsKeyNotAccessibleException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyReplicationConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyReplicationConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyReplicationConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyReplicationConfig");
            ModifyReplicationConfigResponse modifyReplicationConfigResponse = (ModifyReplicationConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyReplicationConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyReplicationConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyReplicationConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyReplicationConfig$169((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyReplicationInstanceResponse modifyReplicationInstance(ModifyReplicationInstanceRequest modifyReplicationInstanceRequest) throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException, InsufficientResourceCapacityException, StorageQuotaExceededException, UpgradeDependencyFailureException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyReplicationInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyReplicationInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyReplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyReplicationInstance");
            ModifyReplicationInstanceResponse modifyReplicationInstanceResponse = (ModifyReplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyReplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyReplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyReplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyReplicationInstance$171((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroup(ModifyReplicationSubnetGroupRequest modifyReplicationSubnetGroupRequest) throws AccessDeniedException, ResourceNotFoundException, ResourceQuotaExceededException, SubnetAlreadyInUseException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyReplicationSubnetGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyReplicationSubnetGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyReplicationSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyReplicationSubnetGroup");
            ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroupResponse = (ModifyReplicationSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationSubnetGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyReplicationSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyReplicationSubnetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyReplicationSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyReplicationSubnetGroup$173((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyReplicationTaskResponse modifyReplicationTask(ModifyReplicationTaskRequest modifyReplicationTaskRequest) throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyReplicationTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)modifyReplicationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, modifyReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyReplicationTask");
            ModifyReplicationTaskResponse modifyReplicationTaskResponse = (ModifyReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyReplicationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)modifyReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return modifyReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$modifyReplicationTask$175((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MoveReplicationTaskResponse moveReplicationTask(MoveReplicationTaskRequest moveReplicationTaskRequest) throws AccessDeniedException, InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MoveReplicationTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)moveReplicationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, moveReplicationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MoveReplicationTask");
            MoveReplicationTaskResponse moveReplicationTaskResponse = (MoveReplicationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MoveReplicationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)moveReplicationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new MoveReplicationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return moveReplicationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$moveReplicationTask$177((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootReplicationInstanceResponse rebootReplicationInstance(RebootReplicationInstanceRequest rebootReplicationInstanceRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootReplicationInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootReplicationInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, rebootReplicationInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootReplicationInstance");
            RebootReplicationInstanceResponse rebootReplicationInstanceResponse = (RebootReplicationInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootReplicationInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rebootReplicationInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootReplicationInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebootReplicationInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$rebootReplicationInstance$179((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefreshSchemasResponse refreshSchemas(RefreshSchemasRequest refreshSchemasRequest) throws InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RefreshSchemasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)refreshSchemasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, refreshSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RefreshSchemas");
            RefreshSchemasResponse refreshSchemasResponse = (RefreshSchemasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RefreshSchemas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)refreshSchemasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RefreshSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return refreshSchemasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$refreshSchemas$181((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReloadReplicationTablesResponse reloadReplicationTables(ReloadReplicationTablesRequest reloadReplicationTablesRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReloadReplicationTablesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)reloadReplicationTablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, reloadReplicationTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReloadReplicationTables");
            ReloadReplicationTablesResponse reloadReplicationTablesResponse = (ReloadReplicationTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReloadReplicationTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)reloadReplicationTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReloadReplicationTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return reloadReplicationTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$reloadReplicationTables$183((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReloadTablesResponse reloadTables(ReloadTablesRequest reloadTablesRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReloadTablesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)reloadTablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, reloadTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReloadTables");
            ReloadTablesResponse reloadTablesResponse = (ReloadTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReloadTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)reloadTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ReloadTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return reloadTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$reloadTables$185((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsFromResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            RemoveTagsFromResourceResponse removeTagsFromResourceResponse = (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeTagsFromResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTagsFromResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDatabaseMigrationClient.lambda$removeTagsFromResource$187((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunFleetAdvisorLsaAnalysisResponse runFleetAdvisorLsaAnalysis(RunFleetAdvisorLsaAnalysisRequest runFleetAdvisorLsaAnalysisRequest) throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RunFleetAdvisorLsaAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "FailedDependencyFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                }
                case "KMSThrottlingFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                }
                case "KMSNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                }
                case "KMSKeyNotAccessibleFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                }
                case "S3AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                }
                case "InvalidResourceStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "KMSDisabledFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsDisabledException::builder).build());
                }
                case "StorageQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                }
                case "InvalidOperationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                }
                case "InvalidCertificateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                }
                case "KMSInvalidStateFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                }
                case "InsufficientResourceCapacityFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                }
                case "ResourceQuotaExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                }
                case "ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "KMSAccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                }
                case "SubnetAlreadyInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                }
                case "ResourceAlreadyExistsFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidSubnet": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                }
                case "CollectorNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                }
                case "KMSFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "UpgradeDependencyFailureFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                }
                case "SNSInvalidTopicFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                }
                case "AccessDeniedFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "SNSNoAuthorizationFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                }
                case "S3ResourceNotFoundFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                }
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)runFleetAdvisorLsaAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDatabaseMigrationClient.resolveMetricPublishers(clientConfiguration, runFleetAdvisorLsaAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RunFleetAdvisorLsaAnalysis");
            RunFleetAdvisorLsaAnalysisResponse runFleetAdvisorLsaAnalysisResponse = (RunFleetAdvisorLsaAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RunFleetAdvisorLsaAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)runFleetAdvisorLsaAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RunFleetAdvisorLs