/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftDataProviderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(RedshiftDataProviderSettings.getter(RedshiftDataProviderSettings::serverName)).setter(RedshiftDataProviderSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RedshiftDataProviderSettings.getter(RedshiftDataProviderSettings::port)).setter(RedshiftDataProviderSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(RedshiftDataProviderSettings.getter(RedshiftDataProviderSettings::databaseName)).setter(RedshiftDataProviderSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Path").getter(RedshiftDataProviderSettings.getter(RedshiftDataProviderSettings::s3Path)).setter(RedshiftDataProviderSettings.setter(Builder::s3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()}).build();
    private static final SdkField<String> S3_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3AccessRoleArn").getter(RedshiftDataProviderSettings.getter(RedshiftDataProviderSettings::s3AccessRoleArn)).setter(RedshiftDataProviderSettings.setter(Builder::s3AccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, S3_PATH_FIELD, S3_ACCESS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftDataProviderSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serverName;
    private final Integer port;
    private final String databaseName;
    private final String s3Path;
    private final String s3AccessRoleArn;

    private RedshiftDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.s3Path = builder.s3Path;
        this.s3AccessRoleArn = builder.s3AccessRoleArn;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer port() {
        return this.port;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String s3Path() {
        return this.s3Path;
    }

    public final String s3AccessRoleArn() {
        return this.s3AccessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataProviderSettings)) {
            return false;
        }
        RedshiftDataProviderSettings other = (RedshiftDataProviderSettings)obj;
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.s3Path(), other.s3Path()) && Objects.equals(this.s3AccessRoleArn(), other.s3AccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftDataProviderSettings").add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).add("S3Path", (Object)this.s3Path()).add("S3AccessRoleArn", (Object)this.s3AccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "S3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
            case "S3AccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.s3AccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("S3Path", S3_PATH_FIELD);
        map.put("S3AccessRoleArn", S3_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDataProviderSettings, T> g) {
        return obj -> g.apply((RedshiftDataProviderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverName;
        private Integer port;
        private String databaseName;
        private String s3Path;
        private String s3AccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataProviderSettings model) {
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
            this.s3Path(model.s3Path);
            this.s3AccessRoleArn(model.s3AccessRoleArn);
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getS3Path() {
            return this.s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getS3AccessRoleArn() {
            return this.s3AccessRoleArn;
        }

        public final void setS3AccessRoleArn(String s3AccessRoleArn) {
            this.s3AccessRoleArn = s3AccessRoleArn;
        }

        @Override
        public final Builder s3AccessRoleArn(String s3AccessRoleArn) {
            this.s3AccessRoleArn = s3AccessRoleArn;
            return this;
        }

        public RedshiftDataProviderSettings build() {
            return new RedshiftDataProviderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftDataProviderSettings> {
        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);

        public Builder s3Path(String var1);

        public Builder s3AccessRoleArn(String var1);
    }
}

