/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Briefly describes a Fleet Advisor collector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollectorShortInfoResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CollectorShortInfoResponse.Builder, CollectorShortInfoResponse> {
    private static final SdkField<String> COLLECTOR_REFERENCED_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectorReferencedId").getter(getter(CollectorShortInfoResponse::collectorReferencedId))
            .setter(setter(Builder::collectorReferencedId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorReferencedId").build())
            .build();

    private static final SdkField<String> COLLECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectorName").getter(getter(CollectorShortInfoResponse::collectorName))
            .setter(setter(Builder::collectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTOR_REFERENCED_ID_FIELD,
            COLLECTOR_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String collectorReferencedId;

    private final String collectorName;

    private CollectorShortInfoResponse(BuilderImpl builder) {
        this.collectorReferencedId = builder.collectorReferencedId;
        this.collectorName = builder.collectorName;
    }

    /**
     * <p>
     * The reference ID of the Fleet Advisor collector.
     * </p>
     * 
     * @return The reference ID of the Fleet Advisor collector.
     */
    public final String collectorReferencedId() {
        return collectorReferencedId;
    }

    /**
     * <p>
     * The name of the Fleet Advisor collector.
     * </p>
     * 
     * @return The name of the Fleet Advisor collector.
     */
    public final String collectorName() {
        return collectorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectorReferencedId());
        hashCode = 31 * hashCode + Objects.hashCode(collectorName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectorShortInfoResponse)) {
            return false;
        }
        CollectorShortInfoResponse other = (CollectorShortInfoResponse) obj;
        return Objects.equals(collectorReferencedId(), other.collectorReferencedId())
                && Objects.equals(collectorName(), other.collectorName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollectorShortInfoResponse").add("CollectorReferencedId", collectorReferencedId())
                .add("CollectorName", collectorName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectorReferencedId":
            return Optional.ofNullable(clazz.cast(collectorReferencedId()));
        case "CollectorName":
            return Optional.ofNullable(clazz.cast(collectorName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CollectorReferencedId", COLLECTOR_REFERENCED_ID_FIELD);
        map.put("CollectorName", COLLECTOR_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectorShortInfoResponse, T> g) {
        return obj -> g.apply((CollectorShortInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollectorShortInfoResponse> {
        /**
         * <p>
         * The reference ID of the Fleet Advisor collector.
         * </p>
         * 
         * @param collectorReferencedId
         *        The reference ID of the Fleet Advisor collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorReferencedId(String collectorReferencedId);

        /**
         * <p>
         * The name of the Fleet Advisor collector.
         * </p>
         * 
         * @param collectorName
         *        The name of the Fleet Advisor collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorName(String collectorName);
    }

    static final class BuilderImpl implements Builder {
        private String collectorReferencedId;

        private String collectorName;

        private BuilderImpl() {
        }

        private BuilderImpl(CollectorShortInfoResponse model) {
            collectorReferencedId(model.collectorReferencedId);
            collectorName(model.collectorName);
        }

        public final String getCollectorReferencedId() {
            return collectorReferencedId;
        }

        public final void setCollectorReferencedId(String collectorReferencedId) {
            this.collectorReferencedId = collectorReferencedId;
        }

        @Override
        public final Builder collectorReferencedId(String collectorReferencedId) {
            this.collectorReferencedId = collectorReferencedId;
            return this;
        }

        public final String getCollectorName() {
            return collectorName;
        }

        public final void setCollectorName(String collectorName) {
            this.collectorName = collectorName;
        }

        @Override
        public final Builder collectorName(String collectorName) {
            this.collectorName = collectorName;
            return this;
        }

        @Override
        public CollectorShortInfoResponse build() {
            return new CollectorShortInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
