/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a data provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProviderSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProviderSettings.Builder, DataProviderSettings> {
    private static final SdkField<RedshiftDataProviderSettings> REDSHIFT_SETTINGS_FIELD = SdkField
            .<RedshiftDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("RedshiftSettings")
            .getter(getter(DataProviderSettings::redshiftSettings)).setter(setter(Builder::redshiftSettings))
            .constructor(RedshiftDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftSettings").build()).build();

    private static final SdkField<PostgreSqlDataProviderSettings> POSTGRE_SQL_SETTINGS_FIELD = SdkField
            .<PostgreSqlDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("PostgreSqlSettings")
            .getter(getter(DataProviderSettings::postgreSqlSettings)).setter(setter(Builder::postgreSqlSettings))
            .constructor(PostgreSqlDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostgreSqlSettings").build())
            .build();

    private static final SdkField<MySqlDataProviderSettings> MY_SQL_SETTINGS_FIELD = SdkField
            .<MySqlDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("MySqlSettings")
            .getter(getter(DataProviderSettings::mySqlSettings)).setter(setter(Builder::mySqlSettings))
            .constructor(MySqlDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MySqlSettings").build()).build();

    private static final SdkField<OracleDataProviderSettings> ORACLE_SETTINGS_FIELD = SdkField
            .<OracleDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("OracleSettings")
            .getter(getter(DataProviderSettings::oracleSettings)).setter(setter(Builder::oracleSettings))
            .constructor(OracleDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OracleSettings").build()).build();

    private static final SdkField<MicrosoftSqlServerDataProviderSettings> MICROSOFT_SQL_SERVER_SETTINGS_FIELD = SdkField
            .<MicrosoftSqlServerDataProviderSettings> builder(MarshallingType.SDK_POJO)
            .memberName("MicrosoftSqlServerSettings")
            .getter(getter(DataProviderSettings::microsoftSqlServerSettings))
            .setter(setter(Builder::microsoftSqlServerSettings))
            .constructor(MicrosoftSqlServerDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftSqlServerSettings").build())
            .build();

    private static final SdkField<DocDbDataProviderSettings> DOC_DB_SETTINGS_FIELD = SdkField
            .<DocDbDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("DocDbSettings")
            .getter(getter(DataProviderSettings::docDbSettings)).setter(setter(Builder::docDbSettings))
            .constructor(DocDbDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocDbSettings").build()).build();

    private static final SdkField<MariaDbDataProviderSettings> MARIA_DB_SETTINGS_FIELD = SdkField
            .<MariaDbDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("MariaDbSettings")
            .getter(getter(DataProviderSettings::mariaDbSettings)).setter(setter(Builder::mariaDbSettings))
            .constructor(MariaDbDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MariaDbSettings").build()).build();

    private static final SdkField<IbmDb2LuwDataProviderSettings> IBM_DB2_LUW_SETTINGS_FIELD = SdkField
            .<IbmDb2LuwDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("IbmDb2LuwSettings")
            .getter(getter(DataProviderSettings::ibmDb2LuwSettings)).setter(setter(Builder::ibmDb2LuwSettings))
            .constructor(IbmDb2LuwDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IbmDb2LuwSettings").build()).build();

    private static final SdkField<IbmDb2zOsDataProviderSettings> IBM_DB2_Z_OS_SETTINGS_FIELD = SdkField
            .<IbmDb2zOsDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("IbmDb2zOsSettings")
            .getter(getter(DataProviderSettings::ibmDb2zOsSettings)).setter(setter(Builder::ibmDb2zOsSettings))
            .constructor(IbmDb2zOsDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IbmDb2zOsSettings").build()).build();

    private static final SdkField<MongoDbDataProviderSettings> MONGO_DB_SETTINGS_FIELD = SdkField
            .<MongoDbDataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("MongoDbSettings")
            .getter(getter(DataProviderSettings::mongoDbSettings)).setter(setter(Builder::mongoDbSettings))
            .constructor(MongoDbDataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MongoDbSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_SETTINGS_FIELD,
            POSTGRE_SQL_SETTINGS_FIELD, MY_SQL_SETTINGS_FIELD, ORACLE_SETTINGS_FIELD, MICROSOFT_SQL_SERVER_SETTINGS_FIELD,
            DOC_DB_SETTINGS_FIELD, MARIA_DB_SETTINGS_FIELD, IBM_DB2_LUW_SETTINGS_FIELD, IBM_DB2_Z_OS_SETTINGS_FIELD,
            MONGO_DB_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RedshiftDataProviderSettings redshiftSettings;

    private final PostgreSqlDataProviderSettings postgreSqlSettings;

    private final MySqlDataProviderSettings mySqlSettings;

    private final OracleDataProviderSettings oracleSettings;

    private final MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings;

    private final DocDbDataProviderSettings docDbSettings;

    private final MariaDbDataProviderSettings mariaDbSettings;

    private final IbmDb2LuwDataProviderSettings ibmDb2LuwSettings;

    private final IbmDb2zOsDataProviderSettings ibmDb2zOsSettings;

    private final MongoDbDataProviderSettings mongoDbSettings;

    private final Type type;

    private DataProviderSettings(BuilderImpl builder) {
        this.redshiftSettings = builder.redshiftSettings;
        this.postgreSqlSettings = builder.postgreSqlSettings;
        this.mySqlSettings = builder.mySqlSettings;
        this.oracleSettings = builder.oracleSettings;
        this.microsoftSqlServerSettings = builder.microsoftSqlServerSettings;
        this.docDbSettings = builder.docDbSettings;
        this.mariaDbSettings = builder.mariaDbSettings;
        this.ibmDb2LuwSettings = builder.ibmDb2LuwSettings;
        this.ibmDb2zOsSettings = builder.ibmDb2zOsSettings;
        this.mongoDbSettings = builder.mongoDbSettings;
        this.type = builder.type;
    }

    /**
     * Returns the value of the RedshiftSettings property for this object.
     * 
     * @return The value of the RedshiftSettings property for this object.
     */
    public final RedshiftDataProviderSettings redshiftSettings() {
        return redshiftSettings;
    }

    /**
     * Returns the value of the PostgreSqlSettings property for this object.
     * 
     * @return The value of the PostgreSqlSettings property for this object.
     */
    public final PostgreSqlDataProviderSettings postgreSqlSettings() {
        return postgreSqlSettings;
    }

    /**
     * Returns the value of the MySqlSettings property for this object.
     * 
     * @return The value of the MySqlSettings property for this object.
     */
    public final MySqlDataProviderSettings mySqlSettings() {
        return mySqlSettings;
    }

    /**
     * Returns the value of the OracleSettings property for this object.
     * 
     * @return The value of the OracleSettings property for this object.
     */
    public final OracleDataProviderSettings oracleSettings() {
        return oracleSettings;
    }

    /**
     * Returns the value of the MicrosoftSqlServerSettings property for this object.
     * 
     * @return The value of the MicrosoftSqlServerSettings property for this object.
     */
    public final MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings() {
        return microsoftSqlServerSettings;
    }

    /**
     * Returns the value of the DocDbSettings property for this object.
     * 
     * @return The value of the DocDbSettings property for this object.
     */
    public final DocDbDataProviderSettings docDbSettings() {
        return docDbSettings;
    }

    /**
     * <p>
     * Provides information that defines a MariaDB data provider.
     * </p>
     * 
     * @return Provides information that defines a MariaDB data provider.
     */
    public final MariaDbDataProviderSettings mariaDbSettings() {
        return mariaDbSettings;
    }

    /**
     * <p>
     * Provides information that defines an IBM DB2 LUW data provider.
     * </p>
     * 
     * @return Provides information that defines an IBM DB2 LUW data provider.
     */
    public final IbmDb2LuwDataProviderSettings ibmDb2LuwSettings() {
        return ibmDb2LuwSettings;
    }

    /**
     * <p>
     * Provides information that defines an IBM DB2 for z/OS data provider.
     * </p>
     * 
     * @return Provides information that defines an IBM DB2 for z/OS data provider.
     */
    public final IbmDb2zOsDataProviderSettings ibmDb2zOsSettings() {
        return ibmDb2zOsSettings;
    }

    /**
     * <p>
     * Provides information that defines a MongoDB data provider.
     * </p>
     * 
     * @return Provides information that defines a MongoDB data provider.
     */
    public final MongoDbDataProviderSettings mongoDbSettings() {
        return mongoDbSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redshiftSettings());
        hashCode = 31 * hashCode + Objects.hashCode(postgreSqlSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mySqlSettings());
        hashCode = 31 * hashCode + Objects.hashCode(oracleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(microsoftSqlServerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(docDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mariaDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ibmDb2LuwSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ibmDb2zOsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mongoDbSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProviderSettings)) {
            return false;
        }
        DataProviderSettings other = (DataProviderSettings) obj;
        return Objects.equals(redshiftSettings(), other.redshiftSettings())
                && Objects.equals(postgreSqlSettings(), other.postgreSqlSettings())
                && Objects.equals(mySqlSettings(), other.mySqlSettings())
                && Objects.equals(oracleSettings(), other.oracleSettings())
                && Objects.equals(microsoftSqlServerSettings(), other.microsoftSqlServerSettings())
                && Objects.equals(docDbSettings(), other.docDbSettings())
                && Objects.equals(mariaDbSettings(), other.mariaDbSettings())
                && Objects.equals(ibmDb2LuwSettings(), other.ibmDb2LuwSettings())
                && Objects.equals(ibmDb2zOsSettings(), other.ibmDb2zOsSettings())
                && Objects.equals(mongoDbSettings(), other.mongoDbSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProviderSettings").add("RedshiftSettings", redshiftSettings())
                .add("PostgreSqlSettings", postgreSqlSettings()).add("MySqlSettings", mySqlSettings())
                .add("OracleSettings", oracleSettings()).add("MicrosoftSqlServerSettings", microsoftSqlServerSettings())
                .add("DocDbSettings", docDbSettings()).add("MariaDbSettings", mariaDbSettings())
                .add("IbmDb2LuwSettings", ibmDb2LuwSettings()).add("IbmDb2zOsSettings", ibmDb2zOsSettings())
                .add("MongoDbSettings", mongoDbSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedshiftSettings":
            return Optional.ofNullable(clazz.cast(redshiftSettings()));
        case "PostgreSqlSettings":
            return Optional.ofNullable(clazz.cast(postgreSqlSettings()));
        case "MySqlSettings":
            return Optional.ofNullable(clazz.cast(mySqlSettings()));
        case "OracleSettings":
            return Optional.ofNullable(clazz.cast(oracleSettings()));
        case "MicrosoftSqlServerSettings":
            return Optional.ofNullable(clazz.cast(microsoftSqlServerSettings()));
        case "DocDbSettings":
            return Optional.ofNullable(clazz.cast(docDbSettings()));
        case "MariaDbSettings":
            return Optional.ofNullable(clazz.cast(mariaDbSettings()));
        case "IbmDb2LuwSettings":
            return Optional.ofNullable(clazz.cast(ibmDb2LuwSettings()));
        case "IbmDb2zOsSettings":
            return Optional.ofNullable(clazz.cast(ibmDb2zOsSettings()));
        case "MongoDbSettings":
            return Optional.ofNullable(clazz.cast(mongoDbSettings()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #redshiftSettings()} initialized to the given value.
     *
     * Sets the value of the RedshiftSettings property for this object.
     *
     * @param redshiftSettings
     *        The new value for the RedshiftSettings property for this object.
     */
    public static DataProviderSettings fromRedshiftSettings(RedshiftDataProviderSettings redshiftSettings) {
        return builder().redshiftSettings(redshiftSettings).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftSettings()} initialized to the given value.
     *
     * Sets the value of the RedshiftSettings property for this object.
     *
     * @param redshiftSettings
     *        The new value for the RedshiftSettings property for this object.
     */
    public static DataProviderSettings fromRedshiftSettings(Consumer<RedshiftDataProviderSettings.Builder> redshiftSettings) {
        RedshiftDataProviderSettings.Builder builder = RedshiftDataProviderSettings.builder();
        redshiftSettings.accept(builder);
        return fromRedshiftSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #postgreSqlSettings()} initialized to the given value.
     *
     * Sets the value of the PostgreSqlSettings property for this object.
     *
     * @param postgreSqlSettings
     *        The new value for the PostgreSqlSettings property for this object.
     */
    public static DataProviderSettings fromPostgreSqlSettings(PostgreSqlDataProviderSettings postgreSqlSettings) {
        return builder().postgreSqlSettings(postgreSqlSettings).build();
    }

    /**
     * Create an instance of this class with {@link #postgreSqlSettings()} initialized to the given value.
     *
     * Sets the value of the PostgreSqlSettings property for this object.
     *
     * @param postgreSqlSettings
     *        The new value for the PostgreSqlSettings property for this object.
     */
    public static DataProviderSettings fromPostgreSqlSettings(Consumer<PostgreSqlDataProviderSettings.Builder> postgreSqlSettings) {
        PostgreSqlDataProviderSettings.Builder builder = PostgreSqlDataProviderSettings.builder();
        postgreSqlSettings.accept(builder);
        return fromPostgreSqlSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mySqlSettings()} initialized to the given value.
     *
     * Sets the value of the MySqlSettings property for this object.
     *
     * @param mySqlSettings
     *        The new value for the MySqlSettings property for this object.
     */
    public static DataProviderSettings fromMySqlSettings(MySqlDataProviderSettings mySqlSettings) {
        return builder().mySqlSettings(mySqlSettings).build();
    }

    /**
     * Create an instance of this class with {@link #mySqlSettings()} initialized to the given value.
     *
     * Sets the value of the MySqlSettings property for this object.
     *
     * @param mySqlSettings
     *        The new value for the MySqlSettings property for this object.
     */
    public static DataProviderSettings fromMySqlSettings(Consumer<MySqlDataProviderSettings.Builder> mySqlSettings) {
        MySqlDataProviderSettings.Builder builder = MySqlDataProviderSettings.builder();
        mySqlSettings.accept(builder);
        return fromMySqlSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #oracleSettings()} initialized to the given value.
     *
     * Sets the value of the OracleSettings property for this object.
     *
     * @param oracleSettings
     *        The new value for the OracleSettings property for this object.
     */
    public static DataProviderSettings fromOracleSettings(OracleDataProviderSettings oracleSettings) {
        return builder().oracleSettings(oracleSettings).build();
    }

    /**
     * Create an instance of this class with {@link #oracleSettings()} initialized to the given value.
     *
     * Sets the value of the OracleSettings property for this object.
     *
     * @param oracleSettings
     *        The new value for the OracleSettings property for this object.
     */
    public static DataProviderSettings fromOracleSettings(Consumer<OracleDataProviderSettings.Builder> oracleSettings) {
        OracleDataProviderSettings.Builder builder = OracleDataProviderSettings.builder();
        oracleSettings.accept(builder);
        return fromOracleSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #microsoftSqlServerSettings()} initialized to the given value.
     *
     * Sets the value of the MicrosoftSqlServerSettings property for this object.
     *
     * @param microsoftSqlServerSettings
     *        The new value for the MicrosoftSqlServerSettings property for this object.
     */
    public static DataProviderSettings fromMicrosoftSqlServerSettings(
            MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings) {
        return builder().microsoftSqlServerSettings(microsoftSqlServerSettings).build();
    }

    /**
     * Create an instance of this class with {@link #microsoftSqlServerSettings()} initialized to the given value.
     *
     * Sets the value of the MicrosoftSqlServerSettings property for this object.
     *
     * @param microsoftSqlServerSettings
     *        The new value for the MicrosoftSqlServerSettings property for this object.
     */
    public static DataProviderSettings fromMicrosoftSqlServerSettings(
            Consumer<MicrosoftSqlServerDataProviderSettings.Builder> microsoftSqlServerSettings) {
        MicrosoftSqlServerDataProviderSettings.Builder builder = MicrosoftSqlServerDataProviderSettings.builder();
        microsoftSqlServerSettings.accept(builder);
        return fromMicrosoftSqlServerSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #docDbSettings()} initialized to the given value.
     *
     * Sets the value of the DocDbSettings property for this object.
     *
     * @param docDbSettings
     *        The new value for the DocDbSettings property for this object.
     */
    public static DataProviderSettings fromDocDbSettings(DocDbDataProviderSettings docDbSettings) {
        return builder().docDbSettings(docDbSettings).build();
    }

    /**
     * Create an instance of this class with {@link #docDbSettings()} initialized to the given value.
     *
     * Sets the value of the DocDbSettings property for this object.
     *
     * @param docDbSettings
     *        The new value for the DocDbSettings property for this object.
     */
    public static DataProviderSettings fromDocDbSettings(Consumer<DocDbDataProviderSettings.Builder> docDbSettings) {
        DocDbDataProviderSettings.Builder builder = DocDbDataProviderSettings.builder();
        docDbSettings.accept(builder);
        return fromDocDbSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mariaDbSettings()} initialized to the given value.
     *
     * <p>
     * Provides information that defines a MariaDB data provider.
     * </p>
     * 
     * @param mariaDbSettings
     *        Provides information that defines a MariaDB data provider.
     */
    public static DataProviderSettings fromMariaDbSettings(MariaDbDataProviderSettings mariaDbSettings) {
        return builder().mariaDbSettings(mariaDbSettings).build();
    }

    /**
     * Create an instance of this class with {@link #mariaDbSettings()} initialized to the given value.
     *
     * <p>
     * Provides information that defines a MariaDB data provider.
     * </p>
     * 
     * @param mariaDbSettings
     *        Provides information that defines a MariaDB data provider.
     */
    public static DataProviderSettings fromMariaDbSettings(Consumer<MariaDbDataProviderSettings.Builder> mariaDbSettings) {
        MariaDbDataProviderSettings.Builder builder = MariaDbDataProviderSettings.builder();
        mariaDbSettings.accept(builder);
        return fromMariaDbSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ibmDb2LuwSettings()} initialized to the given value.
     *
     * <p>
     * Provides information that defines an IBM DB2 LUW data provider.
     * </p>
     * 
     * @param ibmDb2LuwSettings
     *        Provides information that defines an IBM DB2 LUW data provider.
     */
    public static DataProviderSettings fromIbmDb2LuwSettings(IbmDb2LuwDataProviderSettings ibmDb2LuwSettings) {
        return builder().ibmDb2LuwSettings(ibmDb2LuwSettings).build();
    }

    /**
     * Create an instance of this class with {@link #ibmDb2LuwSettings()} initialized to the given value.
     *
     * <p>
     * Provides information that defines an IBM DB2 LUW data provider.
     * </p>
     * 
     * @param ibmDb2LuwSettings
     *        Provides information that defines an IBM DB2 LUW data provider.
     */
    public static DataProviderSettings fromIbmDb2LuwSettings(Consumer<IbmDb2LuwDataProviderSettings.Builder> ibmDb2LuwSettings) {
        IbmDb2LuwDataProviderSettings.Builder builder = IbmDb2LuwDataProviderSettings.builder();
        ibmDb2LuwSettings.accept(builder);
        return fromIbmDb2LuwSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ibmDb2zOsSettings()} initialized to the given value.
     *
     * <p>
     * Provides information that defines an IBM DB2 for z/OS data provider.
     * </p>
     * 
     * @param ibmDb2zOsSettings
     *        Provides information that defines an IBM DB2 for z/OS data provider.
     */
    public static DataProviderSettings fromIbmDb2zOsSettings(IbmDb2zOsDataProviderSettings ibmDb2zOsSettings) {
        return builder().ibmDb2zOsSettings(ibmDb2zOsSettings).build();
    }

    /**
     * Create an instance of this class with {@link #ibmDb2zOsSettings()} initialized to the given value.
     *
     * <p>
     * Provides information that defines an IBM DB2 for z/OS data provider.
     * </p>
     * 
     * @param ibmDb2zOsSettings
     *        Provides information that defines an IBM DB2 for z/OS data provider.
     */
    public static DataProviderSettings fromIbmDb2zOsSettings(Consumer<IbmDb2zOsDataProviderSettings.Builder> ibmDb2zOsSettings) {
        IbmDb2zOsDataProviderSettings.Builder builder = IbmDb2zOsDataProviderSettings.builder();
        ibmDb2zOsSettings.accept(builder);
        return fromIbmDb2zOsSettings(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mongoDbSettings()} initialized to the given value.
     *
     * <p>
     * Provides information that defines a MongoDB data provider.
     * </p>
     * 
     * @param mongoDbSettings
     *        Provides information that defines a MongoDB data provider.
     */
    public static DataProviderSettings fromMongoDbSettings(MongoDbDataProviderSettings mongoDbSettings) {
        return builder().mongoDbSettings(mongoDbSettings).build();
    }

    /**
     * Create an instance of this class with {@link #mongoDbSettings()} initialized to the given value.
     *
     * <p>
     * Provides information that defines a MongoDB data provider.
     * </p>
     * 
     * @param mongoDbSettings
     *        Provides information that defines a MongoDB data provider.
     */
    public static DataProviderSettings fromMongoDbSettings(Consumer<MongoDbDataProviderSettings.Builder> mongoDbSettings) {
        MongoDbDataProviderSettings.Builder builder = MongoDbDataProviderSettings.builder();
        mongoDbSettings.accept(builder);
        return fromMongoDbSettings(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RedshiftSettings", REDSHIFT_SETTINGS_FIELD);
        map.put("PostgreSqlSettings", POSTGRE_SQL_SETTINGS_FIELD);
        map.put("MySqlSettings", MY_SQL_SETTINGS_FIELD);
        map.put("OracleSettings", ORACLE_SETTINGS_FIELD);
        map.put("MicrosoftSqlServerSettings", MICROSOFT_SQL_SERVER_SETTINGS_FIELD);
        map.put("DocDbSettings", DOC_DB_SETTINGS_FIELD);
        map.put("MariaDbSettings", MARIA_DB_SETTINGS_FIELD);
        map.put("IbmDb2LuwSettings", IBM_DB2_LUW_SETTINGS_FIELD);
        map.put("IbmDb2zOsSettings", IBM_DB2_Z_OS_SETTINGS_FIELD);
        map.put("MongoDbSettings", MONGO_DB_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProviderSettings, T> g) {
        return obj -> g.apply((DataProviderSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProviderSettings> {
        /**
         * Sets the value of the RedshiftSettings property for this object.
         *
         * @param redshiftSettings
         *        The new value for the RedshiftSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftSettings(RedshiftDataProviderSettings redshiftSettings);

        /**
         * Sets the value of the RedshiftSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RedshiftDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link RedshiftDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftDataProviderSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #redshiftSettings(RedshiftDataProviderSettings)}.
         * 
         * @param redshiftSettings
         *        a consumer that will call methods on {@link RedshiftDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftSettings(RedshiftDataProviderSettings)
         */
        default Builder redshiftSettings(Consumer<RedshiftDataProviderSettings.Builder> redshiftSettings) {
            return redshiftSettings(RedshiftDataProviderSettings.builder().applyMutation(redshiftSettings).build());
        }

        /**
         * Sets the value of the PostgreSqlSettings property for this object.
         *
         * @param postgreSqlSettings
         *        The new value for the PostgreSqlSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postgreSqlSettings(PostgreSqlDataProviderSettings postgreSqlSettings);

        /**
         * Sets the value of the PostgreSqlSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PostgreSqlDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link PostgreSqlDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostgreSqlDataProviderSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #postgreSqlSettings(PostgreSqlDataProviderSettings)}.
         * 
         * @param postgreSqlSettings
         *        a consumer that will call methods on {@link PostgreSqlDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postgreSqlSettings(PostgreSqlDataProviderSettings)
         */
        default Builder postgreSqlSettings(Consumer<PostgreSqlDataProviderSettings.Builder> postgreSqlSettings) {
            return postgreSqlSettings(PostgreSqlDataProviderSettings.builder().applyMutation(postgreSqlSettings).build());
        }

        /**
         * Sets the value of the MySqlSettings property for this object.
         *
         * @param mySqlSettings
         *        The new value for the MySqlSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mySqlSettings(MySqlDataProviderSettings mySqlSettings);

        /**
         * Sets the value of the MySqlSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MySqlDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link MySqlDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MySqlDataProviderSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #mySqlSettings(MySqlDataProviderSettings)}.
         * 
         * @param mySqlSettings
         *        a consumer that will call methods on {@link MySqlDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mySqlSettings(MySqlDataProviderSettings)
         */
        default Builder mySqlSettings(Consumer<MySqlDataProviderSettings.Builder> mySqlSettings) {
            return mySqlSettings(MySqlDataProviderSettings.builder().applyMutation(mySqlSettings).build());
        }

        /**
         * Sets the value of the OracleSettings property for this object.
         *
         * @param oracleSettings
         *        The new value for the OracleSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oracleSettings(OracleDataProviderSettings oracleSettings);

        /**
         * Sets the value of the OracleSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OracleDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link OracleDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OracleDataProviderSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #oracleSettings(OracleDataProviderSettings)}.
         * 
         * @param oracleSettings
         *        a consumer that will call methods on {@link OracleDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oracleSettings(OracleDataProviderSettings)
         */
        default Builder oracleSettings(Consumer<OracleDataProviderSettings.Builder> oracleSettings) {
            return oracleSettings(OracleDataProviderSettings.builder().applyMutation(oracleSettings).build());
        }

        /**
         * Sets the value of the MicrosoftSqlServerSettings property for this object.
         *
         * @param microsoftSqlServerSettings
         *        The new value for the MicrosoftSqlServerSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings);

        /**
         * Sets the value of the MicrosoftSqlServerSettings property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link MicrosoftSqlServerDataProviderSettings.Builder} avoiding the need to create one manually via
         * {@link MicrosoftSqlServerDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MicrosoftSqlServerDataProviderSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings)}.
         * 
         * @param microsoftSqlServerSettings
         *        a consumer that will call methods on {@link MicrosoftSqlServerDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings)
         */
        default Builder microsoftSqlServerSettings(
                Consumer<MicrosoftSqlServerDataProviderSettings.Builder> microsoftSqlServerSettings) {
            return microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings.builder()
                    .applyMutation(microsoftSqlServerSettings).build());
        }

        /**
         * Sets the value of the DocDbSettings property for this object.
         *
         * @param docDbSettings
         *        The new value for the DocDbSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder docDbSettings(DocDbDataProviderSettings docDbSettings);

        /**
         * Sets the value of the DocDbSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DocDbDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link DocDbDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocDbDataProviderSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #docDbSettings(DocDbDataProviderSettings)}.
         * 
         * @param docDbSettings
         *        a consumer that will call methods on {@link DocDbDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #docDbSettings(DocDbDataProviderSettings)
         */
        default Builder docDbSettings(Consumer<DocDbDataProviderSettings.Builder> docDbSettings) {
            return docDbSettings(DocDbDataProviderSettings.builder().applyMutation(docDbSettings).build());
        }

        /**
         * <p>
         * Provides information that defines a MariaDB data provider.
         * </p>
         * 
         * @param mariaDbSettings
         *        Provides information that defines a MariaDB data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mariaDbSettings(MariaDbDataProviderSettings mariaDbSettings);

        /**
         * <p>
         * Provides information that defines a MariaDB data provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link MariaDbDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link MariaDbDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MariaDbDataProviderSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #mariaDbSettings(MariaDbDataProviderSettings)}.
         * 
         * @param mariaDbSettings
         *        a consumer that will call methods on {@link MariaDbDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mariaDbSettings(MariaDbDataProviderSettings)
         */
        default Builder mariaDbSettings(Consumer<MariaDbDataProviderSettings.Builder> mariaDbSettings) {
            return mariaDbSettings(MariaDbDataProviderSettings.builder().applyMutation(mariaDbSettings).build());
        }

        /**
         * <p>
         * Provides information that defines an IBM DB2 LUW data provider.
         * </p>
         * 
         * @param ibmDb2LuwSettings
         *        Provides information that defines an IBM DB2 LUW data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ibmDb2LuwSettings(IbmDb2LuwDataProviderSettings ibmDb2LuwSettings);

        /**
         * <p>
         * Provides information that defines an IBM DB2 LUW data provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IbmDb2LuwDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link IbmDb2LuwDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IbmDb2LuwDataProviderSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #ibmDb2LuwSettings(IbmDb2LuwDataProviderSettings)}.
         * 
         * @param ibmDb2LuwSettings
         *        a consumer that will call methods on {@link IbmDb2LuwDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ibmDb2LuwSettings(IbmDb2LuwDataProviderSettings)
         */
        default Builder ibmDb2LuwSettings(Consumer<IbmDb2LuwDataProviderSettings.Builder> ibmDb2LuwSettings) {
            return ibmDb2LuwSettings(IbmDb2LuwDataProviderSettings.builder().applyMutation(ibmDb2LuwSettings).build());
        }

        /**
         * <p>
         * Provides information that defines an IBM DB2 for z/OS data provider.
         * </p>
         * 
         * @param ibmDb2zOsSettings
         *        Provides information that defines an IBM DB2 for z/OS data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ibmDb2zOsSettings(IbmDb2zOsDataProviderSettings ibmDb2zOsSettings);

        /**
         * <p>
         * Provides information that defines an IBM DB2 for z/OS data provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IbmDb2zOsDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link IbmDb2zOsDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IbmDb2zOsDataProviderSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #ibmDb2zOsSettings(IbmDb2zOsDataProviderSettings)}.
         * 
         * @param ibmDb2zOsSettings
         *        a consumer that will call methods on {@link IbmDb2zOsDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ibmDb2zOsSettings(IbmDb2zOsDataProviderSettings)
         */
        default Builder ibmDb2zOsSettings(Consumer<IbmDb2zOsDataProviderSettings.Builder> ibmDb2zOsSettings) {
            return ibmDb2zOsSettings(IbmDb2zOsDataProviderSettings.builder().applyMutation(ibmDb2zOsSettings).build());
        }

        /**
         * <p>
         * Provides information that defines a MongoDB data provider.
         * </p>
         * 
         * @param mongoDbSettings
         *        Provides information that defines a MongoDB data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mongoDbSettings(MongoDbDataProviderSettings mongoDbSettings);

        /**
         * <p>
         * Provides information that defines a MongoDB data provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link MongoDbDataProviderSettings.Builder}
         * avoiding the need to create one manually via {@link MongoDbDataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MongoDbDataProviderSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #mongoDbSettings(MongoDbDataProviderSettings)}.
         * 
         * @param mongoDbSettings
         *        a consumer that will call methods on {@link MongoDbDataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mongoDbSettings(MongoDbDataProviderSettings)
         */
        default Builder mongoDbSettings(Consumer<MongoDbDataProviderSettings.Builder> mongoDbSettings) {
            return mongoDbSettings(MongoDbDataProviderSettings.builder().applyMutation(mongoDbSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RedshiftDataProviderSettings redshiftSettings;

        private PostgreSqlDataProviderSettings postgreSqlSettings;

        private MySqlDataProviderSettings mySqlSettings;

        private OracleDataProviderSettings oracleSettings;

        private MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings;

        private DocDbDataProviderSettings docDbSettings;

        private MariaDbDataProviderSettings mariaDbSettings;

        private IbmDb2LuwDataProviderSettings ibmDb2LuwSettings;

        private IbmDb2zOsDataProviderSettings ibmDb2zOsSettings;

        private MongoDbDataProviderSettings mongoDbSettings;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataProviderSettings model) {
            redshiftSettings(model.redshiftSettings);
            postgreSqlSettings(model.postgreSqlSettings);
            mySqlSettings(model.mySqlSettings);
            oracleSettings(model.oracleSettings);
            microsoftSqlServerSettings(model.microsoftSqlServerSettings);
            docDbSettings(model.docDbSettings);
            mariaDbSettings(model.mariaDbSettings);
            ibmDb2LuwSettings(model.ibmDb2LuwSettings);
            ibmDb2zOsSettings(model.ibmDb2zOsSettings);
            mongoDbSettings(model.mongoDbSettings);
        }

        public final RedshiftDataProviderSettings.Builder getRedshiftSettings() {
            return redshiftSettings != null ? redshiftSettings.toBuilder() : null;
        }

        public final void setRedshiftSettings(RedshiftDataProviderSettings.BuilderImpl redshiftSettings) {
            Object oldValue = this.redshiftSettings;
            this.redshiftSettings = redshiftSettings != null ? redshiftSettings.build() : null;
            handleUnionValueChange(Type.REDSHIFT_SETTINGS, oldValue, this.redshiftSettings);
        }

        @Override
        public final Builder redshiftSettings(RedshiftDataProviderSettings redshiftSettings) {
            Object oldValue = this.redshiftSettings;
            this.redshiftSettings = redshiftSettings;
            handleUnionValueChange(Type.REDSHIFT_SETTINGS, oldValue, this.redshiftSettings);
            return this;
        }

        public final PostgreSqlDataProviderSettings.Builder getPostgreSqlSettings() {
            return postgreSqlSettings != null ? postgreSqlSettings.toBuilder() : null;
        }

        public final void setPostgreSqlSettings(PostgreSqlDataProviderSettings.BuilderImpl postgreSqlSettings) {
            Object oldValue = this.postgreSqlSettings;
            this.postgreSqlSettings = postgreSqlSettings != null ? postgreSqlSettings.build() : null;
            handleUnionValueChange(Type.POSTGRE_SQL_SETTINGS, oldValue, this.postgreSqlSettings);
        }

        @Override
        public final Builder postgreSqlSettings(PostgreSqlDataProviderSettings postgreSqlSettings) {
            Object oldValue = this.postgreSqlSettings;
            this.postgreSqlSettings = postgreSqlSettings;
            handleUnionValueChange(Type.POSTGRE_SQL_SETTINGS, oldValue, this.postgreSqlSettings);
            return this;
        }

        public final MySqlDataProviderSettings.Builder getMySqlSettings() {
            return mySqlSettings != null ? mySqlSettings.toBuilder() : null;
        }

        public final void setMySqlSettings(MySqlDataProviderSettings.BuilderImpl mySqlSettings) {
            Object oldValue = this.mySqlSettings;
            this.mySqlSettings = mySqlSettings != null ? mySqlSettings.build() : null;
            handleUnionValueChange(Type.MY_SQL_SETTINGS, oldValue, this.mySqlSettings);
        }

        @Override
        public final Builder mySqlSettings(MySqlDataProviderSettings mySqlSettings) {
            Object oldValue = this.mySqlSettings;
            this.mySqlSettings = mySqlSettings;
            handleUnionValueChange(Type.MY_SQL_SETTINGS, oldValue, this.mySqlSettings);
            return this;
        }

        public final OracleDataProviderSettings.Builder getOracleSettings() {
            return oracleSettings != null ? oracleSettings.toBuilder() : null;
        }

        public final void setOracleSettings(OracleDataProviderSettings.BuilderImpl oracleSettings) {
            Object oldValue = this.oracleSettings;
            this.oracleSettings = oracleSettings != null ? oracleSettings.build() : null;
            handleUnionValueChange(Type.ORACLE_SETTINGS, oldValue, this.oracleSettings);
        }

        @Override
        public final Builder oracleSettings(OracleDataProviderSettings oracleSettings) {
            Object oldValue = this.oracleSettings;
            this.oracleSettings = oracleSettings;
            handleUnionValueChange(Type.ORACLE_SETTINGS, oldValue, this.oracleSettings);
            return this;
        }

        public final MicrosoftSqlServerDataProviderSettings.Builder getMicrosoftSqlServerSettings() {
            return microsoftSqlServerSettings != null ? microsoftSqlServerSettings.toBuilder() : null;
        }

        public final void setMicrosoftSqlServerSettings(
                MicrosoftSqlServerDataProviderSettings.BuilderImpl microsoftSqlServerSettings) {
            Object oldValue = this.microsoftSqlServerSettings;
            this.microsoftSqlServerSettings = microsoftSqlServerSettings != null ? microsoftSqlServerSettings.build() : null;
            handleUnionValueChange(Type.MICROSOFT_SQL_SERVER_SETTINGS, oldValue, this.microsoftSqlServerSettings);
        }

        @Override
        public final Builder microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings) {
            Object oldValue = this.microsoftSqlServerSettings;
            this.microsoftSqlServerSettings = microsoftSqlServerSettings;
            handleUnionValueChange(Type.MICROSOFT_SQL_SERVER_SETTINGS, oldValue, this.microsoftSqlServerSettings);
            return this;
        }

        public final DocDbDataProviderSettings.Builder getDocDbSettings() {
            return docDbSettings != null ? docDbSettings.toBuilder() : null;
        }

        public final void setDocDbSettings(DocDbDataProviderSettings.BuilderImpl docDbSettings) {
            Object oldValue = this.docDbSettings;
            this.docDbSettings = docDbSettings != null ? docDbSettings.build() : null;
            handleUnionValueChange(Type.DOC_DB_SETTINGS, oldValue, this.docDbSettings);
        }

        @Override
        public final Builder docDbSettings(DocDbDataProviderSettings docDbSettings) {
            Object oldValue = this.docDbSettings;
            this.docDbSettings = docDbSettings;
            handleUnionValueChange(Type.DOC_DB_SETTINGS, oldValue, this.docDbSettings);
            return this;
        }

        public final MariaDbDataProviderSettings.Builder getMariaDbSettings() {
            return mariaDbSettings != null ? mariaDbSettings.toBuilder() : null;
        }

        public final void setMariaDbSettings(MariaDbDataProviderSettings.BuilderImpl mariaDbSettings) {
            Object oldValue = this.mariaDbSettings;
            this.mariaDbSettings = mariaDbSettings != null ? mariaDbSettings.build() : null;
            handleUnionValueChange(Type.MARIA_DB_SETTINGS, oldValue, this.mariaDbSettings);
        }

        @Override
        public final Builder mariaDbSettings(MariaDbDataProviderSettings mariaDbSettings) {
            Object oldValue = this.mariaDbSettings;
            this.mariaDbSettings = mariaDbSettings;
            handleUnionValueChange(Type.MARIA_DB_SETTINGS, oldValue, this.mariaDbSettings);
            return this;
        }

        public final IbmDb2LuwDataProviderSettings.Builder getIbmDb2LuwSettings() {
            return ibmDb2LuwSettings != null ? ibmDb2LuwSettings.toBuilder() : null;
        }

        public final void setIbmDb2LuwSettings(IbmDb2LuwDataProviderSettings.BuilderImpl ibmDb2LuwSettings) {
            Object oldValue = this.ibmDb2LuwSettings;
            this.ibmDb2LuwSettings = ibmDb2LuwSettings != null ? ibmDb2LuwSettings.build() : null;
            handleUnionValueChange(Type.IBM_DB2_LUW_SETTINGS, oldValue, this.ibmDb2LuwSettings);
        }

        @Override
        public final Builder ibmDb2LuwSettings(IbmDb2LuwDataProviderSettings ibmDb2LuwSettings) {
            Object oldValue = this.ibmDb2LuwSettings;
            this.ibmDb2LuwSettings = ibmDb2LuwSettings;
            handleUnionValueChange(Type.IBM_DB2_LUW_SETTINGS, oldValue, this.ibmDb2LuwSettings);
            return this;
        }

        public final IbmDb2zOsDataProviderSettings.Builder getIbmDb2zOsSettings() {
            return ibmDb2zOsSettings != null ? ibmDb2zOsSettings.toBuilder() : null;
        }

        public final void setIbmDb2zOsSettings(IbmDb2zOsDataProviderSettings.BuilderImpl ibmDb2zOsSettings) {
            Object oldValue = this.ibmDb2zOsSettings;
            this.ibmDb2zOsSettings = ibmDb2zOsSettings != null ? ibmDb2zOsSettings.build() : null;
            handleUnionValueChange(Type.IBM_DB2_Z_OS_SETTINGS, oldValue, this.ibmDb2zOsSettings);
        }

        @Override
        public final Builder ibmDb2zOsSettings(IbmDb2zOsDataProviderSettings ibmDb2zOsSettings) {
            Object oldValue = this.ibmDb2zOsSettings;
            this.ibmDb2zOsSettings = ibmDb2zOsSettings;
            handleUnionValueChange(Type.IBM_DB2_Z_OS_SETTINGS, oldValue, this.ibmDb2zOsSettings);
            return this;
        }

        public final MongoDbDataProviderSettings.Builder getMongoDbSettings() {
            return mongoDbSettings != null ? mongoDbSettings.toBuilder() : null;
        }

        public final void setMongoDbSettings(MongoDbDataProviderSettings.BuilderImpl mongoDbSettings) {
            Object oldValue = this.mongoDbSettings;
            this.mongoDbSettings = mongoDbSettings != null ? mongoDbSettings.build() : null;
            handleUnionValueChange(Type.MONGO_DB_SETTINGS, oldValue, this.mongoDbSettings);
        }

        @Override
        public final Builder mongoDbSettings(MongoDbDataProviderSettings mongoDbSettings) {
            Object oldValue = this.mongoDbSettings;
            this.mongoDbSettings = mongoDbSettings;
            handleUnionValueChange(Type.MONGO_DB_SETTINGS, oldValue, this.mongoDbSettings);
            return this;
        }

        @Override
        public DataProviderSettings build() {
            return new DataProviderSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataProviderSettings#type()
     */
    public enum Type {
        REDSHIFT_SETTINGS,

        POSTGRE_SQL_SETTINGS,

        MY_SQL_SETTINGS,

        ORACLE_SETTINGS,

        MICROSOFT_SQL_SERVER_SETTINGS,

        DOC_DB_SETTINGS,

        MARIA_DB_SETTINGS,

        IBM_DB2_LUW_SETTINGS,

        IBM_DB2_Z_OS_SETTINGS,

        MONGO_DB_SETTINGS,

        UNKNOWN_TO_SDK_VERSION
    }
}
