/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The progress values reported by the <code>AssessmentProgress</code> response element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationTaskAssessmentRunProgress implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationTaskAssessmentRunProgress.Builder, ReplicationTaskAssessmentRunProgress> {
    private static final SdkField<Integer> INDIVIDUAL_ASSESSMENT_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("IndividualAssessmentCount")
            .getter(getter(ReplicationTaskAssessmentRunProgress::individualAssessmentCount))
            .setter(setter(Builder::individualAssessmentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndividualAssessmentCount").build())
            .build();

    private static final SdkField<Integer> INDIVIDUAL_ASSESSMENT_COMPLETED_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IndividualAssessmentCompletedCount")
            .getter(getter(ReplicationTaskAssessmentRunProgress::individualAssessmentCompletedCount))
            .setter(setter(Builder::individualAssessmentCompletedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndividualAssessmentCompletedCount")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INDIVIDUAL_ASSESSMENT_COUNT_FIELD, INDIVIDUAL_ASSESSMENT_COMPLETED_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer individualAssessmentCount;

    private final Integer individualAssessmentCompletedCount;

    private ReplicationTaskAssessmentRunProgress(BuilderImpl builder) {
        this.individualAssessmentCount = builder.individualAssessmentCount;
        this.individualAssessmentCompletedCount = builder.individualAssessmentCompletedCount;
    }

    /**
     * <p>
     * The number of individual assessments that are specified to run.
     * </p>
     * 
     * @return The number of individual assessments that are specified to run.
     */
    public final Integer individualAssessmentCount() {
        return individualAssessmentCount;
    }

    /**
     * <p>
     * The number of individual assessments that have completed, successfully or not.
     * </p>
     * 
     * @return The number of individual assessments that have completed, successfully or not.
     */
    public final Integer individualAssessmentCompletedCount() {
        return individualAssessmentCompletedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(individualAssessmentCount());
        hashCode = 31 * hashCode + Objects.hashCode(individualAssessmentCompletedCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskAssessmentRunProgress)) {
            return false;
        }
        ReplicationTaskAssessmentRunProgress other = (ReplicationTaskAssessmentRunProgress) obj;
        return Objects.equals(individualAssessmentCount(), other.individualAssessmentCount())
                && Objects.equals(individualAssessmentCompletedCount(), other.individualAssessmentCompletedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationTaskAssessmentRunProgress")
                .add("IndividualAssessmentCount", individualAssessmentCount())
                .add("IndividualAssessmentCompletedCount", individualAssessmentCompletedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndividualAssessmentCount":
            return Optional.ofNullable(clazz.cast(individualAssessmentCount()));
        case "IndividualAssessmentCompletedCount":
            return Optional.ofNullable(clazz.cast(individualAssessmentCompletedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndividualAssessmentCount", INDIVIDUAL_ASSESSMENT_COUNT_FIELD);
        map.put("IndividualAssessmentCompletedCount", INDIVIDUAL_ASSESSMENT_COMPLETED_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskAssessmentRunProgress, T> g) {
        return obj -> g.apply((ReplicationTaskAssessmentRunProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationTaskAssessmentRunProgress> {
        /**
         * <p>
         * The number of individual assessments that are specified to run.
         * </p>
         * 
         * @param individualAssessmentCount
         *        The number of individual assessments that are specified to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder individualAssessmentCount(Integer individualAssessmentCount);

        /**
         * <p>
         * The number of individual assessments that have completed, successfully or not.
         * </p>
         * 
         * @param individualAssessmentCompletedCount
         *        The number of individual assessments that have completed, successfully or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder individualAssessmentCompletedCount(Integer individualAssessmentCompletedCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer individualAssessmentCount;

        private Integer individualAssessmentCompletedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskAssessmentRunProgress model) {
            individualAssessmentCount(model.individualAssessmentCount);
            individualAssessmentCompletedCount(model.individualAssessmentCompletedCount);
        }

        public final Integer getIndividualAssessmentCount() {
            return individualAssessmentCount;
        }

        public final void setIndividualAssessmentCount(Integer individualAssessmentCount) {
            this.individualAssessmentCount = individualAssessmentCount;
        }

        @Override
        public final Builder individualAssessmentCount(Integer individualAssessmentCount) {
            this.individualAssessmentCount = individualAssessmentCount;
            return this;
        }

        public final Integer getIndividualAssessmentCompletedCount() {
            return individualAssessmentCompletedCount;
        }

        public final void setIndividualAssessmentCompletedCount(Integer individualAssessmentCompletedCount) {
            this.individualAssessmentCompletedCount = individualAssessmentCompletedCount;
        }

        @Override
        public final Builder individualAssessmentCompletedCount(Integer individualAssessmentCompletedCount) {
            this.individualAssessmentCompletedCount = individualAssessmentCompletedCount;
            return this;
        }

        @Override
        public ReplicationTaskAssessmentRunProgress build() {
            return new ReplicationTaskAssessmentRunProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
