/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInstanceProfileRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<DeleteInstanceProfileRequest.Builder, DeleteInstanceProfileRequest> {
    private static final SdkField<String> INSTANCE_PROFILE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProfileIdentifier").getter(getter(DeleteInstanceProfileRequest::instanceProfileIdentifier))
            .setter(setter(Builder::instanceProfileIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSTANCE_PROFILE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceProfileIdentifier;

    private DeleteInstanceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.instanceProfileIdentifier = builder.instanceProfileIdentifier;
    }

    /**
     * <p>
     * The identifier of the instance profile to delete.
     * </p>
     * 
     * @return The identifier of the instance profile to delete.
     */
    public final String instanceProfileIdentifier() {
        return instanceProfileIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceProfileRequest)) {
            return false;
        }
        DeleteInstanceProfileRequest other = (DeleteInstanceProfileRequest) obj;
        return Objects.equals(instanceProfileIdentifier(), other.instanceProfileIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteInstanceProfileRequest").add("InstanceProfileIdentifier", instanceProfileIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceProfileIdentifier":
            return Optional.ofNullable(clazz.cast(instanceProfileIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceProfileIdentifier", INSTANCE_PROFILE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstanceProfileRequest, T> g) {
        return obj -> g.apply((DeleteInstanceProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteInstanceProfileRequest> {
        /**
         * <p>
         * The identifier of the instance profile to delete.
         * </p>
         * 
         * @param instanceProfileIdentifier
         *        The identifier of the instance profile to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileIdentifier(String instanceProfileIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String instanceProfileIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceProfileRequest model) {
            super(model);
            instanceProfileIdentifier(model.instanceProfileIdentifier);
        }

        public final String getInstanceProfileIdentifier() {
            return instanceProfileIdentifier;
        }

        public final void setInstanceProfileIdentifier(String instanceProfileIdentifier) {
            this.instanceProfileIdentifier = instanceProfileIdentifier;
        }

        @Override
        public final Builder instanceProfileIdentifier(String instanceProfileIdentifier) {
            this.instanceProfileIdentifier = instanceProfileIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInstanceProfileRequest build() {
            return new DeleteInstanceProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
