/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an IBM DB2 LUW data provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IbmDb2LuwDataProviderSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<IbmDb2LuwDataProviderSettings.Builder, IbmDb2LuwDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(IbmDb2LuwDataProviderSettings::serverName))
            .setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(IbmDb2LuwDataProviderSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(IbmDb2LuwDataProviderSettings::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> SSL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslMode").getter(getter(IbmDb2LuwDataProviderSettings::sslModeAsString))
            .setter(setter(Builder::sslMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(IbmDb2LuwDataProviderSettings::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Path")
            .getter(getter(IbmDb2LuwDataProviderSettings::s3Path)).setter(setter(Builder::s3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()).build();

    private static final SdkField<String> S3_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3AccessRoleArn").getter(getter(IbmDb2LuwDataProviderSettings::s3AccessRoleArn))
            .setter(setter(Builder::s3AccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD,
            DATABASE_NAME_FIELD, SSL_MODE_FIELD, CERTIFICATE_ARN_FIELD, S3_PATH_FIELD, S3_ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serverName;

    private final Integer port;

    private final String databaseName;

    private final String sslMode;

    private final String certificateArn;

    private final String s3Path;

    private final String s3AccessRoleArn;

    private IbmDb2LuwDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.sslMode = builder.sslMode;
        this.certificateArn = builder.certificateArn;
        this.s3Path = builder.s3Path;
        this.s3AccessRoleArn = builder.s3AccessRoleArn;
    }

    /**
     * <p>
     * The name of the DB2 LUW server.
     * </p>
     * 
     * @return The name of the DB2 LUW server.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The port value for the DB2 LUW data provider.
     * </p>
     * 
     * @return The port value for the DB2 LUW data provider.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The database name on the DB2 LUW data provider.
     * </p>
     * 
     * @return The database name on the DB2 LUW data provider.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The SSL mode used to connect to the DB2 LUW data provider. The default value is <code>none</code>. Valid Values:
     * <code>none</code> and <code>verify-ca</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the DB2 LUW data provider. The default value is <code>none</code>. Valid
     *         Values: <code>none</code> and <code>verify-ca</code>.
     * @see DmsSslModeValue
     */
    public final DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(sslMode);
    }

    /**
     * <p>
     * The SSL mode used to connect to the DB2 LUW data provider. The default value is <code>none</code>. Valid Values:
     * <code>none</code> and <code>verify-ca</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the DB2 LUW data provider. The default value is <code>none</code>. Valid
     *         Values: <code>none</code> and <code>verify-ca</code>.
     * @see DmsSslModeValue
     */
    public final String sslModeAsString() {
        return sslMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The path for the Amazon S3 bucket that the application uses for accessing the user-defined schema.
     * </p>
     * 
     * @return The path for the Amazon S3 bucket that the application uses for accessing the user-defined schema.
     */
    public final String s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * The ARN for the role the application uses to access its Amazon S3 bucket.
     * </p>
     * 
     * @return The ARN for the role the application uses to access its Amazon S3 bucket.
     */
    public final String s3AccessRoleArn() {
        return s3AccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IbmDb2LuwDataProviderSettings)) {
            return false;
        }
        IbmDb2LuwDataProviderSettings other = (IbmDb2LuwDataProviderSettings) obj;
        return Objects.equals(serverName(), other.serverName()) && Objects.equals(port(), other.port())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(sslModeAsString(), other.sslModeAsString())
                && Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(s3Path(), other.s3Path())
                && Objects.equals(s3AccessRoleArn(), other.s3AccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IbmDb2LuwDataProviderSettings").add("ServerName", serverName()).add("Port", port())
                .add("DatabaseName", databaseName()).add("SslMode", sslModeAsString()).add("CertificateArn", certificateArn())
                .add("S3Path", s3Path()).add("S3AccessRoleArn", s3AccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "SslMode":
            return Optional.ofNullable(clazz.cast(sslModeAsString()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "S3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "S3AccessRoleArn":
            return Optional.ofNullable(clazz.cast(s3AccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("SslMode", SSL_MODE_FIELD);
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("S3Path", S3_PATH_FIELD);
        map.put("S3AccessRoleArn", S3_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IbmDb2LuwDataProviderSettings, T> g) {
        return obj -> g.apply((IbmDb2LuwDataProviderSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IbmDb2LuwDataProviderSettings> {
        /**
         * <p>
         * The name of the DB2 LUW server.
         * </p>
         * 
         * @param serverName
         *        The name of the DB2 LUW server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The port value for the DB2 LUW data provider.
         * </p>
         * 
         * @param port
         *        The port value for the DB2 LUW data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The database name on the DB2 LUW data provider.
         * </p>
         * 
         * @param databaseName
         *        The database name on the DB2 LUW data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The SSL mode used to connect to the DB2 LUW data provider. The default value is <code>none</code>. Valid
         * Values: <code>none</code> and <code>verify-ca</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the DB2 LUW data provider. The default value is <code>none</code>.
         *        Valid Values: <code>none</code> and <code>verify-ca</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(String sslMode);

        /**
         * <p>
         * The SSL mode used to connect to the DB2 LUW data provider. The default value is <code>none</code>. Valid
         * Values: <code>none</code> and <code>verify-ca</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the DB2 LUW data provider. The default value is <code>none</code>.
         *        Valid Values: <code>none</code> and <code>verify-ca</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(DmsSslModeValue sslMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The path for the Amazon S3 bucket that the application uses for accessing the user-defined schema.
         * </p>
         * 
         * @param s3Path
         *        The path for the Amazon S3 bucket that the application uses for accessing the user-defined schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(String s3Path);

        /**
         * <p>
         * The ARN for the role the application uses to access its Amazon S3 bucket.
         * </p>
         * 
         * @param s3AccessRoleArn
         *        The ARN for the role the application uses to access its Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessRoleArn(String s3AccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String serverName;

        private Integer port;

        private String databaseName;

        private String sslMode;

        private String certificateArn;

        private String s3Path;

        private String s3AccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IbmDb2LuwDataProviderSettings model) {
            serverName(model.serverName);
            port(model.port);
            databaseName(model.databaseName);
            sslMode(model.sslMode);
            certificateArn(model.certificateArn);
            s3Path(model.s3Path);
            s3AccessRoleArn(model.s3AccessRoleArn);
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getSslMode() {
            return sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getS3Path() {
            return s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getS3AccessRoleArn() {
            return s3AccessRoleArn;
        }

        public final void setS3AccessRoleArn(String s3AccessRoleArn) {
            this.s3AccessRoleArn = s3AccessRoleArn;
        }

        @Override
        public final Builder s3AccessRoleArn(String s3AccessRoleArn) {
            this.s3AccessRoleArn = s3AccessRoleArn;
            return this;
        }

        @Override
        public IbmDb2LuwDataProviderSettings build() {
            return new IbmDb2LuwDataProviderSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
