/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the limitations of target Amazon Web Services engines.
 * </p>
 * <p>
 * Your source database might include features that the target Amazon Web Services engine doesn't support. Fleet Advisor
 * lists these features as limitations. You should consider these limitations during database migration. For each
 * limitation, Fleet Advisor recommends an action that you can take to address or avoid this limitation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Limitation implements SdkPojo, Serializable, ToCopyableBuilder<Limitation.Builder, Limitation> {
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseId").getter(getter(Limitation::databaseId)).setter(setter(Builder::databaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()).build();

    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineName").getter(getter(Limitation::engineName)).setter(setter(Builder::engineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Limitation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Limitation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IMPACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Impact")
            .getter(getter(Limitation::impact)).setter(setter(Builder::impact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Impact").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Limitation::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ID_FIELD,
            ENGINE_NAME_FIELD, NAME_FIELD, DESCRIPTION_FIELD, IMPACT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseId;

    private final String engineName;

    private final String name;

    private final String description;

    private final String impact;

    private final String type;

    private Limitation(BuilderImpl builder) {
        this.databaseId = builder.databaseId;
        this.engineName = builder.engineName;
        this.name = builder.name;
        this.description = builder.description;
        this.impact = builder.impact;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifier of the source database.
     * </p>
     * 
     * @return The identifier of the source database.
     */
    public final String databaseId() {
        return databaseId;
    }

    /**
     * <p>
     * The name of the target engine that Fleet Advisor should use in the target engine recommendation. Valid values
     * include <code>"rds-aurora-mysql"</code>, <code>"rds-aurora-postgresql"</code>, <code>"rds-mysql"</code>,
     * <code>"rds-oracle"</code>, <code>"rds-sql-server"</code>, and <code>"rds-postgresql"</code>.
     * </p>
     * 
     * @return The name of the target engine that Fleet Advisor should use in the target engine recommendation. Valid
     *         values include <code>"rds-aurora-mysql"</code>, <code>"rds-aurora-postgresql"</code>,
     *         <code>"rds-mysql"</code>, <code>"rds-oracle"</code>, <code>"rds-sql-server"</code>, and
     *         <code>"rds-postgresql"</code>.
     */
    public final String engineName() {
        return engineName;
    }

    /**
     * <p>
     * The name of the limitation. Describes unsupported database features, migration action items, and other
     * limitations.
     * </p>
     * 
     * @return The name of the limitation. Describes unsupported database features, migration action items, and other
     *         limitations.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the limitation. Provides additional information about the limitation, and includes recommended
     * actions that you can take to address or avoid this limitation.
     * </p>
     * 
     * @return A description of the limitation. Provides additional information about the limitation, and includes
     *         recommended actions that you can take to address or avoid this limitation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The impact of the limitation. You can use this parameter to prioritize limitations that you want to address.
     * Valid values include <code>"Blocker"</code>, <code>"High"</code>, <code>"Medium"</code>, and <code>"Low"</code>.
     * </p>
     * 
     * @return The impact of the limitation. You can use this parameter to prioritize limitations that you want to
     *         address. Valid values include <code>"Blocker"</code>, <code>"High"</code>, <code>"Medium"</code>, and
     *         <code>"Low"</code>.
     */
    public final String impact() {
        return impact;
    }

    /**
     * <p>
     * The type of the limitation, such as action required, upgrade required, and limited feature.
     * </p>
     * 
     * @return The type of the limitation, such as action required, upgrade required, and limited feature.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(engineName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(impact());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limitation)) {
            return false;
        }
        Limitation other = (Limitation) obj;
        return Objects.equals(databaseId(), other.databaseId()) && Objects.equals(engineName(), other.engineName())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(impact(), other.impact()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Limitation").add("DatabaseId", databaseId()).add("EngineName", engineName()).add("Name", name())
                .add("Description", description()).add("Impact", impact()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseId":
            return Optional.ofNullable(clazz.cast(databaseId()));
        case "EngineName":
            return Optional.ofNullable(clazz.cast(engineName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Impact":
            return Optional.ofNullable(clazz.cast(impact()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseId", DATABASE_ID_FIELD);
        map.put("EngineName", ENGINE_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Impact", IMPACT_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Limitation, T> g) {
        return obj -> g.apply((Limitation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Limitation> {
        /**
         * <p>
         * The identifier of the source database.
         * </p>
         * 
         * @param databaseId
         *        The identifier of the source database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseId(String databaseId);

        /**
         * <p>
         * The name of the target engine that Fleet Advisor should use in the target engine recommendation. Valid values
         * include <code>"rds-aurora-mysql"</code>, <code>"rds-aurora-postgresql"</code>, <code>"rds-mysql"</code>,
         * <code>"rds-oracle"</code>, <code>"rds-sql-server"</code>, and <code>"rds-postgresql"</code>.
         * </p>
         * 
         * @param engineName
         *        The name of the target engine that Fleet Advisor should use in the target engine recommendation. Valid
         *        values include <code>"rds-aurora-mysql"</code>, <code>"rds-aurora-postgresql"</code>,
         *        <code>"rds-mysql"</code>, <code>"rds-oracle"</code>, <code>"rds-sql-server"</code>, and
         *        <code>"rds-postgresql"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineName(String engineName);

        /**
         * <p>
         * The name of the limitation. Describes unsupported database features, migration action items, and other
         * limitations.
         * </p>
         * 
         * @param name
         *        The name of the limitation. Describes unsupported database features, migration action items, and other
         *        limitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the limitation. Provides additional information about the limitation, and includes
         * recommended actions that you can take to address or avoid this limitation.
         * </p>
         * 
         * @param description
         *        A description of the limitation. Provides additional information about the limitation, and includes
         *        recommended actions that you can take to address or avoid this limitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The impact of the limitation. You can use this parameter to prioritize limitations that you want to address.
         * Valid values include <code>"Blocker"</code>, <code>"High"</code>, <code>"Medium"</code>, and
         * <code>"Low"</code>.
         * </p>
         * 
         * @param impact
         *        The impact of the limitation. You can use this parameter to prioritize limitations that you want to
         *        address. Valid values include <code>"Blocker"</code>, <code>"High"</code>, <code>"Medium"</code>, and
         *        <code>"Low"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impact(String impact);

        /**
         * <p>
         * The type of the limitation, such as action required, upgrade required, and limited feature.
         * </p>
         * 
         * @param type
         *        The type of the limitation, such as action required, upgrade required, and limited feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String databaseId;

        private String engineName;

        private String name;

        private String description;

        private String impact;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Limitation model) {
            databaseId(model.databaseId);
            engineName(model.engineName);
            name(model.name);
            description(model.description);
            impact(model.impact);
            type(model.type);
        }

        public final String getDatabaseId() {
            return databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getEngineName() {
            return engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getImpact() {
            return impact;
        }

        public final void setImpact(String impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(String impact) {
            this.impact = impact;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Limitation build() {
            return new Limitation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
