/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a schema in a Fleet Advisor collector inventory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaShortInfoResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaShortInfoResponse.Builder, SchemaShortInfoResponse> {
    private static final SdkField<String> SCHEMA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaId").getter(getter(SchemaShortInfoResponse::schemaId)).setter(setter(Builder::schemaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(SchemaShortInfoResponse::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseId").getter(getter(SchemaShortInfoResponse::databaseId)).setter(setter(Builder::databaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(SchemaShortInfoResponse::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> DATABASE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseIpAddress").getter(getter(SchemaShortInfoResponse::databaseIpAddress))
            .setter(setter(Builder::databaseIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD,
            SCHEMA_NAME_FIELD, DATABASE_ID_FIELD, DATABASE_NAME_FIELD, DATABASE_IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schemaId;

    private final String schemaName;

    private final String databaseId;

    private final String databaseName;

    private final String databaseIpAddress;

    private SchemaShortInfoResponse(BuilderImpl builder) {
        this.schemaId = builder.schemaId;
        this.schemaName = builder.schemaName;
        this.databaseId = builder.databaseId;
        this.databaseName = builder.databaseName;
        this.databaseIpAddress = builder.databaseIpAddress;
    }

    /**
     * <p>
     * The ID of a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The ID of a schema in a Fleet Advisor collector inventory.
     */
    public final String schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The name of a schema in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The name of a schema in a Fleet Advisor collector inventory.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The ID of a database in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The ID of a database in a Fleet Advisor collector inventory.
     */
    public final String databaseId() {
        return databaseId;
    }

    /**
     * <p>
     * The name of a database in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The name of a database in a Fleet Advisor collector inventory.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The IP address of a database in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The IP address of a database in a Fleet Advisor collector inventory.
     */
    public final String databaseIpAddress() {
        return databaseIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaShortInfoResponse)) {
            return false;
        }
        SchemaShortInfoResponse other = (SchemaShortInfoResponse) obj;
        return Objects.equals(schemaId(), other.schemaId()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(databaseId(), other.databaseId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(databaseIpAddress(), other.databaseIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaShortInfoResponse").add("SchemaId", schemaId()).add("SchemaName", schemaName())
                .add("DatabaseId", databaseId()).add("DatabaseName", databaseName())
                .add("DatabaseIpAddress", databaseIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "DatabaseId":
            return Optional.ofNullable(clazz.cast(databaseId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "DatabaseIpAddress":
            return Optional.ofNullable(clazz.cast(databaseIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("SchemaName", SCHEMA_NAME_FIELD);
        map.put("DatabaseId", DATABASE_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("DatabaseIpAddress", DATABASE_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaShortInfoResponse, T> g) {
        return obj -> g.apply((SchemaShortInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaShortInfoResponse> {
        /**
         * <p>
         * The ID of a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param schemaId
         *        The ID of a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(String schemaId);

        /**
         * <p>
         * The name of a schema in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param schemaName
         *        The name of a schema in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The ID of a database in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param databaseId
         *        The ID of a database in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseId(String databaseId);

        /**
         * <p>
         * The name of a database in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param databaseName
         *        The name of a database in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The IP address of a database in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param databaseIpAddress
         *        The IP address of a database in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseIpAddress(String databaseIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String schemaId;

        private String schemaName;

        private String databaseId;

        private String databaseName;

        private String databaseIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaShortInfoResponse model) {
            schemaId(model.schemaId);
            schemaName(model.schemaName);
            databaseId(model.databaseId);
            databaseName(model.databaseName);
            databaseIpAddress(model.databaseIpAddress);
        }

        public final String getSchemaId() {
            return schemaId;
        }

        public final void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getDatabaseId() {
            return databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDatabaseIpAddress() {
            return databaseIpAddress;
        }

        public final void setDatabaseIpAddress(String databaseIpAddress) {
            this.databaseIpAddress = databaseIpAddress;
        }

        @Override
        public final Builder databaseIpAddress(String databaseIpAddress) {
            this.databaseIpAddress = databaseIpAddress;
            return this;
        }

        @Override
        public SchemaShortInfoResponse build() {
            return new SchemaShortInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
