/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConversionConfigurationResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeConversionConfigurationResponse> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectIdentifier").getter(DescribeConversionConfigurationResponse.getter(DescribeConversionConfigurationResponse::migrationProjectIdentifier)).setter(DescribeConversionConfigurationResponse.setter(Builder::migrationProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build()}).build();
    private static final SdkField<String> CONVERSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConversionConfiguration").getter(DescribeConversionConfigurationResponse.getter(DescribeConversionConfigurationResponse::conversionConfiguration)).setter(DescribeConversionConfigurationResponse.setter(Builder::conversionConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_IDENTIFIER_FIELD, CONVERSION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConversionConfigurationResponse.memberNameToFieldInitializer();
    private final String migrationProjectIdentifier;
    private final String conversionConfiguration;

    private DescribeConversionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.conversionConfiguration = builder.conversionConfiguration;
    }

    public final String migrationProjectIdentifier() {
        return this.migrationProjectIdentifier;
    }

    public final String conversionConfiguration() {
        return this.conversionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionConfigurationResponse)) {
            return false;
        }
        DescribeConversionConfigurationResponse other = (DescribeConversionConfigurationResponse)((Object)obj);
        return Objects.equals(this.migrationProjectIdentifier(), other.migrationProjectIdentifier()) && Objects.equals(this.conversionConfiguration(), other.conversionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConversionConfigurationResponse").add("MigrationProjectIdentifier", (Object)this.migrationProjectIdentifier()).add("ConversionConfiguration", (Object)this.conversionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MigrationProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectIdentifier()));
            }
            case "ConversionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.conversionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MigrationProjectIdentifier", MIGRATION_PROJECT_IDENTIFIER_FIELD);
        map.put("ConversionConfiguration", CONVERSION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConversionConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeConversionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String migrationProjectIdentifier;
        private String conversionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConversionConfigurationResponse model) {
            super(model);
            this.migrationProjectIdentifier(model.migrationProjectIdentifier);
            this.conversionConfiguration(model.conversionConfiguration);
        }

        public final String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getConversionConfiguration() {
            return this.conversionConfiguration;
        }

        public final void setConversionConfiguration(String conversionConfiguration) {
            this.conversionConfiguration = conversionConfiguration;
        }

        @Override
        public final Builder conversionConfiguration(String conversionConfiguration) {
            this.conversionConfiguration = conversionConfiguration;
            return this;
        }

        @Override
        public DescribeConversionConfigurationResponse build() {
            return new DescribeConversionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConversionConfigurationResponse> {
        public Builder migrationProjectIdentifier(String var1);

        public Builder conversionConfiguration(String var1);
    }
}

