/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.databasemigration.internal.DatabaseMigrationServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.databasemigration.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.databasemigration.model.AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelMetadataModelConversionRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelMetadataModelConversionResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelMetadataModelCreationRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelMetadataModelCreationResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.CollectorNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationException;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelChildrenRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelChildrenResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelCreationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelCreationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.FailedDependencyException;
import software.amazon.awssdk.services.databasemigration.model.GetTargetSelectionRulesRequest;
import software.amazon.awssdk.services.databasemigration.model.GetTargetSelectionRulesResponse;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.InsufficientResourceCapacityException;
import software.amazon.awssdk.services.databasemigration.model.InvalidCertificateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidOperationException;
import software.amazon.awssdk.services.databasemigration.model.InvalidResourceStateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidSubnetException;
import software.amazon.awssdk.services.databasemigration.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.KmsDisabledException;
import software.amazon.awssdk.services.databasemigration.model.KmsException;
import software.amazon.awssdk.services.databasemigration.model.KmsInvalidStateException;
import software.amazon.awssdk.services.databasemigration.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.databasemigration.model.KmsNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.KmsThrottlingException;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.ResourceQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisRequest;
import software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.S3AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.S3ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.databasemigration.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelCreationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelCreationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StopDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest;
import software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse;
import software.amazon.awssdk.services.databasemigration.model.UpgradeDependencyFailureException;
import software.amazon.awssdk.services.databasemigration.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.BatchStartRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CancelMetadataModelConversionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CancelMetadataModelCreationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CancelReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateDataProviderRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateFleetAdvisorCollectorRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateMigrationProjectRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationConfigRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteDataProviderRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteFleetAdvisorCollectorRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteFleetAdvisorDatabasesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteMigrationProjectRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationConfigRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeApplicableIndividualAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeConnectionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeConversionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeDataMigrationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeDataProvidersRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointSettingsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointTypesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeExtensionPackAssociationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorCollectorsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorDatabasesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorLsaAnalysisRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorSchemaObjectSummaryRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeFleetAdvisorSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeInstanceProfilesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelChildrenRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelConversionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelCreationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelExportsAsScriptRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelExportsToTargetRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelImportsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMetadataModelRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeMigrationProjectsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeOrderableReplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeRecommendationLimitationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeRefreshSchemasStatusRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationConfigsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationInstanceTaskLogsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTableStatisticsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskAssessmentResultsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskAssessmentRunsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskIndividualAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTasksRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeTableStatisticsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ExportMetadataModelAssessmentRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.GetTargetSelectionRulesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ImportCertificateRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyConversionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyDataProviderRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyMigrationProjectRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationConfigRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.MoveReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RebootReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RefreshSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ReloadReplicationTablesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ReloadTablesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RunFleetAdvisorLsaAnalysisRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartExtensionPackAssociationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelAssessmentRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelConversionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelCreationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelExportAsScriptRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelExportToTargetRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartMetadataModelImportRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskAssessmentRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StopDataMigrationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StopReplicationRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StopReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.TestConnectionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.UpdateSubscriptionsToEventBridgeRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link DatabaseMigrationAsyncClient}.
 *
 * @see DatabaseMigrationAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDatabaseMigrationAsyncClient implements DatabaseMigrationAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseMigrationAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultDatabaseMigrationAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Database_Migration_Service" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or
     * used in a Condition statement in an IAM policy for DMS. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Associates a set of tags with an DMS resource.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddTagsToResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddTagsToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                            .withOperationName("AddTagsToResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsToResourceRequest));
            CompletableFuture<AddTagsToResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(applyPendingMaintenanceActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ApplyPendingMaintenanceAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ApplyPendingMaintenanceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ApplyPendingMaintenanceActionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ApplyPendingMaintenanceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse>()
                            .withOperationName("ApplyPendingMaintenanceAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ApplyPendingMaintenanceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(applyPendingMaintenanceActionRequest));
            CompletableFuture<ApplyPendingMaintenanceActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Starts the analysis of up to 20 source databases to recommend target engines for each source database. This is a
     * batch version of <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html">StartRecommendations
     * </a>.
     * </p>
     * <p>
     * The result of analysis of each source database is reported individually in the response. Because the batch
     * request can result in a combination of successful and unsuccessful actions, you should check for batch errors
     * even when the call returns an HTTP status code of <code>200</code>.
     * </p>
     *
     * @param batchStartRecommendationsRequest
     * @return A Java Future containing the result of the BatchStartRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.BatchStartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/BatchStartRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchStartRecommendationsResponse> batchStartRecommendations(
            BatchStartRecommendationsRequest batchStartRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchStartRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchStartRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchStartRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchStartRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchStartRecommendationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchStartRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchStartRecommendationsRequest, BatchStartRecommendationsResponse>()
                            .withOperationName("BatchStartRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchStartRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchStartRecommendationsRequest));
            CompletableFuture<BatchStartRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a single metadata model conversion operation that was started with
     * <code>StartMetadataModelConversion</code>.
     * </p>
     *
     * @param cancelMetadataModelConversionRequest
     * @return A Java Future containing the result of the CancelMetadataModelConversion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CancelMetadataModelConversion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelMetadataModelConversion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMetadataModelConversionResponse> cancelMetadataModelConversion(
            CancelMetadataModelConversionRequest cancelMetadataModelConversionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMetadataModelConversionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelMetadataModelConversionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMetadataModelConversion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMetadataModelConversionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMetadataModelConversionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CancelMetadataModelConversionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMetadataModelConversionRequest, CancelMetadataModelConversionResponse>()
                            .withOperationName("CancelMetadataModelConversion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelMetadataModelConversionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelMetadataModelConversionRequest));
            CompletableFuture<CancelMetadataModelConversionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a single metadata model creation operation that was started with <code>StartMetadataModelCreation</code>.
     * </p>
     *
     * @param cancelMetadataModelCreationRequest
     * @return A Java Future containing the result of the CancelMetadataModelCreation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CancelMetadataModelCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelMetadataModelCreation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMetadataModelCreationResponse> cancelMetadataModelCreation(
            CancelMetadataModelCreationRequest cancelMetadataModelCreationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMetadataModelCreationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMetadataModelCreationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMetadataModelCreation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMetadataModelCreationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMetadataModelCreationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CancelMetadataModelCreationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMetadataModelCreationRequest, CancelMetadataModelCreationResponse>()
                            .withOperationName("CancelMetadataModelCreation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelMetadataModelCreationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelMetadataModelCreationRequest));
            CompletableFuture<CancelMetadataModelCreationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a single premigration assessment run.
     * </p>
     * <p>
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts
     * to cancel any individual assessments that are currently running.
     * </p>
     *
     * @param cancelReplicationTaskAssessmentRunRequest
     * @return A Java Future containing the result of the CancelReplicationTaskAssessmentRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CancelReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelReplicationTaskAssessmentRunResponse> cancelReplicationTaskAssessmentRun(
            CancelReplicationTaskAssessmentRunRequest cancelReplicationTaskAssessmentRunRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelReplicationTaskAssessmentRunRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelReplicationTaskAssessmentRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelReplicationTaskAssessmentRunResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CancelReplicationTaskAssessmentRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CancelReplicationTaskAssessmentRunResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelReplicationTaskAssessmentRunRequest, CancelReplicationTaskAssessmentRunResponse>()
                            .withOperationName("CancelReplicationTaskAssessmentRun").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelReplicationTaskAssessmentRunRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelReplicationTaskAssessmentRunRequest));
            CompletableFuture<CancelReplicationTaskAssessmentRunResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a data migration using the provided settings.
     * </p>
     *
     * @param createDataMigrationRequest
     * @return A Java Future containing the result of the CreateDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>InvalidOperationException The action or operation requested isn't valid.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataMigrationResponse> createDataMigration(
            CreateDataMigrationRequest createDataMigrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataMigrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataMigration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataMigrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataMigrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDataMigrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataMigrationRequest, CreateDataMigrationResponse>()
                            .withOperationName("CreateDataMigration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDataMigrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDataMigrationRequest));
            CompletableFuture<CreateDataMigrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a data provider using the provided settings. A data provider stores a data store type and location
     * information about your database.
     * </p>
     *
     * @param createDataProviderRequest
     * @return A Java Future containing the result of the CreateDataProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataProviderResponse> createDataProvider(CreateDataProviderRequest createDataProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDataProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataProviderRequest, CreateDataProviderResponse>()
                            .withOperationName("CreateDataProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDataProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDataProviderRequest));
            CompletableFuture<CreateDataProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an endpoint using the provided settings.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointRequest, CreateEndpointResponse>()
                            .withOperationName("CreateEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEndpointRequest));
            CompletableFuture<CreateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an DMS event notification subscription.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS
     * source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (
     * <code>EventCategories</code>) for events you want to be notified of. If you specify both the
     * <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and
     * <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for
     * the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>,
     * you receive notice of the events for that source type for all your DMS sources. If you don't specify either
     * <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException You are not authorized for the SNS subscription.</li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that the DMS account
     *         doesn't have access to.</li>
     *         <li>KmsDisabledException The specified KMS key isn't enabled.</li>
     *         <li>KmsInvalidStateException The state of the specified KMS resource isn't valid for this request.</li>
     *         <li>KmsNotFoundException The specified KMS entity or resource can't be found.</li>
     *         <li>KmsThrottlingException This request triggered KMS request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEventSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEventSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateEventSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse>()
                            .withOperationName("CreateEventSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEventSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEventSubscriptionRequest));
            CompletableFuture<CreateEventSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Creates a Fleet Advisor collector using the specified parameters.
     * </p>
     *
     * @param createFleetAdvisorCollectorRequest
     * @return A Java Future containing the result of the CreateFleetAdvisorCollector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetAdvisorCollectorResponse> createFleetAdvisorCollector(
            CreateFleetAdvisorCollectorRequest createFleetAdvisorCollectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetAdvisorCollectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetAdvisorCollectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleetAdvisorCollector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFleetAdvisorCollectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFleetAdvisorCollectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFleetAdvisorCollectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetAdvisorCollectorRequest, CreateFleetAdvisorCollectorResponse>()
                            .withOperationName("CreateFleetAdvisorCollector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFleetAdvisorCollectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFleetAdvisorCollectorRequest));
            CompletableFuture<CreateFleetAdvisorCollectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the instance profile using the specified parameters.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return A Java Future containing the result of the CreateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceProfileResponse> createInstanceProfile(
            CreateInstanceProfileRequest createInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInstanceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInstanceProfileResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceProfileRequest, CreateInstanceProfileResponse>()
                            .withOperationName("CreateInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInstanceProfileRequest));
            CompletableFuture<CreateInstanceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the migration project using the specified parameters.
     * </p>
     * <p>
     * You can run this action only after you create an instance profile and data providers using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateInstanceProfile.html"
     * >CreateInstanceProfile</a> and <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateDataProvider.html">CreateDataProvider</a>.
     * </p>
     *
     * @param createMigrationProjectRequest
     * @return A Java Future containing the result of the CreateMigrationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMigrationProjectResponse> createMigrationProject(
            CreateMigrationProjectRequest createMigrationProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMigrationProjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMigrationProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMigrationProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMigrationProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMigrationProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateMigrationProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMigrationProjectRequest, CreateMigrationProjectResponse>()
                            .withOperationName("CreateMigrationProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMigrationProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMigrationProjectRequest));
            CompletableFuture<CreateMigrationProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a configuration that you can later provide to configure and start an DMS Serverless replication. You can
     * also provide options to validate the configuration inputs before you start the replication.
     * </p>
     *
     * @param createReplicationConfigRequest
     * @return A Java Future containing the result of the CreateReplicationConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReplicationConfigResponse> createReplicationConfig(
            CreateReplicationConfigRequest createReplicationConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReplicationConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateReplicationConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateReplicationConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateReplicationConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationConfigRequest, CreateReplicationConfigResponse>()
                            .withOperationName("CreateReplicationConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReplicationConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReplicationConfigRequest));
            CompletableFuture<CreateReplicationConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the replication instance using the specified parameters.
     * </p>
     * <p>
     * DMS requires that your account have certain roles with appropriate permissions before you can create a
     * replication instance. For information on the required roles, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM
     * Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM
     * Permissions Needed to Use DMS</a>.
     * </p>
     * <note>
     * <p>
     * If you don't specify a version when creating a replication instance, DMS will create the instance using the
     * default engine version. For information about the default engine version, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReleaseNotes.html">Release Notes</a>.
     * </p>
     * </note>
     *
     * @param createReplicationInstanceRequest
     * @return A Java Future containing the result of the CreateReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>InsufficientResourceCapacityException There are not enough resources allocated to the database
     *         migration.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>StorageQuotaExceededException The storage quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReplicationInstanceResponse> createReplicationInstance(
            CreateReplicationInstanceRequest createReplicationInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReplicationInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateReplicationInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateReplicationInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateReplicationInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationInstanceRequest, CreateReplicationInstanceResponse>()
                            .withOperationName("CreateReplicationInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReplicationInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReplicationInstanceRequest));
            CompletableFuture<CreateReplicationInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * </p>
     * <p>
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region,
     * otherwise the service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.
     * </p>
     * <p>
     * If a replication subnet group exists in your Amazon Web Services account, the CreateReplicationSubnetGroup action
     * returns the following error message: The Replication Subnet Group already exists. In this case, delete the
     * existing replication subnet group. To do so, use the <a
     * href="https://docs.aws.amazon.com/en_us/dms/latest/APIReference/API_DeleteReplicationSubnetGroup.html"
     * >DeleteReplicationSubnetGroup</a> action. Optionally, choose Subnet groups in the DMS console, then choose your
     * subnet group. Next, choose Delete from Actions.
     * </p>
     *
     * @param createReplicationSubnetGroupRequest
     * @return A Java Future containing the result of the CreateReplicationSubnetGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReplicationSubnetGroupResponse> createReplicationSubnetGroup(
            CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReplicationSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationSubnetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateReplicationSubnetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateReplicationSubnetGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateReplicationSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationSubnetGroupRequest, CreateReplicationSubnetGroupResponse>()
                            .withOperationName("CreateReplicationSubnetGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReplicationSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReplicationSubnetGroupRequest));
            CompletableFuture<CreateReplicationSubnetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a replication task using the specified parameters.
     * </p>
     *
     * @param createReplicationTaskRequest
     * @return A Java Future containing the result of the CreateReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReplicationTaskResponse> createReplicationTask(
            CreateReplicationTaskRequest createReplicationTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReplicationTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateReplicationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateReplicationTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateReplicationTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationTaskRequest, CreateReplicationTaskResponse>()
                            .withOperationName("CreateReplicationTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReplicationTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReplicationTaskRequest));
            CompletableFuture<CreateReplicationTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCertificateRequest, DeleteCertificateResponse>()
                            .withOperationName("DeleteCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCertificateRequest));
            CompletableFuture<DeleteCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the connection between a replication instance and an endpoint.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectionRequest, DeleteConnectionResponse>()
                            .withOperationName("DeleteConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConnectionRequest));
            CompletableFuture<DeleteConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified data migration.
     * </p>
     *
     * @param deleteDataMigrationRequest
     * @return A Java Future containing the result of the DeleteDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataMigrationResponse> deleteDataMigration(
            DeleteDataMigrationRequest deleteDataMigrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataMigrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataMigrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataMigration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataMigrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataMigrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDataMigrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataMigrationRequest, DeleteDataMigrationResponse>()
                            .withOperationName("DeleteDataMigration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataMigrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataMigrationRequest));
            CompletableFuture<DeleteDataMigrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified data provider.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the data provider must be deleted or modified before you can delete the
     * data provider.
     * </p>
     * </note>
     *
     * @param deleteDataProviderRequest
     * @return A Java Future containing the result of the DeleteDataProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataProviderResponse> deleteDataProvider(DeleteDataProviderRequest deleteDataProviderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataProviderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDataProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataProviderRequest, DeleteDataProviderResponse>()
                            .withOperationName("DeleteDataProvider").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDataProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDataProviderRequest));
            CompletableFuture<DeleteDataProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified endpoint.
     * </p>
     * <note>
     * <p>
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li> <li>InvalidResourceStateException The
     *         resource is in a state that prevents it from being used for database migration.</li> <li>SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as an IO related
     *         failure, failure to get credentials, etc.</li> <li>DatabaseMigrationException Base class for all service
     *         exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                            .withOperationName("DeleteEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEndpointRequest));
            CompletableFuture<DeleteEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an DMS event subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteEventSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse>()
                            .withOperationName("DeleteEventSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventSubscriptionRequest));
            CompletableFuture<DeleteEventSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Deletes the specified Fleet Advisor collector.
     * </p>
     *
     * @param deleteFleetAdvisorCollectorRequest
     * @return A Java Future containing the result of the DeleteFleetAdvisorCollector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>CollectorNotFoundException The specified collector doesn't exist.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetAdvisorCollectorResponse> deleteFleetAdvisorCollector(
            DeleteFleetAdvisorCollectorRequest deleteFleetAdvisorCollectorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetAdvisorCollectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetAdvisorCollectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleetAdvisorCollector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFleetAdvisorCollectorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFleetAdvisorCollectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFleetAdvisorCollectorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetAdvisorCollectorRequest, DeleteFleetAdvisorCollectorResponse>()
                            .withOperationName("DeleteFleetAdvisorCollector").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFleetAdvisorCollectorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFleetAdvisorCollectorRequest));
            CompletableFuture<DeleteFleetAdvisorCollectorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Deletes the specified Fleet Advisor collector databases.
     * </p>
     *
     * @param deleteFleetAdvisorDatabasesRequest
     * @return A Java Future containing the result of the DeleteFleetAdvisorDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidOperationException The action or operation requested isn't valid.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetAdvisorDatabasesResponse> deleteFleetAdvisorDatabases(
            DeleteFleetAdvisorDatabasesRequest deleteFleetAdvisorDatabasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetAdvisorDatabasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetAdvisorDatabasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleetAdvisorDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFleetAdvisorDatabasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFleetAdvisorDatabasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFleetAdvisorDatabasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetAdvisorDatabasesRequest, DeleteFleetAdvisorDatabasesResponse>()
                            .withOperationName("DeleteFleetAdvisorDatabases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFleetAdvisorDatabasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFleetAdvisorDatabasesRequest));
            CompletableFuture<DeleteFleetAdvisorDatabasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified instance profile.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can delete the
     * instance profile.
     * </p>
     * </note>
     *
     * @param deleteInstanceProfileRequest
     * @return A Java Future containing the result of the DeleteInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceProfileResponse> deleteInstanceProfile(
            DeleteInstanceProfileRequest deleteInstanceProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInstanceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInstanceProfileResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteInstanceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceProfileRequest, DeleteInstanceProfileResponse>()
                            .withOperationName("DeleteInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInstanceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInstanceProfileRequest));
            CompletableFuture<DeleteInstanceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified migration project.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can delete it.
     * </p>
     * </note>
     *
     * @param deleteMigrationProjectRequest
     * @return A Java Future containing the result of the DeleteMigrationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMigrationProjectResponse> deleteMigrationProject(
            DeleteMigrationProjectRequest deleteMigrationProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMigrationProjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMigrationProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMigrationProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMigrationProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMigrationProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteMigrationProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMigrationProjectRequest, DeleteMigrationProjectResponse>()
                            .withOperationName("DeleteMigrationProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMigrationProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMigrationProjectRequest));
            CompletableFuture<DeleteMigrationProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an DMS Serverless replication configuration. This effectively deprovisions any and all replications that
     * use this configuration. You can't delete the configuration for an DMS Serverless replication that is ongoing. You
     * can delete the configuration when the replication is in a non-RUNNING and non-STARTING state.
     * </p>
     *
     * @param deleteReplicationConfigRequest
     * @return A Java Future containing the result of the DeleteReplicationConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReplicationConfigResponse> deleteReplicationConfig(
            DeleteReplicationConfigRequest deleteReplicationConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReplicationConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReplicationConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReplicationConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteReplicationConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationConfigRequest, DeleteReplicationConfigResponse>()
                            .withOperationName("DeleteReplicationConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReplicationConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReplicationConfigRequest));
            CompletableFuture<DeleteReplicationConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified replication instance.
     * </p>
     * <note>
     * <p>
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteReplicationInstanceRequest
     * @return A Java Future containing the result of the DeleteReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li> <li>ResourceNotFoundException The resource could not be found.</li> <li>
     *         SdkException Base class for all exceptions that can be thrown by the SDK (both service and client). Can
     *         be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as an
     *         IO related failure, failure to get credentials, etc.</li> <li>DatabaseMigrationException Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReplicationInstanceResponse> deleteReplicationInstance(
            DeleteReplicationInstanceRequest deleteReplicationInstanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReplicationInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReplicationInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReplicationInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteReplicationInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationInstanceRequest, DeleteReplicationInstanceResponse>()
                            .withOperationName("DeleteReplicationInstance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReplicationInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReplicationInstanceRequest));
            CompletableFuture<DeleteReplicationInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     *
     * @param deleteReplicationSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteReplicationSubnetGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReplicationSubnetGroupResponse> deleteReplicationSubnetGroup(
            DeleteReplicationSubnetGroupRequest deleteReplicationSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReplicationSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationSubnetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReplicationSubnetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReplicationSubnetGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteReplicationSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationSubnetGroupRequest, DeleteReplicationSubnetGroupResponse>()
                            .withOperationName("DeleteReplicationSubnetGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReplicationSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReplicationSubnetGroupRequest));
            CompletableFuture<DeleteReplicationSubnetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified replication task.
     * </p>
     *
     * @param deleteReplicationTaskRequest
     * @return A Java Future containing the result of the DeleteReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReplicationTaskResponse> deleteReplicationTask(
            DeleteReplicationTaskRequest deleteReplicationTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReplicationTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReplicationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReplicationTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteReplicationTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationTaskRequest, DeleteReplicationTaskResponse>()
                            .withOperationName("DeleteReplicationTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReplicationTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReplicationTaskRequest));
            CompletableFuture<DeleteReplicationTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the record of a single premigration assessment run.
     * </p>
     * <p>
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves
     * untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     * </p>
     *
     * @param deleteReplicationTaskAssessmentRunRequest
     * @return A Java Future containing the result of the DeleteReplicationTaskAssessmentRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReplicationTaskAssessmentRunResponse> deleteReplicationTaskAssessmentRun(
            DeleteReplicationTaskAssessmentRunRequest deleteReplicationTaskAssessmentRunRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReplicationTaskAssessmentRunRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationTaskAssessmentRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReplicationTaskAssessmentRunResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteReplicationTaskAssessmentRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteReplicationTaskAssessmentRunResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationTaskAssessmentRunRequest, DeleteReplicationTaskAssessmentRunResponse>()
                            .withOperationName("DeleteReplicationTaskAssessmentRun").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReplicationTaskAssessmentRunRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReplicationTaskAssessmentRunRequest));
            CompletableFuture<DeleteReplicationTaskAssessmentRunResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAccountAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                            .withOperationName("DescribeAccountAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountAttributesRequest));
            CompletableFuture<DescribeAccountAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return A Java Future containing the result of the DescribeApplicableIndividualAssessments operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeApplicableIndividualAssessmentsResponse> describeApplicableIndividualAssessments(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeApplicableIndividualAssessmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeApplicableIndividualAssessmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplicableIndividualAssessments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeApplicableIndividualAssessmentsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeApplicableIndividualAssessmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeApplicableIndividualAssessmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeApplicableIndividualAssessmentsRequest, DescribeApplicableIndividualAssessmentsResponse>()
                            .withOperationName("DescribeApplicableIndividualAssessments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeApplicableIndividualAssessmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeApplicableIndividualAssessmentsRequest));
            CompletableFuture<DescribeApplicableIndividualAssessmentsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCertificatesResponse> describeCertificates(
            DescribeCertificatesRequest describeCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCertificatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCertificatesRequest, DescribeCertificatesResponse>()
                            .withOperationName("DescribeCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCertificatesRequest));
            CompletableFuture<DescribeCertificatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     *
     * @param describeConnectionsRequest
     * @return A Java Future containing the result of the DescribeConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConnectionsResponse> describeConnections(
            DescribeConnectionsRequest describeConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConnectionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConnectionsRequest, DescribeConnectionsResponse>()
                            .withOperationName("DescribeConnections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConnectionsRequest));
            CompletableFuture<DescribeConnectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns configuration parameters for a schema conversion project.
     * </p>
     *
     * @param describeConversionConfigurationRequest
     * @return A Java Future containing the result of the DescribeConversionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConversionConfigurationResponse> describeConversionConfiguration(
            DescribeConversionConfigurationRequest describeConversionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConversionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConversionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConversionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConversionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConversionConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConversionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConversionConfigurationRequest, DescribeConversionConfigurationResponse>()
                            .withOperationName("DescribeConversionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConversionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConversionConfigurationRequest));
            CompletableFuture<DescribeConversionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about data migrations.
     * </p>
     *
     * @param describeDataMigrationsRequest
     * @return A Java Future containing the result of the DescribeDataMigrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataMigrationsResponse> describeDataMigrations(
            DescribeDataMigrationsRequest describeDataMigrationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataMigrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataMigrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataMigrations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataMigrationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataMigrationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDataMigrationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataMigrationsRequest, DescribeDataMigrationsResponse>()
                            .withOperationName("DescribeDataMigrations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataMigrationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataMigrationsRequest));
            CompletableFuture<DescribeDataMigrationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of data providers for your account in the current region.
     * </p>
     *
     * @param describeDataProvidersRequest
     * @return A Java Future containing the result of the DescribeDataProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataProvidersResponse> describeDataProviders(
            DescribeDataProvidersRequest describeDataProvidersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataProvidersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDataProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataProvidersRequest, DescribeDataProvidersResponse>()
                            .withOperationName("DescribeDataProviders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataProvidersRequest));
            CompletableFuture<DescribeDataProvidersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return A Java Future containing the result of the DescribeEndpointSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointSettingsResponse> describeEndpointSettings(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEndpointSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointSettingsRequest, DescribeEndpointSettingsResponse>()
                            .withOperationName("DescribeEndpointSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointSettingsRequest));
            CompletableFuture<DescribeEndpointSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return A Java Future containing the result of the DescribeEndpointTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointTypesResponse> describeEndpointTypes(
            DescribeEndpointTypesRequest describeEndpointTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEndpointTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointTypesRequest, DescribeEndpointTypesResponse>()
                            .withOperationName("DescribeEndpointTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointTypesRequest));
            CompletableFuture<DescribeEndpointTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     *
     * @param describeEndpointsRequest
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointsRequest, DescribeEndpointsResponse>()
                            .withOperationName("DescribeEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointsRequest));
            CompletableFuture<DescribeEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the replication instance versions used in the project.
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return A Java Future containing the result of the DescribeEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEngineVersionsResponse> describeEngineVersions(
            DescribeEngineVersionsRequest describeEngineVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEngineVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEngineVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEngineVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEngineVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineVersionsRequest, DescribeEngineVersionsResponse>()
                            .withOperationName("DescribeEngineVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEngineVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEngineVersionsRequest));
            CompletableFuture<DescribeEngineVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventCategoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventCategoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventCategories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventCategoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventCategoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEventCategoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse>()
                            .withOperationName("DescribeEventCategories").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventCategoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventCategoriesRequest));
            CompletableFuture<DescribeEventCategoriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventSubscriptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventSubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventSubscriptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventSubscriptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEventSubscriptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse>()
                            .withOperationName("DescribeEventSubscriptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventSubscriptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventSubscriptionsRequest));
            CompletableFuture<DescribeEventSubscriptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                            .withOperationName("DescribeEvents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventsRequest));
            CompletableFuture<DescribeEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of extension pack associations for the specified migration project. An extension pack is
     * an add-on module that emulates functions present in a source database that are required when converting objects
     * to the target database.
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     * @return A Java Future containing the result of the DescribeExtensionPackAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeExtensionPackAssociationsResponse> describeExtensionPackAssociations(
            DescribeExtensionPackAssociationsRequest describeExtensionPackAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeExtensionPackAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeExtensionPackAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExtensionPackAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeExtensionPackAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeExtensionPackAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeExtensionPackAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeExtensionPackAssociationsRequest, DescribeExtensionPackAssociationsResponse>()
                            .withOperationName("DescribeExtensionPackAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeExtensionPackAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeExtensionPackAssociationsRequest));
            CompletableFuture<DescribeExtensionPackAssociationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Returns a list of the Fleet Advisor collectors in your account.
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorCollectors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetAdvisorCollectorsResponse> describeFleetAdvisorCollectors(
            DescribeFleetAdvisorCollectorsRequest describeFleetAdvisorCollectorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetAdvisorCollectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFleetAdvisorCollectorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetAdvisorCollectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetAdvisorCollectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetAdvisorCollectorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetAdvisorCollectorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetAdvisorCollectorsRequest, DescribeFleetAdvisorCollectorsResponse>()
                            .withOperationName("DescribeFleetAdvisorCollectors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetAdvisorCollectorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetAdvisorCollectorsRequest));
            CompletableFuture<DescribeFleetAdvisorCollectorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Returns a list of Fleet Advisor databases in your account.
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorDatabases operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetAdvisorDatabasesResponse> describeFleetAdvisorDatabases(
            DescribeFleetAdvisorDatabasesRequest describeFleetAdvisorDatabasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetAdvisorDatabasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFleetAdvisorDatabasesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetAdvisorDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetAdvisorDatabasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetAdvisorDatabasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetAdvisorDatabasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetAdvisorDatabasesRequest, DescribeFleetAdvisorDatabasesResponse>()
                            .withOperationName("DescribeFleetAdvisorDatabases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetAdvisorDatabasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetAdvisorDatabasesRequest));
            CompletableFuture<DescribeFleetAdvisorDatabasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Provides descriptions of large-scale assessment (LSA) analyses produced by your Fleet Advisor collectors.
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorLsaAnalysis operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetAdvisorLsaAnalysisResponse> describeFleetAdvisorLsaAnalysis(
            DescribeFleetAdvisorLsaAnalysisRequest describeFleetAdvisorLsaAnalysisRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetAdvisorLsaAnalysisRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFleetAdvisorLsaAnalysisRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetAdvisorLsaAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetAdvisorLsaAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetAdvisorLsaAnalysisResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetAdvisorLsaAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetAdvisorLsaAnalysisRequest, DescribeFleetAdvisorLsaAnalysisResponse>()
                            .withOperationName("DescribeFleetAdvisorLsaAnalysis").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetAdvisorLsaAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetAdvisorLsaAnalysisRequest));
            CompletableFuture<DescribeFleetAdvisorLsaAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorSchemaObjectSummary operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetAdvisorSchemaObjectSummaryResponse> describeFleetAdvisorSchemaObjectSummary(
            DescribeFleetAdvisorSchemaObjectSummaryRequest describeFleetAdvisorSchemaObjectSummaryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetAdvisorSchemaObjectSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFleetAdvisorSchemaObjectSummaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetAdvisorSchemaObjectSummary");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetAdvisorSchemaObjectSummaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeFleetAdvisorSchemaObjectSummaryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetAdvisorSchemaObjectSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetAdvisorSchemaObjectSummaryRequest, DescribeFleetAdvisorSchemaObjectSummaryResponse>()
                            .withOperationName("DescribeFleetAdvisorSchemaObjectSummary").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetAdvisorSchemaObjectSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetAdvisorSchemaObjectSummaryRequest));
            CompletableFuture<DescribeFleetAdvisorSchemaObjectSummaryResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Returns a list of schemas detected by Fleet Advisor Collectors in your account.
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFleetAdvisorSchemasResponse> describeFleetAdvisorSchemas(
            DescribeFleetAdvisorSchemasRequest describeFleetAdvisorSchemasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetAdvisorSchemasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetAdvisorSchemasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetAdvisorSchemas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFleetAdvisorSchemasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFleetAdvisorSchemasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeFleetAdvisorSchemasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFleetAdvisorSchemasRequest, DescribeFleetAdvisorSchemasResponse>()
                            .withOperationName("DescribeFleetAdvisorSchemas").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFleetAdvisorSchemasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFleetAdvisorSchemasRequest));
            CompletableFuture<DescribeFleetAdvisorSchemasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of instance profiles for your account in the current region.
     * </p>
     *
     * @param describeInstanceProfilesRequest
     * @return A Java Future containing the result of the DescribeInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInstanceProfilesResponse> describeInstanceProfiles(
            DescribeInstanceProfilesRequest describeInstanceProfilesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInstanceProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstanceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceProfiles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInstanceProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInstanceProfilesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeInstanceProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceProfilesRequest, DescribeInstanceProfilesResponse>()
                            .withOperationName("DescribeInstanceProfiles").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInstanceProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInstanceProfilesRequest));
            CompletableFuture<DescribeInstanceProfilesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets detailed information about the specified metadata model, including its definition and corresponding
     * converted objects in the target database if applicable.
     * </p>
     *
     * @param describeMetadataModelRequest
     * @return A Java Future containing the result of the DescribeMetadataModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetadataModelResponse> describeMetadataModel(
            DescribeMetadataModelRequest describeMetadataModelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetadataModelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMetadataModelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetadataModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetadataModelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMetadataModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMetadataModelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetadataModelRequest, DescribeMetadataModelResponse>()
                            .withOperationName("DescribeMetadataModel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMetadataModelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMetadataModelRequest));
            CompletableFuture<DescribeMetadataModelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of metadata model assessments for your account in the current region.
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     * @return A Java Future containing the result of the DescribeMetadataModelAssessments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetadataModelAssessmentsResponse> describeMetadataModelAssessments(
            DescribeMetadataModelAssessmentsRequest describeMetadataModelAssessmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetadataModelAssessmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMetadataModelAssessmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetadataModelAssessments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetadataModelAssessmentsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMetadataModelAssessmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMetadataModelAssessmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetadataModelAssessmentsRequest, DescribeMetadataModelAssessmentsResponse>()
                            .withOperationName("DescribeMetadataModelAssessments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMetadataModelAssessmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMetadataModelAssessmentsRequest));
            CompletableFuture<DescribeMetadataModelAssessmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of child metadata models for the specified metadata model in the database hierarchy.
     * </p>
     *
     * @param describeMetadataModelChildrenRequest
     * @return A Java Future containing the result of the DescribeMetadataModelChildren operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelChildren
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelChildren"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetadataModelChildrenResponse> describeMetadataModelChildren(
            DescribeMetadataModelChildrenRequest describeMetadataModelChildrenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetadataModelChildrenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMetadataModelChildrenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetadataModelChildren");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetadataModelChildrenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMetadataModelChildrenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMetadataModelChildrenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetadataModelChildrenRequest, DescribeMetadataModelChildrenResponse>()
                            .withOperationName("DescribeMetadataModelChildren").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMetadataModelChildrenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMetadataModelChildrenRequest));
            CompletableFuture<DescribeMetadataModelChildrenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of metadata model conversions for a migration project.
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     * @return A Java Future containing the result of the DescribeMetadataModelConversions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetadataModelConversionsResponse> describeMetadataModelConversions(
            DescribeMetadataModelConversionsRequest describeMetadataModelConversionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetadataModelConversionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMetadataModelConversionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetadataModelConversions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetadataModelConversionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMetadataModelConversionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMetadataModelConversionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetadataModelConversionsRequest, DescribeMetadataModelConversionsResponse>()
                            .withOperationName("DescribeMetadataModelConversions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMetadataModelConversionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMetadataModelConversionsRequest));
            CompletableFuture<DescribeMetadataModelConversionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of metadata model creation requests for a migration project.
     * </p>
     *
     * @param describeMetadataModelCreationsRequest
     * @return A Java Future containing the result of the DescribeMetadataModelCreations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelCreations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelCreations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetadataModelCreationsResponse> describeMetadataModelCreations(
            DescribeMetadataModelCreationsRequest describeMetadataModelCreationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetadataModelCreationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMetadataModelCreationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetadataModelCreations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetadataModelCreationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMetadataModelCreationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMetadataModelCreationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetadataModelCreationsRequest, DescribeMetadataModelCreationsResponse>()
                            .withOperationName("DescribeMetadataModelCreations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMetadataModelCreationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMetadataModelCreationsRequest));
            CompletableFuture<DescribeMetadataModelCreationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     * @return A Java Future containing the result of the DescribeMetadataModelExportsAsScript operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetadataModelExportsAsScriptResponse> describeMetadataModelExportsAsScript(
            DescribeMetadataModelExportsAsScriptRequest describeMetadataModelExportsAsScriptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetadataModelExportsAsScriptRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMetadataModelExportsAsScriptRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetadataModelExportsAsScript");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetadataModelExportsAsScriptResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMetadataModelExportsAsScriptResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMetadataModelExportsAsScriptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetadataModelExportsAsScriptRequest, DescribeMetadataModelExportsAsScriptResponse>()
                            .withOperationName("DescribeMetadataModelExportsAsScript").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMetadataModelExportsAsScriptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMetadataModelExportsAsScriptRequest));
            CompletableFuture<DescribeMetadataModelExportsAsScriptResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     * @return A Java Future containing the result of the DescribeMetadataModelExportsToTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetadataModelExportsToTargetResponse> describeMetadataModelExportsToTarget(
            DescribeMetadataModelExportsToTargetRequest describeMetadataModelExportsToTargetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetadataModelExportsToTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMetadataModelExportsToTargetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetadataModelExportsToTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetadataModelExportsToTargetResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeMetadataModelExportsToTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMetadataModelExportsToTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetadataModelExportsToTargetRequest, DescribeMetadataModelExportsToTargetResponse>()
                            .withOperationName("DescribeMetadataModelExportsToTarget").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMetadataModelExportsToTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMetadataModelExportsToTargetRequest));
            CompletableFuture<DescribeMetadataModelExportsToTargetResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of metadata model imports.
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     * @return A Java Future containing the result of the DescribeMetadataModelImports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMetadataModelImportsResponse> describeMetadataModelImports(
            DescribeMetadataModelImportsRequest describeMetadataModelImportsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetadataModelImportsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMetadataModelImportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetadataModelImports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMetadataModelImportsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMetadataModelImportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMetadataModelImportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMetadataModelImportsRequest, DescribeMetadataModelImportsResponse>()
                            .withOperationName("DescribeMetadataModelImports").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMetadataModelImportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMetadataModelImportsRequest));
            CompletableFuture<DescribeMetadataModelImportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of migration projects for your account in the current region.
     * </p>
     *
     * @param describeMigrationProjectsRequest
     * @return A Java Future containing the result of the DescribeMigrationProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMigrationProjectsResponse> describeMigrationProjects(
            DescribeMigrationProjectsRequest describeMigrationProjectsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMigrationProjectsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMigrationProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMigrationProjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMigrationProjectsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMigrationProjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMigrationProjectsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMigrationProjectsRequest, DescribeMigrationProjectsResponse>()
                            .withOperationName("DescribeMigrationProjects").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMigrationProjectsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMigrationProjectsRequest));
            CompletableFuture<DescribeMigrationProjectsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return A Java Future containing the result of the DescribeOrderableReplicationInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrderableReplicationInstancesResponse> describeOrderableReplicationInstances(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrderableReplicationInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrderableReplicationInstancesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrderableReplicationInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrderableReplicationInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrderableReplicationInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeOrderableReplicationInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrderableReplicationInstancesRequest, DescribeOrderableReplicationInstancesResponse>()
                            .withOperationName("DescribeOrderableReplicationInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOrderableReplicationInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrderableReplicationInstancesRequest));
            CompletableFuture<DescribeOrderableReplicationInstancesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of upcoming maintenance events for replication instances in your account in the current Region.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePendingMaintenanceActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePendingMaintenanceActions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePendingMaintenanceActionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribePendingMaintenanceActionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribePendingMaintenanceActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse>()
                            .withOperationName("DescribePendingMaintenanceActions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePendingMaintenanceActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePendingMaintenanceActionsRequest));
            CompletableFuture<DescribePendingMaintenanceActionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Returns a paginated list of limitations for recommendations of target Amazon Web Services engines.
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     * @return A Java Future containing the result of the DescribeRecommendationLimitations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRecommendationLimitationsResponse> describeRecommendationLimitations(
            DescribeRecommendationLimitationsRequest describeRecommendationLimitationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRecommendationLimitationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRecommendationLimitationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecommendationLimitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRecommendationLimitationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeRecommendationLimitationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRecommendationLimitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRecommendationLimitationsRequest, DescribeRecommendationLimitationsResponse>()
                            .withOperationName("DescribeRecommendationLimitations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRecommendationLimitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRecommendationLimitationsRequest));
            CompletableFuture<DescribeRecommendationLimitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <important>
     * <p>
     * End of support notice: On May 20, 2026, Amazon Web Services will end support for Amazon Web Services DMS Fleet
     * Advisor;. After May 20, 2026, you will no longer be able to access the Amazon Web Services DMS Fleet Advisor;
     * console or Amazon Web Services DMS Fleet Advisor; resources. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html">Amazon Web Services
     * DMS Fleet Advisor end of support</a>.
     * </p>
     * </important>
     * <p>
     * Returns a paginated list of target engine recommendations for your source databases.
     * </p>
     *
     * @param describeRecommendationsRequest
     * @return A Java Future containing the result of the DescribeRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRecommendationsResponse> describeRecommendations(
            DescribeRecommendationsRequest describeRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecommendations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRecommendationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRecommendationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRecommendationsRequest, DescribeRecommendationsResponse>()
                            .withOperationName("DescribeRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRecommendationsRequest));
            CompletableFuture<DescribeRecommendationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the status of the RefreshSchemas operation.
     * </p>
     *
     * @param describeRefreshSchemasStatusRequest
     * @return A Java Future containing the result of the DescribeRefreshSchemasStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRefreshSchemasStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRefreshSchemasStatusResponse> describeRefreshSchemasStatus(
            DescribeRefreshSchemasStatusRequest describeRefreshSchemasStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRefreshSchemasStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRefreshSchemasStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRefreshSchemasStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRefreshSchemasStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRefreshSchemasStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRefreshSchemasStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRefreshSchemasStatusRequest, DescribeRefreshSchemasStatusResponse>()
                            .withOperationName("DescribeRefreshSchemasStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRefreshSchemasStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRefreshSchemasStatusRequest));
            CompletableFuture<DescribeRefreshSchemasStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns one or more existing DMS Serverless replication configurations as a list of structures.
     * </p>
     *
     * @param describeReplicationConfigsRequest
     * @return A Java Future containing the result of the DescribeReplicationConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationConfigsResponse> describeReplicationConfigs(
            DescribeReplicationConfigsRequest describeReplicationConfigsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReplicationConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationConfigs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReplicationConfigsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationConfigsRequest, DescribeReplicationConfigsResponse>()
                            .withOperationName("DescribeReplicationConfigs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationConfigsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationConfigsRequest));
            CompletableFuture<DescribeReplicationConfigsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return A Java Future containing the result of the DescribeReplicationInstanceTaskLogs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationInstanceTaskLogsResponse> describeReplicationInstanceTaskLogs(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationInstanceTaskLogsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationInstanceTaskLogsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationInstanceTaskLogs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationInstanceTaskLogsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReplicationInstanceTaskLogsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationInstanceTaskLogsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationInstanceTaskLogsRequest, DescribeReplicationInstanceTaskLogsResponse>()
                            .withOperationName("DescribeReplicationInstanceTaskLogs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationInstanceTaskLogsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationInstanceTaskLogsRequest));
            CompletableFuture<DescribeReplicationInstanceTaskLogsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return A Java Future containing the result of the DescribeReplicationInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationInstancesResponse> describeReplicationInstances(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReplicationInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReplicationInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationInstancesRequest, DescribeReplicationInstancesResponse>()
                            .withOperationName("DescribeReplicationInstances").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationInstancesRequest));
            CompletableFuture<DescribeReplicationInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeReplicationSubnetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationSubnetGroupsResponse> describeReplicationSubnetGroups(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationSubnetGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationSubnetGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationSubnetGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationSubnetGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReplicationSubnetGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationSubnetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationSubnetGroupsRequest, DescribeReplicationSubnetGroupsResponse>()
                            .withOperationName("DescribeReplicationSubnetGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationSubnetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationSubnetGroupsRequest));
            CompletableFuture<DescribeReplicationSubnetGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns table and schema statistics for one or more provisioned replications that use a given DMS Serverless
     * replication configuration.
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     * @return A Java Future containing the result of the DescribeReplicationTableStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationTableStatisticsResponse> describeReplicationTableStatistics(
            DescribeReplicationTableStatisticsRequest describeReplicationTableStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationTableStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationTableStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTableStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationTableStatisticsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReplicationTableStatisticsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationTableStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTableStatisticsRequest, DescribeReplicationTableStatisticsResponse>()
                            .withOperationName("DescribeReplicationTableStatistics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationTableStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationTableStatisticsRequest));
            CompletableFuture<DescribeReplicationTableStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return A Java Future containing the result of the DescribeReplicationTaskAssessmentResults operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationTaskAssessmentResultsResponse> describeReplicationTaskAssessmentResults(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeReplicationTaskAssessmentResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationTaskAssessmentResultsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTaskAssessmentResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationTaskAssessmentResultsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReplicationTaskAssessmentResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationTaskAssessmentResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTaskAssessmentResultsRequest, DescribeReplicationTaskAssessmentResultsResponse>()
                            .withOperationName("DescribeReplicationTaskAssessmentResults").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationTaskAssessmentResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationTaskAssessmentResultsRequest));
            CompletableFuture<DescribeReplicationTaskAssessmentResultsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return A Java Future containing the result of the DescribeReplicationTaskAssessmentRuns operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationTaskAssessmentRunsResponse> describeReplicationTaskAssessmentRuns(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationTaskAssessmentRunsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationTaskAssessmentRunsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTaskAssessmentRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationTaskAssessmentRunsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReplicationTaskAssessmentRunsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationTaskAssessmentRunsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTaskAssessmentRunsRequest, DescribeReplicationTaskAssessmentRunsResponse>()
                            .withOperationName("DescribeReplicationTaskAssessmentRuns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationTaskAssessmentRunsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationTaskAssessmentRunsRequest));
            CompletableFuture<DescribeReplicationTaskAssessmentRunsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return A Java Future containing the result of the DescribeReplicationTaskIndividualAssessments operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationTaskIndividualAssessmentsResponse> describeReplicationTaskIndividualAssessments(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeReplicationTaskIndividualAssessmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationTaskIndividualAssessmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTaskIndividualAssessments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationTaskIndividualAssessmentsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReplicationTaskIndividualAssessmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationTaskIndividualAssessmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTaskIndividualAssessmentsRequest, DescribeReplicationTaskIndividualAssessmentsResponse>()
                            .withOperationName("DescribeReplicationTaskIndividualAssessments")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationTaskIndividualAssessmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationTaskIndividualAssessmentsRequest));
            CompletableFuture<DescribeReplicationTaskIndividualAssessmentsResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return A Java Future containing the result of the DescribeReplicationTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationTasksResponse> describeReplicationTasks(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReplicationTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReplicationTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTasksRequest, DescribeReplicationTasksResponse>()
                            .withOperationName("DescribeReplicationTasks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationTasksRequest));
            CompletableFuture<DescribeReplicationTasksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides details on replication progress by returning status information for one or more provisioned DMS
     * Serverless replications.
     * </p>
     *
     * @param describeReplicationsRequest
     * @return A Java Future containing the result of the DescribeReplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReplicationsResponse> describeReplications(
            DescribeReplicationsRequest describeReplicationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReplicationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeReplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationsRequest, DescribeReplicationsResponse>()
                            .withOperationName("DescribeReplications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReplicationsRequest));
            CompletableFuture<DescribeReplicationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     *
     * @param describeSchemasRequest
     * @return A Java Future containing the result of the DescribeSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li> <li>ResourceNotFoundException The resource could not be found.</li> <li>
     *         SdkException Base class for all exceptions that can be thrown by the SDK (both service and client). Can
     *         be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as an
     *         IO related failure, failure to get credentials, etc.</li> <li>DatabaseMigrationException Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSchemasResponse> describeSchemas(DescribeSchemasRequest describeSchemasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSchemasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSchemasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSchemas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSchemasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSchemasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "SNSNoAuthorizationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build());
                case "S3ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build());
                case "ReplicationSubnetGroupDoesNotCoverEnoughAZs":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                            .httpStatusCode(400)
                            .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeSchemasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSchemasRequest, DescribeSchemasResponse>()
                            .withOperationName("DescribeSchemas").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSchemasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSchemasRequest));
            CompletableFuture<DescribeSchemasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return A Java Future containing the result of the DescribeTableStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTableStatisticsResponse> describeTableStatistics(
            DescribeTableStatisticsRequest describeTableStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTableStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTableStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTableStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTableStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTableStatisticsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "FailedDependencyFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(FailedDependencyException::builder).build());
                case "KMSThrottlingFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSThrottlingFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsThrottlingException::builder).build());
                case "KMSNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsNotFoundException::builder).build());
                case "KMSKeyNotAccessibleFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build());
                case "S3AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(S3AccessDeniedException::builder).build());
                case "InvalidResourceStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                case "KMSDisabledFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSDisabledFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsDisabledException::builder).build());
                case "StorageQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build());
                case "InvalidOperationFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidOperationException::builder).build());
                case "InvalidCertificateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "KMSInvalidStateFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSInvalidStateFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsInvalidStateException::builder).build());
                case "InsufficientResourceCapacityFault":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault").httpStatusCode(400)
                                    .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build());
                case "ResourceQuotaExceededFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build());
                case "ResourceNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "KMSAccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build());
                case "SubnetAlreadyInUse":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").httpStatusCode(400)
                            .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build());
                case "ResourceAlreadyExistsFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidSubnet":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSubnet").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSubnetException::builder).build());
                case "CollectorNotFoundFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CollectorNotFoundFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(CollectorNotFoundException::builder).build());
                case "KMSFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("KMSFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(KmsException::builder).build());
                case "UpgradeDependencyFailureFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build());
                case "SNSInvalidTopicFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build());
                case "AccessDeniedFault":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedFault").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build()