/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetAdvisorCollectorResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<CreateFleetAdvisorCollectorResponse.Builder, CreateFleetAdvisorCollectorResponse> {
    private static final SdkField<String> COLLECTOR_REFERENCED_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectorReferencedId").getter(getter(CreateFleetAdvisorCollectorResponse::collectorReferencedId))
            .setter(setter(Builder::collectorReferencedId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorReferencedId").build())
            .build();

    private static final SdkField<String> COLLECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectorName").getter(getter(CreateFleetAdvisorCollectorResponse::collectorName))
            .setter(setter(Builder::collectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFleetAdvisorCollectorResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(CreateFleetAdvisorCollectorResponse::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(CreateFleetAdvisorCollectorResponse::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTOR_REFERENCED_ID_FIELD,
            COLLECTOR_NAME_FIELD, DESCRIPTION_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, S3_BUCKET_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collectorReferencedId;

    private final String collectorName;

    private final String description;

    private final String serviceAccessRoleArn;

    private final String s3BucketName;

    private CreateFleetAdvisorCollectorResponse(BuilderImpl builder) {
        super(builder);
        this.collectorReferencedId = builder.collectorReferencedId;
        this.collectorName = builder.collectorName;
        this.description = builder.description;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.s3BucketName = builder.s3BucketName;
    }

    /**
     * <p>
     * The unique ID of the new Fleet Advisor collector, for example: <code>22fda70c-40d5-4acf-b233-a495bd8eb7f5</code>
     * </p>
     * 
     * @return The unique ID of the new Fleet Advisor collector, for example:
     *         <code>22fda70c-40d5-4acf-b233-a495bd8eb7f5</code>
     */
    public final String collectorReferencedId() {
        return collectorReferencedId;
    }

    /**
     * <p>
     * The name of the new Fleet Advisor collector.
     * </p>
     * 
     * @return The name of the new Fleet Advisor collector.
     */
    public final String collectorName() {
        return collectorName;
    }

    /**
     * <p>
     * A summary description of the Fleet Advisor collector.
     * </p>
     * 
     * @return A summary description of the Fleet Advisor collector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IAM role that grants permissions to access the specified Amazon S3 bucket.
     * </p>
     * 
     * @return The IAM role that grants permissions to access the specified Amazon S3 bucket.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket that the collector uses to store inventory metadata.
     * </p>
     * 
     * @return The Amazon S3 bucket that the collector uses to store inventory metadata.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectorReferencedId());
        hashCode = 31 * hashCode + Objects.hashCode(collectorName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetAdvisorCollectorResponse)) {
            return false;
        }
        CreateFleetAdvisorCollectorResponse other = (CreateFleetAdvisorCollectorResponse) obj;
        return Objects.equals(collectorReferencedId(), other.collectorReferencedId())
                && Objects.equals(collectorName(), other.collectorName()) && Objects.equals(description(), other.description())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(s3BucketName(), other.s3BucketName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetAdvisorCollectorResponse").add("CollectorReferencedId", collectorReferencedId())
                .add("CollectorName", collectorName()).add("Description", description())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn()).add("S3BucketName", s3BucketName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectorReferencedId":
            return Optional.ofNullable(clazz.cast(collectorReferencedId()));
        case "CollectorName":
            return Optional.ofNullable(clazz.cast(collectorName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CollectorReferencedId", COLLECTOR_REFERENCED_ID_FIELD);
        map.put("CollectorName", COLLECTOR_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ServiceAccessRoleArn", SERVICE_ACCESS_ROLE_ARN_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetAdvisorCollectorResponse, T> g) {
        return obj -> g.apply((CreateFleetAdvisorCollectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFleetAdvisorCollectorResponse> {
        /**
         * <p>
         * The unique ID of the new Fleet Advisor collector, for example:
         * <code>22fda70c-40d5-4acf-b233-a495bd8eb7f5</code>
         * </p>
         * 
         * @param collectorReferencedId
         *        The unique ID of the new Fleet Advisor collector, for example:
         *        <code>22fda70c-40d5-4acf-b233-a495bd8eb7f5</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorReferencedId(String collectorReferencedId);

        /**
         * <p>
         * The name of the new Fleet Advisor collector.
         * </p>
         * 
         * @param collectorName
         *        The name of the new Fleet Advisor collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectorName(String collectorName);

        /**
         * <p>
         * A summary description of the Fleet Advisor collector.
         * </p>
         * 
         * @param description
         *        A summary description of the Fleet Advisor collector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IAM role that grants permissions to access the specified Amazon S3 bucket.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The IAM role that grants permissions to access the specified Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * The Amazon S3 bucket that the collector uses to store inventory metadata.
         * </p>
         * 
         * @param s3BucketName
         *        The Amazon S3 bucket that the collector uses to store inventory metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String collectorReferencedId;

        private String collectorName;

        private String description;

        private String serviceAccessRoleArn;

        private String s3BucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetAdvisorCollectorResponse model) {
            super(model);
            collectorReferencedId(model.collectorReferencedId);
            collectorName(model.collectorName);
            description(model.description);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            s3BucketName(model.s3BucketName);
        }

        public final String getCollectorReferencedId() {
            return collectorReferencedId;
        }

        public final void setCollectorReferencedId(String collectorReferencedId) {
            this.collectorReferencedId = collectorReferencedId;
        }

        @Override
        public final Builder collectorReferencedId(String collectorReferencedId) {
            this.collectorReferencedId = collectorReferencedId;
            return this;
        }

        public final String getCollectorName() {
            return collectorName;
        }

        public final void setCollectorName(String collectorName) {
            this.collectorName = collectorName;
        }

        @Override
        public final Builder collectorName(String collectorName) {
            this.collectorName = collectorName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        @Override
        public CreateFleetAdvisorCollectorResponse build() {
            return new CreateFleetAdvisorCollectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
