/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetadataModelResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeMetadataModelResponse.Builder, DescribeMetadataModelResponse> {
    private static final SdkField<String> METADATA_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataModelName").getter(getter(DescribeMetadataModelResponse::metadataModelName))
            .setter(setter(Builder::metadataModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelName").build()).build();

    private static final SdkField<String> METADATA_MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataModelType").getter(getter(DescribeMetadataModelResponse::metadataModelType))
            .setter(setter(Builder::metadataModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelType").build()).build();

    private static final SdkField<List<MetadataModelReference>> TARGET_METADATA_MODELS_FIELD = SdkField
            .<List<MetadataModelReference>> builder(MarshallingType.LIST)
            .memberName("TargetMetadataModels")
            .getter(getter(DescribeMetadataModelResponse::targetMetadataModels))
            .setter(setter(Builder::targetMetadataModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMetadataModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetadataModelReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataModelReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Definition").getter(getter(DescribeMetadataModelResponse::definition))
            .setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_MODEL_NAME_FIELD,
            METADATA_MODEL_TYPE_FIELD, TARGET_METADATA_MODELS_FIELD, DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String metadataModelName;

    private final String metadataModelType;

    private final List<MetadataModelReference> targetMetadataModels;

    private final String definition;

    private DescribeMetadataModelResponse(BuilderImpl builder) {
        super(builder);
        this.metadataModelName = builder.metadataModelName;
        this.metadataModelType = builder.metadataModelType;
        this.targetMetadataModels = builder.targetMetadataModels;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * The name of the metadata model.
     * </p>
     * 
     * @return The name of the metadata model.
     */
    public final String metadataModelName() {
        return metadataModelName;
    }

    /**
     * <p>
     * The type of the metadata model.
     * </p>
     * 
     * @return The type of the metadata model.
     */
    public final String metadataModelType() {
        return metadataModelType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetMetadataModels property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetMetadataModels() {
        return targetMetadataModels != null && !(targetMetadataModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of counterpart metadata models in the target. This field is populated only when Origin is SOURCE and after
     * the object has been converted by DMS Schema Conversion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetMetadataModels} method.
     * </p>
     * 
     * @return A list of counterpart metadata models in the target. This field is populated only when Origin is SOURCE
     *         and after the object has been converted by DMS Schema Conversion.
     */
    public final List<MetadataModelReference> targetMetadataModels() {
        return targetMetadataModels;
    }

    /**
     * <p>
     * The SQL text of the metadata model. This field might not be populated for some metadata models.
     * </p>
     * 
     * @return The SQL text of the metadata model. This field might not be populated for some metadata models.
     */
    public final String definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadataModelName());
        hashCode = 31 * hashCode + Objects.hashCode(metadataModelType());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetMetadataModels() ? targetMetadataModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetadataModelResponse)) {
            return false;
        }
        DescribeMetadataModelResponse other = (DescribeMetadataModelResponse) obj;
        return Objects.equals(metadataModelName(), other.metadataModelName())
                && Objects.equals(metadataModelType(), other.metadataModelType())
                && hasTargetMetadataModels() == other.hasTargetMetadataModels()
                && Objects.equals(targetMetadataModels(), other.targetMetadataModels())
                && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMetadataModelResponse").add("MetadataModelName", metadataModelName())
                .add("MetadataModelType", metadataModelType())
                .add("TargetMetadataModels", hasTargetMetadataModels() ? targetMetadataModels() : null)
                .add("Definition", definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataModelName":
            return Optional.ofNullable(clazz.cast(metadataModelName()));
        case "MetadataModelType":
            return Optional.ofNullable(clazz.cast(metadataModelType()));
        case "TargetMetadataModels":
            return Optional.ofNullable(clazz.cast(targetMetadataModels()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetadataModelName", METADATA_MODEL_NAME_FIELD);
        map.put("MetadataModelType", METADATA_MODEL_TYPE_FIELD);
        map.put("TargetMetadataModels", TARGET_METADATA_MODELS_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetadataModelResponse, T> g) {
        return obj -> g.apply((DescribeMetadataModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetadataModelResponse> {
        /**
         * <p>
         * The name of the metadata model.
         * </p>
         * 
         * @param metadataModelName
         *        The name of the metadata model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataModelName(String metadataModelName);

        /**
         * <p>
         * The type of the metadata model.
         * </p>
         * 
         * @param metadataModelType
         *        The type of the metadata model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataModelType(String metadataModelType);

        /**
         * <p>
         * A list of counterpart metadata models in the target. This field is populated only when Origin is SOURCE and
         * after the object has been converted by DMS Schema Conversion.
         * </p>
         * 
         * @param targetMetadataModels
         *        A list of counterpart metadata models in the target. This field is populated only when Origin is
         *        SOURCE and after the object has been converted by DMS Schema Conversion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMetadataModels(Collection<MetadataModelReference> targetMetadataModels);

        /**
         * <p>
         * A list of counterpart metadata models in the target. This field is populated only when Origin is SOURCE and
         * after the object has been converted by DMS Schema Conversion.
         * </p>
         * 
         * @param targetMetadataModels
         *        A list of counterpart metadata models in the target. This field is populated only when Origin is
         *        SOURCE and after the object has been converted by DMS Schema Conversion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMetadataModels(MetadataModelReference... targetMetadataModels);

        /**
         * <p>
         * A list of counterpart metadata models in the target. This field is populated only when Origin is SOURCE and
         * after the object has been converted by DMS Schema Conversion.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.MetadataModelReference.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.MetadataModelReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.MetadataModelReference.Builder#build()} is
         * called immediately and its result is passed to {@link #targetMetadataModels(List<MetadataModelReference>)}.
         * 
         * @param targetMetadataModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.MetadataModelReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetMetadataModels(java.util.Collection<MetadataModelReference>)
         */
        Builder targetMetadataModels(Consumer<MetadataModelReference.Builder>... targetMetadataModels);

        /**
         * <p>
         * The SQL text of the metadata model. This field might not be populated for some metadata models.
         * </p>
         * 
         * @param definition
         *        The SQL text of the metadata model. This field might not be populated for some metadata models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String metadataModelName;

        private String metadataModelType;

        private List<MetadataModelReference> targetMetadataModels = DefaultSdkAutoConstructList.getInstance();

        private String definition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetadataModelResponse model) {
            super(model);
            metadataModelName(model.metadataModelName);
            metadataModelType(model.metadataModelType);
            targetMetadataModels(model.targetMetadataModels);
            definition(model.definition);
        }

        public final String getMetadataModelName() {
            return metadataModelName;
        }

        public final void setMetadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
        }

        @Override
        public final Builder metadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
            return this;
        }

        public final String getMetadataModelType() {
            return metadataModelType;
        }

        public final void setMetadataModelType(String metadataModelType) {
            this.metadataModelType = metadataModelType;
        }

        @Override
        public final Builder metadataModelType(String metadataModelType) {
            this.metadataModelType = metadataModelType;
            return this;
        }

        public final List<MetadataModelReference.Builder> getTargetMetadataModels() {
            List<MetadataModelReference.Builder> result = MetadataModelReferenceListCopier
                    .copyToBuilder(this.targetMetadataModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetMetadataModels(Collection<MetadataModelReference.BuilderImpl> targetMetadataModels) {
            this.targetMetadataModels = MetadataModelReferenceListCopier.copyFromBuilder(targetMetadataModels);
        }

        @Override
        public final Builder targetMetadataModels(Collection<MetadataModelReference> targetMetadataModels) {
            this.targetMetadataModels = MetadataModelReferenceListCopier.copy(targetMetadataModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMetadataModels(MetadataModelReference... targetMetadataModels) {
            targetMetadataModels(Arrays.asList(targetMetadataModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMetadataModels(Consumer<MetadataModelReference.Builder>... targetMetadataModels) {
            targetMetadataModels(Stream.of(targetMetadataModels)
                    .map(c -> MetadataModelReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public DescribeMetadataModelResponse build() {
            return new DescribeMetadataModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
