/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a collection of table statistics in response to a request by the <code>DescribeTableStatistics</code>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableStatistics implements SdkPojo, Serializable, ToCopyableBuilder<TableStatistics.Builder, TableStatistics> {
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(TableStatistics::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(TableStatistics::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Long> INSERTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Inserts")
            .getter(getter(TableStatistics::inserts)).setter(setter(Builder::inserts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inserts").build()).build();

    private static final SdkField<Long> DELETES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Deletes")
            .getter(getter(TableStatistics::deletes)).setter(setter(Builder::deletes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deletes").build()).build();

    private static final SdkField<Long> UPDATES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Updates")
            .getter(getter(TableStatistics::updates)).setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build()).build();

    private static final SdkField<Long> DDLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Ddls")
            .getter(getter(TableStatistics::ddls)).setter(setter(Builder::ddls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ddls").build()).build();

    private static final SdkField<Long> APPLIED_INSERTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AppliedInserts").getter(getter(TableStatistics::appliedInserts)).setter(setter(Builder::appliedInserts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedInserts").build()).build();

    private static final SdkField<Long> APPLIED_DELETES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AppliedDeletes").getter(getter(TableStatistics::appliedDeletes)).setter(setter(Builder::appliedDeletes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedDeletes").build()).build();

    private static final SdkField<Long> APPLIED_UPDATES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AppliedUpdates").getter(getter(TableStatistics::appliedUpdates)).setter(setter(Builder::appliedUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedUpdates").build()).build();

    private static final SdkField<Long> APPLIED_DDLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AppliedDdls").getter(getter(TableStatistics::appliedDdls)).setter(setter(Builder::appliedDdls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedDdls").build()).build();

    private static final SdkField<Long> FULL_LOAD_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FullLoadRows").getter(getter(TableStatistics::fullLoadRows)).setter(setter(Builder::fullLoadRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadRows").build()).build();

    private static final SdkField<Long> FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("FullLoadCondtnlChkFailedRows")
            .getter(getter(TableStatistics::fullLoadCondtnlChkFailedRows))
            .setter(setter(Builder::fullLoadCondtnlChkFailedRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadCondtnlChkFailedRows")
                    .build()).build();

    private static final SdkField<Long> FULL_LOAD_ERROR_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FullLoadErrorRows").getter(getter(TableStatistics::fullLoadErrorRows))
            .setter(setter(Builder::fullLoadErrorRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadErrorRows").build()).build();

    private static final SdkField<Instant> FULL_LOAD_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FullLoadStartTime").getter(getter(TableStatistics::fullLoadStartTime))
            .setter(setter(Builder::fullLoadStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadStartTime").build()).build();

    private static final SdkField<Instant> FULL_LOAD_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FullLoadEndTime").getter(getter(TableStatistics::fullLoadEndTime))
            .setter(setter(Builder::fullLoadEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadEndTime").build()).build();

    private static final SdkField<Boolean> FULL_LOAD_RELOADED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FullLoadReloaded").getter(getter(TableStatistics::fullLoadReloaded))
            .setter(setter(Builder::fullLoadReloaded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadReloaded").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(TableStatistics::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<String> TABLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableState").getter(getter(TableStatistics::tableState)).setter(setter(Builder::tableState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableState").build()).build();

    private static final SdkField<Long> VALIDATION_PENDING_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ValidationPendingRecords").getter(getter(TableStatistics::validationPendingRecords))
            .setter(setter(Builder::validationPendingRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationPendingRecords").build())
            .build();

    private static final SdkField<Long> VALIDATION_FAILED_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ValidationFailedRecords").getter(getter(TableStatistics::validationFailedRecords))
            .setter(setter(Builder::validationFailedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailedRecords").build())
            .build();

    private static final SdkField<Long> VALIDATION_SUSPENDED_RECORDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ValidationSuspendedRecords")
            .getter(getter(TableStatistics::validationSuspendedRecords))
            .setter(setter(Builder::validationSuspendedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSuspendedRecords").build())
            .build();

    private static final SdkField<String> VALIDATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationState").getter(getter(TableStatistics::validationState))
            .setter(setter(Builder::validationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationState").build()).build();

    private static final SdkField<String> VALIDATION_STATE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStateDetails").getter(getter(TableStatistics::validationStateDetails))
            .setter(setter(Builder::validationStateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStateDetails").build())
            .build();

    private static final SdkField<String> RESYNC_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResyncState").getter(getter(TableStatistics::resyncState)).setter(setter(Builder::resyncState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResyncState").build()).build();

    private static final SdkField<Long> RESYNC_ROWS_ATTEMPTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResyncRowsAttempted").getter(getter(TableStatistics::resyncRowsAttempted))
            .setter(setter(Builder::resyncRowsAttempted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResyncRowsAttempted").build())
            .build();

    private static final SdkField<Long> RESYNC_ROWS_SUCCEEDED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResyncRowsSucceeded").getter(getter(TableStatistics::resyncRowsSucceeded))
            .setter(setter(Builder::resyncRowsSucceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResyncRowsSucceeded").build())
            .build();

    private static final SdkField<Long> RESYNC_ROWS_FAILED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResyncRowsFailed").getter(getter(TableStatistics::resyncRowsFailed))
            .setter(setter(Builder::resyncRowsFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResyncRowsFailed").build()).build();

    private static final SdkField<Double> RESYNC_PROGRESS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ResyncProgress").getter(getter(TableStatistics::resyncProgress)).setter(setter(Builder::resyncProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResyncProgress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_NAME_FIELD,
            TABLE_NAME_FIELD, INSERTS_FIELD, DELETES_FIELD, UPDATES_FIELD, DDLS_FIELD, APPLIED_INSERTS_FIELD,
            APPLIED_DELETES_FIELD, APPLIED_UPDATES_FIELD, APPLIED_DDLS_FIELD, FULL_LOAD_ROWS_FIELD,
            FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD, FULL_LOAD_ERROR_ROWS_FIELD, FULL_LOAD_START_TIME_FIELD,
            FULL_LOAD_END_TIME_FIELD, FULL_LOAD_RELOADED_FIELD, LAST_UPDATE_TIME_FIELD, TABLE_STATE_FIELD,
            VALIDATION_PENDING_RECORDS_FIELD, VALIDATION_FAILED_RECORDS_FIELD, VALIDATION_SUSPENDED_RECORDS_FIELD,
            VALIDATION_STATE_FIELD, VALIDATION_STATE_DETAILS_FIELD, RESYNC_STATE_FIELD, RESYNC_ROWS_ATTEMPTED_FIELD,
            RESYNC_ROWS_SUCCEEDED_FIELD, RESYNC_ROWS_FAILED_FIELD, RESYNC_PROGRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String schemaName;

    private final String tableName;

    private final Long inserts;

    private final Long deletes;

    private final Long updates;

    private final Long ddls;

    private final Long appliedInserts;

    private final Long appliedDeletes;

    private final Long appliedUpdates;

    private final Long appliedDdls;

    private final Long fullLoadRows;

    private final Long fullLoadCondtnlChkFailedRows;

    private final Long fullLoadErrorRows;

    private final Instant fullLoadStartTime;

    private final Instant fullLoadEndTime;

    private final Boolean fullLoadReloaded;

    private final Instant lastUpdateTime;

    private final String tableState;

    private final Long validationPendingRecords;

    private final Long validationFailedRecords;

    private final Long validationSuspendedRecords;

    private final String validationState;

    private final String validationStateDetails;

    private final String resyncState;

    private final Long resyncRowsAttempted;

    private final Long resyncRowsSucceeded;

    private final Long resyncRowsFailed;

    private final Double resyncProgress;

    private TableStatistics(BuilderImpl builder) {
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.inserts = builder.inserts;
        this.deletes = builder.deletes;
        this.updates = builder.updates;
        this.ddls = builder.ddls;
        this.appliedInserts = builder.appliedInserts;
        this.appliedDeletes = builder.appliedDeletes;
        this.appliedUpdates = builder.appliedUpdates;
        this.appliedDdls = builder.appliedDdls;
        this.fullLoadRows = builder.fullLoadRows;
        this.fullLoadCondtnlChkFailedRows = builder.fullLoadCondtnlChkFailedRows;
        this.fullLoadErrorRows = builder.fullLoadErrorRows;
        this.fullLoadStartTime = builder.fullLoadStartTime;
        this.fullLoadEndTime = builder.fullLoadEndTime;
        this.fullLoadReloaded = builder.fullLoadReloaded;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.tableState = builder.tableState;
        this.validationPendingRecords = builder.validationPendingRecords;
        this.validationFailedRecords = builder.validationFailedRecords;
        this.validationSuspendedRecords = builder.validationSuspendedRecords;
        this.validationState = builder.validationState;
        this.validationStateDetails = builder.validationStateDetails;
        this.resyncState = builder.resyncState;
        this.resyncRowsAttempted = builder.resyncRowsAttempted;
        this.resyncRowsSucceeded = builder.resyncRowsSucceeded;
        this.resyncRowsFailed = builder.resyncRowsFailed;
        this.resyncProgress = builder.resyncProgress;
    }

    /**
     * <p>
     * The schema name.
     * </p>
     * 
     * @return The schema name.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The number of insert actions performed on a table.
     * </p>
     * 
     * @return The number of insert actions performed on a table.
     */
    public final Long inserts() {
        return inserts;
    }

    /**
     * <p>
     * The number of delete actions performed on a table.
     * </p>
     * 
     * @return The number of delete actions performed on a table.
     */
    public final Long deletes() {
        return deletes;
    }

    /**
     * <p>
     * The number of update actions performed on a table.
     * </p>
     * 
     * @return The number of update actions performed on a table.
     */
    public final Long updates() {
        return updates;
    }

    /**
     * <p>
     * The data definition language (DDL) used to build and modify the structure of your tables.
     * </p>
     * 
     * @return The data definition language (DDL) used to build and modify the structure of your tables.
     */
    public final Long ddls() {
        return ddls;
    }

    /**
     * <p>
     * The number of insert actions applied on a target table.
     * </p>
     * 
     * @return The number of insert actions applied on a target table.
     */
    public final Long appliedInserts() {
        return appliedInserts;
    }

    /**
     * <p>
     * The number of delete actions applied on a target table.
     * </p>
     * 
     * @return The number of delete actions applied on a target table.
     */
    public final Long appliedDeletes() {
        return appliedDeletes;
    }

    /**
     * <p>
     * The number of update actions applied on a target table.
     * </p>
     * 
     * @return The number of update actions applied on a target table.
     */
    public final Long appliedUpdates() {
        return appliedUpdates;
    }

    /**
     * <p>
     * The number of data definition language (DDL) statements used to build and modify the structure of your tables
     * applied on the target.
     * </p>
     * 
     * @return The number of data definition language (DDL) statements used to build and modify the structure of your
     *         tables applied on the target.
     */
    public final Long appliedDdls() {
        return appliedDdls;
    }

    /**
     * <p>
     * The number of rows added during the full load operation.
     * </p>
     * 
     * @return The number of rows added during the full load operation.
     */
    public final Long fullLoadRows() {
        return fullLoadRows;
    }

    /**
     * <p>
     * The number of rows that failed conditional checks during the full load operation (valid only for migrations where
     * DynamoDB is the target).
     * </p>
     * 
     * @return The number of rows that failed conditional checks during the full load operation (valid only for
     *         migrations where DynamoDB is the target).
     */
    public final Long fullLoadCondtnlChkFailedRows() {
        return fullLoadCondtnlChkFailedRows;
    }

    /**
     * <p>
     * The number of rows that failed to load during the full load operation (valid only for migrations where DynamoDB
     * is the target).
     * </p>
     * 
     * @return The number of rows that failed to load during the full load operation (valid only for migrations where
     *         DynamoDB is the target).
     */
    public final Long fullLoadErrorRows() {
        return fullLoadErrorRows;
    }

    /**
     * <p>
     * The time when the full load operation started.
     * </p>
     * 
     * @return The time when the full load operation started.
     */
    public final Instant fullLoadStartTime() {
        return fullLoadStartTime;
    }

    /**
     * <p>
     * The time when the full load operation completed.
     * </p>
     * 
     * @return The time when the full load operation completed.
     */
    public final Instant fullLoadEndTime() {
        return fullLoadEndTime;
    }

    /**
     * <p>
     * A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full load
     * operation (<code>false</code>).
     * </p>
     * 
     * @return A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full load
     *         operation (<code>false</code>).
     */
    public final Boolean fullLoadReloaded() {
        return fullLoadReloaded;
    }

    /**
     * <p>
     * The last time a table was updated.
     * </p>
     * 
     * @return The last time a table was updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The state of the tables described.
     * </p>
     * <p>
     * Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table error |
     * Table is being reloaded
     * </p>
     * 
     * @return The state of the tables described.</p>
     *         <p>
     *         Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table
     *         error | Table is being reloaded
     */
    public final String tableState() {
        return tableState;
    }

    /**
     * <p>
     * The number of records that have yet to be validated.
     * </p>
     * 
     * @return The number of records that have yet to be validated.
     */
    public final Long validationPendingRecords() {
        return validationPendingRecords;
    }

    /**
     * <p>
     * The number of records that failed validation.
     * </p>
     * 
     * @return The number of records that failed validation.
     */
    public final Long validationFailedRecords() {
        return validationFailedRecords;
    }

    /**
     * <p>
     * The number of records that couldn't be validated.
     * </p>
     * 
     * @return The number of records that couldn't be validated.
     */
    public final Long validationSuspendedRecords() {
        return validationSuspendedRecords;
    }

    /**
     * <p>
     * The validation state of the table.
     * </p>
     * <p>
     * This parameter can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Not enabled – Validation isn't enabled for the table in the migration task.
     * </p>
     * </li>
     * <li>
     * <p>
     * Pending records – Some records in the table are waiting for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Mismatched records – Some records in the table don't match between the source and target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Suspended records – Some records in the table couldn't be validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * No primary key –The table couldn't be validated because it has no primary key.
     * </p>
     * </li>
     * <li>
     * <p>
     * Table error – The table wasn't validated because it's in an error state and some data wasn't migrated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Validated – All rows in the table are validated. If the table is updated, the status can change from Validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Error – The table couldn't be validated because of an unexpected error.
     * </p>
     * </li>
     * <li>
     * <p>
     * Pending validation – The table is waiting validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Preparing table – Preparing the table enabled in the migration task for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Pending revalidation – All rows in the table are pending validation after the table was updated.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The validation state of the table.</p>
     *         <p>
     *         This parameter can have the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Not enabled – Validation isn't enabled for the table in the migration task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Pending records – Some records in the table are waiting for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Mismatched records – Some records in the table don't match between the source and target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Suspended records – Some records in the table couldn't be validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No primary key –The table couldn't be validated because it has no primary key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Table error – The table wasn't validated because it's in an error state and some data wasn't migrated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Validated – All rows in the table are validated. If the table is updated, the status can change from
     *         Validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Error – The table couldn't be validated because of an unexpected error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Pending validation – The table is waiting validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Preparing table – Preparing the table enabled in the migration task for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Pending revalidation – All rows in the table are pending validation after the table was updated.
     *         </p>
     *         </li>
     */
    public final String validationState() {
        return validationState;
    }

    /**
     * <p>
     * Additional details about the state of validation.
     * </p>
     * 
     * @return Additional details about the state of validation.
     */
    public final String validationStateDetails() {
        return validationStateDetails;
    }

    /**
     * <p>
     * Records the current state of table resynchronization in the migration task.
     * </p>
     * <p>
     * This parameter can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Not enabled – Resync is not enabled for the table in the migration task.
     * </p>
     * </li>
     * <li>
     * <p>
     * Pending – The tables are waiting for resync.
     * </p>
     * </li>
     * <li>
     * <p>
     * In progress – Resync in progress for some records in the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * No primary key – The table could not be resynced because it has no primary key.
     * </p>
     * </li>
     * <li>
     * <p>
     * Last resync at: <code>date/time</code> – Resync session is finished at time. Time provided in UTC format.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Records the current state of table resynchronization in the migration task.</p>
     *         <p>
     *         This parameter can have the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Not enabled – Resync is not enabled for the table in the migration task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Pending – The tables are waiting for resync.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In progress – Resync in progress for some records in the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No primary key – The table could not be resynced because it has no primary key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Last resync at: <code>date/time</code> – Resync session is finished at time. Time provided in UTC format.
     *         </p>
     *         </li>
     */
    public final String resyncState() {
        return resyncState;
    }

    /**
     * <p>
     * Records the total number of mismatched data rows where the system attempted to apply fixes in the target
     * database.
     * </p>
     * 
     * @return Records the total number of mismatched data rows where the system attempted to apply fixes in the target
     *         database.
     */
    public final Long resyncRowsAttempted() {
        return resyncRowsAttempted;
    }

    /**
     * <p>
     * Records the total number of mismatched data rows where fixes were successfully applied in the target database.
     * </p>
     * 
     * @return Records the total number of mismatched data rows where fixes were successfully applied in the target
     *         database.
     */
    public final Long resyncRowsSucceeded() {
        return resyncRowsSucceeded;
    }

    /**
     * <p>
     * Records the total number of mismatched data rows where fix attempts failed in the target database.
     * </p>
     * 
     * @return Records the total number of mismatched data rows where fix attempts failed in the target database.
     */
    public final Long resyncRowsFailed() {
        return resyncRowsFailed;
    }

    /**
     * <p>
     * Calculates the percentage of failed validations that were successfully resynced to the system.
     * </p>
     * 
     * @return Calculates the percentage of failed validations that were successfully resynced to the system.
     */
    public final Double resyncProgress() {
        return resyncProgress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(inserts());
        hashCode = 31 * hashCode + Objects.hashCode(deletes());
        hashCode = 31 * hashCode + Objects.hashCode(updates());
        hashCode = 31 * hashCode + Objects.hashCode(ddls());
        hashCode = 31 * hashCode + Objects.hashCode(appliedInserts());
        hashCode = 31 * hashCode + Objects.hashCode(appliedDeletes());
        hashCode = 31 * hashCode + Objects.hashCode(appliedUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(appliedDdls());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadRows());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadCondtnlChkFailedRows());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadErrorRows());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadReloaded());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(tableState());
        hashCode = 31 * hashCode + Objects.hashCode(validationPendingRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationFailedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationSuspendedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationState());
        hashCode = 31 * hashCode + Objects.hashCode(validationStateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(resyncState());
        hashCode = 31 * hashCode + Objects.hashCode(resyncRowsAttempted());
        hashCode = 31 * hashCode + Objects.hashCode(resyncRowsSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(resyncRowsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(resyncProgress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableStatistics)) {
            return false;
        }
        TableStatistics other = (TableStatistics) obj;
        return Objects.equals(schemaName(), other.schemaName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(inserts(), other.inserts()) && Objects.equals(deletes(), other.deletes())
                && Objects.equals(updates(), other.updates()) && Objects.equals(ddls(), other.ddls())
                && Objects.equals(appliedInserts(), other.appliedInserts())
                && Objects.equals(appliedDeletes(), other.appliedDeletes())
                && Objects.equals(appliedUpdates(), other.appliedUpdates()) && Objects.equals(appliedDdls(), other.appliedDdls())
                && Objects.equals(fullLoadRows(), other.fullLoadRows())
                && Objects.equals(fullLoadCondtnlChkFailedRows(), other.fullLoadCondtnlChkFailedRows())
                && Objects.equals(fullLoadErrorRows(), other.fullLoadErrorRows())
                && Objects.equals(fullLoadStartTime(), other.fullLoadStartTime())
                && Objects.equals(fullLoadEndTime(), other.fullLoadEndTime())
                && Objects.equals(fullLoadReloaded(), other.fullLoadReloaded())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(tableState(), other.tableState())
                && Objects.equals(validationPendingRecords(), other.validationPendingRecords())
                && Objects.equals(validationFailedRecords(), other.validationFailedRecords())
                && Objects.equals(validationSuspendedRecords(), other.validationSuspendedRecords())
                && Objects.equals(validationState(), other.validationState())
                && Objects.equals(validationStateDetails(), other.validationStateDetails())
                && Objects.equals(resyncState(), other.resyncState())
                && Objects.equals(resyncRowsAttempted(), other.resyncRowsAttempted())
                && Objects.equals(resyncRowsSucceeded(), other.resyncRowsSucceeded())
                && Objects.equals(resyncRowsFailed(), other.resyncRowsFailed())
                && Objects.equals(resyncProgress(), other.resyncProgress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableStatistics").add("SchemaName", schemaName()).add("TableName", tableName())
                .add("Inserts", inserts()).add("Deletes", deletes()).add("Updates", updates()).add("Ddls", ddls())
                .add("AppliedInserts", appliedInserts()).add("AppliedDeletes", appliedDeletes())
                .add("AppliedUpdates", appliedUpdates()).add("AppliedDdls", appliedDdls()).add("FullLoadRows", fullLoadRows())
                .add("FullLoadCondtnlChkFailedRows", fullLoadCondtnlChkFailedRows())
                .add("FullLoadErrorRows", fullLoadErrorRows()).add("FullLoadStartTime", fullLoadStartTime())
                .add("FullLoadEndTime", fullLoadEndTime()).add("FullLoadReloaded", fullLoadReloaded())
                .add("LastUpdateTime", lastUpdateTime()).add("TableState", tableState())
                .add("ValidationPendingRecords", validationPendingRecords())
                .add("ValidationFailedRecords", validationFailedRecords())
                .add("ValidationSuspendedRecords", validationSuspendedRecords()).add("ValidationState", validationState())
                .add("ValidationStateDetails", validationStateDetails()).add("ResyncState", resyncState())
                .add("ResyncRowsAttempted", resyncRowsAttempted()).add("ResyncRowsSucceeded", resyncRowsSucceeded())
                .add("ResyncRowsFailed", resyncRowsFailed()).add("ResyncProgress", resyncProgress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Inserts":
            return Optional.ofNullable(clazz.cast(inserts()));
        case "Deletes":
            return Optional.ofNullable(clazz.cast(deletes()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "Ddls":
            return Optional.ofNullable(clazz.cast(ddls()));
        case "AppliedInserts":
            return Optional.ofNullable(clazz.cast(appliedInserts()));
        case "AppliedDeletes":
            return Optional.ofNullable(clazz.cast(appliedDeletes()));
        case "AppliedUpdates":
            return Optional.ofNullable(clazz.cast(appliedUpdates()));
        case "AppliedDdls":
            return Optional.ofNullable(clazz.cast(appliedDdls()));
        case "FullLoadRows":
            return Optional.ofNullable(clazz.cast(fullLoadRows()));
        case "FullLoadCondtnlChkFailedRows":
            return Optional.ofNullable(clazz.cast(fullLoadCondtnlChkFailedRows()));
        case "FullLoadErrorRows":
            return Optional.ofNullable(clazz.cast(fullLoadErrorRows()));
        case "FullLoadStartTime":
            return Optional.ofNullable(clazz.cast(fullLoadStartTime()));
        case "FullLoadEndTime":
            return Optional.ofNullable(clazz.cast(fullLoadEndTime()));
        case "FullLoadReloaded":
            return Optional.ofNullable(clazz.cast(fullLoadReloaded()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "TableState":
            return Optional.ofNullable(clazz.cast(tableState()));
        case "ValidationPendingRecords":
            return Optional.ofNullable(clazz.cast(validationPendingRecords()));
        case "ValidationFailedRecords":
            return Optional.ofNullable(clazz.cast(validationFailedRecords()));
        case "ValidationSuspendedRecords":
            return Optional.ofNullable(clazz.cast(validationSuspendedRecords()));
        case "ValidationState":
            return Optional.ofNullable(clazz.cast(validationState()));
        case "ValidationStateDetails":
            return Optional.ofNullable(clazz.cast(validationStateDetails()));
        case "ResyncState":
            return Optional.ofNullable(clazz.cast(resyncState()));
        case "ResyncRowsAttempted":
            return Optional.ofNullable(clazz.cast(resyncRowsAttempted()));
        case "ResyncRowsSucceeded":
            return Optional.ofNullable(clazz.cast(resyncRowsSucceeded()));
        case "ResyncRowsFailed":
            return Optional.ofNullable(clazz.cast(resyncRowsFailed()));
        case "ResyncProgress":
            return Optional.ofNullable(clazz.cast(resyncProgress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaName", SCHEMA_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("Inserts", INSERTS_FIELD);
        map.put("Deletes", DELETES_FIELD);
        map.put("Updates", UPDATES_FIELD);
        map.put("Ddls", DDLS_FIELD);
        map.put("AppliedInserts", APPLIED_INSERTS_FIELD);
        map.put("AppliedDeletes", APPLIED_DELETES_FIELD);
        map.put("AppliedUpdates", APPLIED_UPDATES_FIELD);
        map.put("AppliedDdls", APPLIED_DDLS_FIELD);
        map.put("FullLoadRows", FULL_LOAD_ROWS_FIELD);
        map.put("FullLoadCondtnlChkFailedRows", FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD);
        map.put("FullLoadErrorRows", FULL_LOAD_ERROR_ROWS_FIELD);
        map.put("FullLoadStartTime", FULL_LOAD_START_TIME_FIELD);
        map.put("FullLoadEndTime", FULL_LOAD_END_TIME_FIELD);
        map.put("FullLoadReloaded", FULL_LOAD_RELOADED_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("TableState", TABLE_STATE_FIELD);
        map.put("ValidationPendingRecords", VALIDATION_PENDING_RECORDS_FIELD);
        map.put("ValidationFailedRecords", VALIDATION_FAILED_RECORDS_FIELD);
        map.put("ValidationSuspendedRecords", VALIDATION_SUSPENDED_RECORDS_FIELD);
        map.put("ValidationState", VALIDATION_STATE_FIELD);
        map.put("ValidationStateDetails", VALIDATION_STATE_DETAILS_FIELD);
        map.put("ResyncState", RESYNC_STATE_FIELD);
        map.put("ResyncRowsAttempted", RESYNC_ROWS_ATTEMPTED_FIELD);
        map.put("ResyncRowsSucceeded", RESYNC_ROWS_SUCCEEDED_FIELD);
        map.put("ResyncRowsFailed", RESYNC_ROWS_FAILED_FIELD);
        map.put("ResyncProgress", RESYNC_PROGRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableStatistics, T> g) {
        return obj -> g.apply((TableStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableStatistics> {
        /**
         * <p>
         * The schema name.
         * </p>
         * 
         * @param schemaName
         *        The schema name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The number of insert actions performed on a table.
         * </p>
         * 
         * @param inserts
         *        The number of insert actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inserts(Long inserts);

        /**
         * <p>
         * The number of delete actions performed on a table.
         * </p>
         * 
         * @param deletes
         *        The number of delete actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(Long deletes);

        /**
         * <p>
         * The number of update actions performed on a table.
         * </p>
         * 
         * @param updates
         *        The number of update actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Long updates);

        /**
         * <p>
         * The data definition language (DDL) used to build and modify the structure of your tables.
         * </p>
         * 
         * @param ddls
         *        The data definition language (DDL) used to build and modify the structure of your tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ddls(Long ddls);

        /**
         * <p>
         * The number of insert actions applied on a target table.
         * </p>
         * 
         * @param appliedInserts
         *        The number of insert actions applied on a target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedInserts(Long appliedInserts);

        /**
         * <p>
         * The number of delete actions applied on a target table.
         * </p>
         * 
         * @param appliedDeletes
         *        The number of delete actions applied on a target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedDeletes(Long appliedDeletes);

        /**
         * <p>
         * The number of update actions applied on a target table.
         * </p>
         * 
         * @param appliedUpdates
         *        The number of update actions applied on a target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedUpdates(Long appliedUpdates);

        /**
         * <p>
         * The number of data definition language (DDL) statements used to build and modify the structure of your tables
         * applied on the target.
         * </p>
         * 
         * @param appliedDdls
         *        The number of data definition language (DDL) statements used to build and modify the structure of your
         *        tables applied on the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedDdls(Long appliedDdls);

        /**
         * <p>
         * The number of rows added during the full load operation.
         * </p>
         * 
         * @param fullLoadRows
         *        The number of rows added during the full load operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadRows(Long fullLoadRows);

        /**
         * <p>
         * The number of rows that failed conditional checks during the full load operation (valid only for migrations
         * where DynamoDB is the target).
         * </p>
         * 
         * @param fullLoadCondtnlChkFailedRows
         *        The number of rows that failed conditional checks during the full load operation (valid only for
         *        migrations where DynamoDB is the target).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows);

        /**
         * <p>
         * The number of rows that failed to load during the full load operation (valid only for migrations where
         * DynamoDB is the target).
         * </p>
         * 
         * @param fullLoadErrorRows
         *        The number of rows that failed to load during the full load operation (valid only for migrations where
         *        DynamoDB is the target).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadErrorRows(Long fullLoadErrorRows);

        /**
         * <p>
         * The time when the full load operation started.
         * </p>
         * 
         * @param fullLoadStartTime
         *        The time when the full load operation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadStartTime(Instant fullLoadStartTime);

        /**
         * <p>
         * The time when the full load operation completed.
         * </p>
         * 
         * @param fullLoadEndTime
         *        The time when the full load operation completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadEndTime(Instant fullLoadEndTime);

        /**
         * <p>
         * A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full load
         * operation (<code>false</code>).
         * </p>
         * 
         * @param fullLoadReloaded
         *        A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full
         *        load operation (<code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadReloaded(Boolean fullLoadReloaded);

        /**
         * <p>
         * The last time a table was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time a table was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The state of the tables described.
         * </p>
         * <p>
         * Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table
         * error | Table is being reloaded
         * </p>
         * 
         * @param tableState
         *        The state of the tables described.</p>
         *        <p>
         *        Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled |
         *        Table error | Table is being reloaded
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableState(String tableState);

        /**
         * <p>
         * The number of records that have yet to be validated.
         * </p>
         * 
         * @param validationPendingRecords
         *        The number of records that have yet to be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationPendingRecords(Long validationPendingRecords);

        /**
         * <p>
         * The number of records that failed validation.
         * </p>
         * 
         * @param validationFailedRecords
         *        The number of records that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationFailedRecords(Long validationFailedRecords);

        /**
         * <p>
         * The number of records that couldn't be validated.
         * </p>
         * 
         * @param validationSuspendedRecords
         *        The number of records that couldn't be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSuspendedRecords(Long validationSuspendedRecords);

        /**
         * <p>
         * The validation state of the table.
         * </p>
         * <p>
         * This parameter can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Not enabled – Validation isn't enabled for the table in the migration task.
         * </p>
         * </li>
         * <li>
         * <p>
         * Pending records – Some records in the table are waiting for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Mismatched records – Some records in the table don't match between the source and target.
         * </p>
         * </li>
         * <li>
         * <p>
         * Suspended records – Some records in the table couldn't be validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * No primary key –The table couldn't be validated because it has no primary key.
         * </p>
         * </li>
         * <li>
         * <p>
         * Table error – The table wasn't validated because it's in an error state and some data wasn't migrated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Validated – All rows in the table are validated. If the table is updated, the status can change from
         * Validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Error – The table couldn't be validated because of an unexpected error.
         * </p>
         * </li>
         * <li>
         * <p>
         * Pending validation – The table is waiting validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Preparing table – Preparing the table enabled in the migration task for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Pending revalidation – All rows in the table are pending validation after the table was updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param validationState
         *        The validation state of the table.</p>
         *        <p>
         *        This parameter can have the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Not enabled – Validation isn't enabled for the table in the migration task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Pending records – Some records in the table are waiting for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Mismatched records – Some records in the table don't match between the source and target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Suspended records – Some records in the table couldn't be validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No primary key –The table couldn't be validated because it has no primary key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Table error – The table wasn't validated because it's in an error state and some data wasn't migrated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Validated – All rows in the table are validated. If the table is updated, the status can change from
         *        Validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Error – The table couldn't be validated because of an unexpected error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Pending validation – The table is waiting validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Preparing table – Preparing the table enabled in the migration task for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Pending revalidation – All rows in the table are pending validation after the table was updated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationState(String validationState);

        /**
         * <p>
         * Additional details about the state of validation.
         * </p>
         * 
         * @param validationStateDetails
         *        Additional details about the state of validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStateDetails(String validationStateDetails);

        /**
         * <p>
         * Records the current state of table resynchronization in the migration task.
         * </p>
         * <p>
         * This parameter can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Not enabled – Resync is not enabled for the table in the migration task.
         * </p>
         * </li>
         * <li>
         * <p>
         * Pending – The tables are waiting for resync.
         * </p>
         * </li>
         * <li>
         * <p>
         * In progress – Resync in progress for some records in the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * No primary key – The table could not be resynced because it has no primary key.
         * </p>
         * </li>
         * <li>
         * <p>
         * Last resync at: <code>date/time</code> – Resync session is finished at time. Time provided in UTC format.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resyncState
         *        Records the current state of table resynchronization in the migration task.</p>
         *        <p>
         *        This parameter can have the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Not enabled – Resync is not enabled for the table in the migration task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Pending – The tables are waiting for resync.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In progress – Resync in progress for some records in the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No primary key – The table could not be resynced because it has no primary key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Last resync at: <code>date/time</code> – Resync session is finished at time. Time provided in UTC
         *        format.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resyncState(String resyncState);

        /**
         * <p>
         * Records the total number of mismatched data rows where the system attempted to apply fixes in the target
         * database.
         * </p>
         * 
         * @param resyncRowsAttempted
         *        Records the total number of mismatched data rows where the system attempted to apply fixes in the
         *        target database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resyncRowsAttempted(Long resyncRowsAttempted);

        /**
         * <p>
         * Records the total number of mismatched data rows where fixes were successfully applied in the target
         * database.
         * </p>
         * 
         * @param resyncRowsSucceeded
         *        Records the total number of mismatched data rows where fixes were successfully applied in the target
         *        database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resyncRowsSucceeded(Long resyncRowsSucceeded);

        /**
         * <p>
         * Records the total number of mismatched data rows where fix attempts failed in the target database.
         * </p>
         * 
         * @param resyncRowsFailed
         *        Records the total number of mismatched data rows where fix attempts failed in the target database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resyncRowsFailed(Long resyncRowsFailed);

        /**
         * <p>
         * Calculates the percentage of failed validations that were successfully resynced to the system.
         * </p>
         * 
         * @param resyncProgress
         *        Calculates the percentage of failed validations that were successfully resynced to the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resyncProgress(Double resyncProgress);
    }

    static final class BuilderImpl implements Builder {
        private String schemaName;

        private String tableName;

        private Long inserts;

        private Long deletes;

        private Long updates;

        private Long ddls;

        private Long appliedInserts;

        private Long appliedDeletes;

        private Long appliedUpdates;

        private Long appliedDdls;

        private Long fullLoadRows;

        private Long fullLoadCondtnlChkFailedRows;

        private Long fullLoadErrorRows;

        private Instant fullLoadStartTime;

        private Instant fullLoadEndTime;

        private Boolean fullLoadReloaded;

        private Instant lastUpdateTime;

        private String tableState;

        private Long validationPendingRecords;

        private Long validationFailedRecords;

        private Long validationSuspendedRecords;

        private String validationState;

        private String validationStateDetails;

        private String resyncState;

        private Long resyncRowsAttempted;

        private Long resyncRowsSucceeded;

        private Long resyncRowsFailed;

        private Double resyncProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(TableStatistics model) {
            schemaName(model.schemaName);
            tableName(model.tableName);
            inserts(model.inserts);
            deletes(model.deletes);
            updates(model.updates);
            ddls(model.ddls);
            appliedInserts(model.appliedInserts);
            appliedDeletes(model.appliedDeletes);
            appliedUpdates(model.appliedUpdates);
            appliedDdls(model.appliedDdls);
            fullLoadRows(model.fullLoadRows);
            fullLoadCondtnlChkFailedRows(model.fullLoadCondtnlChkFailedRows);
            fullLoadErrorRows(model.fullLoadErrorRows);
            fullLoadStartTime(model.fullLoadStartTime);
            fullLoadEndTime(model.fullLoadEndTime);
            fullLoadReloaded(model.fullLoadReloaded);
            lastUpdateTime(model.lastUpdateTime);
            tableState(model.tableState);
            validationPendingRecords(model.validationPendingRecords);
            validationFailedRecords(model.validationFailedRecords);
            validationSuspendedRecords(model.validationSuspendedRecords);
            validationState(model.validationState);
            validationStateDetails(model.validationStateDetails);
            resyncState(model.resyncState);
            resyncRowsAttempted(model.resyncRowsAttempted);
            resyncRowsSucceeded(model.resyncRowsSucceeded);
            resyncRowsFailed(model.resyncRowsFailed);
            resyncProgress(model.resyncProgress);
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Long getInserts() {
            return inserts;
        }

        public final void setInserts(Long inserts) {
            this.inserts = inserts;
        }

        @Override
        public final Builder inserts(Long inserts) {
            this.inserts = inserts;
            return this;
        }

        public final Long getDeletes() {
            return deletes;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final Long getUpdates() {
            return updates;
        }

        public final void setUpdates(Long updates) {
            this.updates = updates;
        }

        @Override
        public final Builder updates(Long updates) {
            this.updates = updates;
            return this;
        }

        public final Long getDdls() {
            return ddls;
        }

        public final void setDdls(Long ddls) {
            this.ddls = ddls;
        }

        @Override
        public final Builder ddls(Long ddls) {
            this.ddls = ddls;
            return this;
        }

        public final Long getAppliedInserts() {
            return appliedInserts;
        }

        public final void setAppliedInserts(Long appliedInserts) {
            this.appliedInserts = appliedInserts;
        }

        @Override
        public final Builder appliedInserts(Long appliedInserts) {
            this.appliedInserts = appliedInserts;
            return this;
        }

        public final Long getAppliedDeletes() {
            return appliedDeletes;
        }

        public final void setAppliedDeletes(Long appliedDeletes) {
            this.appliedDeletes = appliedDeletes;
        }

        @Override
        public final Builder appliedDeletes(Long appliedDeletes) {
            this.appliedDeletes = appliedDeletes;
            return this;
        }

        public final Long getAppliedUpdates() {
            return appliedUpdates;
        }

        public final void setAppliedUpdates(Long appliedUpdates) {
            this.appliedUpdates = appliedUpdates;
        }

        @Override
        public final Builder appliedUpdates(Long appliedUpdates) {
            this.appliedUpdates = appliedUpdates;
            return this;
        }

        public final Long getAppliedDdls() {
            return appliedDdls;
        }

        public final void setAppliedDdls(Long appliedDdls) {
            this.appliedDdls = appliedDdls;
        }

        @Override
        public final Builder appliedDdls(Long appliedDdls) {
            this.appliedDdls = appliedDdls;
            return this;
        }

        public final Long getFullLoadRows() {
            return fullLoadRows;
        }

        public final void setFullLoadRows(Long fullLoadRows) {
            this.fullLoadRows = fullLoadRows;
        }

        @Override
        public final Builder fullLoadRows(Long fullLoadRows) {
            this.fullLoadRows = fullLoadRows;
            return this;
        }

        public final Long getFullLoadCondtnlChkFailedRows() {
            return fullLoadCondtnlChkFailedRows;
        }

        public final void setFullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows) {
            this.fullLoadCondtnlChkFailedRows = fullLoadCondtnlChkFailedRows;
        }

        @Override
        public final Builder fullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows) {
            this.fullLoadCondtnlChkFailedRows = fullLoadCondtnlChkFailedRows;
            return this;
        }

        public final Long getFullLoadErrorRows() {
            return fullLoadErrorRows;
        }

        public final void setFullLoadErrorRows(Long fullLoadErrorRows) {
            this.fullLoadErrorRows = fullLoadErrorRows;
        }

        @Override
        public final Builder fullLoadErrorRows(Long fullLoadErrorRows) {
            this.fullLoadErrorRows = fullLoadErrorRows;
            return this;
        }

        public final Instant getFullLoadStartTime() {
            return fullLoadStartTime;
        }

        public final void setFullLoadStartTime(Instant fullLoadStartTime) {
            this.fullLoadStartTime = fullLoadStartTime;
        }

        @Override
        public final Builder fullLoadStartTime(Instant fullLoadStartTime) {
            this.fullLoadStartTime = fullLoadStartTime;
            return this;
        }

        public final Instant getFullLoadEndTime() {
            return fullLoadEndTime;
        }

        public final void setFullLoadEndTime(Instant fullLoadEndTime) {
            this.fullLoadEndTime = fullLoadEndTime;
        }

        @Override
        public final Builder fullLoadEndTime(Instant fullLoadEndTime) {
            this.fullLoadEndTime = fullLoadEndTime;
            return this;
        }

        public final Boolean getFullLoadReloaded() {
            return fullLoadReloaded;
        }

        public final void setFullLoadReloaded(Boolean fullLoadReloaded) {
            this.fullLoadReloaded = fullLoadReloaded;
        }

        @Override
        public final Builder fullLoadReloaded(Boolean fullLoadReloaded) {
            this.fullLoadReloaded = fullLoadReloaded;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getTableState() {
            return tableState;
        }

        public final void setTableState(String tableState) {
            this.tableState = tableState;
        }

        @Override
        public final Builder tableState(String tableState) {
            this.tableState = tableState;
            return this;
        }

        public final Long getValidationPendingRecords() {
            return validationPendingRecords;
        }

        public final void setValidationPendingRecords(Long validationPendingRecords) {
            this.validationPendingRecords = validationPendingRecords;
        }

        @Override
        public final Builder validationPendingRecords(Long validationPendingRecords) {
            this.validationPendingRecords = validationPendingRecords;
            return this;
        }

        public final Long getValidationFailedRecords() {
            return validationFailedRecords;
        }

        public final void setValidationFailedRecords(Long validationFailedRecords) {
            this.validationFailedRecords = validationFailedRecords;
        }

        @Override
        public final Builder validationFailedRecords(Long validationFailedRecords) {
            this.validationFailedRecords = validationFailedRecords;
            return this;
        }

        public final Long getValidationSuspendedRecords() {
            return validationSuspendedRecords;
        }

        public final void setValidationSuspendedRecords(Long validationSuspendedRecords) {
            this.validationSuspendedRecords = validationSuspendedRecords;
        }

        @Override
        public final Builder validationSuspendedRecords(Long validationSuspendedRecords) {
            this.validationSuspendedRecords = validationSuspendedRecords;
            return this;
        }

        public final String getValidationState() {
            return validationState;
        }

        public final void setValidationState(String validationState) {
            this.validationState = validationState;
        }

        @Override
        public final Builder validationState(String validationState) {
            this.validationState = validationState;
            return this;
        }

        public final String getValidationStateDetails() {
            return validationStateDetails;
        }

        public final void setValidationStateDetails(String validationStateDetails) {
            this.validationStateDetails = validationStateDetails;
        }

        @Override
        public final Builder validationStateDetails(String validationStateDetails) {
            this.validationStateDetails = validationStateDetails;
            return this;
        }

        public final String getResyncState() {
            return resyncState;
        }

        public final void setResyncState(String resyncState) {
            this.resyncState = resyncState;
        }

        @Override
        public final Builder resyncState(String resyncState) {
            this.resyncState = resyncState;
            return this;
        }

        public final Long getResyncRowsAttempted() {
            return resyncRowsAttempted;
        }

        public final void setResyncRowsAttempted(Long resyncRowsAttempted) {
            this.resyncRowsAttempted = resyncRowsAttempted;
        }

        @Override
        public final Builder resyncRowsAttempted(Long resyncRowsAttempted) {
            this.resyncRowsAttempted = resyncRowsAttempted;
            return this;
        }

        public final Long getResyncRowsSucceeded() {
            return resyncRowsSucceeded;
        }

        public final void setResyncRowsSucceeded(Long resyncRowsSucceeded) {
            this.resyncRowsSucceeded = resyncRowsSucceeded;
        }

        @Override
        public final Builder resyncRowsSucceeded(Long resyncRowsSucceeded) {
            this.resyncRowsSucceeded = resyncRowsSucceeded;
            return this;
        }

        public final Long getResyncRowsFailed() {
            return resyncRowsFailed;
        }

        public final void setResyncRowsFailed(Long resyncRowsFailed) {
            this.resyncRowsFailed = resyncRowsFailed;
        }

        @Override
        public final Builder resyncRowsFailed(Long resyncRowsFailed) {
            this.resyncRowsFailed = resyncRowsFailed;
            return this;
        }

        public final Double getResyncProgress() {
            return resyncProgress;
        }

        public final void setResyncProgress(Double resyncProgress) {
            this.resyncProgress = resyncProgress;
        }

        @Override
        public final Builder resyncProgress(Double resyncProgress) {
            this.resyncProgress = resyncProgress;
            return this;
        }

        @Override
        public TableStatistics build() {
            return new TableStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
