/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.MetadataModelReference;
import software.amazon.awssdk.services.databasemigration.model.MetadataModelReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMetadataModelResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeMetadataModelResponse> {
    private static final SdkField<String> METADATA_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataModelName").getter(DescribeMetadataModelResponse.getter(DescribeMetadataModelResponse::metadataModelName)).setter(DescribeMetadataModelResponse.setter(Builder::metadataModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelName").build()}).build();
    private static final SdkField<String> METADATA_MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataModelType").getter(DescribeMetadataModelResponse.getter(DescribeMetadataModelResponse::metadataModelType)).setter(DescribeMetadataModelResponse.setter(Builder::metadataModelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelType").build()}).build();
    private static final SdkField<List<MetadataModelReference>> TARGET_METADATA_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetMetadataModels").getter(DescribeMetadataModelResponse.getter(DescribeMetadataModelResponse::targetMetadataModels)).setter(DescribeMetadataModelResponse.setter(Builder::targetMetadataModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMetadataModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataModelReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Definition").getter(DescribeMetadataModelResponse.getter(DescribeMetadataModelResponse::definition)).setter(DescribeMetadataModelResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_MODEL_NAME_FIELD, METADATA_MODEL_TYPE_FIELD, TARGET_METADATA_MODELS_FIELD, DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMetadataModelResponse.memberNameToFieldInitializer();
    private final String metadataModelName;
    private final String metadataModelType;
    private final List<MetadataModelReference> targetMetadataModels;
    private final String definition;

    private DescribeMetadataModelResponse(BuilderImpl builder) {
        super(builder);
        this.metadataModelName = builder.metadataModelName;
        this.metadataModelType = builder.metadataModelType;
        this.targetMetadataModels = builder.targetMetadataModels;
        this.definition = builder.definition;
    }

    public final String metadataModelName() {
        return this.metadataModelName;
    }

    public final String metadataModelType() {
        return this.metadataModelType;
    }

    public final boolean hasTargetMetadataModels() {
        return this.targetMetadataModels != null && !(this.targetMetadataModels instanceof SdkAutoConstructList);
    }

    public final List<MetadataModelReference> targetMetadataModels() {
        return this.targetMetadataModels;
    }

    public final String definition() {
        return this.definition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataModelType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetMetadataModels() ? this.targetMetadataModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetadataModelResponse)) {
            return false;
        }
        DescribeMetadataModelResponse other = (DescribeMetadataModelResponse)((Object)obj);
        return Objects.equals(this.metadataModelName(), other.metadataModelName()) && Objects.equals(this.metadataModelType(), other.metadataModelType()) && this.hasTargetMetadataModels() == other.hasTargetMetadataModels() && Objects.equals(this.targetMetadataModels(), other.targetMetadataModels()) && Objects.equals(this.definition(), other.definition());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMetadataModelResponse").add("MetadataModelName", (Object)this.metadataModelName()).add("MetadataModelType", (Object)this.metadataModelType()).add("TargetMetadataModels", this.hasTargetMetadataModels() ? this.targetMetadataModels() : null).add("Definition", (Object)this.definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetadataModelName": {
                return Optional.ofNullable(clazz.cast(this.metadataModelName()));
            }
            case "MetadataModelType": {
                return Optional.ofNullable(clazz.cast(this.metadataModelType()));
            }
            case "TargetMetadataModels": {
                return Optional.ofNullable(clazz.cast(this.targetMetadataModels()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetadataModelName", METADATA_MODEL_NAME_FIELD);
        map.put("MetadataModelType", METADATA_MODEL_TYPE_FIELD);
        map.put("TargetMetadataModels", TARGET_METADATA_MODELS_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetadataModelResponse, T> g) {
        return obj -> g.apply((DescribeMetadataModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String metadataModelName;
        private String metadataModelType;
        private List<MetadataModelReference> targetMetadataModels = DefaultSdkAutoConstructList.getInstance();
        private String definition;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetadataModelResponse model) {
            super(model);
            this.metadataModelName(model.metadataModelName);
            this.metadataModelType(model.metadataModelType);
            this.targetMetadataModels(model.targetMetadataModels);
            this.definition(model.definition);
        }

        public final String getMetadataModelName() {
            return this.metadataModelName;
        }

        public final void setMetadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
        }

        @Override
        public final Builder metadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
            return this;
        }

        public final String getMetadataModelType() {
            return this.metadataModelType;
        }

        public final void setMetadataModelType(String metadataModelType) {
            this.metadataModelType = metadataModelType;
        }

        @Override
        public final Builder metadataModelType(String metadataModelType) {
            this.metadataModelType = metadataModelType;
            return this;
        }

        public final List<MetadataModelReference.Builder> getTargetMetadataModels() {
            List<MetadataModelReference.Builder> result = MetadataModelReferenceListCopier.copyToBuilder(this.targetMetadataModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetMetadataModels(Collection<MetadataModelReference.BuilderImpl> targetMetadataModels) {
            this.targetMetadataModels = MetadataModelReferenceListCopier.copyFromBuilder(targetMetadataModels);
        }

        @Override
        public final Builder targetMetadataModels(Collection<MetadataModelReference> targetMetadataModels) {
            this.targetMetadataModels = MetadataModelReferenceListCopier.copy(targetMetadataModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMetadataModels(MetadataModelReference ... targetMetadataModels) {
            this.targetMetadataModels(Arrays.asList(targetMetadataModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMetadataModels(Consumer<MetadataModelReference.Builder> ... targetMetadataModels) {
            this.targetMetadataModels(Stream.of(targetMetadataModels).map(c -> (MetadataModelReference)((MetadataModelReference.Builder)MetadataModelReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public DescribeMetadataModelResponse build() {
            return new DescribeMetadataModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMetadataModelResponse> {
        public Builder metadataModelName(String var1);

        public Builder metadataModelType(String var1);

        public Builder targetMetadataModels(Collection<MetadataModelReference> var1);

        public Builder targetMetadataModels(MetadataModelReference ... var1);

        public Builder targetMetadataModels(Consumer<MetadataModelReference.Builder> ... var1);

        public Builder definition(String var1);
    }
}

