/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelChildrenRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelChildrenResponse;
import software.amazon.awssdk.services.databasemigration.model.MetadataModelReference;

public class DescribeMetadataModelChildrenIterable
implements SdkIterable<DescribeMetadataModelChildrenResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeMetadataModelChildrenRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMetadataModelChildrenIterable(DatabaseMigrationClient client, DescribeMetadataModelChildrenRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMetadataModelChildrenResponseFetcher();
    }

    public Iterator<DescribeMetadataModelChildrenResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetadataModelReference> metadataModelChildren() {
        Function<DescribeMetadataModelChildrenResponse, Iterator> getIterator = response -> {
            if (response != null && response.metadataModelChildren() != null) {
                return response.metadataModelChildren().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMetadataModelChildrenResponseFetcher
    implements SyncPageFetcher<DescribeMetadataModelChildrenResponse> {
        private DescribeMetadataModelChildrenResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelChildrenResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeMetadataModelChildrenResponse nextPage(DescribeMetadataModelChildrenResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelChildrenIterable.this.client.describeMetadataModelChildren(DescribeMetadataModelChildrenIterable.this.firstRequest);
            }
            return DescribeMetadataModelChildrenIterable.this.client.describeMetadataModelChildren((DescribeMetadataModelChildrenRequest)((Object)DescribeMetadataModelChildrenIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

