/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.ExcelOptions;
import software.amazon.awssdk.services.databrew.model.JsonOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormatOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormatOptions> {
    private static final SdkField<JsonOptions> JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Json").getter(FormatOptions.getter(FormatOptions::json)).setter(FormatOptions.setter(Builder::json)).constructor(JsonOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Json").build()}).build();
    private static final SdkField<ExcelOptions> EXCEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Excel").getter(FormatOptions.getter(FormatOptions::excel)).setter(FormatOptions.setter(Builder::excel)).constructor(ExcelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_FIELD, EXCEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final JsonOptions json;
    private final ExcelOptions excel;

    private FormatOptions(BuilderImpl builder) {
        this.json = builder.json;
        this.excel = builder.excel;
    }

    public JsonOptions json() {
        return this.json;
    }

    public ExcelOptions excel() {
        return this.excel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.json());
        hashCode = 31 * hashCode + Objects.hashCode(this.excel());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormatOptions)) {
            return false;
        }
        FormatOptions other = (FormatOptions)obj;
        return Objects.equals(this.json(), other.json()) && Objects.equals(this.excel(), other.excel());
    }

    public String toString() {
        return ToString.builder((String)"FormatOptions").add("Json", (Object)this.json()).add("Excel", (Object)this.excel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Json": {
                return Optional.ofNullable(clazz.cast(this.json()));
            }
            case "Excel": {
                return Optional.ofNullable(clazz.cast(this.excel()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FormatOptions, T> g) {
        return obj -> g.apply((FormatOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JsonOptions json;
        private ExcelOptions excel;

        private BuilderImpl() {
        }

        private BuilderImpl(FormatOptions model) {
            this.json(model.json);
            this.excel(model.excel);
        }

        public final JsonOptions.Builder getJson() {
            return this.json != null ? this.json.toBuilder() : null;
        }

        @Override
        public final Builder json(JsonOptions json) {
            this.json = json;
            return this;
        }

        public final void setJson(JsonOptions.BuilderImpl json) {
            this.json = json != null ? json.build() : null;
        }

        public final ExcelOptions.Builder getExcel() {
            return this.excel != null ? this.excel.toBuilder() : null;
        }

        @Override
        public final Builder excel(ExcelOptions excel) {
            this.excel = excel;
            return this;
        }

        public final void setExcel(ExcelOptions.BuilderImpl excel) {
            this.excel = excel != null ? excel.build() : null;
        }

        public FormatOptions build() {
            return new FormatOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormatOptions> {
        public Builder json(JsonOptions var1);

        default public Builder json(Consumer<JsonOptions.Builder> json) {
            return this.json((JsonOptions)((JsonOptions.Builder)JsonOptions.builder().applyMutation(json)).build());
        }

        public Builder excel(ExcelOptions var1);

        default public Builder excel(Consumer<ExcelOptions.Builder> excel) {
            return this.excel((ExcelOptions)((ExcelOptions.Builder)ExcelOptions.builder().applyMutation(excel)).build());
        }
    }
}

