/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.HiddenColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewFrame
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewFrame> {
    private static final SdkField<Integer> START_COLUMN_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartColumnIndex").getter(ViewFrame.getter(ViewFrame::startColumnIndex)).setter(ViewFrame.setter(Builder::startColumnIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartColumnIndex").build()}).build();
    private static final SdkField<Integer> COLUMN_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ColumnRange").getter(ViewFrame.getter(ViewFrame::columnRange)).setter(ViewFrame.setter(Builder::columnRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnRange").build()}).build();
    private static final SdkField<List<String>> HIDDEN_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HiddenColumns").getter(ViewFrame.getter(ViewFrame::hiddenColumns)).setter(ViewFrame.setter(Builder::hiddenColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_COLUMN_INDEX_FIELD, COLUMN_RANGE_FIELD, HIDDEN_COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer startColumnIndex;
    private final Integer columnRange;
    private final List<String> hiddenColumns;

    private ViewFrame(BuilderImpl builder) {
        this.startColumnIndex = builder.startColumnIndex;
        this.columnRange = builder.columnRange;
        this.hiddenColumns = builder.hiddenColumns;
    }

    public Integer startColumnIndex() {
        return this.startColumnIndex;
    }

    public Integer columnRange() {
        return this.columnRange;
    }

    public boolean hasHiddenColumns() {
        return this.hiddenColumns != null && !(this.hiddenColumns instanceof SdkAutoConstructList);
    }

    public List<String> hiddenColumns() {
        return this.hiddenColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startColumnIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiddenColumns() ? this.hiddenColumns() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewFrame)) {
            return false;
        }
        ViewFrame other = (ViewFrame)obj;
        return Objects.equals(this.startColumnIndex(), other.startColumnIndex()) && Objects.equals(this.columnRange(), other.columnRange()) && this.hasHiddenColumns() == other.hasHiddenColumns() && Objects.equals(this.hiddenColumns(), other.hiddenColumns());
    }

    public String toString() {
        return ToString.builder((String)"ViewFrame").add("StartColumnIndex", (Object)this.startColumnIndex()).add("ColumnRange", (Object)this.columnRange()).add("HiddenColumns", this.hasHiddenColumns() ? this.hiddenColumns() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartColumnIndex": {
                return Optional.ofNullable(clazz.cast(this.startColumnIndex()));
            }
            case "ColumnRange": {
                return Optional.ofNullable(clazz.cast(this.columnRange()));
            }
            case "HiddenColumns": {
                return Optional.ofNullable(clazz.cast(this.hiddenColumns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewFrame, T> g) {
        return obj -> g.apply((ViewFrame)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer startColumnIndex;
        private Integer columnRange;
        private List<String> hiddenColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ViewFrame model) {
            this.startColumnIndex(model.startColumnIndex);
            this.columnRange(model.columnRange);
            this.hiddenColumns(model.hiddenColumns);
        }

        public final Integer getStartColumnIndex() {
            return this.startColumnIndex;
        }

        @Override
        public final Builder startColumnIndex(Integer startColumnIndex) {
            this.startColumnIndex = startColumnIndex;
            return this;
        }

        public final void setStartColumnIndex(Integer startColumnIndex) {
            this.startColumnIndex = startColumnIndex;
        }

        public final Integer getColumnRange() {
            return this.columnRange;
        }

        @Override
        public final Builder columnRange(Integer columnRange) {
            this.columnRange = columnRange;
            return this;
        }

        public final void setColumnRange(Integer columnRange) {
            this.columnRange = columnRange;
        }

        public final Collection<String> getHiddenColumns() {
            if (this.hiddenColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hiddenColumns;
        }

        @Override
        public final Builder hiddenColumns(Collection<String> hiddenColumns) {
            this.hiddenColumns = HiddenColumnListCopier.copy(hiddenColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenColumns(String ... hiddenColumns) {
            this.hiddenColumns(Arrays.asList(hiddenColumns));
            return this;
        }

        public final void setHiddenColumns(Collection<String> hiddenColumns) {
            this.hiddenColumns = HiddenColumnListCopier.copy(hiddenColumns);
        }

        public ViewFrame build() {
            return new ViewFrame(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewFrame> {
        public Builder startColumnIndex(Integer var1);

        public Builder columnRange(Integer var1);

        public Builder hiddenColumns(Collection<String> var1);

        public Builder hiddenColumns(String ... var1);
    }
}

