/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.DataBrewRequest;
import software.amazon.awssdk.services.databrew.model.EncryptionMode;
import software.amazon.awssdk.services.databrew.model.LogSubscription;
import software.amazon.awssdk.services.databrew.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProfileJobRequest
extends DataBrewRequest
implements ToCopyableBuilder<Builder, UpdateProfileJobRequest> {
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::encryptionKeyArn)).setter(UpdateProfileJobRequest.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionMode").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::encryptionModeAsString)).setter(UpdateProfileJobRequest.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::name)).setter(UpdateProfileJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogSubscription").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::logSubscriptionAsString)).setter(UpdateProfileJobRequest.setter(Builder::logSubscription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::maxCapacity)).setter(UpdateProfileJobRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRetries").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::maxRetries)).setter(UpdateProfileJobRequest.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()}).build();
    private static final SdkField<S3Location> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputLocation").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::outputLocation)).setter(UpdateProfileJobRequest.setter(Builder::outputLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::roleArn)).setter(UpdateProfileJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(UpdateProfileJobRequest.getter(UpdateProfileJobRequest::timeout)).setter(UpdateProfileJobRequest.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_MODE_FIELD, NAME_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD, MAX_RETRIES_FIELD, OUTPUT_LOCATION_FIELD, ROLE_ARN_FIELD, TIMEOUT_FIELD));
    private final String encryptionKeyArn;
    private final String encryptionMode;
    private final String name;
    private final String logSubscription;
    private final Integer maxCapacity;
    private final Integer maxRetries;
    private final S3Location outputLocation;
    private final String roleArn;
    private final Integer timeout;

    private UpdateProfileJobRequest(BuilderImpl builder) {
        super(builder);
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputLocation = builder.outputLocation;
        this.roleArn = builder.roleArn;
        this.timeout = builder.timeout;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(this.encryptionMode);
    }

    public final String encryptionModeAsString() {
        return this.encryptionMode;
    }

    public final String name() {
        return this.name;
    }

    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(this.logSubscription);
    }

    public final String logSubscriptionAsString() {
        return this.logSubscription;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer maxRetries() {
        return this.maxRetries;
    }

    public final S3Location outputLocation() {
        return this.outputLocation;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileJobRequest)) {
            return false;
        }
        UpdateProfileJobRequest other = (UpdateProfileJobRequest)((Object)obj);
        return Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.encryptionModeAsString(), other.encryptionModeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.logSubscriptionAsString(), other.logSubscriptionAsString()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.maxRetries(), other.maxRetries()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.timeout(), other.timeout());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProfileJobRequest").add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("EncryptionMode", (Object)this.encryptionModeAsString()).add("Name", (Object)this.name()).add("LogSubscription", (Object)this.logSubscriptionAsString()).add("MaxCapacity", (Object)this.maxCapacity()).add("MaxRetries", (Object)this.maxRetries()).add("OutputLocation", (Object)this.outputLocation()).add("RoleArn", (Object)this.roleArn()).add("Timeout", (Object)this.timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "EncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionModeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LogSubscription": {
                return Optional.ofNullable(clazz.cast(this.logSubscriptionAsString()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileJobRequest, T> g) {
        return obj -> g.apply((UpdateProfileJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewRequest.BuilderImpl
    implements Builder {
        private String encryptionKeyArn;
        private String encryptionMode;
        private String name;
        private String logSubscription;
        private Integer maxCapacity;
        private Integer maxRetries;
        private S3Location outputLocation;
        private String roleArn;
        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileJobRequest model) {
            super(model);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.encryptionMode(model.encryptionMode);
            this.name(model.name);
            this.logSubscription(model.logSubscription);
            this.maxCapacity(model.maxCapacity);
            this.maxRetries(model.maxRetries);
            this.outputLocation(model.outputLocation);
            this.roleArn(model.roleArn);
            this.timeout(model.timeout);
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLogSubscription() {
            return this.logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final S3Location.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(S3Location outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(S3Location.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileJobRequest build() {
            return new UpdateProfileJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataBrewRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProfileJobRequest> {
        public Builder encryptionKeyArn(String var1);

        public Builder encryptionMode(String var1);

        public Builder encryptionMode(EncryptionMode var1);

        public Builder name(String var1);

        public Builder logSubscription(String var1);

        public Builder logSubscription(LogSubscription var1);

        public Builder maxCapacity(Integer var1);

        public Builder maxRetries(Integer var1);

        public Builder outputLocation(S3Location var1);

        default public Builder outputLocation(Consumer<S3Location.Builder> outputLocation) {
            return this.outputLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(outputLocation)).build());
        }

        public Builder roleArn(String var1);

        public Builder timeout(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

