/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OutputFormat {
    CSV("CSV"),
    JSON("JSON"),
    PARQUET("PARQUET"),
    GLUEPARQUET("GLUEPARQUET"),
    AVRO("AVRO"),
    ORC("ORC"),
    XML("XML"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OutputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OutputFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OutputFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OutputFormat> knownValues() {
        return Stream.of(OutputFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

