/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SampleType {
    FIRST_N("FIRST_N"),
    LAST_N("LAST_N"),
    RANDOM("RANDOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SampleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SampleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SampleType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SampleType> knownValues() {
        return Stream.of(SampleType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

