/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SessionStatus {
    ASSIGNED("ASSIGNED"),
    FAILED("FAILED"),
    INITIALIZING("INITIALIZING"),
    PROVISIONING("PROVISIONING"),
    READY("READY"),
    RECYCLING("RECYCLING"),
    ROTATING("ROTATING"),
    TERMINATED("TERMINATED"),
    TERMINATING("TERMINATING"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SessionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SessionStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionStatus> knownValues() {
        return Stream.of(SessionStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

